/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.checks.utils;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.List;
import org.jenkinsci.plugins.workflow.actions.LabelAction;
import org.jenkinsci.plugins.workflow.actions.ThreadNameAction;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graph.StepNode;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class FlowNodeUtils {
    @NonNull
    public static List<FlowNode> getEnclosingStagesAndParallels(FlowNode node) {
        ArrayList<FlowNode> enclosingBlocks = new ArrayList<FlowNode>();
        for (FlowNode enclosing : node.getEnclosingBlocks()) {
            if (enclosing == null || enclosing.getAction(LabelAction.class) == null || !FlowNodeUtils.isStageNode(enclosing) && enclosing.getAction(ThreadNameAction.class) == null) continue;
            enclosingBlocks.add(enclosing);
        }
        return enclosingBlocks;
    }

    @NonNull
    public static List<String> getEnclosingBlockNames(@NonNull List<FlowNode> nodes) {
        ArrayList<String> names = new ArrayList<String>();
        for (FlowNode n : nodes) {
            ThreadNameAction threadNameAction = (ThreadNameAction)n.getPersistentAction(ThreadNameAction.class);
            LabelAction labelAction = (LabelAction)n.getPersistentAction(LabelAction.class);
            if (threadNameAction != null) {
                if (!names.isEmpty() && threadNameAction.getThreadName().equals(names.get(names.size() - 1))) continue;
                names.add(threadNameAction.getThreadName());
                continue;
            }
            if (labelAction == null) continue;
            names.add(labelAction.getDisplayName());
        }
        return names;
    }

    private static boolean isStageNode(@NonNull FlowNode node) {
        if (node instanceof StepNode) {
            StepDescriptor d = ((StepNode)node).getDescriptor();
            return d != null && d.getFunctionName().equals("stage");
        }
        return false;
    }

    private FlowNodeUtils() {
    }
}

