/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps.global;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import groovy.lang.Binding;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import jenkins.model.Jenkins;
import org.apache.commons.io.FileUtils;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.jenkinsci.plugins.workflow.cps.CpsCompilationErrorsException;
import org.jenkinsci.plugins.workflow.cps.CpsScript;
import org.jenkinsci.plugins.workflow.cps.CpsThread;
import org.jenkinsci.plugins.workflow.cps.GlobalVariable;

public class UserDefinedGlobalVariable
extends GlobalVariable {
    private final File help;
    private final String name;

    public UserDefinedGlobalVariable(String name, File help) {
        this.name = name;
        this.help = help;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public Object getValue(@NonNull CpsScript script) throws Exception {
        Object instance;
        Binding binding = script.getBinding();
        if (binding.hasVariable(this.getName())) {
            instance = binding.getVariable(this.getName());
        } else {
            CpsThread c = CpsThread.current();
            if (c == null) {
                throw new IllegalStateException("Expected to be called from CpsThread");
            }
            try {
                instance = c.getExecution().getShell().getClassLoader().loadClass(this.getName()).newInstance();
            }
            catch (MultipleCompilationErrorsException ex) {
                throw new CpsCompilationErrorsException(ex);
            }
            binding.setVariable(this.getName(), instance);
        }
        return instance;
    }

    @CheckForNull
    public String getHelpHtml() throws IOException {
        if (!this.help.exists()) {
            return null;
        }
        return Jenkins.get().getMarkupFormatter().translate(FileUtils.readFileToString((File)this.help, (Charset)StandardCharsets.UTF_8).replace("\r\n", "\n"));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        UserDefinedGlobalVariable that = (UserDefinedGlobalVariable)((Object)o);
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

