/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.libs;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.DescriptorVisibilityFilter;
import hudson.model.Item;
import hudson.util.FormValidation;
import java.util.Collection;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.libs.LibraryCachingConfiguration;
import org.jenkinsci.plugins.workflow.libs.LibraryResolver;
import org.jenkinsci.plugins.workflow.libs.LibraryRetriever;
import org.jenkinsci.plugins.workflow.libs.LibraryRetrieverDescriptor;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class LibraryConfiguration
extends AbstractDescribableImpl<LibraryConfiguration> {
    private final String name;
    private final LibraryRetriever retriever;
    private String defaultVersion;
    private boolean implicit;
    private boolean allowVersionOverride = true;
    private boolean includeInChangesets = true;
    private LibraryCachingConfiguration cachingConfiguration = null;

    @DataBoundConstructor
    public LibraryConfiguration(String name, LibraryRetriever retriever) {
        this.name = Util.fixEmptyAndTrim((String)name);
        this.retriever = retriever;
    }

    public String getName() {
        return this.name;
    }

    public LibraryRetriever getRetriever() {
        return this.retriever;
    }

    public String getDefaultVersion() {
        return this.defaultVersion;
    }

    @DataBoundSetter
    public void setDefaultVersion(String defaultVersion) {
        this.defaultVersion = Util.fixEmptyAndTrim((String)defaultVersion);
    }

    public boolean isImplicit() {
        return this.implicit;
    }

    @DataBoundSetter
    public void setImplicit(boolean implicit) {
        this.implicit = implicit;
    }

    public boolean isAllowVersionOverride() {
        return this.allowVersionOverride;
    }

    @DataBoundSetter
    public void setAllowVersionOverride(boolean allowVersionOverride) {
        this.allowVersionOverride = allowVersionOverride;
    }

    public boolean getIncludeInChangesets() {
        return this.includeInChangesets;
    }

    @DataBoundSetter
    public void setIncludeInChangesets(boolean includeInChangesets) {
        this.includeInChangesets = includeInChangesets;
    }

    public LibraryCachingConfiguration getCachingConfiguration() {
        return this.cachingConfiguration;
    }

    @DataBoundSetter
    public void setCachingConfiguration(LibraryCachingConfiguration cachingConfiguration) {
        this.cachingConfiguration = cachingConfiguration;
    }

    @NonNull
    boolean defaultedChangelogs(@CheckForNull Boolean changelog) throws AbortException {
        if (changelog == null) {
            return this.includeInChangesets;
        }
        return changelog;
    }

    @NonNull
    String defaultedVersion(@CheckForNull String version) throws AbortException {
        if (version == null) {
            if (this.defaultVersion == null) {
                throw new AbortException("No version specified for library " + this.name);
            }
            return this.defaultVersion;
        }
        if (this.allowVersionOverride) {
            return version;
        }
        throw new AbortException("Version override not permitted for library " + this.name);
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<LibraryConfiguration> {
        @Restricted(value={NoExternalUse.class})
        public Collection<LibraryRetrieverDescriptor> getRetrieverDescriptors() {
            StaplerRequest req = Stapler.getCurrentRequest();
            Item it = req != null ? (Item)req.findAncestorObject(Item.class) : null;
            return DescriptorVisibilityFilter.apply((Object)(it != null ? it : Jenkins.get()), (Iterable)ExtensionList.lookup(LibraryRetrieverDescriptor.class));
        }

        public FormValidation doCheckName(@QueryParameter String name) {
            if (name.isEmpty()) {
                return FormValidation.error((String)"You must enter a name.");
            }
            return FormValidation.ok();
        }

        @RequirePOST
        public FormValidation doCheckDefaultVersion(@AncestorInPath Item context, @QueryParameter String defaultVersion, @QueryParameter boolean implicit, @QueryParameter boolean allowVersionOverride, @QueryParameter String name) {
            if (defaultVersion.isEmpty()) {
                if (implicit) {
                    return FormValidation.error((String)"If you load a library implicitly, you must specify a default version.");
                }
                if (!allowVersionOverride) {
                    return FormValidation.error((String)"If you deny overriding a default version, you must define that version.");
                }
                return FormValidation.ok();
            }
            for (LibraryResolver resolver : ExtensionList.lookup(LibraryResolver.class)) {
                for (LibraryConfiguration config : resolver.fromConfiguration(Stapler.getCurrentRequest())) {
                    if (!config.getName().equals(name)) continue;
                    return config.getRetriever().validateVersion(name, defaultVersion, context);
                }
            }
            return FormValidation.ok((String)"Cannot validate default version until after saving and reconfiguring.");
        }
    }
}

