/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.libs;

import hudson.EnvVars;
import hudson.Extension;
import hudson.model.EnvironmentContributor;
import hudson.model.InvisibleAction;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jenkinsci.plugins.workflow.libs.LibraryRecord;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class LibrariesAction
extends InvisibleAction {
    private final List<LibraryRecord> libraries;

    LibrariesAction(List<LibraryRecord> libraries) {
        this.libraries = libraries;
    }

    @Exported
    public List<LibraryRecord> getLibraries() {
        return Collections.unmodifiableList(this.libraries);
    }

    @Extension
    public static class LibraryEnvironment
    extends EnvironmentContributor {
        public void buildEnvironmentFor(Run r, EnvVars envs, TaskListener listener) throws IOException, InterruptedException {
            LibrariesAction action = (LibrariesAction)r.getAction(LibrariesAction.class);
            if (action != null) {
                for (LibraryRecord library : action.libraries) {
                    envs.put("library." + library.name + ".version", library.version);
                }
            }
        }
    }
}

