/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.libs;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.scm.SCM;
import java.io.IOException;
import jenkins.branch.Branch;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMRevisionAction;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceOwner;
import org.jenkinsci.plugins.variant.OptionalExtension;
import org.jenkinsci.plugins.workflow.libs.LibraryStepRetrieverVerifier;
import org.jenkinsci.plugins.workflow.multibranch.BranchJobProperty;

@OptionalExtension(requirePlugins={"workflow-multibranch"})
public class MultibranchScmRevisionVerifier
implements LibraryStepRetrieverVerifier {
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static boolean DISABLED = Boolean.getBoolean(MultibranchScmRevisionVerifier.class.getName() + ".DISABLED");

    @Override
    public void verify(Run<?, ?> run, TaskListener listener, SCM libraryScm, String name) throws IOException, InterruptedException {
        SCMRevision headRevision;
        if (DISABLED) {
            return;
        }
        Job job = run.getParent();
        BranchJobProperty property = (BranchJobProperty)job.getProperty(BranchJobProperty.class);
        if (property == null || !(job.getParent() instanceof SCMSourceOwner)) {
            return;
        }
        Branch pipelineBranch = property.getBranch();
        SCMSource pipelineScmSource = ((SCMSourceOwner)job.getParent()).getSCMSource(pipelineBranch.getSourceId());
        if (pipelineScmSource == null) {
            throw new IllegalStateException(pipelineBranch.getSourceId() + " not found");
        }
        SCMHead head = pipelineBranch.getHead();
        SCMRevisionAction action = (SCMRevisionAction)run.getAction(SCMRevisionAction.class);
        if (action != null) {
            headRevision = action.getRevision();
        } else {
            headRevision = pipelineScmSource.fetch(head, listener);
            if (headRevision == null) {
                throw new AbortException("Could not determine exact tip revision of " + pipelineBranch.getName());
            }
            run.addAction((Action)new SCMRevisionAction(pipelineScmSource, headRevision));
        }
        SCMRevision trustedRevision = pipelineScmSource.getTrustedRevision(headRevision, listener);
        if (!headRevision.equals((Object)trustedRevision) && libraryScm.getKey().equals(pipelineScmSource.build(head, headRevision).getKey())) {
            throw new AbortException("Library '" + name + "' has been modified in an untrusted revision");
        }
    }
}

