/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.util;

import io.jenkins.plugins.util.QualityGate;
import io.jenkins.plugins.util.QualityGateStatus;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class QualityGateResult
implements Serializable {
    private static final long serialVersionUID = -4306601972076922976L;
    private QualityGateStatus overallStatus = QualityGateStatus.INACTIVE;
    private final List<QualityGateResultItem> items = new ArrayList<QualityGateResultItem>();

    public void add(QualityGate qualityGate, QualityGateStatus actualStatus, String actualValue) {
        this.items.add(new QualityGateResultItem(actualStatus, qualityGate, actualValue));
        if (actualStatus.isWorseThan(this.overallStatus)) {
            this.overallStatus = actualStatus;
        }
    }

    public List<QualityGateResultItem> getResultItems() {
        return this.items;
    }

    public QualityGateStatus getOverallStatus() {
        return this.overallStatus;
    }

    public boolean isSuccessful() {
        return this.overallStatus.isSuccessful();
    }

    public boolean isInactive() {
        return this.overallStatus == QualityGateStatus.INACTIVE;
    }

    public Collection<String> getMessages() {
        return this.items.stream().map(this::createMessage).collect(Collectors.toList());
    }

    private String createMessage(QualityGateResultItem item) {
        return String.format("-> [%s]: \u226a%s\u226b - (Actual value: %s, Quality gate: %.2f)", item.getQualityGate().getName(), item.getStatus().getDescription(), item.getActualValue(), item.getQualityGate().getThreshold());
    }

    public static class QualityGateResultItem
    implements Serializable {
        private static final long serialVersionUID = -4011767393049355487L;
        private final QualityGateStatus status;
        private final QualityGate qualityGate;
        private final String actualValue;

        QualityGateResultItem(QualityGateStatus status, QualityGate qualityGate, String actualValue) {
            this.status = status;
            this.qualityGate = qualityGate;
            this.actualValue = actualValue;
        }

        public QualityGateStatus getStatus() {
            return this.status;
        }

        public QualityGate getQualityGate() {
            return this.qualityGate;
        }

        public String getActualValue() {
            return this.actualValue;
        }
    }
}

