/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.util;

import edu.hm.hafner.util.VisibleForTesting;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.util.JenkinsFacade;
import io.jenkins.plugins.util.Messages;
import io.jenkins.plugins.util.QualityGateStatus;
import java.io.Serializable;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.verb.POST;

public abstract class QualityGate
extends AbstractDescribableImpl<QualityGate>
implements Serializable {
    private static final long serialVersionUID = -397278599489426668L;
    private final double threshold;
    private QualityGateCriticality criticality = QualityGateCriticality.UNSTABLE;

    protected QualityGate(double threshold) {
        this.threshold = threshold;
    }

    @DataBoundSetter
    public final void setCriticality(QualityGateCriticality criticality) {
        this.criticality = criticality;
    }

    public abstract String getName();

    public String toString() {
        return this.getName() + String.format(" - %s: %f", new Object[]{this.getCriticality(), this.getThreshold()});
    }

    public final double getThreshold() {
        return this.threshold;
    }

    public final QualityGateCriticality getCriticality() {
        return this.criticality;
    }

    public final QualityGateStatus getStatus() {
        return this.getCriticality().getStatus();
    }

    public static enum QualityGateCriticality {
        UNSTABLE(QualityGateStatus.WARNING),
        FAILURE(QualityGateStatus.FAILED);

        private final QualityGateStatus status;

        private QualityGateCriticality(QualityGateStatus status) {
            this.status = status;
        }

        public QualityGateStatus getStatus() {
            return this.status;
        }
    }

    @Extension
    public static class QualityGateDescriptor
    extends Descriptor<QualityGate> {
        private final JenkinsFacade jenkins;

        @VisibleForTesting
        QualityGateDescriptor(JenkinsFacade jenkinsFacade) {
            this.jenkins = jenkinsFacade;
        }

        public QualityGateDescriptor() {
            this(new JenkinsFacade());
        }

        @POST
        public ListBoxModel doFillCriticalityItems() {
            if (this.jenkins.hasPermission(Jenkins.READ)) {
                ListBoxModel options = new ListBoxModel();
                options.add(Messages.QualityGate_Unstable(), QualityGateCriticality.UNSTABLE.name());
                options.add(Messages.QualityGate_Failure(), QualityGateCriticality.FAILURE.name());
                return options;
            }
            return new ListBoxModel();
        }
    }
}

