/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.util;

import hudson.model.Result;
import io.jenkins.plugins.util.QualityGate;
import io.jenkins.plugins.util.QualityGateStatus;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

public class QualityGateResult
implements Serializable {
    private static final long serialVersionUID = -4306601972076922976L;
    private QualityGateStatus overallStatus;
    private final List<QualityGateResultItem> items = new ArrayList<QualityGateResultItem>();

    public QualityGateResult() {
        this(QualityGateStatus.INACTIVE);
    }

    public QualityGateResult(QualityGateStatus overallStatus) {
        this.overallStatus = overallStatus;
    }

    public void add(QualityGate qualityGate, QualityGateStatus actualStatus, String actualValue) {
        this.items.add(new QualityGateResultItem(actualStatus, qualityGate, actualValue));
        if (actualStatus.isWorseThan(this.overallStatus)) {
            this.overallStatus = actualStatus;
        }
    }

    public List<QualityGateResultItem> getResultItems() {
        return this.items;
    }

    @Whitelisted
    public QualityGateStatus getOverallStatus() {
        return this.overallStatus;
    }

    @Whitelisted
    public boolean isSuccessful() {
        return this.overallStatus.isSuccessful();
    }

    public boolean isInactive() {
        return this.overallStatus == QualityGateStatus.INACTIVE;
    }

    public Collection<String> getMessages() {
        return this.items.stream().map(this::createMessage).collect(Collectors.toList());
    }

    private String createMessage(QualityGateResultItem item) {
        return String.format("[%s]: \u226a%s\u226b - (Actual value: %s, Quality gate: %.2f)", item.getQualityGate().getName(), item.getStatus().getDescription(), item.getActualValue(), item.getQualityGate().getThreshold());
    }

    public String toString() {
        return this.getOverallStatus().toString();
    }

    public static class QualityGateResultItem
    implements Serializable {
        private static final long serialVersionUID = -4011767393049355487L;
        private final QualityGateStatus status;
        private final QualityGate qualityGate;
        private final String actualValue;

        QualityGateResultItem(QualityGateStatus status, QualityGate qualityGate, String actualValue) {
            this.status = status;
            this.qualityGate = qualityGate;
            this.actualValue = actualValue;
        }

        public QualityGateStatus getStatus() {
            return this.status;
        }

        public QualityGate getQualityGate() {
            return this.qualityGate;
        }

        public String getActualValue() {
            return this.actualValue;
        }
    }

    @ExportedBean
    public static class QualityGateItemApi {
        private final QualityGateResultItem item;

        public QualityGateItemApi(QualityGateResultItem item) {
            this.item = item;
        }

        @Exported
        public String getQualityGate() {
            return this.item.getQualityGate().getName();
        }

        @Exported
        public double getThreshold() {
            return this.item.getQualityGate().getThreshold();
        }

        @Exported(inline=true)
        public Result getResult() {
            return this.item.getStatus().getResult();
        }

        @Exported
        public String getValue() {
            return this.item.getActualValue();
        }
    }

    @ExportedBean
    public static class QualityGateResultApi {
        private final QualityGateResult qualityGateResult;

        public QualityGateResultApi(QualityGateResult qualityGateResult) {
            this.qualityGateResult = qualityGateResult;
        }

        @Exported(inline=true)
        public QualityGateStatus getOverallResult() {
            return this.qualityGateResult.getOverallStatus();
        }

        @Exported(inline=true)
        public Collection<QualityGateItemApi> getResultItems() {
            return this.qualityGateResult.getResultItems().stream().map(QualityGateItemApi::new).collect(Collectors.toList());
        }
    }
}

