/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.util;

import edu.hm.hafner.util.PackageDetectorFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.InvalidPathException;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.io.input.BOMInputStream;

abstract class PackageDetector {
    private final PackageDetectorFactory.FileSystemFacade fileSystem;

    PackageDetector(PackageDetectorFactory.FileSystemFacade fileSystem) {
        this.fileSystem = fileSystem;
    }

    public Optional<String> detectPackageName(String fileName, Charset charset) {
        Optional<String> optional;
        block8: {
            InputStream stream = this.fileSystem.openFile(fileName);
            try {
                optional = this.detectPackageName(stream, charset);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | InvalidPathException exception) {
                    return Optional.empty();
                }
            }
            stream.close();
        }
        return optional;
    }

    private Optional<String> detectPackageName(InputStream stream, Charset charset) throws IOException {
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader((InputStream)((BOMInputStream.Builder)BOMInputStream.builder().setInputStream(stream)).get(), charset));){
            Optional<String> optional = this.detectPackageName(buffer.lines());
            return optional;
        }
    }

    private Optional<String> detectPackageName(Stream<String> lines) {
        Pattern pattern = this.getPattern();
        return lines.map(pattern::matcher).filter(Matcher::matches).findFirst().map(matcher -> matcher.group(1)).map(String::trim);
    }

    abstract Pattern getPattern();

    abstract boolean accepts(String var1);
}

