/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.util;

import hudson.FilePath;
import hudson.model.Computer;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import io.jenkins.plugins.util.PipelineResultHandler;
import io.jenkins.plugins.util.ResultHandler;
import io.jenkins.plugins.util.ValidationUtilities;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Optional;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;

public abstract class AbstractExecution<T>
extends SynchronousNonBlockingStepExecution<T> {
    private static final long serialVersionUID = -127479018279069250L;

    protected AbstractExecution(StepContext context) {
        super(context);
    }

    protected Run<?, ?> getRun() throws IOException, InterruptedException {
        Run run = (Run)this.getContext().get(Run.class);
        if (run == null) {
            throw new IOException("Can't resolve Run for " + String.valueOf((Object)this));
        }
        return run;
    }

    protected Optional<VirtualChannel> getChannel() throws IOException, InterruptedException {
        Computer computer = (Computer)this.getContext().get(Computer.class);
        if (computer == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(computer.getChannel());
    }

    protected FilePath getBuildFolder() throws IOException, InterruptedException {
        return new FilePath(this.getRun().getRootDir());
    }

    protected FilePath getWorkspace() throws IOException, InterruptedException {
        FilePath workspace = (FilePath)this.getContext().get(FilePath.class);
        if (workspace == null) {
            throw new IOException("No workspace available for " + String.valueOf((Object)this));
        }
        workspace.mkdirs();
        return workspace;
    }

    protected TaskListener getTaskListener() throws InterruptedException, IOException {
        TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
        if (listener != null) {
            return listener;
        }
        return TaskListener.NULL;
    }

    protected Charset getCharset(String charset) {
        return new ValidationUtilities().getCharset(charset);
    }

    protected ResultHandler createResultHandler() throws InterruptedException, IOException {
        return this.createPipelineResultHandler();
    }

    private PipelineResultHandler createPipelineResultHandler() throws IOException, InterruptedException {
        return new PipelineResultHandler(this.getRun(), this.getFlowNode());
    }

    private FlowNode getFlowNode() throws IOException, InterruptedException {
        FlowNode flowNode = (FlowNode)this.getContext().get(FlowNode.class);
        if (flowNode != null) {
            return flowNode;
        }
        throw new IllegalStateException("FlowNode is not defined in the context of " + String.valueOf((Object)this));
    }
}

