/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.tools.incrementals.maven;

import io.jenkins.tools.incrementals.lib.UpdateChecker;
import io.jenkins.tools.incrementals.maven.DependencyManagementMojo;
import io.jenkins.tools.incrementals.maven.util.PluginRef;
import io.jenkins.tools.incrementals.maven.util.PluginRefList;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="updatePluginsTxt", defaultPhase=LifecyclePhase.PACKAGE, requiresProject=false)
public class UpdatePluginsTxt
extends AbstractMojo
implements DependencyManagementMojo {
    @Parameter(property="pluginsFile", required=true)
    public String pluginsFile;
    private boolean updateNonincremental = false;
    @Parameter(property="branch", defaultValue="master")
    private String branch;

    public void execute() throws MojoExecutionException {
        PluginRefList pluginsTxt;
        UpdateChecker checker = new UpdateChecker(message -> this.getLog().info((CharSequence)message), Arrays.asList("https://repo.jenkins-ci.org/releases/", "https://repo.jenkins-ci.org/incrementals/"));
        File file = new File(this.pluginsFile);
        if (!file.exists()) {
            throw new MojoExecutionException("File does not exist: " + this.pluginsFile);
        }
        if (!file.isFile()) {
            throw new MojoExecutionException("Path is not a file: " + this.pluginsFile);
        }
        try {
            pluginsTxt = PluginRefList.fromFile(file);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Failed to read the plugins list file", (Exception)ex);
        }
        this.update(pluginsTxt, checker);
        try {
            pluginsTxt.writeToFile(file);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Failed to update plugins.txt file " + file, (Exception)ex);
        }
        this.getLog().info((CharSequence)("Updated plugins.txt: " + file));
    }

    private void update(List<PluginRef> dependencies, UpdateChecker checker) throws MojoExecutionException {
        for (PluginRef dep : dependencies) {
            UpdateChecker.VersionAndRepo result;
            if (dep.isComment()) continue;
            if (!this.updateNonincremental && !dep.isIncrementals()) {
                this.getLog().info((CharSequence)("Skipping non-incrementals dependency: " + dep));
                continue;
            }
            String version = dep.getVersion();
            if (version == null) {
                this.getLog().info((CharSequence)("Skipping plugin without version definition: " + dep));
                continue;
            }
            if (ArtifactUtils.isSnapshot((String)version)) {
                this.getLog().info((CharSequence)("Skipping plugin with snapshot version: " + dep));
                continue;
            }
            if (!this.updateNonincremental && !version.matches(".+-rc[0-9]+[.][0-9a-f]{12}")) {
                this.getLog().debug((CharSequence)("Skipping plugin with non-incremental version " + dep));
                continue;
            }
            String artifactId = dep.getArtifactId();
            if (artifactId == null) {
                throw new MojoExecutionException("No artifact ID for the dependency: " + dep);
            }
            String groupId = dep.getGroupId();
            if (groupId == null) {
                try {
                    groupId = checker.findGroupId(artifactId);
                }
                catch (IOException | InterruptedException ex) {
                    throw new MojoExecutionException("Cannot find group ID for plugin: " + artifactId, ex);
                }
            }
            Object effectiveBranch = this.branch;
            if (dep.getGithubBranch() != null) {
                effectiveBranch = dep.getGithubBranch();
                if (dep.getGithubUser() != null) {
                    effectiveBranch = dep.getGithubUser() + ":" + (String)effectiveBranch;
                }
            }
            try {
                result = checker.find(groupId, artifactId, version, (String)effectiveBranch);
            }
            catch (Exception ex) {
                throw new MojoExecutionException("Cannot check for updates", ex);
            }
            if (result == null) {
                this.getLog().info((CharSequence)("No update found for " + dep + ". Current version is " + version));
                continue;
            }
            this.getLog().info((CharSequence)("Can update dependency " + dep + " to " + result.version));
            dep.setVersion(result.version.toString());
        }
    }
}

