/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate;

import com.intuit.karate.JsonUtils;
import com.intuit.karate.Match;
import com.intuit.karate.StringUtils;
import com.intuit.karate.XmlUtils;
import com.intuit.karate.graal.JsEngine;
import com.intuit.karate.graal.JsValue;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Node;

public class MatchOperation {
    public static final String REGEX = "regex";
    final Match.Context context;
    final Match.Type type;
    final Match.Value actual;
    final Match.Value expected;
    final List<MatchOperation> failures;
    final boolean matchEachEmptyAllowed;
    boolean pass = true;
    private String failReason;
    private static final Pattern UNDERSCORE_PATTERN = Pattern.compile("\\W_\\W|\\W_|_\\W");

    MatchOperation(Match.Type type, Match.Value actual, Match.Value expected, boolean matchEachEmptyAllowed) {
        this(JsEngine.global(), null, type, actual, expected, matchEachEmptyAllowed);
    }

    MatchOperation(JsEngine js, Match.Type type, Match.Value actual, Match.Value expected, boolean matchEachEmptyAllowed) {
        this(js, null, type, actual, expected, matchEachEmptyAllowed);
    }

    MatchOperation(Match.Context context, Match.Type type, Match.Value actual, Match.Value expected, boolean matchEachEmptyAllowed) {
        this(null, context, type, actual, expected, matchEachEmptyAllowed);
    }

    private MatchOperation(JsEngine js, Match.Context context, Match.Type type, Match.Value actual, Match.Value expected, boolean matchEachEmptyAllowed) {
        this.type = type;
        this.actual = actual;
        this.expected = expected;
        this.matchEachEmptyAllowed = matchEachEmptyAllowed;
        if (context == null) {
            if (js == null) {
                js = JsEngine.global();
            }
            this.failures = new ArrayList<MatchOperation>();
            this.context = actual.isXml() ? new Match.Context(js, this, true, 0, "/", "", -1, matchEachEmptyAllowed) : new Match.Context(js, this, false, 0, "$", "", -1, matchEachEmptyAllowed);
        } else {
            this.context = context;
            this.failures = context.root.failures;
        }
    }

    private Match.Type fromMatchEach() {
        switch (this.type) {
            case EACH_CONTAINS: {
                return Match.Type.CONTAINS;
            }
            case EACH_NOT_CONTAINS: {
                return Match.Type.NOT_CONTAINS;
            }
            case EACH_CONTAINS_ONLY: {
                return Match.Type.CONTAINS_ONLY;
            }
            case EACH_CONTAINS_ANY: {
                return Match.Type.CONTAINS_ANY;
            }
            case EACH_EQUALS: {
                return Match.Type.EQUALS;
            }
            case EACH_NOT_EQUALS: {
                return Match.Type.NOT_EQUALS;
            }
            case EACH_CONTAINS_DEEP: {
                return Match.Type.CONTAINS_DEEP;
            }
        }
        throw new RuntimeException("unexpected outer match type: " + this.type);
    }

    private static Match.Type macroToMatchType(boolean each, String macro) {
        if (macro.startsWith("^^")) {
            return each ? Match.Type.EACH_CONTAINS_ONLY : Match.Type.CONTAINS_ONLY;
        }
        if (macro.startsWith("^+")) {
            return each ? Match.Type.EACH_CONTAINS_DEEP : Match.Type.CONTAINS_DEEP;
        }
        if (macro.startsWith("^*")) {
            return each ? Match.Type.EACH_CONTAINS_ANY : Match.Type.CONTAINS_ANY;
        }
        if (macro.startsWith("^")) {
            return each ? Match.Type.EACH_CONTAINS : Match.Type.CONTAINS;
        }
        if (macro.startsWith("!^")) {
            return each ? Match.Type.EACH_NOT_CONTAINS : Match.Type.NOT_CONTAINS;
        }
        if (macro.startsWith("!=")) {
            return each ? Match.Type.EACH_NOT_EQUALS : Match.Type.NOT_EQUALS;
        }
        return each ? Match.Type.EACH_EQUALS : Match.Type.EQUALS;
    }

    private static int matchTypeToStartPos(Match.Type mt) {
        switch (mt) {
            case EACH_NOT_CONTAINS: 
            case EACH_CONTAINS_ONLY: 
            case EACH_CONTAINS_ANY: 
            case EACH_NOT_EQUALS: 
            case EACH_CONTAINS_DEEP: 
            case CONTAINS_ONLY: 
            case CONTAINS_DEEP: 
            case CONTAINS_ANY: 
            case NOT_CONTAINS: 
            case NOT_EQUALS: {
                return 2;
            }
            case EACH_CONTAINS: 
            case CONTAINS: {
                return 1;
            }
        }
        return 0;
    }

    boolean execute() {
        String expStr;
        switch (this.type) {
            case EACH_CONTAINS: 
            case EACH_NOT_CONTAINS: 
            case EACH_CONTAINS_ONLY: 
            case EACH_CONTAINS_ANY: 
            case EACH_EQUALS: 
            case EACH_NOT_EQUALS: 
            case EACH_CONTAINS_DEEP: {
                if (this.actual.isList()) {
                    List list = (List)this.actual.getValue();
                    if (list.isEmpty() && !this.matchEachEmptyAllowed) {
                        return this.fail("match each failed, empty array / list");
                    }
                    Match.Type nestedMatchType = this.fromMatchEach();
                    int count = list.size();
                    for (int i = 0; i < count; ++i) {
                        Object o = list.get(i);
                        this.context.JS.put("_$", o);
                        MatchOperation mo = new MatchOperation(this.context.descend(i), nestedMatchType, new Match.Value(o), this.expected, this.matchEachEmptyAllowed);
                        mo.execute();
                        this.context.JS.bindings.removeMember("_$");
                        if (mo.pass) continue;
                        return this.fail("match each failed at index " + i);
                    }
                    return true;
                }
                return this.fail("actual is not an array or list");
            }
        }
        if (!(!this.actual.isNotPresent() || this.expected.isString() && this.expected.getAsString().startsWith("#"))) {
            return this.fail("actual path does not exist");
        }
        if (this.actual.type != this.expected.type) {
            switch (this.type) {
                case CONTAINS_ONLY: 
                case CONTAINS_DEEP: 
                case CONTAINS_ANY: 
                case NOT_CONTAINS: 
                case CONTAINS: 
                case CONTAINS_ONLY_DEEP: 
                case CONTAINS_ANY_DEEP: {
                    if (this.expected.isList() || this.expected.isString() && this.expected.isArrayObjectOrReference()) break;
                    MatchOperation mo = new MatchOperation(this.context, this.type, this.actual, new Match.Value(Collections.singletonList(this.expected.getValue())), this.matchEachEmptyAllowed);
                    mo.execute();
                    return mo.pass ? this.pass() : this.fail(mo.failReason);
                }
            }
            if (this.expected.isXml() && this.actual.isMap()) {
                MatchOperation mo = new MatchOperation(this.context, this.type, this.actual, new Match.Value(XmlUtils.toObject((Node)this.expected.getValue(), true)), this.matchEachEmptyAllowed);
                mo.execute();
                return mo.pass ? this.pass() : this.fail(mo.failReason);
            }
            if (this.expected.isString()) {
                expStr = (String)this.expected.getValue();
                if (!expStr.startsWith("#")) {
                    return this.type == Match.Type.NOT_EQUALS ? this.pass() : this.fail("data types don't match");
                }
            } else {
                return this.type == Match.Type.NOT_EQUALS ? this.pass() : this.fail("data types don't match");
            }
        }
        if (this.expected.isString() && (expStr = (String)this.expected.getValue()).startsWith("#")) {
            switch (this.type) {
                case NOT_EQUALS: {
                    return this.macroEqualsExpected(expStr) ? this.fail("is equal") : this.pass();
                }
                case NOT_CONTAINS: {
                    return this.macroEqualsExpected(expStr) ? this.fail("actual contains expected") : this.pass();
                }
            }
            return this.macroEqualsExpected(expStr) ? this.pass() : this.fail(null);
        }
        switch (this.type) {
            case EQUALS: {
                return this.actualEqualsExpected() ? this.pass() : this.fail("not equal");
            }
            case NOT_EQUALS: {
                return this.actualEqualsExpected() ? this.fail("is equal") : this.pass();
            }
            case CONTAINS_ONLY: 
            case CONTAINS_DEEP: 
            case CONTAINS_ANY: 
            case CONTAINS: 
            case CONTAINS_ONLY_DEEP: 
            case CONTAINS_ANY_DEEP: {
                return this.actualContainsExpected() ? this.pass() : this.fail("actual does not contain expected");
            }
            case NOT_CONTAINS: {
                return this.actualContainsExpected() ? this.fail("actual contains expected") : this.pass();
            }
        }
        throw new RuntimeException("unexpected match type: " + this.type);
    }

    private boolean macroEqualsExpected(String expStr) {
        int minLength;
        boolean optional = expStr.startsWith("##");
        if (optional && this.actual.isNull()) {
            return true;
        }
        int n = minLength = optional ? 3 : 2;
        if (expStr.length() > minLength) {
            Object macro = expStr.substring(minLength - 1);
            if (((String)macro).startsWith("(") && ((String)macro).endsWith(")")) {
                macro = ((String)macro).substring(1, ((String)macro).length() - 1);
                Match.Type nestedType = MatchOperation.macroToMatchType(false, (String)macro);
                int startPos = MatchOperation.matchTypeToStartPos(nestedType);
                macro = ((String)macro).substring(startPos);
                if (this.actual.isList()) {
                    switch (nestedType) {
                        case CONTAINS: {
                            nestedType = Match.Type.CONTAINS_DEEP;
                            break;
                        }
                        case CONTAINS_ONLY: {
                            nestedType = Match.Type.CONTAINS_ONLY_DEEP;
                            break;
                        }
                        case CONTAINS_ANY: {
                            nestedType = Match.Type.CONTAINS_ANY_DEEP;
                        }
                    }
                }
                this.context.JS.put("$", this.context.root.actual.getValue());
                this.context.JS.put("_", this.actual.getValue());
                JsValue jv = this.context.JS.eval((String)macro);
                this.context.JS.bindings.removeMember("$");
                this.context.JS.bindings.removeMember("_");
                MatchOperation mo = new MatchOperation(this.context, nestedType, this.actual, new Match.Value(jv.getValue()), this.matchEachEmptyAllowed);
                return mo.execute();
            }
            if (((String)macro).startsWith("[")) {
                int closeBracketPos = ((String)macro).indexOf(93);
                if (closeBracketPos != -1) {
                    if (!this.actual.isList()) {
                        return this.fail("actual is not an array");
                    }
                    if (closeBracketPos > 1) {
                        String bracketContents = ((String)macro).substring(1, closeBracketPos);
                        List listAct = (List)this.actual.getValue();
                        int listSize = listAct.size();
                        this.context.JS.put("$", this.context.root.actual.getValue());
                        this.context.JS.put("_", listSize);
                        Object sizeExpr = this.containsPlaceholderUnderscore(bracketContents) ? bracketContents : bracketContents + " == _";
                        JsValue jv = this.context.JS.eval((String)sizeExpr);
                        this.context.JS.bindings.removeMember("$");
                        this.context.JS.bindings.removeMember("_");
                        if (!jv.isTrue()) {
                            return this.fail("actual array length is " + listSize);
                        }
                    }
                    if (((String)macro).length() > closeBracketPos + 1 && (macro = StringUtils.trimToNull(((String)macro).substring(closeBracketPos + 1))) != null) {
                        if (((String)macro).startsWith("(") && ((String)macro).endsWith(")")) {
                            macro = ((String)macro).substring(1, ((String)macro).length() - 1);
                        }
                        if (((String)macro).startsWith("?")) {
                            macro = "#" + (String)macro;
                        }
                        if (((String)macro).startsWith("#")) {
                            MatchOperation mo = new MatchOperation(this.context, Match.Type.EACH_EQUALS, this.actual, new Match.Value(macro), this.matchEachEmptyAllowed);
                            mo.execute();
                            return mo.pass ? this.pass() : this.fail("all array elements matched");
                        }
                        Match.Type nestedType = MatchOperation.macroToMatchType(true, (String)macro);
                        int startPos = MatchOperation.matchTypeToStartPos(nestedType);
                        macro = ((String)macro).substring(startPos);
                        JsValue jv = this.context.JS.eval((String)macro);
                        MatchOperation mo = new MatchOperation(this.context, nestedType, this.actual, new Match.Value(jv.getValue()), this.matchEachEmptyAllowed);
                        return mo.execute();
                    }
                    return true;
                }
            } else {
                int questionPos = ((String)macro).indexOf(63);
                String validatorName = null;
                if (questionPos != -1 && !((String)macro).startsWith(REGEX)) {
                    validatorName = ((String)macro).substring(0, questionPos);
                    macro = ((String)macro).length() > questionPos + 1 ? StringUtils.trimToEmpty(((String)macro).substring(questionPos + 1)) : "";
                } else {
                    validatorName = macro;
                    macro = "";
                }
                validatorName = StringUtils.trimToNull(validatorName);
                if (validatorName != null) {
                    Match.Validator validator = null;
                    if (validatorName.startsWith(REGEX)) {
                        String regex = validatorName.substring(5).trim();
                        validator = new Match.RegexValidator(regex);
                    } else {
                        validator = Match.VALIDATORS.get(validatorName);
                    }
                    if (validator != null) {
                        if (!optional || !this.actual.isNotPresent() && !this.actual.isNull()) {
                            if (!optional && this.actual.isNotPresent()) {
                                return this.expected.isNotPresent() || "#ignore".contentEquals(this.expected.getAsString());
                            }
                            Match.Result mr = (Match.Result)validator.apply(this.actual);
                            if (!mr.pass) {
                                return this.fail(mr.message);
                            }
                        }
                    } else if (!validatorName.startsWith(REGEX)) {
                        String actualValue = (String)this.actual.getValue();
                        switch (this.type) {
                            case CONTAINS: {
                                return actualValue.contains(expStr);
                            }
                        }
                        return actualValue.equals(expStr);
                    }
                }
                if ((macro = StringUtils.trimToNull((String)macro)) != null && questionPos != -1) {
                    this.context.JS.put("$", this.context.root.actual.getValue());
                    this.context.JS.put("_", this.actual.getValue());
                    JsValue jv = this.context.JS.eval((String)macro);
                    this.context.JS.bindings.removeMember("$");
                    this.context.JS.bindings.removeMember("_");
                    if (!jv.isTrue()) {
                        return this.fail("evaluated to 'false'");
                    }
                }
            }
        }
        return true;
    }

    private boolean containsPlaceholderUnderscore(String bracketContents) {
        Matcher m1 = UNDERSCORE_PATTERN.matcher(bracketContents);
        return m1.find();
    }

    private boolean actualEqualsExpected() {
        switch (this.actual.type) {
            case NULL: {
                return true;
            }
            case BOOLEAN: {
                boolean actBoolean = (Boolean)this.actual.getValue();
                boolean expBoolean = (Boolean)this.expected.getValue();
                return actBoolean == expBoolean;
            }
            case NUMBER: {
                if (this.actual.getValue() instanceof BigDecimal || this.expected.getValue() instanceof BigDecimal) {
                    BigDecimal expBigDecimal;
                    BigDecimal actBigDecimal = MatchOperation.toBigDecimal(this.actual.getValue());
                    return actBigDecimal.compareTo(expBigDecimal = MatchOperation.toBigDecimal(this.expected.getValue())) == 0;
                }
                Number actNumber = (Number)this.actual.getValue();
                Number expNumber = (Number)this.expected.getValue();
                return actNumber.doubleValue() == expNumber.doubleValue();
            }
            case STRING: {
                return this.actual.getValue().equals(this.expected.getValue());
            }
            case BYTES: {
                byte[] actBytes = (byte[])this.actual.getValue();
                byte[] expBytes = (byte[])this.expected.getValue();
                return Arrays.equals(actBytes, expBytes);
            }
            case LIST: {
                List actList = (List)this.actual.getValue();
                List expList = (List)this.expected.getValue();
                int actListCount = actList.size();
                int expListCount = expList.size();
                if (actListCount != expListCount) {
                    return this.fail("actual array length is not equal to expected - " + actListCount + ":" + expListCount);
                }
                for (int i = 0; i < actListCount; ++i) {
                    Match.Value actListValue = new Match.Value(actList.get(i));
                    Match.Value expListValue = new Match.Value(expList.get(i));
                    MatchOperation mo = new MatchOperation(this.context.descend(i), Match.Type.EQUALS, actListValue, expListValue, this.matchEachEmptyAllowed);
                    mo.execute();
                    if (mo.pass) continue;
                    return this.fail("array match failed at index " + i);
                }
                return true;
            }
            case MAP: {
                Map actMap = (Map)this.actual.getValue();
                Map expMap = (Map)this.expected.getValue();
                return this.matchMapValues(actMap, expMap);
            }
            case XML: {
                Map actXml = (Map)XmlUtils.toObject((Node)this.actual.getValue(), true);
                Map expXml = (Map)XmlUtils.toObject((Node)this.expected.getValue(), true);
                return this.matchMapValues(actXml, expXml);
            }
            case OTHER: {
                return this.actual.getValue().equals(this.expected.getValue());
            }
        }
        throw new RuntimeException("unexpected type (match equals): " + this.actual.type);
    }

    private boolean matchMapValues(Map<String, Object> actMap, Map<String, Object> expMap) {
        if (actMap.size() > expMap.size() && (this.type == Match.Type.EQUALS || this.type == Match.Type.CONTAINS_ONLY || this.type == Match.Type.CONTAINS_ONLY_DEEP)) {
            int sizeDiff = actMap.size() - expMap.size();
            LinkedHashMap<String, Object> diffMap = new LinkedHashMap<String, Object>(actMap);
            for (String key : expMap.keySet()) {
                diffMap.remove(key);
            }
            return this.fail("actual has " + sizeDiff + " more key(s) than expected - " + JsonUtils.toJson(diffMap));
        }
        LinkedHashSet<String> unMatchedKeysAct = new LinkedHashSet<String>(actMap.keySet());
        LinkedHashSet<String> unMatchedKeysExp = new LinkedHashSet<String>(expMap.keySet());
        for (Map.Entry<String, Object> expEntry : expMap.entrySet()) {
            String key = expEntry.getKey();
            Object childExp = expEntry.getValue();
            if (!actMap.containsKey(key)) {
                String childString;
                if (childExp instanceof String && ((childString = (String)childExp).startsWith("##") || childString.equals("#ignore") || childString.equals("#notpresent"))) {
                    if (this.type == Match.Type.CONTAINS_ANY || this.type == Match.Type.CONTAINS_ANY_DEEP) {
                        return true;
                    }
                    unMatchedKeysExp.remove(key);
                    if (!unMatchedKeysExp.isEmpty() || this.type != Match.Type.CONTAINS && this.type != Match.Type.CONTAINS_DEEP) continue;
                    return true;
                }
                if (this.type != Match.Type.CONTAINS_ANY && this.type != Match.Type.CONTAINS_ANY_DEEP) {
                    return this.fail("actual does not contain key - '" + key + "'");
                }
            }
            Match.Value childActValue = new Match.Value(actMap.get(key));
            Match.Type childMatchType = this.type == Match.Type.CONTAINS_DEEP ? (childActValue.isMapOrListOrXml() ? Match.Type.CONTAINS_DEEP : Match.Type.EQUALS) : (this.type == Match.Type.CONTAINS_ONLY_DEEP ? (childActValue.isMapOrListOrXml() ? Match.Type.CONTAINS_ONLY_DEEP : Match.Type.EQUALS) : Match.Type.EQUALS);
            MatchOperation mo = new MatchOperation(this.context.descend(key), childMatchType, childActValue, new Match.Value(childExp), this.matchEachEmptyAllowed);
            mo.execute();
            if (mo.pass) {
                if (this.type == Match.Type.CONTAINS_ANY || this.type == Match.Type.CONTAINS_ANY_DEEP) {
                    return true;
                }
                unMatchedKeysExp.remove(key);
                if (unMatchedKeysExp.isEmpty() && (this.type == Match.Type.CONTAINS || this.type == Match.Type.CONTAINS_DEEP)) {
                    return true;
                }
                unMatchedKeysAct.remove(key);
                continue;
            }
            if (this.type != Match.Type.EQUALS) continue;
            return this.fail("match failed for name: '" + key + "'");
        }
        if (this.type == Match.Type.CONTAINS_ANY || this.type == Match.Type.CONTAINS_ANY_DEEP) {
            return unMatchedKeysExp.isEmpty() ? true : this.fail("no key-values matched");
        }
        if (unMatchedKeysExp.isEmpty()) {
            if (this.type == Match.Type.CONTAINS || this.type == Match.Type.CONTAINS_DEEP) {
                return true;
            }
            if (this.type == Match.Type.NOT_CONTAINS && !expMap.isEmpty()) {
                return true;
            }
        }
        if (!unMatchedKeysExp.isEmpty()) {
            return this.fail("all key-values did not match, expected has un-matched keys - " + unMatchedKeysExp);
        }
        if (!unMatchedKeysAct.isEmpty()) {
            return this.fail("all key-values did not match, actual has un-matched keys - " + unMatchedKeysAct);
        }
        return true;
    }

    private boolean actualContainsExpected() {
        switch (this.actual.type) {
            case STRING: {
                String actString = (String)this.actual.getValue();
                String expString = (String)this.expected.getValue();
                return actString.contains(expString);
            }
            case LIST: {
                List actList = (List)this.actual.getValue();
                List expList = (List)this.expected.getValue();
                int actListCount = actList.size();
                int expListCount = expList.size();
                boolean[] actVisitedList = new boolean[actListCount];
                if (this.type != Match.Type.CONTAINS_ANY && this.type != Match.Type.CONTAINS_ANY_DEEP && expListCount > actListCount) {
                    return this.fail("actual array length is less than expected - " + actListCount + ":" + expListCount);
                }
                if ((this.type == Match.Type.CONTAINS_ONLY || this.type == Match.Type.CONTAINS_ONLY_DEEP) && expListCount != actListCount) {
                    return this.fail("actual array length is not equal to expected - " + actListCount + ":" + expListCount);
                }
                for (Object exp : expList) {
                    boolean found = false;
                    Match.Value expListValue = new Match.Value(exp);
                    for (int i = 0; i < actListCount; ++i) {
                        Match.Value actListValue = new Match.Value(actList.get(i));
                        MatchOperation mo = new MatchOperation(this.context.descend(i), switch (this.type) {
                            case Match.Type.CONTAINS_DEEP -> actListValue.isMapOrListOrXml() ? Match.Type.CONTAINS_DEEP : Match.Type.EQUALS;
                            case Match.Type.CONTAINS_ONLY_DEEP -> actListValue.isMapOrListOrXml() ? Match.Type.CONTAINS_ONLY_DEEP : Match.Type.EQUALS;
                            case Match.Type.CONTAINS_ANY_DEEP -> actListValue.isMapOrListOrXml() ? Match.Type.CONTAINS_ANY : Match.Type.EQUALS;
                            default -> Match.Type.EQUALS;
                        }, actListValue, expListValue, this.matchEachEmptyAllowed);
                        mo.execute();
                        if (!mo.pass) continue;
                        if (this.type == Match.Type.CONTAINS_ANY || this.type == Match.Type.CONTAINS_ANY_DEEP) {
                            return true;
                        }
                        if (this.type == Match.Type.CONTAINS_ONLY) {
                            if (actVisitedList[i]) continue;
                            actVisitedList[i] = true;
                            found = true;
                            break;
                        }
                        found = true;
                        break;
                    }
                    if (found || this.type == Match.Type.CONTAINS_ANY || this.type == Match.Type.CONTAINS_ANY_DEEP) continue;
                    return this.fail("actual array does not contain expected item - " + expListValue.getAsString());
                }
                if (this.type == Match.Type.CONTAINS_ANY || this.type == Match.Type.CONTAINS_ANY_DEEP) {
                    return this.fail("actual array does not contain any of the expected items");
                }
                return true;
            }
            case MAP: {
                Map actMap = (Map)this.actual.getValue();
                Map expMap = (Map)this.expected.getValue();
                return this.matchMapValues(actMap, expMap);
            }
            case XML: {
                Map actXml = (Map)XmlUtils.toObject((Node)this.actual.getValue());
                Map expXml = (Map)XmlUtils.toObject((Node)this.expected.getValue());
                return this.matchMapValues(actXml, expXml);
            }
        }
        throw new RuntimeException("unexpected type (match contains): " + this.actual.type);
    }

    private static BigDecimal toBigDecimal(Object o) {
        if (o instanceof BigDecimal) {
            return (BigDecimal)o;
        }
        if (o instanceof Number) {
            Number n = (Number)o;
            return BigDecimal.valueOf(n.doubleValue());
        }
        throw new RuntimeException("expected number instead of: " + o);
    }

    private boolean pass() {
        this.pass = true;
        return true;
    }

    private boolean fail(String reason) {
        this.pass = false;
        if (reason == null) {
            return false;
        }
        this.failReason = this.failReason == null ? reason : reason + " | " + this.failReason;
        this.context.root.failures.add(this);
        return false;
    }

    String getFailureReasons() {
        return MatchOperation.collectFailureReasons(this);
    }

    private boolean isXmlAttributeOrMap() {
        return this.context.xml && this.actual.isMap() && (this.context.name.equals("@") || ((Map)this.actual.getValue()).containsKey("_"));
    }

    private static String collectFailureReasons(MatchOperation root) {
        StringBuilder sb = new StringBuilder();
        sb.append("match failed: ").append((Object)root.type).append('\n');
        Collections.reverse(root.failures);
        Iterator<MatchOperation> iterator = root.failures.iterator();
        HashSet<String> previousPaths = new HashSet<String>();
        int index = 0;
        int prevDepth = -1;
        while (iterator.hasNext()) {
            MatchOperation mo = iterator.next();
            if (previousPaths.contains(mo.context.path) || mo.isXmlAttributeOrMap()) continue;
            previousPaths.add(mo.context.path);
            if (mo.context.depth != prevDepth) {
                prevDepth = mo.context.depth;
                ++index;
            }
            String prefix = StringUtils.repeat(' ', index * 2);
            sb.append(prefix).append(mo.context.path).append(" | ").append(mo.failReason);
            sb.append(" (").append((Object)mo.actual.type).append(':').append((Object)mo.expected.type).append(")");
            sb.append('\n');
            if (mo.context.xml) {
                sb.append(prefix).append(mo.actual.getAsXmlString()).append('\n');
                sb.append(prefix).append(mo.expected.getAsXmlString()).append('\n');
            } else {
                Match.Value expected = mo.expected.getSortedLike(mo.actual);
                sb.append(prefix).append(mo.actual.getWithinSingleQuotesIfString()).append('\n');
                sb.append(prefix).append(expected.getWithinSingleQuotesIfString()).append('\n');
            }
            if (!iterator.hasNext()) continue;
            sb.append('\n');
        }
        return sb.toString();
    }
}

