/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.Json;
import com.intuit.karate.KarateException;
import com.intuit.karate.ScenarioActions;
import com.intuit.karate.StringUtils;
import com.intuit.karate.Suite;
import com.intuit.karate.core.Feature;
import com.intuit.karate.core.FeatureCall;
import com.intuit.karate.core.FeatureRuntime;
import com.intuit.karate.core.FeatureSection;
import com.intuit.karate.core.MockInterceptor;
import com.intuit.karate.core.Result;
import com.intuit.karate.core.Scenario;
import com.intuit.karate.core.ScenarioEngine;
import com.intuit.karate.core.ScenarioRuntime;
import com.intuit.karate.core.Step;
import com.intuit.karate.core.StepRuntime;
import com.intuit.karate.core.Variable;
import com.intuit.karate.graal.JsValue;
import com.intuit.karate.http.HttpClientFactory;
import com.intuit.karate.http.HttpUtils;
import com.intuit.karate.http.Request;
import com.intuit.karate.http.ResourceType;
import com.intuit.karate.http.Response;
import com.intuit.karate.http.ServerHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockHandler
implements ServerHandler {
    private static final Logger logger = LoggerFactory.getLogger(MockHandler.class);
    private static final String REQUEST_BYTES = "requestBytes";
    private static final String REQUEST_PARAMS = "requestParams";
    private static final String REQUEST_PARTS = "requestParts";
    private static final String RESPONSE_DELAY = "responseDelay";
    private static final String PATH_MATCHES = "pathMatches";
    private static final String METHOD_IS = "methodIs";
    private static final String TYPE_CONTAINS = "typeContains";
    private static final String ACCEPT_CONTAINS = "acceptContains";
    private static final String HEADER_CONTAINS = "headerContains";
    private static final String PARAM_VALUE = "paramValue";
    private static final String PARAM_EXISTS = "paramExists";
    private static final String PATH_PARAMS = "pathParams";
    private static final String BODY_PATH = "bodyPath";
    private final LinkedHashMap<Feature, ScenarioRuntime> scenarioRuntimes = new LinkedHashMap();
    private final Map<String, Variable> globals = new HashMap<String, Variable>();
    private boolean corsEnabled;
    protected static final ThreadLocal<Request> LOCAL_REQUEST = new ThreadLocal();
    private final String prefix;
    private final MockInterceptor mockInterceptor;
    private static final Result PASSED = Result.passed(0L, 0L);
    private static final String ALLOWED_METHODS = "GET, HEAD, POST, PUT, DELETE, PATCH";

    public MockHandler(Feature feature) {
        this(feature, null);
    }

    public MockHandler(Feature feature, Map<String, Object> args) {
        this(null, Collections.singletonList(feature), args, null);
    }

    public MockHandler(List<Feature> features) {
        this(null, features, null, null);
    }

    public MockHandler(String prefix, List<Feature> features, Map<String, Object> args, MockInterceptor interceptor) {
        this.prefix = "/".equals(prefix) ? null : prefix;
        this.mockInterceptor = interceptor;
        features.forEach(feature -> {
            ScenarioRuntime runtime = this.initRuntime((Feature)feature, args);
            this.corsEnabled = this.corsEnabled || runtime.engine.getConfig().isCorsEnabled();
            this.globals.putAll(runtime.engine.shallowCloneVariables());
            runtime.logger.info("mock server initialized: {}", feature);
            this.scenarioRuntimes.put((Feature)feature, runtime);
        });
    }

    public Object getVariable(String name) {
        Variable v;
        if (this.globals.containsKey(name) && (v = this.globals.get(name)) != null) {
            return JsValue.fromJava(v.getValue());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScenarioRuntime initRuntime(Feature feature, Map<String, Object> args) {
        FeatureRuntime featureRuntime = FeatureRuntime.of(Suite.forTempUse(HttpClientFactory.DEFAULT), new FeatureCall(feature), args);
        FeatureSection section = new FeatureSection();
        section.setIndex(-1);
        Scenario dummy = new Scenario(feature, section, -1);
        section.setScenario(dummy);
        ScenarioRuntime runtime = new ScenarioRuntime(featureRuntime, dummy);
        runtime.logger.setLogOnly(true);
        runtime.engine.setVariable(PATH_MATCHES, this::pathMatches);
        runtime.engine.setVariable(PARAM_EXISTS, this::paramExists);
        runtime.engine.setVariable(PARAM_VALUE, this::paramValue);
        runtime.engine.setVariable(METHOD_IS, this::methodIs);
        runtime.engine.setVariable(TYPE_CONTAINS, this::typeContains);
        runtime.engine.setVariable(ACCEPT_CONTAINS, this::acceptContains);
        runtime.engine.setVariable(HEADER_CONTAINS, this::headerContains);
        runtime.engine.setVariable(BODY_PATH, this::bodyPath);
        runtime.engine.init();
        if (feature.isBackgroundPresent()) {
            ScenarioEngine prevEngine = ScenarioEngine.get();
            try {
                ScenarioEngine.set(runtime.engine);
                for (Step step : feature.getBackground().getSteps()) {
                    Result result = StepRuntime.execute(step, runtime.actions);
                    if (!result.isFailed()) continue;
                    String message = "mock-server background failed - " + feature + ":" + step.getLine();
                    runtime.logger.error(message, new Object[0]);
                    throw new KarateException(message, result.getError());
                }
            }
            finally {
                ScenarioEngine.set(prevEngine);
            }
        }
        return runtime;
    }

    @Override
    public synchronized Response handle(Request req) {
        if (this.corsEnabled && "OPTIONS".equals(req.getMethod())) {
            Response response = new Response(200);
            response.setHeader("Allow", ALLOWED_METHODS);
            response.setHeader("Access-Control-Allow-Origin", "*");
            response.setHeader("Access-Control-Allow-Methods", ALLOWED_METHODS);
            List<String> requestHeaders = req.getHeaderValues("Access-Control-Request-Headers");
            if (requestHeaders != null) {
                response.setHeader("Access-Control-Allow-Headers", requestHeaders);
            }
            return response;
        }
        if (this.prefix != null && req.getPath().startsWith(this.prefix)) {
            req.setPath(req.getPath().substring(this.prefix.length()));
        }
        ScenarioEngine prevEngine = ScenarioEngine.get();
        block0: for (Map.Entry<Feature, ScenarioRuntime> entry : this.scenarioRuntimes.entrySet()) {
            Feature feature = entry.getKey();
            ScenarioRuntime runtime = entry.getValue();
            Thread.currentThread().setContextClassLoader(runtime.featureRuntime.suite.classLoader);
            LOCAL_REQUEST.set(req);
            req.processBody();
            ScenarioEngine engine = MockHandler.initEngine(runtime, this.globals, req);
            for (FeatureSection fs : feature.getSections()) {
                if (fs.isOutline()) {
                    runtime.logger.warn("skipping scenario outline - {}:{}", feature, fs.getScenarioOutline().getLine());
                    continue block0;
                }
                Scenario scenario = fs.getScenario();
                if (!this.isMatchingScenario(scenario, engine)) continue;
                ScenarioActions actions = new ScenarioActions(engine);
                Result result = this.executeScenarioSteps(feature, runtime, scenario, actions);
                engine.mockAfterScenario();
                Map<String, Object> configureHeaders = engine.mockConfigureHeaders();
                Variable response = engine.vars.remove("response");
                Variable responseStatus = engine.vars.remove("responseStatus");
                Variable responseHeaders = engine.vars.remove("responseHeaders");
                Variable responseDelay = engine.vars.remove(RESPONSE_DELAY);
                this.globals.putAll(engine.shallowCloneVariables());
                Response res = new Response(200);
                if (result.isFailed()) {
                    response = new Variable(result.getError().getMessage());
                    responseStatus = new Variable(500);
                } else {
                    if (this.corsEnabled) {
                        res.setHeader("Access-Control-Allow-Origin", "*");
                    }
                    res.setHeaders(configureHeaders);
                    if (responseHeaders != null && responseHeaders.isMap()) {
                        res.setHeaders((Map)responseHeaders.getValue());
                    }
                    if (responseDelay != null) {
                        res.setDelay(responseDelay.getAsInt());
                    }
                }
                if (response != null && !response.isNull()) {
                    ResourceType rt;
                    res.setBody(response.getAsByteArray());
                    if (res.getContentType() == null && (rt = ResourceType.fromObject(response.getValue())) != null) {
                        res.setContentType(rt.contentType);
                    }
                }
                if (responseStatus != null) {
                    res.setStatus(responseStatus.getAsInt());
                }
                if (prevEngine != null) {
                    ScenarioEngine.set(prevEngine);
                }
                if (this.mockInterceptor != null) {
                    this.mockInterceptor.intercept(req, res, scenario);
                }
                return res;
            }
        }
        logger.warn("no scenarios matched, returning 404: {}", (Object)req);
        if (prevEngine != null) {
            ScenarioEngine.set(prevEngine);
        }
        return new Response(404);
    }

    private static ScenarioEngine initEngine(ScenarioRuntime runtime, Map<String, Variable> globals, Request req) {
        ScenarioEngine engine = new ScenarioEngine(runtime.engine.getConfig(), runtime, new HashMap<String, Variable>(globals), runtime.logger);
        engine.init();
        engine.setVariable("requestUrlBase", req.getUrlBase());
        engine.setVariable("requestPath", req.getPath());
        engine.setVariable("requestUri", req.getPathRaw());
        engine.setVariable("requestMethod", req.getMethod());
        engine.setVariable("requestHeaders", req.getHeaders());
        engine.setVariable("request", req.getBodyConverted());
        engine.setVariable(REQUEST_PARAMS, req.getParams());
        engine.setVariable(REQUEST_BYTES, req.getBody());
        engine.setRequest(req);
        runtime.featureRuntime.setMockEngine(engine);
        ScenarioEngine.set(engine);
        Map<String, List<Map<String, Object>>> parts = req.getMultiParts();
        if (parts != null) {
            engine.setHiddenVariable(REQUEST_PARTS, parts);
        }
        return engine;
    }

    private Result executeScenarioSteps(Feature feature, ScenarioRuntime runtime, Scenario scenario, ScenarioActions actions) {
        Result result = PASSED;
        for (Step step : scenario.getSteps()) {
            result = StepRuntime.execute(step, actions);
            if (result.isAborted()) {
                runtime.logger.debug("abort at {}:{}", feature, step.getLine());
                break;
            }
            if (!result.isFailed()) continue;
            String message = "server-side scenario failed, " + feature + ":" + step.getLine() + "\n" + step.toString() + "\n" + result.getError().getMessage();
            runtime.logger.error(message, new Object[0]);
            break;
        }
        return result;
    }

    private boolean isMatchingScenario(Scenario scenario, ScenarioEngine engine) {
        String expression = StringUtils.trimToNull(scenario.getName() + scenario.getDescription());
        if (expression == null) {
            engine.logger.debug("default scenario matched at line: {} - {}", scenario.getLine(), engine.getVariable("requestUri"));
            return true;
        }
        try {
            Variable v = engine.evalJs(expression);
            if (v.isTrue()) {
                engine.logger.debug("scenario matched at line {}: {}", scenario.getLine(), expression);
                return true;
            }
            engine.logger.trace("scenario skipped at line {}: {}", scenario.getLine(), expression);
            return false;
        }
        catch (Exception e) {
            engine.logger.warn("scenario match evaluation failed at line {}: {} - {}", scenario.getLine(), expression, "" + e);
            return false;
        }
    }

    public boolean pathMatches(String pattern) {
        String uri = LOCAL_REQUEST.get().getPath();
        if (uri.equals(pattern)) {
            return true;
        }
        Map<String, String> pathParams = HttpUtils.parseUriPattern(pattern, uri);
        if (pathParams == null) {
            return false;
        }
        ScenarioEngine.get().setVariable(PATH_PARAMS, pathParams);
        return true;
    }

    public boolean paramExists(String name) {
        Map<String, List<String>> params = LOCAL_REQUEST.get().getParams();
        return params != null && params.containsKey(name);
    }

    public String paramValue(String name) {
        return LOCAL_REQUEST.get().getParam(name);
    }

    public boolean methodIs(String name) {
        return LOCAL_REQUEST.get().getMethod().equalsIgnoreCase(name);
    }

    public boolean typeContains(String text) {
        String contentType = LOCAL_REQUEST.get().getContentType();
        return contentType != null && contentType.contains(text);
    }

    public boolean acceptContains(String text) {
        String acceptHeader = LOCAL_REQUEST.get().getHeader("Accept");
        return acceptHeader != null && acceptHeader.contains(text);
    }

    public boolean headerContains(String name, String value) {
        List<String> values = LOCAL_REQUEST.get().getHeaderValues(name);
        if (values != null) {
            for (String v : values) {
                if (!v.contains(value)) continue;
                return true;
            }
        }
        return false;
    }

    public Object bodyPath(String path) {
        Object result;
        Object body = LOCAL_REQUEST.get().getBodyConverted();
        if (body == null) {
            return null;
        }
        if (path.startsWith("/")) {
            Variable v = ScenarioEngine.evalXmlPath(new Variable(body), path);
            if (v.isNotPresent()) {
                return null;
            }
            return JsValue.fromJava(v.getValue());
        }
        Json json = Json.of(body);
        try {
            result = json.get(path);
        }
        catch (Exception e) {
            return null;
        }
        return JsValue.fromJava(result);
    }
}

