/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.JsonUtils;
import com.intuit.karate.StringUtils;
import com.intuit.karate.graal.JsEngine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Table {
    private static final Logger logger = LoggerFactory.getLogger(Table.class);
    private final List<List<String>> rows;
    private final Map<String, Column> colMap;
    private final List<Column> cols;
    private final List<Integer> lineNumbers;
    private final String dynamicExpression;

    public String getDynamicExpression() {
        return this.dynamicExpression;
    }

    public boolean isDynamic() {
        return this.dynamicExpression != null;
    }

    public Collection<String> getKeys() {
        return this.colMap.keySet();
    }

    public int getLineNumberForRow(int i) {
        return this.lineNumbers.get(i);
    }

    public Table replace(String token, String value) {
        int rowCount = this.rows.size();
        List<String> keys = this.rows.get(0);
        int colCount = keys.size();
        ArrayList<List<String>> list = new ArrayList<List<String>>(rowCount);
        list.add(keys);
        for (int i = 1; i < rowCount; ++i) {
            List<String> row = this.rows.get(i);
            ArrayList<String> replaced = new ArrayList<String>(colCount);
            list.add(replaced);
            for (int j = 0; j < colCount; ++j) {
                String text = row.get(j).replace(token, value);
                replaced.add(text);
            }
        }
        return new Table(list, this.lineNumbers);
    }

    public String getValueAsString(String key, int row) {
        Column col = this.colMap.get(key);
        if (col == null) {
            return null;
        }
        return this.rows.get(row).get(col.index);
    }

    public static Table fromKarateJson(List<Map<String, Object>> tableRows) {
        ArrayList<List<String>> rows = new ArrayList<List<String>>(tableRows.size());
        ArrayList<Integer> lines = new ArrayList<Integer>(tableRows.size());
        for (Map<String, Object> row : tableRows) {
            rows.add((List)row.get("row"));
            lines.add((Integer)row.get("line"));
        }
        return new Table(rows, lines);
    }

    public List<Map<String, Object>> toKarateJson() {
        int count = this.rows.size();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(count);
        for (int i = 0; i < count; ++i) {
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            list.add(map);
            map.put("row", this.rows.get(i));
            map.put("line", this.lineNumbers.get(i));
        }
        return list;
    }

    public Table(List<List<String>> rows, List<Integer> lineNumbers) {
        this.rows = rows;
        this.lineNumbers = lineNumbers;
        List<String> keys = rows.get(0);
        int colCount = keys.size();
        this.colMap = new LinkedHashMap<String, Column>(colCount);
        for (int i = 0; i < colCount; ++i) {
            ColumnType type;
            String key = keys.get(i);
            if (key.endsWith("!")) {
                key = key.substring(0, key.length() - 1);
                type = ColumnType.EVALUATED;
            } else {
                type = ColumnType.STRING;
            }
            this.colMap.put(key, new Column(key, i, type));
        }
        this.dynamicExpression = colCount == 1 && rows.size() == 1 ? keys.get(0) : null;
        this.cols = new ArrayList<Column>(this.colMap.values());
    }

    public List<List<String>> getRows() {
        return this.rows;
    }

    public List<Map<String, String>> getRowsAsMaps() {
        int rowCount = this.rows.size();
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>(rowCount - 1);
        for (int i = 1; i < rowCount; ++i) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(this.cols.size());
            list.add(map);
            List<String> row = this.rows.get(i);
            for (Column col : this.cols) {
                map.put(col.key, row.get(col.index));
            }
        }
        return list;
    }

    public List<Map<String, Object>> getRowsAsMapsConverted() {
        int rowCount = this.rows.size();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(rowCount - 1);
        for (int i = 1; i < rowCount; ++i) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(this.cols.size());
            list.add(map);
            List<String> row = this.rows.get(i);
            for (Column col : this.cols) {
                map.put(col.key, Table.convert(row.get(col.index), col));
            }
        }
        return list;
    }

    private static Object convert(String raw, Column col) {
        try {
            switch (col.type) {
                case EVALUATED: {
                    if (JsonUtils.isJson((String)raw)) {
                        raw = "(" + (String)raw + ")";
                    }
                    return JsEngine.evalGlobal((String)raw).getValue();
                }
            }
            if (StringUtils.isBlank((String)raw)) {
                return null;
            }
            return raw;
        }
        catch (Exception e) {
            if (logger.isTraceEnabled()) {
                logger.trace("type conversion failed for column: {}, type: {} - {}", new Object[]{col.key, col.type, e.getMessage()});
            }
            return raw;
        }
    }

    public Map<String, Object> getExampleData(int exampleIndex) {
        List<String> row = this.rows.get(exampleIndex + 1);
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(this.cols.size());
        for (Column col : this.cols) {
            String raw = row.get(col.index);
            map.put(col.key, Table.convert(raw, col));
        }
        return map;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('\n');
        for (List<String> row : this.rows) {
            sb.append('|').append('\t');
            for (String s : row) {
                sb.append(s).append('\t').append('|');
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    class Column {
        final String key;
        final int index;
        final ColumnType type;

        Column(String key, int index, ColumnType type) {
            this.key = key;
            this.index = index;
            this.type = type;
        }
    }

    static enum ColumnType {
        STRING,
        EVALUATED;

    }
}

