/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.JsonUtils;
import com.intuit.karate.StringUtils;
import com.intuit.karate.core.FeatureResult;
import com.intuit.karate.core.Scenario;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TimelineResults {
    private final Map<String, Integer> groupsMap = new LinkedHashMap<String, Integer>();
    private final List<Map> items = new ArrayList<Map>();
    private final DateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
    private int id;

    public void addFeatureResult(FeatureResult fr) {
        fr.getScenarioResults().stream().forEach(sr -> {
            String threadName = sr.getExecutorName();
            Integer groupId = this.groupsMap.get(threadName);
            if (groupId == null) {
                groupId = this.groupsMap.size() + 1;
                this.groupsMap.put(threadName, groupId);
            }
            LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>(10);
            this.items.add(item);
            item.put("id", ++this.id);
            item.put("group", groupId);
            Scenario s = sr.getScenario();
            String featureName = s.getFeature().getResource().getFileNameWithoutExtension();
            String content = featureName + s.getRefId();
            item.put("content", content);
            long startTime = sr.getStartTime();
            item.put("start", startTime);
            long endTime = sr.getEndTime() - 1L;
            item.put("end", endTime);
            String startTimeString = this.dateFormat.format(new Date(startTime));
            String endTimeString = this.dateFormat.format(new Date(endTime));
            content = content + " " + startTimeString + "-" + endTimeString;
            String scenarioTitle = StringUtils.trimToEmpty(s.getName());
            if (!scenarioTitle.isEmpty()) {
                content = content + " " + scenarioTitle;
            }
            item.put("title", content);
            if (sr.isFailed()) {
                item.put("className", "failed");
            }
        });
    }

    public Map<String, Object> toKarateJson() {
        ArrayList groups = new ArrayList(this.groupsMap.size());
        this.groupsMap.forEach((k, v) -> {
            HashMap<String, Object> group = new HashMap<String, Object>(2);
            groups.add(group);
            group.put("id", v);
            group.put("content", k);
        });
        StringBuilder sb = new StringBuilder();
        sb.append('\n');
        sb.append("var groups = ").append(JsonUtils.toJson(groups)).append(';');
        sb.append('\n');
        sb.append("var items = ").append(JsonUtils.toJson(this.items)).append(';');
        sb.append('\n');
        return Collections.singletonMap("data", sb.toString());
    }
}

