/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.driver;

import com.intuit.karate.Http;
import com.intuit.karate.Json;
import com.intuit.karate.Logger;
import com.intuit.karate.core.Variable;
import com.intuit.karate.driver.Driver;
import com.intuit.karate.driver.DriverElement;
import com.intuit.karate.driver.DriverOptions;
import com.intuit.karate.driver.Element;
import com.intuit.karate.http.ResourceType;
import com.intuit.karate.http.Response;
import com.intuit.karate.shell.Command;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public abstract class WebDriver
implements Driver {
    protected final DriverOptions options;
    protected final Command command;
    protected final Http http;
    private final String sessionId;
    private boolean terminated;
    protected boolean open = true;
    protected Boolean specCompliant;
    protected final Logger logger;

    protected WebDriver(DriverOptions options) {
        this.options = options;
        this.logger = options.driverLogger;
        this.command = options.startProcess();
        this.http = options.getHttp();
        Response response = this.http.path("session").post(options.getWebDriverSessionPayload());
        if (response.getStatus() != 200) {
            String message = "webdriver session create status " + response.getStatus() + ", " + response.getBodyAsString();
            this.logger.error(message, new Object[0]);
            if (this.command != null) {
                this.command.close(true);
            }
            throw new RuntimeException(message);
        }
        this.sessionId = (String)response.json().getFirst("$..sessionId");
        this.logger.debug("init session id: {}", this.sessionId);
        this.http.url(this.http.urlBase + "/session/" + this.sessionId);
        if (options.start) {
            this.activate();
        }
    }

    @Override
    public Driver timeout(Integer millis) {
        this.options.setTimeout(millis);
        this.http.configure("readTimeout", "" + this.options.getTimeout());
        return this;
    }

    @Override
    public Driver timeout() {
        return this.timeout(null);
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public Http getHttp() {
        return this.http;
    }

    private String getSubmitHash() {
        return this.getUrl() + this.elementId("html");
    }

    protected <T> T retryIfEnabled(String locator, Supplier<T> action) {
        String before;
        if (this.options.isRetryEnabled()) {
            this.waitFor(locator);
        }
        if (this.options.highlight) {
            this.highlight(locator, this.options.highlightDuration);
        }
        if ((before = this.options.getPreSubmitHash()) != null) {
            this.logger.trace("submit requested, will wait for page load after next action on : {}", locator);
            this.options.setPreSubmitHash(null);
            T result = action.get();
            Integer retryInterval = this.options.getRetryInterval();
            this.options.setRetryInterval(500);
            this.options.retry(() -> this.getSubmitHash(), hash -> !before.equals(hash), "waiting for document to change", false);
            this.options.setRetryInterval(retryInterval);
            return result;
        }
        return action.get();
    }

    protected boolean isJavaScriptError(Response res) {
        return res.getStatus() != 200 && !((String)res.json().get("value")).contains("unexpected alert open");
    }

    protected boolean isLocatorError(Response res) {
        return res.getStatus() != 200;
    }

    protected boolean isCookieError(Response res) {
        return res.getStatus() != 200;
    }

    private Element evalLocator(String locator, String dotExpression) {
        this.eval(this.prefixReturn(DriverOptions.selector(locator) + "." + dotExpression));
        return DriverElement.locatorExists(this, locator);
    }

    private Element evalFocus(String locator) {
        this.eval(this.options.focusJs(locator));
        return DriverElement.locatorExists(this, locator);
    }

    protected Variable eval(String expression, List args) {
        Json json = Json.object().set("script", expression).set("args", args == null ? Collections.EMPTY_LIST : args);
        Response res = this.http.path("execute", "sync").post(json);
        if (this.isJavaScriptError(res)) {
            this.logger.warn("javascript failed, will retry once: {}", res.getBodyAsString());
            this.options.sleep();
            res = this.http.path("execute", "sync").post(json);
            if (this.isJavaScriptError(res)) {
                String message = "javascript failed twice: " + res.getBodyAsString();
                this.logger.error(message, new Object[0]);
                throw new RuntimeException(message);
            }
        }
        return new Variable(res.json().get("value"));
    }

    protected Variable eval(String expression) {
        return this.eval(expression, null);
    }

    protected List<String> getElementKeys() {
        return Arrays.asList("element-6066-11e4-a52e-4f735466cecf", "ELEMENT");
    }

    protected String getJsonForInput(String text) {
        return Json.object().set("text", text).toString();
    }

    protected String getJsonForLegacyInput(String text) {
        return Json.of("{ value: [ '" + text + "' ] }").toString();
    }

    protected String getJsonForHandle(String text) {
        return Json.object().set("handle", text).toString();
    }

    protected String getJsonForFrame(String text) {
        return Json.object().set("id", text).toString();
    }

    protected String selectorPayload(String locator) {
        if (locator.startsWith("{")) {
            locator = DriverOptions.preProcessWildCard(locator);
        }
        Json json = Json.object();
        if (locator.startsWith("/")) {
            json.set("using", "xpath").set("value", locator);
        } else {
            json.set("using", "css selector").set("value", locator);
        }
        return json.toString();
    }

    @Override
    public String elementId(String locator) {
        List resultElements;
        String resultElement;
        String json = this.selectorPayload(locator);
        Response res = this.http.path("element").postJson(json);
        if (this.isLocatorError(res)) {
            this.logger.warn("locator failed, will retry once: {}", res.getBodyAsString());
            this.options.sleep();
            res = this.http.path("element").postJson(json);
            if (this.isLocatorError(res)) {
                String message = "locator failed twice: " + res.getBodyAsString();
                this.logger.error(message, new Object[0]);
                throw new RuntimeException(message);
            }
        }
        String string = resultElement = (resultElements = res.json().getAll("$..", this.getElementKeys()).stream().flatMap(Collection::stream).collect(Collectors.toList())) != null && !resultElements.isEmpty() ? (String)resultElements.get(0) : null;
        if (resultElement == null) {
            String message = "locator failed to retrieve element returned by target driver: " + res.getBodyAsString();
            this.logger.error(message, new Object[0]);
            throw new RuntimeException(message);
        }
        return resultElement;
    }

    @Override
    public List<String> elementIds(String locator) {
        return this.http.path("elements").postJson(this.selectorPayload(locator)).json().getAll("$..", this.getElementKeys()).stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public DriverOptions getOptions() {
        return this.options;
    }

    @Override
    public void setUrl(String url) {
        Json json = Json.object().set("url", url);
        this.http.path("url").post(json);
    }

    @Override
    public Map<String, Object> getDimensions() {
        return (Map)this.http.path("window", "rect").get().json().get("value");
    }

    @Override
    public void setDimensions(Map<String, Object> map) {
        this.http.path("window", "rect").post(map);
    }

    @Override
    public void refresh() {
        this.http.path("refresh").postJson("{}");
    }

    @Override
    public void reload() {
        this.refresh();
    }

    @Override
    public void back() {
        this.http.path("back").postJson("{}");
    }

    @Override
    public void forward() {
        this.http.path("forward").postJson("{}");
    }

    @Override
    public void maximize() {
        this.http.path("window", "maximize").postJson("{}");
    }

    @Override
    public void minimize() {
        this.http.path("window", "minimize").postJson("{}");
    }

    @Override
    public void fullscreen() {
        this.http.path("window", "fullscreen").postJson("{}");
    }

    @Override
    public Element focus(String locator) {
        return this.retryIfEnabled(locator, () -> this.evalFocus(locator));
    }

    @Override
    public Element clear(String locator) {
        return this.retryIfEnabled(locator, () -> this.evalLocator(locator, "value = ''"));
    }

    @Override
    public Element input(String locator, String value) {
        return this.retryIfEnabled(locator, () -> {
            String elementId;
            if (locator.startsWith("(")) {
                this.evalFocus(locator);
                List elements = this.http.path("element", "active").get().json().getAll("$..", this.getElementKeys()).stream().flatMap(Collection::stream).collect(Collectors.toList());
                elementId = elements != null && !elements.isEmpty() ? (String)elements.get(0) : null;
            } else {
                elementId = this.elementId(locator);
            }
            Response response = this.http.path("element", elementId, "value").postJson(this.isSpecCompliant() ? this.getJsonForInput(value) : this.getJsonForLegacyInput(value));
            if (this.checkForSpecCompliance()) {
                if (response.json().get("$.value") != null) {
                    String responseMessage = (String)response.json().get("$.value.message");
                    if (responseMessage.contains("invalid argument: 'value' must be a list")) {
                        this.http.path("element", elementId, "value").postJson(this.getJsonForLegacyInput(value));
                        this.specCompliant = false;
                    } else {
                        this.specCompliant = true;
                    }
                } else {
                    this.specCompliant = true;
                }
            }
            return DriverElement.locatorExists(this, locator);
        });
    }

    @Override
    public Element click(String locator) {
        return this.retryIfEnabled(locator, () -> this.evalLocator(locator, "click()"));
    }

    @Override
    public Driver submit() {
        this.options.setPreSubmitHash(this.getSubmitHash());
        return this;
    }

    @Override
    public Element select(String locator, String text) {
        return this.retryIfEnabled(locator, () -> {
            this.eval(this.options.optionSelector(locator, text));
            return DriverElement.locatorExists(this, locator);
        });
    }

    @Override
    public Element select(String locator, int index) {
        return this.retryIfEnabled(locator, () -> {
            this.eval(this.options.optionSelector(locator, index));
            return DriverElement.locatorExists(this, locator);
        });
    }

    @Override
    public void actions(List<Map<String, Object>> actions) {
        this.http.path("actions").post(Collections.singletonMap("actions", actions));
    }

    @Override
    public void close() {
        this.http.path("window").delete();
        this.open = false;
    }

    @Override
    public boolean isTerminated() {
        return this.terminated;
    }

    public boolean isSpecCompliant() {
        return this.specCompliant == null || this.specCompliant != false;
    }

    public boolean checkForSpecCompliance() {
        return this.specCompliant == null;
    }

    @Override
    public void quit() {
        if (this.terminated) {
            return;
        }
        this.terminated = true;
        if (this.open) {
            this.close();
        }
        try {
            this.http.delete();
        }
        catch (Exception e) {
            this.logger.warn("session delete failed: {}", e.getMessage());
        }
        if (this.command != null) {
            this.command.close(true);
        }
    }

    @Override
    public String getUrl() {
        return (String)this.http.path("url").get().json().get("value");
    }

    private String evalReturn(String locator, String dotExpression) {
        return this.eval("return " + DriverOptions.selector(locator) + "." + dotExpression).getAsString();
    }

    @Override
    public String html(String locator) {
        return this.retryIfEnabled(locator, () -> this.evalReturn(locator, "outerHTML"));
    }

    @Override
    public String text(String locator) {
        return this.retryIfEnabled(locator, () -> this.evalReturn(locator, "textContent"));
    }

    @Override
    public String value(String locator) {
        return this.retryIfEnabled(locator, () -> this.evalReturn(locator, "value"));
    }

    @Override
    public Element value(String locator, String value) {
        return this.retryIfEnabled(locator, () -> this.evalLocator(locator, "value = '" + value + "'"));
    }

    @Override
    public String attribute(String locator, String name) {
        return this.retryIfEnabled(locator, () -> this.evalReturn(locator, "getAttribute('" + name + "')"));
    }

    @Override
    public String property(String locator, String name) {
        return this.retryIfEnabled(locator, () -> this.evalReturn(locator, name));
    }

    @Override
    public Map<String, Object> position(String locator) {
        return this.position(locator, false);
    }

    @Override
    public Map<String, Object> position(String locator, boolean relative) {
        return this.retryIfEnabled(locator, () -> (Map)this.eval("return " + DriverOptions.selector(locator) + ".getBoundingClientRect()").getValue());
    }

    @Override
    public boolean enabled(String locator) {
        return this.retryIfEnabled(locator, () -> this.eval("return !" + DriverOptions.selector(locator) + ".disabled").isTrue());
    }

    private String prefixReturn(String expression) {
        return expression.startsWith("return ") ? expression : "return " + expression;
    }

    @Override
    public boolean waitUntil(String expression) {
        return this.options.retry(() -> {
            try {
                return this.eval(this.prefixReturn(expression)).isTrue();
            }
            catch (Exception e) {
                this.logger.warn("waitUntil evaluate failed: {}", e.getMessage());
                return false;
            }
        }, b -> b, "waitUntil (js)", true);
    }

    @Override
    public Object script(String expression) {
        expression = this.prefixReturn(expression);
        return this.eval(expression).getValue();
    }

    @Override
    public String getTitle() {
        return (String)this.http.path("title").get().json().get("value");
    }

    @Override
    public List<Map> getCookies() {
        return (List)this.http.path("cookie").get().json().get("value");
    }

    @Override
    public Map<String, Object> cookie(String name) {
        return (Map)this.http.path("cookie", name).get().json().get("value");
    }

    @Override
    public void cookie(Map<String, Object> cookie) {
        Response res = this.http.path("cookie").post(Collections.singletonMap("cookie", cookie));
        if (this.isCookieError(res)) {
            throw new RuntimeException("set-cookie failed: " + res.getBodyAsString());
        }
    }

    @Override
    public void deleteCookie(String name) {
        this.http.path("cookie", name).delete();
    }

    @Override
    public void clearCookies() {
        this.http.path("cookie").delete();
    }

    @Override
    public void dialog(boolean accept) {
        this.dialog(accept, null);
    }

    @Override
    public String getDialogText() {
        return (String)this.http.path("alert", "text").get().json().get("value");
    }

    @Override
    public void dialog(boolean accept, String text) {
        if (text == null) {
            this.http.path("alert", accept ? "accept" : "dismiss").postJson("{}");
        } else {
            this.http.path("alert", "text").post(Collections.singletonMap("text", text));
            this.http.path("alert", "accept").postJson("{}");
        }
    }

    @Override
    public byte[] screenshot(boolean embed) {
        return this.screenshot(null, embed);
    }

    @Override
    public byte[] screenshot(String locator, boolean embed) {
        String temp = locator == null ? (String)this.http.path("screenshot").get().json().get("value") : this.retryIfEnabled(locator, () -> {
            String id = this.elementId(locator);
            return (String)this.http.path("element", id, "screenshot").get().json().get("value");
        });
        byte[] bytes = this.getDecoder().decode(temp);
        if (embed) {
            this.getRuntime().embed(bytes, ResourceType.PNG);
        }
        return bytes;
    }

    @Override
    public List<String> getPages() {
        return (List)this.http.path("window", "handles").get().json().get("value");
    }

    @Override
    public void switchPage(String titleOrUrl) {
        if (titleOrUrl == null) {
            return;
        }
        this.options.retry(() -> {
            for (String handle : this.getPages()) {
                this.http.path("window").postJson(this.getJsonForHandle(handle));
                String title = this.getTitle();
                if (title != null && title.contains(titleOrUrl)) {
                    return true;
                }
                String url = this.getUrl();
                if (url == null || !url.contains(titleOrUrl)) continue;
                return true;
            }
            return false;
        }, returned -> returned, "waiting to switch to tab: " + titleOrUrl, true);
    }

    @Override
    public void switchPage(int index) {
        if (index == -1) {
            return;
        }
        String json = Json.object().set("id", index).toString();
        this.http.path("window").postJson(json);
    }

    @Override
    public void switchFrame(int index) {
        if (index == -1) {
            this.http.path("frame", "parent").postJson("{}");
            return;
        }
        String json = Json.object().set("id", index).toString();
        this.http.path("frame").postJson(json);
    }

    @Override
    public void switchFrame(String locator) {
        if (locator == null) {
            this.http.path("frame", "parent").postJson("{}");
            return;
        }
        this.retryIfEnabled(locator, () -> {
            String frameId = this.elementId(locator);
            if (frameId == null) {
                return null;
            }
            List<String> ids = this.elementIds("iframe,frame");
            for (int i = 0; i < ids.size(); ++i) {
                String id = ids.get(i);
                if (!frameId.equals(id)) continue;
                this.switchFrame(i);
                break;
            }
            return null;
        });
    }

    protected Base64.Decoder getDecoder() {
        return Base64.getDecoder();
    }

    @Override
    public byte[] pdf(Map<String, Object> printOptions) {
        String temp = (String)this.http.path("print").post(printOptions).json().get("value");
        return Base64.getDecoder().decode(temp);
    }
}

