/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http;

import com.intuit.karate.FileUtils;
import com.intuit.karate.JsonUtils;
import com.intuit.karate.Logger;
import com.intuit.karate.core.Config;
import com.intuit.karate.core.Variable;
import com.intuit.karate.http.HttpLogModifier;
import com.intuit.karate.http.HttpRequest;
import com.intuit.karate.http.ResourceType;
import com.intuit.karate.http.Response;
import java.util.List;
import java.util.Map;

public class HttpLogger {
    private int requestCount;
    private final Logger logger;

    public HttpLogger(Logger logger) {
        this.logger = logger;
    }

    private static void logHeaders(int num, String prefix, StringBuilder sb, HttpLogModifier modifier, Map<String, List<String>> headers) {
        if (headers == null || headers.isEmpty()) {
            return;
        }
        sb.append('\n');
        headers.forEach((k, v) -> {
            for (String value : v) {
                sb.append(num).append(prefix).append((String)k).append(": ");
                if (modifier == null) {
                    sb.append(value);
                } else {
                    sb.append(modifier.header((String)k, value));
                }
                sb.append('\n');
            }
        });
    }

    private static void logBody(Config config, HttpLogModifier logModifier, StringBuilder sb, String uri, byte[] body, boolean request, ResourceType rt) {
        String text;
        if (body == null) {
            return;
        }
        if (config != null && HttpLogger.needsPrettyLogging(config, request)) {
            Object converted = JsonUtils.fromBytes(body, false, rt);
            Variable v = new Variable(converted);
            text = v.getAsPrettyString();
        } else {
            text = FileUtils.toString(body);
        }
        if (logModifier != null) {
            text = request ? logModifier.request(uri, text) : logModifier.response(uri, text);
        }
        sb.append(text);
    }

    private static boolean needsPrettyLogging(Config config, boolean request) {
        return HttpLogger.logPrettyRequest(config, request) || HttpLogger.logPrettyResponse(config, request);
    }

    private static boolean logPrettyResponse(Config config, boolean request) {
        return !request && config.isLogPrettyResponse();
    }

    private static boolean logPrettyRequest(Config config, boolean request) {
        return request && config.isLogPrettyRequest();
    }

    private static HttpLogModifier logModifier(Config config, String uri) {
        HttpLogModifier logModifier = config.getLogModifier();
        return logModifier == null ? null : (logModifier.enableForUri(uri) ? logModifier : null);
    }

    public static String getStatusFailureMessage(int expected, Config config, HttpRequest request, Response response) {
        String url = request.getUrl();
        HttpLogModifier logModifier = HttpLogger.logModifier(config, url);
        String maskedUrl = logModifier == null ? url : logModifier.uri(url);
        String rawResponse = response.getBodyAsString();
        if (rawResponse != null && logModifier != null) {
            rawResponse = logModifier.response(url, rawResponse);
        }
        long responseTime = request.getEndTime() - request.getStartTime();
        return "status code was: " + response.getStatus() + ", expected: " + expected + ", response time in milliseconds: " + responseTime + ", url: " + maskedUrl + ", response: \n" + rawResponse;
    }

    public void logRequest(Config config, HttpRequest request) {
        ++this.requestCount;
        String uri = request.getUrl();
        HttpLogModifier requestModifier = HttpLogger.logModifier(config, uri);
        String maskedUri = requestModifier == null ? uri : requestModifier.uri(uri);
        StringBuilder sb = new StringBuilder();
        sb.append("request:\n").append(this.requestCount).append(" > ").append(request.getMethod()).append(' ').append(maskedUri);
        HttpLogger.logHeaders(this.requestCount, " > ", sb, requestModifier, request.getHeaders());
        ResourceType rt = ResourceType.fromContentType(request.getContentType());
        if (rt != null && !rt.isBinary()) {
            byte[] body = rt == ResourceType.MULTIPART ? (request.getBodyForDisplay() == null ? null : request.getBodyForDisplay().getBytes()) : request.getBody();
            HttpLogger.logBody(config, requestModifier, sb, uri, body, true, rt);
        }
        sb.append('\n');
        this.logger.debug("{}", sb);
    }

    public void logResponse(Config config, HttpRequest request, Response response) {
        long startTime = request.getStartTime();
        long elapsedTime = request.getEndTime() - startTime;
        response.setResponseTime(elapsedTime);
        StringBuilder sb = new StringBuilder();
        String uri = request.getUrl();
        HttpLogModifier responseModifier = HttpLogger.logModifier(config, uri);
        sb.append("response time in milliseconds: ").append(elapsedTime).append('\n');
        sb.append(this.requestCount).append(" < ").append(response.getStatus());
        HttpLogger.logHeaders(this.requestCount, " < ", sb, responseModifier, response.getHeaders());
        ResourceType rt = response.getResourceType();
        if (rt != null && !rt.isBinary()) {
            HttpLogger.logBody(config, responseModifier, sb, uri, response.getBody(), false, rt);
        }
        sb.append('\n');
        this.logger.debug("{}", sb);
    }
}

