/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http;

import com.intuit.karate.FileUtils;
import com.intuit.karate.JsonUtils;
import com.intuit.karate.StringUtils;
import com.intuit.karate.graal.JsArray;
import com.intuit.karate.graal.JsValue;
import com.intuit.karate.graal.Methods;
import com.intuit.karate.http.HttpUtils;
import com.intuit.karate.http.ResourceType;
import com.linecorp.armeria.common.RequestContext;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpPostMultipartRequestDecoder;
import io.netty.handler.codec.http.multipart.HttpPostStandardRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Request
implements ProxyObject {
    private static final Logger logger = LoggerFactory.getLogger(Request.class);
    private static final String PATH = "path";
    private static final String METHOD = "method";
    private static final String PARAM = "param";
    private static final String PARAM_INT = "paramInt";
    private static final String PARAM_BOOL = "paramBool";
    private static final String PARAM_JSON = "paramJson";
    private static final String PARAM_EXISTS = "paramExists";
    private static final String PARAMS = "params";
    private static final String HEADER = "header";
    private static final String HEADERS = "headers";
    private static final String HEADER_VALUES = "headerValues";
    private static final String PATH_PARAM = "pathParam";
    private static final String PATH_PARAMS = "pathParams";
    private static final String PATH_MATCHES = "pathMatches";
    private static final String PATH_PATTERN = "pathPattern";
    private static final String BODY = "body";
    private static final String BODY_STRING = "bodyString";
    private static final String BODY_BYTES = "bodyBytes";
    private static final String MULTI_PART = "multiPart";
    private static final String MULTI_PARTS = "multiParts";
    private static final String GET = "get";
    private static final String POST = "post";
    private static final String PUT = "put";
    private static final String DELETE = "delete";
    private static final String PATCH = "patch";
    private static final String HEAD = "head";
    private static final String CONNECT = "connect";
    private static final String OPTIONS = "options";
    private static final String TRACE = "trace";
    private static final String URL_BASE = "urlBase";
    private static final String URL = "url";
    private static final String PATH_RAW = "pathRaw";
    private static final String START_TIME = "startTime";
    private static final String END_TIME = "endTime";
    private static final String[] KEYS = new String[]{"path", "method", "param", "paramInt", "paramBool", "paramJson", "paramExists", "params", "header", "headers", "headerValues", "pathParam", "pathParams", "pathMatches", "pathPattern", "body", "bodyString", "bodyBytes", "multiPart", "multiParts", "get", "post", "put", "delete", "patch", "head", "connect", "options", "trace", "urlBase", "url", "pathRaw", "startTime", "endTime"};
    private static final Set<String> KEY_SET = new HashSet<String>(Arrays.asList(KEYS));
    private static final JsArray KEY_ARRAY = new JsArray(KEYS);
    private long startTime = System.currentTimeMillis();
    private long endTime;
    private String urlAndPath;
    private String urlBase;
    private String pathOriginal;
    private String path;
    private String method;
    private Map<String, List<String>> params;
    private Map<String, List<String>> headers;
    private byte[] body;
    private Map<String, List<Map<String, Object>>> multiParts;
    private ResourceType resourceType;
    private String resourcePath;
    private Map<String, String> pathParams = Collections.emptyMap();
    private String pathPattern;
    private RequestContext requestContext;
    private final Methods.FunVar PARAM_FUNCTION = args -> {
        if (args.length == 0 || args[0] == null) {
            return null;
        }
        String name = args[0].toString();
        if (args.length > 1) {
            return this.getParam(name, args[1]);
        }
        return this.getParam(name);
    };

    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    public void setRequestContext(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    public boolean isAjax() {
        return this.getHeader("HX-Request") != null;
    }

    public boolean isMultiPart() {
        return this.multiParts != null;
    }

    public Map<String, List<Map<String, Object>>> getMultiParts() {
        return this.multiParts;
    }

    public List<String> getHeaderValues(String name) {
        return StringUtils.getIgnoreKeyCase(this.headers, name);
    }

    public String getHeader(String name) {
        List<String> list = this.getHeaderValues(name);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public List<Cookie> getCookies() {
        List<String> cookieValues = this.getHeaderValues("Cookie");
        if (cookieValues == null) {
            return Collections.emptyList();
        }
        return cookieValues.stream().map(arg_0 -> ((ClientCookieDecoder)ClientCookieDecoder.STRICT).decode(arg_0)).collect(Collectors.toList());
    }

    public int getParamInt(String name) {
        String value = this.getParam(name);
        try {
            return value == null ? -1 : Integer.valueOf(value);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public boolean getParamBool(String name) {
        String value = this.getParam(name);
        try {
            return value == null ? false : Boolean.valueOf(value);
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getParam(String name) {
        List<String> values = this.getParamValues(name);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return values.get(0);
    }

    public Object getParam(String name, Object value) {
        String temp = this.getParam(name);
        return StringUtils.isBlank(temp) ? value : temp;
    }

    public List<String> getParamValues(String name) {
        if (this.params == null) {
            return null;
        }
        return this.params.get(name);
    }

    public boolean getParamExists(String name) {
        if (this.params == null) {
            return false;
        }
        return this.params.containsKey(name);
    }

    public String getPath() {
        return this.path;
    }

    public String getPathRaw() {
        if (this.urlBase != null && this.urlAndPath != null) {
            if (this.urlAndPath.charAt(0) == '/') {
                return this.urlAndPath;
            }
            return this.urlAndPath.substring(this.urlBase.length());
        }
        return this.path;
    }

    public void setUrl(String url) {
        this.urlAndPath = url;
        StringUtils.Pair pair = HttpUtils.parseUriIntoUrlBaseAndPath(url);
        this.urlBase = pair.left;
        QueryStringDecoder qsd = new QueryStringDecoder(pair.right);
        this.setPath(qsd.path());
        this.setParams(qsd.parameters());
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public String getUrlAndPath() {
        return this.urlAndPath != null ? this.urlAndPath : (this.urlBase != null ? this.urlBase : "") + this.path;
    }

    public String getUrlBase() {
        return this.urlBase;
    }

    public void setUrlBase(String urlBase) {
        this.urlBase = urlBase;
    }

    public void setPath(String path) {
        if (path == null || ((String)path).isEmpty()) {
            path = "/";
        }
        if (((String)path).charAt(0) != '/') {
            path = "/" + (String)path;
        }
        this.path = path;
        if (this.pathOriginal == null) {
            this.pathOriginal = path;
        }
    }

    public String getPathOriginal() {
        return this.pathOriginal;
    }

    public void setResourceType(ResourceType resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public Map<String, List<String>> getParams() {
        return this.params == null ? Collections.emptyMap() : this.params;
    }

    public void setParams(Map<String, List<String>> params) {
        this.params = params;
    }

    public boolean pathMatches(String pattern) {
        Map<String, String> temp = HttpUtils.parseUriPattern(pattern, this.path);
        if (temp == null) {
            return false;
        }
        this.pathParams = temp;
        this.pathPattern = pattern;
        return true;
    }

    public void setParamCommaDelimited(String name, String value) {
        if (value == null) {
            return;
        }
        this.setParam(name, StringUtils.split(value, ',', false));
    }

    public void setParam(String name, Object value) {
        if (this.params == null) {
            this.params = new HashMap<String, List<String>>();
        }
        if (value == null) {
            this.params.put(name, null);
        } else if (value instanceof List) {
            List list = (List)value;
            ArrayList<String> values = new ArrayList<String>(list.size());
            for (Object o : list) {
                values.add(o == null ? null : o.toString());
            }
            this.params.put(name, values);
        } else {
            this.params.put(name, Collections.singletonList(value.toString()));
        }
    }

    public Object getPathParam() {
        if (this.pathParams.isEmpty()) {
            return null;
        }
        return this.pathParams.values().iterator().next();
    }

    public Map<String, String> getPathParams() {
        return this.pathParams;
    }

    public void setPathParams(Map<String, String> pathParams) {
        this.pathParams = pathParams;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers == null ? Collections.emptyMap() : this.headers;
    }

    public void setHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
    }

    public void setCookiesRaw(List<String> values) {
        if (values == null) {
            return;
        }
        if (this.headers == null) {
            this.headers = new HashMap<String, List<String>>();
        }
        this.headers.put("Cookie", values);
    }

    public void setHeaderCommaDelimited(String name, String value) {
        if (value == null) {
            return;
        }
        if (this.headers == null) {
            this.headers = new HashMap<String, List<String>>();
        }
        this.headers.put(name, StringUtils.split(value, ',', false));
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public String getBodyAsString() {
        return this.body == null ? null : FileUtils.toString(this.body);
    }

    public Object getBodyConverted() {
        ResourceType rt = this.getResourceType();
        if (rt != null && rt.isBinary()) {
            return this.body;
        }
        return JsonUtils.fromBytes(this.body, false, rt);
    }

    public boolean isHttpGetForStaticResource() {
        if (!"GET".equals(this.method)) {
            return false;
        }
        ResourceType rt = this.getResourceType();
        return rt != null && !rt.isUrlEncodedOrMultipart();
    }

    public ResourceType getResourceType() {
        String contentType;
        if (this.resourceType == null && (contentType = this.getContentType()) != null) {
            this.resourceType = ResourceType.fromContentType(contentType);
        }
        return this.resourceType;
    }

    public Object getParamJson(String name) {
        String value = this.getParam(name);
        if (StringUtils.isBlank(value)) {
            return null;
        }
        try {
            return JsValue.fromJava(JsonUtils.fromJson(value));
        }
        catch (Exception e) {
            return null;
        }
    }

    public Map<String, Object> getMultiPart(String name) {
        if (this.multiParts == null) {
            return null;
        }
        List<Map<String, Object>> parts = this.multiParts.get(name);
        if (parts == null || parts.isEmpty()) {
            return null;
        }
        return parts.get(0);
    }

    public Object getMultiPartAsJsValue(String name) {
        return JsValue.fromJava(this.getMultiPart(name));
    }

    public void processBody() {
        boolean multipart;
        if (this.body == null) {
            return;
        }
        String contentType = this.getContentType();
        if (contentType == null) {
            return;
        }
        if (contentType.startsWith("multipart")) {
            multipart = true;
            this.multiParts = new HashMap<String, List<Map<String, Object>>>();
        } else if (contentType.contains("form-urlencoded")) {
            multipart = false;
        } else {
            return;
        }
        logger.trace("decoding content-type: {}", (Object)contentType);
        this.params = this.params == null || this.params.isEmpty() ? new HashMap<String, List<String>>() : new HashMap<String, List<String>>(this.params);
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.valueOf((String)this.method), this.path, Unpooled.wrappedBuffer((byte[])this.body));
        request.headers().add("Content-Type", (Object)contentType);
        HttpPostMultipartRequestDecoder decoder = multipart ? new HttpPostMultipartRequestDecoder((HttpRequest)request) : new HttpPostStandardRequestDecoder((HttpRequest)request);
        try {
            for (InterfaceHttpData part : decoder.getBodyHttpDatas()) {
                String name = part.getName();
                if (multipart && part instanceof FileUpload) {
                    List list = this.multiParts.computeIfAbsent(name, k -> new ArrayList());
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    list.add(map);
                    FileUpload fup = (FileUpload)part;
                    map.put("name", name);
                    map.put("filename", fup.getFilename());
                    Charset charset = fup.getCharset();
                    if (charset != null) {
                        map.put("charset", charset.name());
                    }
                    String ct = fup.getContentType();
                    map.put("contentType", ct);
                    map.put("value", fup.get());
                    String transferEncoding = fup.getContentTransferEncoding();
                    if (transferEncoding == null) continue;
                    map.put("transferEncoding", transferEncoding);
                    continue;
                }
                Attribute attribute = (Attribute)part;
                List list = this.params.computeIfAbsent(name, k -> new ArrayList());
                list.add(attribute.getValue());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            decoder.destroy();
        }
    }

    public Object getMember(String key) {
        switch (key) {
            case "method": {
                return this.method;
            }
            case "body": {
                return JsValue.fromJava(this.getBodyConverted());
            }
            case "bodyString": {
                return this.getBodyAsString();
            }
            case "bodyBytes": {
                return this.body;
            }
            case "param": {
                return this.PARAM_FUNCTION;
            }
            case "paramInt": {
                return this::getParamInt;
            }
            case "paramBool": {
                return this::getParamBool;
            }
            case "paramJson": {
                return this::getParamJson;
            }
            case "paramExists": {
                return this::getParamExists;
            }
            case "path": {
                return this.path;
            }
            case "pathRaw": {
                return this.getPathRaw();
            }
            case "urlBase": {
                return this.urlBase;
            }
            case "url": {
                return this.urlAndPath;
            }
            case "params": {
                return JsValue.fromJava(this.params);
            }
            case "pathParam": {
                return this.getPathParam();
            }
            case "pathParams": {
                return JsValue.fromJava(this.pathParams);
            }
            case "pathMatches": {
                return this::pathMatches;
            }
            case "pathPattern": {
                return this.pathPattern;
            }
            case "header": {
                return this::getHeader;
            }
            case "headers": {
                return JsValue.fromJava(JsonUtils.simplify(this.headers));
            }
            case "headerValues": {
                return this::getHeaderValues;
            }
            case "multiPart": {
                return this::getMultiPartAsJsValue;
            }
            case "multiParts": {
                return JsValue.fromJava(this.multiParts);
            }
            case "get": 
            case "post": 
            case "put": 
            case "delete": 
            case "patch": 
            case "head": 
            case "connect": 
            case "options": 
            case "trace": {
                return this.method.toLowerCase().equals(key);
            }
            case "startTime": {
                return this.startTime;
            }
            case "endTime": {
                return this.endTime;
            }
        }
        logger.warn("no such property on request object: {}", (Object)key);
        return null;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(URL, this.urlAndPath);
        map.put(URL_BASE, this.urlBase);
        map.put(PATH, this.path);
        map.put(PATH_RAW, this.getPathRaw());
        map.put(METHOD, this.method);
        map.put(HEADERS, JsonUtils.simplify(this.headers));
        map.put(PARAMS, JsonUtils.simplify(this.params));
        map.put(BODY, this.getBodyConverted());
        return map;
    }

    public Object getMemberKeys() {
        return KEY_ARRAY;
    }

    public boolean hasMember(String key) {
        return KEY_SET.contains(key);
    }

    public void putMember(String key, Value value) {
        logger.warn("put not supported on request object: {} - {}", (Object)key, (Object)value);
    }

    public String toString() {
        return this.method + " " + this.pathOriginal;
    }
}

