/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http;

import com.intuit.karate.http.Request;
import com.intuit.karate.http.RequestCycle;
import com.intuit.karate.http.ResourceType;
import com.intuit.karate.http.Response;
import com.intuit.karate.http.ResponseBuilder;
import com.intuit.karate.http.ServerConfig;
import com.intuit.karate.http.ServerContext;
import com.intuit.karate.http.ServerHandler;
import com.intuit.karate.http.Session;
import com.intuit.karate.http.SessionStore;
import com.intuit.karate.template.KarateTemplateEngine;
import com.intuit.karate.template.TemplateUtils;
import java.time.Instant;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestHandler
implements ServerHandler {
    private static final Logger logger = LoggerFactory.getLogger(RequestHandler.class);
    private static final String SLASH = "/";
    private final SessionStore sessionStore;
    private final KarateTemplateEngine templateEngine;
    private final ServerConfig config;
    private final Function<Request, ServerContext> contextFactory;
    private final String stripHostContextPath;

    public RequestHandler(ServerConfig config) {
        this.config = config;
        this.contextFactory = config.getContextFactory();
        this.templateEngine = TemplateUtils.forServer(config);
        this.sessionStore = config.getSessionStore();
        this.stripHostContextPath = config.isStripContextPathFromRequest() ? config.getHostContextPath() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response handle(Request request) {
        if (this.stripHostContextPath != null && request.getPath().startsWith(this.stripHostContextPath)) {
            request.setPath(request.getPath().substring(this.stripHostContextPath.length()));
        }
        if (SLASH.equals(request.getPath())) {
            request.setPath(this.config.getHomePagePath());
        }
        ServerContext context = this.contextFactory.apply(request);
        if (request.getResourceType() == null) {
            request.setResourceType(ResourceType.fromFileExtension(request.getPath()));
        }
        if (!context.isApi() && request.isHttpGetForStaticResource() && context.isHttpGetAllowed()) {
            Response response;
            if (request.getResourcePath() == null) {
                request.setResourcePath(request.getPath());
            }
            try {
                response = this.response().buildStatic(request);
            }
            catch (Throwable throwable) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{} {} [{} ms]", new Object[]{request, 200, System.currentTimeMillis() - request.getStartTime()});
                }
                throw throwable;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{} {} [{} ms]", new Object[]{request, 200, System.currentTimeMillis() - request.getStartTime()});
            }
            return response;
        }
        Session session = context.getSession();
        if (session == null && !context.isStateless()) {
            String sessionId = context.getSessionCookieValue();
            if (sessionId != null && (session = this.sessionStore.get(sessionId)) != null && this.isExpired(session)) {
                logger.debug("session expired: {}", (Object)session);
                this.sessionStore.delete(sessionId);
                session = null;
            }
            if (session == null) {
                if (this.config.isUseGlobalSession()) {
                    session = ServerConfig.GLOBAL_SESSION;
                } else if (this.config.isAutoCreateSession()) {
                    context.init();
                    session = context.getSession();
                    logger.debug("auto-created session: {} - {}", (Object)request, (Object)session);
                } else if (this.config.getSigninPagePath().equals(request.getPath()) || this.config.getSignoutPagePath().equals(request.getPath())) {
                    session = Session.TEMPORARY;
                    logger.debug("auth flow: {}", (Object)request);
                } else {
                    logger.warn("session not found: {}", (Object)request);
                    ResponseBuilder rb = this.response();
                    if (sessionId != null) {
                        rb.deleteSessionCookie(sessionId);
                    }
                    if (request.isAjax()) {
                        rb.ajaxRedirect(this.signInPath());
                    } else {
                        rb.locationHeader(this.signInPath());
                    }
                    return rb.buildWithStatus(302);
                }
            }
            context.setSession(session);
        }
        RequestCycle rc = RequestCycle.init(this.templateEngine, context);
        return rc.handle();
    }

    private String signInPath() {
        String path = this.config.getSigninPagePath();
        String contextPath = this.config.getHostContextPath();
        return contextPath == null ? path : contextPath + path.substring(1);
    }

    private boolean isExpired(Session session) {
        long expires;
        int configExpirySeconds = this.config.getSessionExpirySeconds();
        if (configExpirySeconds == -1) {
            return false;
        }
        long now = Instant.now().getEpochSecond();
        if (now > (expires = session.getUpdated() + (long)configExpirySeconds)) {
            return true;
        }
        session.setUpdated(now);
        session.setExpires(expires);
        return false;
    }

    private ResponseBuilder response() {
        return new ResponseBuilder(this.config, null);
    }
}

