/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.template;

import com.intuit.karate.StringUtils;
import com.intuit.karate.graal.JsEngine;
import com.intuit.karate.template.KarateEngineContext;
import com.intuit.karate.template.KarateStandardDialect;
import com.intuit.karate.template.TemplateContext;
import java.io.IOException;
import java.io.Writer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.TemplateSpec;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IEngineContext;
import org.thymeleaf.context.StandardEngineContextFactory;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.engine.TemplateManager;
import org.thymeleaf.exceptions.TemplateOutputException;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.util.FastStringWriter;

public class KarateTemplateEngine {
    private static final Logger logger = LoggerFactory.getLogger(KarateTemplateEngine.class);
    private final StandardEngineContextFactory standardFactory = new StandardEngineContextFactory();
    private final TemplateEngine wrapped = new TemplateEngine();

    public KarateTemplateEngine(Supplier<JsEngine> jsEngine, IDialect ... dialects) {
        this.wrapped.setEngineContextFactory((ec, data, attrs, context) -> {
            IEngineContext engineContext = this.standardFactory.createEngineContext(ec, data, attrs, context);
            return KarateEngineContext.initThreadLocal(engineContext, (JsEngine)jsEngine.get());
        });
        this.wrapped.setDialect((IDialect)new KarateStandardDialect());
        for (IDialect dialect : dialects) {
            this.wrapped.addDialect(dialect);
        }
    }

    public void addTemplateResolver(ITemplateResolver templateResolver) {
        this.wrapped.addTemplateResolver(templateResolver);
    }

    public void setTemplateResolver(ITemplateResolver templateResolver) {
        this.wrapped.setTemplateResolver(templateResolver);
    }

    public String process(String template) {
        return this.process(template, TemplateContext.LOCALE_US);
    }

    public String process(String template, IContext context) {
        TemplateSpec templateSpec = new TemplateSpec(template, TemplateMode.HTML);
        FastStringWriter stringWriter = new FastStringWriter(100);
        this.process(templateSpec, context, (Writer)stringWriter);
        return stringWriter.toString();
    }

    public void process(TemplateSpec templateSpec, IContext context, Writer writer) {
        try {
            TemplateManager templateManager = this.wrapped.getConfiguration().getTemplateManager();
            templateManager.parseAndProcess(templateSpec, context, writer);
            try {
                writer.flush();
            }
            catch (IOException e) {
                throw new TemplateOutputException("error flushing output writer", templateSpec.getTemplate(), -1, -1, (Throwable)e);
            }
        }
        catch (Exception e) {
            KarateEngineContext kec = KarateEngineContext.get();
            if (kec != null && !kec.isRedirect()) {
                while (e.getCause() instanceof Exception) {
                    if (!((e = (Exception)e.getCause()) instanceof TemplateProcessingException)) continue;
                    logger.error("{}", (Object)e.getMessage());
                    if (e.getCause() == null) break;
                    String message = e.getCause().getMessage();
                    logger.error("{}", (Object)message);
                    break;
                }
            }
            if (logger.isTraceEnabled()) {
                logger.trace("{}", (Object)StringUtils.throwableToString(e));
            }
            throw new RuntimeException(e);
        }
    }
}

