/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.matchers.ranges;

import io.kotest.matchers.ranges.RangeEdge;
import io.kotest.matchers.ranges.RangeEdgeType;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.OpenEndRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\b\u0018\u0000 \u001b*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003:\u0001\u001bB!\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u00c6\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u00c6\u0003J\u0014\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\u0014\u0010\r\u001a\u00020\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005J/\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00d6\u0003J\u0014\u0010\u0013\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\u0014\u0010\u0016\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\u0006\u0010\u0017\u001a\u00020\u000eJ\u0014\u0010\u0018\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u001c"}, d2={"Lio/kotest/matchers/ranges/Range;", "T", "", "", "start", "Lio/kotest/matchers/ranges/RangeEdge;", "end", "(Lio/kotest/matchers/ranges/RangeEdge;Lio/kotest/matchers/ranges/RangeEdge;)V", "getEnd", "()Lio/kotest/matchers/ranges/RangeEdge;", "getStart", "component1", "component2", "contains", "", "other", "edge", "copy", "equals", "greaterThan", "hashCode", "", "intersect", "isEmpty", "lessThan", "toString", "", "Companion", "kotest-assertions-core"})
public final class Range<T extends Comparable<? super T>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RangeEdge<T> start;
    @NotNull
    private final RangeEdge<T> end;

    public Range(@NotNull RangeEdge<T> start, @NotNull RangeEdge<T> end) {
        Intrinsics.checkNotNullParameter(start, (String)"start");
        Intrinsics.checkNotNullParameter(end, (String)"end");
        this.start = start;
        this.end = end;
        if (!(this.start.getValue().compareTo(this.end.getValue()) <= 0)) {
            boolean bl = false;
            String string = this.start.getValue() + " cannot be after " + this.end.getValue();
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final RangeEdge<T> getStart() {
        return this.start;
    }

    @NotNull
    public final RangeEdge<T> getEnd() {
        return this.end;
    }

    @NotNull
    public String toString() {
        return (this.start.getEdgeType() == RangeEdgeType.INCLUSIVE ? "[" : "(") + this.start.getValue() + ", " + this.end.getValue() + (this.end.getEdgeType() == RangeEdgeType.INCLUSIVE ? "]" : ")");
    }

    public final boolean isEmpty() {
        return Intrinsics.areEqual(this.start.getValue(), this.end.getValue()) && (this.start.getEdgeType() == RangeEdgeType.EXCLUSIVE || this.end.getEdgeType() == RangeEdgeType.EXCLUSIVE);
    }

    public final boolean intersect(@NotNull Range<T> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return !this.lessThan(other) && !other.lessThan(this);
    }

    public final boolean lessThan(@NotNull Range<T> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        T endOfThis = this.end.getValue();
        T startOfOther = other.start.getValue();
        return this.end.getEdgeType() == RangeEdgeType.INCLUSIVE && other.start.getEdgeType() == RangeEdgeType.INCLUSIVE ? endOfThis.compareTo(startOfOther) < 0 : endOfThis.compareTo(startOfOther) <= 0;
    }

    public final boolean greaterThan(@NotNull Range<T> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return other.lessThan(this);
    }

    public final boolean contains(@NotNull Range<T> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return this.contains(other.start) && this.contains(other.end);
    }

    public final boolean contains(@NotNull RangeEdge<T> edge) {
        Intrinsics.checkNotNullParameter(edge, (String)"edge");
        return edge.getValue().compareTo(this.start.getValue()) < 0 ? false : (Intrinsics.areEqual(edge.getValue(), this.start.getValue()) ? this.start.getEdgeType() == RangeEdgeType.INCLUSIVE || edge.getEdgeType() == RangeEdgeType.EXCLUSIVE : (this.start.getValue().compareTo(edge.getValue()) < 0 && edge.getValue().compareTo(this.end.getValue()) < 0 ? true : (Intrinsics.areEqual(edge.getValue(), this.end.getValue()) ? this.end.getEdgeType() == RangeEdgeType.INCLUSIVE || edge.getEdgeType() == RangeEdgeType.EXCLUSIVE : false)));
    }

    @NotNull
    public final RangeEdge<T> component1() {
        return this.start;
    }

    @NotNull
    public final RangeEdge<T> component2() {
        return this.end;
    }

    @NotNull
    public final Range<T> copy(@NotNull RangeEdge<T> start, @NotNull RangeEdge<T> end) {
        Intrinsics.checkNotNullParameter(start, (String)"start");
        Intrinsics.checkNotNullParameter(end, (String)"end");
        return new Range<T>(start, end);
    }

    public static /* synthetic */ Range copy$default(Range range, RangeEdge rangeEdge, RangeEdge rangeEdge2, int n, Object object) {
        if ((n & 1) != 0) {
            rangeEdge = range.start;
        }
        if ((n & 2) != 0) {
            rangeEdge2 = range.end;
        }
        return range.copy(rangeEdge, rangeEdge2);
    }

    public int hashCode() {
        int result = this.start.hashCode();
        result = result * 31 + this.end.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Range)) {
            return false;
        }
        Range range = (Range)other;
        if (!Intrinsics.areEqual(this.start, range.start)) {
            return false;
        }
        return Intrinsics.areEqual(this.end, range.end);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J1\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u000e\b\u0001\u0010\u0005*\b\u0012\u0004\u0012\u0002H\u00050\u00062\u0006\u0010\u0007\u001a\u0002H\u00052\u0006\u0010\b\u001a\u0002H\u0005\u00a2\u0006\u0002\u0010\tJ1\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u000e\b\u0001\u0010\u0005*\b\u0012\u0004\u0012\u0002H\u00050\u00062\u0006\u0010\u0007\u001a\u0002H\u00052\u0006\u0010\b\u001a\u0002H\u0005\u00a2\u0006\u0002\u0010\tJ*\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u000e\b\u0001\u0010\u0005*\b\u0012\u0004\u0012\u0002H\u00050\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00050\rJ*\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u000e\b\u0001\u0010\u0005*\b\u0012\u0004\u0012\u0002H\u00050\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00050\u000fJ1\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u000e\b\u0001\u0010\u0005*\b\u0012\u0004\u0012\u0002H\u00050\u00062\u0006\u0010\u0007\u001a\u0002H\u00052\u0006\u0010\b\u001a\u0002H\u0005\u00a2\u0006\u0002\u0010\tJ1\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u000e\b\u0001\u0010\u0005*\b\u0012\u0004\u0012\u0002H\u00050\u00062\u0006\u0010\u0007\u001a\u0002H\u00052\u0006\u0010\b\u001a\u0002H\u0005\u00a2\u0006\u0002\u0010\t\u00a8\u0006\u0012"}, d2={"Lio/kotest/matchers/ranges/Range$Companion;", "", "()V", "closedClosed", "Lio/kotest/matchers/ranges/Range;", "T", "", "start", "end", "(Ljava/lang/Comparable;Ljava/lang/Comparable;)Lio/kotest/matchers/ranges/Range;", "closedOpen", "ofClosedRange", "range", "Lkotlin/ranges/ClosedRange;", "ofOpenEndRange", "Lkotlin/ranges/OpenEndRange;", "openClosed", "openOpen", "kotest-assertions-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T extends Comparable<? super T>> Range<T> ofClosedRange(@NotNull ClosedRange<T> range) {
            Intrinsics.checkNotNullParameter(range, (String)"range");
            return new Range<Comparable>(new RangeEdge<Comparable>(range.getStart(), RangeEdgeType.INCLUSIVE), new RangeEdge<Comparable>(range.getEndInclusive(), RangeEdgeType.INCLUSIVE));
        }

        @NotNull
        public final <T extends Comparable<? super T>> Range<T> ofOpenEndRange(@NotNull OpenEndRange<T> range) {
            Intrinsics.checkNotNullParameter(range, (String)"range");
            return new Range<Comparable>(new RangeEdge<Comparable>(range.getStart(), RangeEdgeType.INCLUSIVE), new RangeEdge<Comparable>(range.getEndExclusive(), RangeEdgeType.EXCLUSIVE));
        }

        @NotNull
        public final <T extends Comparable<? super T>> Range<T> openOpen(@NotNull T start, @NotNull T end) {
            Intrinsics.checkNotNullParameter(start, (String)"start");
            Intrinsics.checkNotNullParameter(end, (String)"end");
            return new Range<T>(new RangeEdge<T>(start, RangeEdgeType.EXCLUSIVE), new RangeEdge<T>(end, RangeEdgeType.EXCLUSIVE));
        }

        @NotNull
        public final <T extends Comparable<? super T>> Range<T> openClosed(@NotNull T start, @NotNull T end) {
            Intrinsics.checkNotNullParameter(start, (String)"start");
            Intrinsics.checkNotNullParameter(end, (String)"end");
            return new Range<T>(new RangeEdge<T>(start, RangeEdgeType.EXCLUSIVE), new RangeEdge<T>(end, RangeEdgeType.INCLUSIVE));
        }

        @NotNull
        public final <T extends Comparable<? super T>> Range<T> closedOpen(@NotNull T start, @NotNull T end) {
            Intrinsics.checkNotNullParameter(start, (String)"start");
            Intrinsics.checkNotNullParameter(end, (String)"end");
            return new Range<T>(new RangeEdge<T>(start, RangeEdgeType.INCLUSIVE), new RangeEdge<T>(end, RangeEdgeType.EXCLUSIVE));
        }

        @NotNull
        public final <T extends Comparable<? super T>> Range<T> closedClosed(@NotNull T start, @NotNull T end) {
            Intrinsics.checkNotNullParameter(start, (String)"start");
            Intrinsics.checkNotNullParameter(end, (String)"end");
            return new Range<T>(new RangeEdge<T>(start, RangeEdgeType.INCLUSIVE), new RangeEdge<T>(end, RangeEdgeType.INCLUSIVE));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

