/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.matchers.resource;

import io.kotest.matchers.ComparableMatcherResult;
import io.kotest.matchers.Matcher;
import io.kotest.matchers.MatcherResult;
import io.kotest.matchers.ShouldKt;
import io.kotest.matchers.resource.StringMatchersKt;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0086\u0004\u001a\u0015\u0010\u0003\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0086\u0004\u001a6\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b\u001a6\u0010\u0003\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b\u001a6\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\u00062\u0006\u0010\n\u001a\u00020\u00012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b\u001a\u000e\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001a\u0016\u0010\u000e\u001a\u00020\u000f*\u0004\u0018\u00010\u00012\u0006\u0010\u0010\u001a\u00020\rH\u0002\u001a\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\rH\u0000\u001a\f\u0010\u0013\u001a\u00020\u0001*\u00020\u0001H\u0002\u00a8\u0006\u0014"}, d2={"shouldMatchResource", "", "path", "shouldNotMatchResource", "matcherProvider", "Lkotlin/Function1;", "Lio/kotest/matchers/Matcher;", "ignoreLineSeparators", "", "matchResource", "resourcePath", "resourceAsString", "getResource", "Ljava/net/URL;", "writeToActualValueFile", "Ljava/nio/file/Path;", "resourceUrl", "getActualFilePath", "expectedFileURL", "toLF", "kotest-assertions-core"})
@SourceDebugExtension(value={"SMAP\nstringMatchers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 stringMatchers.kt\nio/kotest/matchers/resource/StringMatchersKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,124:1\n1#2:125\n*E\n"})
public final class StringMatchersKt {
    @NotNull
    public static final String shouldMatchResource(@NotNull String $this$shouldMatchResource, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldMatchResource, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ShouldKt.should($this$shouldMatchResource, StringMatchersKt.matchResource(path, (Function1<? super String, ? extends Matcher<? super String>>)((Function1)shouldMatchResource.1.INSTANCE), true));
        return $this$shouldMatchResource;
    }

    @NotNull
    public static final String shouldNotMatchResource(@NotNull String $this$shouldNotMatchResource, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotMatchResource, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ShouldKt.shouldNot($this$shouldNotMatchResource, StringMatchersKt.matchResource(path, (Function1<? super String, ? extends Matcher<? super String>>)((Function1)shouldNotMatchResource.1.INSTANCE), true));
        return $this$shouldNotMatchResource;
    }

    @NotNull
    public static final String shouldMatchResource(@NotNull String $this$shouldMatchResource, @NotNull String path, @NotNull Function1<? super String, ? extends Matcher<? super String>> matcherProvider, boolean ignoreLineSeparators) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldMatchResource, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(matcherProvider, (String)"matcherProvider");
        ShouldKt.should($this$shouldMatchResource, StringMatchersKt.matchResource(path, matcherProvider, ignoreLineSeparators));
        return $this$shouldMatchResource;
    }

    public static /* synthetic */ String shouldMatchResource$default(String string, String string2, Function1 function1, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return StringMatchersKt.shouldMatchResource(string, string2, (Function1<? super String, ? extends Matcher<? super String>>)function1, bl);
    }

    @NotNull
    public static final String shouldNotMatchResource(@NotNull String $this$shouldNotMatchResource, @NotNull String path, @NotNull Function1<? super String, ? extends Matcher<? super String>> matcherProvider, boolean ignoreLineSeparators) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotMatchResource, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(matcherProvider, (String)"matcherProvider");
        ShouldKt.shouldNot($this$shouldNotMatchResource, StringMatchersKt.matchResource(path, matcherProvider, ignoreLineSeparators));
        return $this$shouldNotMatchResource;
    }

    public static /* synthetic */ String shouldNotMatchResource$default(String string, String string2, Function1 function1, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return StringMatchersKt.shouldNotMatchResource(string, string2, (Function1<? super String, ? extends Matcher<? super String>>)function1, bl);
    }

    @NotNull
    public static final Matcher<String> matchResource(@NotNull String resourcePath, @NotNull Function1<? super String, ? extends Matcher<? super String>> matcherProvider, boolean ignoreLineSeparators) {
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        Intrinsics.checkNotNullParameter(matcherProvider, (String)"matcherProvider");
        return (Matcher)new Matcher<String>(resourcePath, ignoreLineSeparators, matcherProvider){
            final /* synthetic */ String $resourcePath;
            final /* synthetic */ boolean $ignoreLineSeparators;
            final /* synthetic */ Function1<String, Matcher<String>> $matcherProvider;
            {
                this.$resourcePath = $resourcePath;
                this.$ignoreLineSeparators = $ignoreLineSeparators;
                this.$matcherProvider = $matcherProvider;
            }

            public MatcherResult test(String value) {
                URL resource;
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                URL uRL = resource = StringMatchersKt.getResource(this.$resourcePath);
                Charset charset = Charsets.UTF_8;
                Object object = TextStreamsKt.readBytes((URL)uRL);
                String resourceValue = new String((byte[])object, charset);
                String normalizedValue = this.$ignoreLineSeparators ? StringMatchersKt.access$toLF(value) : value;
                String normalizedResourceValue = this.$ignoreLineSeparators ? StringMatchersKt.access$toLF(resourceValue) : resourceValue;
                object = ((Matcher)this.$matcherProvider.invoke((Object)normalizedResourceValue)).test((Object)normalizedValue);
                String string = this.$resourcePath;
                Object it = object;
                boolean bl = false;
                return (MatcherResult)ComparableMatcherResult.Companion.invoke(it.passed(), () -> matchResource.1.test$lambda$2$lambda$0(normalizedValue, resource, (MatcherResult)it, string), () -> matchResource.1.test$lambda$2$lambda$1((MatcherResult)it, string), normalizedValue, normalizedResourceValue);
            }

            public Matcher<String> invert() {
                return super.invert();
            }

            public <U> Matcher<U> contramap(Function1<? super U, String> f) {
                return super.contramap(f);
            }

            public Matcher<String> invertIf(boolean invert) {
                return super.invertIf(invert);
            }

            private static final String test$lambda$2$lambda$0(String $normalizedValue, URL $resource, MatcherResult $it, String $resourcePath) {
                Path actualFilePath = StringMatchersKt.access$writeToActualValueFile($normalizedValue, $resource);
                return $it.failureMessage() + "\n\nexpected to match resource, but they differed\nExpected : " + $resourcePath + "\nActual   : " + actualFilePath + "\n\n";
            }

            private static final String test$lambda$2$lambda$1(MatcherResult $it, String $resourcePath) {
                return $it.negatedFailureMessage() + "\n\nexpected not to match resource, but they match\nExpected : " + $resourcePath + "\n\n";
            }
        };
    }

    @NotNull
    public static final String resourceAsString(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        URL uRL = StringMatchersKt.getResource(path);
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes((URL)uRL);
        return new String(byArray, charset);
    }

    @NotNull
    public static final URL getResource(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        URL uRL = new Object(){}.getClass().getResource(path);
        if (uRL == null) {
            throw new IllegalStateException(("Failed to get resource at " + path).toString());
        }
        return uRL;
    }

    private static final Path writeToActualValueFile(String $this$writeToActualValueFile, URL resourceUrl) {
        Path path;
        Path $this$writeToActualValueFile_u24lambda_u240 = path = StringMatchersKt.getActualFilePath(resourceUrl);
        boolean bl = false;
        PathsKt.writeText$default((Path)$this$writeToActualValueFile_u24lambda_u240, (CharSequence)String.valueOf($this$writeToActualValueFile), null, (OpenOption[])new OpenOption[0], (int)2, null);
        return path;
    }

    @NotNull
    public static final Path getActualFilePath(@NotNull URL expectedFileURL) {
        Intrinsics.checkNotNullParameter((Object)expectedFileURL, (String)"expectedFileURL");
        File expectedFile = new File(expectedFileURL.toURI());
        boolean bl = false;
        Path path = expectedFile.toPath().getParent().resolve("_actual");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path path2 = path;
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Path path3 = Files.createDirectories(path2, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"createDirectories(...)");
        Path path4 = path3.resolve(expectedFile.getName());
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"let(...)");
        return path4;
    }

    private static final String toLF(String $this$toLF) {
        CharSequence charSequence = $this$toLF;
        Regex regex = new Regex("\\r\\n?");
        String string = "\n";
        return regex.replace(charSequence, string);
    }

    public static final /* synthetic */ String access$toLF(String $receiver) {
        return StringMatchersKt.toLF($receiver);
    }

    public static final /* synthetic */ Path access$writeToActualValueFile(String $receiver, URL resourceUrl) {
        return StringMatchersKt.writeToActualValueFile($receiver, resourceUrl);
    }
}

