/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.matchers.paths;

import io.kotest.matchers.Matcher;
import io.kotest.matchers.MatcherResult;
import io.kotest.matchers.ShouldKt;
import io.kotest.matchers.paths.PathsKt;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\"\u001a\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0086\u0004\u001a\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0086\u0004\u001a\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0086\u0004\u001a\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0086\u0004\u001a\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0086\u0004\u001a\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\b\u001a\u00020\u0002\u001a\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\n\u0010\u000b\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\f\u001a\u00020\u0001*\u00020\u0002\u001a\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\n\u001a\u0015\u0010\u000e\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0086\u0004\u001a\u0015\u0010\u0011\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0086\u0004\u001a\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\n\u0010\u0013\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0014\u001a\u00020\u0001*\u00020\u0002\u001a\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\n\u001a\n\u0010\u0016\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0017\u001a\u00020\u0001*\u00020\u0002\u001a\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\n\u001a\n\u0010\u0019\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u001a\u001a\u00020\u0001*\u00020\u0002\u001a\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\n\u001a\n\u0010\u001c\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u001d\u001a\u00020\u0001*\u00020\u0002\u001a\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\n\u001a\n\u0010\u001f\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010 \u001a\u00020\u0001*\u00020\u0002\u001a\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00020\n\u001a\n\u0010\"\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010#\u001a\u00020\u0001*\u00020\u0002\u001a\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00020\n\u001a\n\u0010%\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010&\u001a\u00020\u0001*\u00020\u0002\u001a\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020\n\u001a\n\u0010(\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010)\u001a\u00020\u0001*\u00020\u0002\u001a\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00020\n\u001a\u0015\u0010+\u001a\u00020\u0001*\u00020\u00022\u0006\u0010,\u001a\u00020\u0007H\u0086\u0004\u001a\u0015\u0010-\u001a\u00020\u0001*\u00020\u00022\u0006\u0010,\u001a\u00020\u0007H\u0086\u0004\u001a\u0014\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010,\u001a\u00020\u0007\u001a\u0015\u0010/\u001a\u00020\u0001*\u00020\u00022\u0006\u0010,\u001a\u00020\u0007H\u0086\u0004\u001a\u0015\u00100\u001a\u00020\u0001*\u00020\u00022\u0006\u0010,\u001a\u00020\u0007H\u0086\u0004\u001a\u0014\u00101\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010,\u001a\u00020\u0007\u00a8\u00062"}, d2={"shouldStartWithPath", "", "Ljava/nio/file/Path;", "file", "Ljava/io/File;", "shouldNotStartWithPath", "prefix", "", "path", "startWithPath", "Lio/kotest/matchers/Matcher;", "shouldExist", "shouldNotExist", "exist", "shouldHaveFileSize", "size", "", "shouldNotHaveFileSize", "haveFileSize", "shouldBeADirectory", "shouldNotBeADirectory", "aDirectory", "shouldBeAFile", "shouldNotBeAFile", "aFile", "shouldBeAbsolute", "shouldNotBeAbsolute", "beAbsolute", "shouldBeRelative", "shouldNotBeRelative", "beRelative", "shouldBeReadable", "shouldNotBeReadable", "beReadable", "shouldBeWriteable", "shouldNotBeWriteable", "beWriteable", "shouldBeExecutable", "shouldNotBeExecutable", "beExecutable", "shouldBeHidden", "shouldNotBeHidden", "beHidden", "shouldContainFileDeep", "name", "shouldNotContainFileDeep", "containFileDeep", "shouldHaveParent", "shouldNotHaveParent", "haveParent", "kotest-assertions-core"})
public final class PathsKt {
    public static final void shouldStartWithPath(@NotNull Path $this$shouldStartWithPath, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldStartWithPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ShouldKt.should($this$shouldStartWithPath, PathsKt.startWithPath(file));
    }

    public static final void shouldNotStartWithPath(@NotNull Path $this$shouldNotStartWithPath, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotStartWithPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ShouldKt.shouldNot($this$shouldNotStartWithPath, PathsKt.startWithPath(file));
    }

    public static final void shouldStartWithPath(@NotNull Path $this$shouldStartWithPath, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldStartWithPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        ShouldKt.should($this$shouldStartWithPath, PathsKt.startWithPath(prefix));
    }

    public static final void shouldNotStartWithPath(@NotNull Path $this$shouldNotStartWithPath, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotStartWithPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        ShouldKt.shouldNot($this$shouldNotStartWithPath, PathsKt.startWithPath(prefix));
    }

    public static final void shouldStartWithPath(@NotNull Path $this$shouldStartWithPath, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldStartWithPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ShouldKt.should($this$shouldStartWithPath, PathsKt.startWithPath(path));
    }

    public static final void shouldNotStartWithPath(@NotNull Path $this$shouldNotStartWithPath, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotStartWithPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ShouldKt.shouldNot($this$shouldNotStartWithPath, PathsKt.startWithPath(path));
    }

    @NotNull
    public static final Matcher<Path> startWithPath(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return PathsKt.startWithPath(((Object)path).toString());
    }

    @NotNull
    public static final Matcher<Path> startWithPath(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Path path = file.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        return PathsKt.startWithPath(path);
    }

    @NotNull
    public static final Matcher<Path> startWithPath(@NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        return (Matcher)new Matcher<Path>(prefix){
            final /* synthetic */ String $prefix;
            {
                this.$prefix = $prefix;
            }

            public MatcherResult test(Path value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(StringsKt.startsWith$default((String)((Object)value).toString(), (String)this.$prefix, (boolean)false, (int)2, null), () -> startWithPath.1.test$lambda$0(value, this.$prefix), () -> startWithPath.1.test$lambda$1(value, this.$prefix));
            }

            private static final String test$lambda$0(Path $value, String $prefix) {
                return "Path " + $value + " should start with " + $prefix;
            }

            private static final String test$lambda$1(Path $value, String $prefix) {
                return "Path " + $value + " should not start with " + $prefix;
            }
        };
    }

    public static final void shouldExist(@NotNull Path $this$shouldExist) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldExist, (String)"<this>");
        ShouldKt.should($this$shouldExist, PathsKt.exist());
    }

    public static final void shouldNotExist(@NotNull Path $this$shouldNotExist) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotExist, (String)"<this>");
        ShouldKt.shouldNot($this$shouldNotExist, PathsKt.exist());
    }

    @NotNull
    public static final Matcher<Path> exist() {
        return (Matcher)new Matcher<Path>(){

            public MatcherResult test(Path value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(Files.exists(value, new LinkOption[0]), () -> exist.1.test$lambda$0(value), () -> exist.1.test$lambda$1(value));
            }

            private static final String test$lambda$0(Path $value) {
                return "Path " + $value + " should exist";
            }

            private static final String test$lambda$1(Path $value) {
                return "Path " + $value + " should not exist";
            }
        };
    }

    public static final void shouldHaveFileSize(@NotNull Path $this$shouldHaveFileSize, long size) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldHaveFileSize, (String)"<this>");
        ShouldKt.should($this$shouldHaveFileSize, PathsKt.haveFileSize(size));
    }

    public static final void shouldNotHaveFileSize(@NotNull Path $this$shouldNotHaveFileSize, long size) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotHaveFileSize, (String)"<this>");
        ShouldKt.shouldNot($this$shouldNotHaveFileSize, PathsKt.haveFileSize(size));
    }

    @NotNull
    public static final Matcher<Path> haveFileSize(long size) {
        return (Matcher)new Matcher<Path>(size){
            final /* synthetic */ long $size;
            {
                this.$size = $size;
            }

            public MatcherResult test(Path value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(Files.size(value) == this.$size, () -> haveFileSize.1.test$lambda$0(value, this.$size), () -> haveFileSize.1.test$lambda$1(value, this.$size));
            }

            private static final String test$lambda$0(Path $value, long $size) {
                return "Path " + $value + " should have size " + $size;
            }

            private static final String test$lambda$1(Path $value, long $size) {
                return "Path " + $value + " should not have size " + $size;
            }
        };
    }

    public static final void shouldBeADirectory(@NotNull Path $this$shouldBeADirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeADirectory, (String)"<this>");
        ShouldKt.should($this$shouldBeADirectory, PathsKt.aDirectory());
    }

    public static final void shouldNotBeADirectory(@NotNull Path $this$shouldNotBeADirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeADirectory, (String)"<this>");
        ShouldKt.shouldNot($this$shouldNotBeADirectory, PathsKt.aDirectory());
    }

    @NotNull
    public static final Matcher<Path> aDirectory() {
        return (Matcher)new Matcher<Path>(){

            public MatcherResult test(Path value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(Files.isDirectory(value, new LinkOption[0]), () -> aDirectory.1.test$lambda$0(value), () -> aDirectory.1.test$lambda$1(value));
            }

            private static final String test$lambda$0(Path $value) {
                return "File " + $value + " should be a directory";
            }

            private static final String test$lambda$1(Path $value) {
                return "File " + $value + " should not be a directory";
            }
        };
    }

    public static final void shouldBeAFile(@NotNull Path $this$shouldBeAFile) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeAFile, (String)"<this>");
        ShouldKt.should($this$shouldBeAFile, PathsKt.aFile());
    }

    public static final void shouldNotBeAFile(@NotNull Path $this$shouldNotBeAFile) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeAFile, (String)"<this>");
        ShouldKt.shouldNot($this$shouldNotBeAFile, PathsKt.aFile());
    }

    @NotNull
    public static final Matcher<Path> aFile() {
        return (Matcher)new Matcher<Path>(){

            public MatcherResult test(Path value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                LinkOption[] linkOptionArray = new LinkOption[]{};
                return MatcherResult.Companion.invoke(Files.isRegularFile(value, Arrays.copyOf(linkOptionArray, linkOptionArray.length)), () -> aFile.1.test$lambda$0(value), () -> aFile.1.test$lambda$1(value));
            }

            private static final String test$lambda$0(Path $value) {
                return "Path " + $value + " should be a regular file";
            }

            private static final String test$lambda$1(Path $value) {
                return "Path " + $value + " should not be a regular file";
            }
        };
    }

    public static final void shouldBeAbsolute(@NotNull Path $this$shouldBeAbsolute) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeAbsolute, (String)"<this>");
        ShouldKt.should($this$shouldBeAbsolute, PathsKt.beAbsolute());
    }

    public static final void shouldNotBeAbsolute(@NotNull Path $this$shouldNotBeAbsolute) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeAbsolute, (String)"<this>");
        ShouldKt.shouldNot($this$shouldNotBeAbsolute, PathsKt.beAbsolute());
    }

    @NotNull
    public static final Matcher<Path> beAbsolute() {
        return (Matcher)new Matcher<Path>(){

            public MatcherResult test(Path value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.isAbsolute(), () -> beAbsolute.1.test$lambda$0(value), () -> beAbsolute.1.test$lambda$1(value));
            }

            private static final String test$lambda$0(Path $value) {
                return "Path " + $value + " should be absolute";
            }

            private static final String test$lambda$1(Path $value) {
                return "Path " + $value + " should not be absolute";
            }
        };
    }

    public static final void shouldBeRelative(@NotNull Path $this$shouldBeRelative) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeRelative, (String)"<this>");
        ShouldKt.should($this$shouldBeRelative, PathsKt.beRelative());
    }

    public static final void shouldNotBeRelative(@NotNull Path $this$shouldNotBeRelative) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeRelative, (String)"<this>");
        ShouldKt.shouldNot($this$shouldNotBeRelative, PathsKt.beRelative());
    }

    @NotNull
    public static final Matcher<Path> beRelative() {
        return (Matcher)new Matcher<Path>(){

            public MatcherResult test(Path value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(!value.isAbsolute(), () -> beRelative.1.test$lambda$0(value), () -> beRelative.1.test$lambda$1(value));
            }

            private static final String test$lambda$0(Path $value) {
                return "Path " + $value + " should be relative";
            }

            private static final String test$lambda$1(Path $value) {
                return "Path " + $value + " should not be relative";
            }
        };
    }

    public static final void shouldBeReadable(@NotNull Path $this$shouldBeReadable) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeReadable, (String)"<this>");
        ShouldKt.should($this$shouldBeReadable, PathsKt.beReadable());
    }

    public static final void shouldNotBeReadable(@NotNull Path $this$shouldNotBeReadable) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeReadable, (String)"<this>");
        ShouldKt.shouldNot($this$shouldNotBeReadable, PathsKt.beReadable());
    }

    @NotNull
    public static final Matcher<Path> beReadable() {
        return (Matcher)new Matcher<Path>(){

            public MatcherResult test(Path value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(Files.isReadable(value), () -> beReadable.1.test$lambda$0(value), () -> beReadable.1.test$lambda$1(value));
            }

            private static final String test$lambda$0(Path $value) {
                return "Path " + $value + " should be readable";
            }

            private static final String test$lambda$1(Path $value) {
                return "Path " + $value + " should not be readable";
            }
        };
    }

    public static final void shouldBeWriteable(@NotNull Path $this$shouldBeWriteable) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeWriteable, (String)"<this>");
        ShouldKt.should($this$shouldBeWriteable, PathsKt.beWriteable());
    }

    public static final void shouldNotBeWriteable(@NotNull Path $this$shouldNotBeWriteable) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeWriteable, (String)"<this>");
        ShouldKt.shouldNot($this$shouldNotBeWriteable, PathsKt.beWriteable());
    }

    @NotNull
    public static final Matcher<Path> beWriteable() {
        return (Matcher)new Matcher<Path>(){

            public MatcherResult test(Path value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(Files.isWritable(value), () -> beWriteable.1.test$lambda$0(value), () -> beWriteable.1.test$lambda$1(value));
            }

            private static final String test$lambda$0(Path $value) {
                return "Path " + $value + " should be writeable";
            }

            private static final String test$lambda$1(Path $value) {
                return "Path " + $value + " should not be writeable";
            }
        };
    }

    public static final void shouldBeExecutable(@NotNull Path $this$shouldBeExecutable) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeExecutable, (String)"<this>");
        ShouldKt.should($this$shouldBeExecutable, PathsKt.beExecutable());
    }

    public static final void shouldNotBeExecutable(@NotNull Path $this$shouldNotBeExecutable) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeExecutable, (String)"<this>");
        ShouldKt.shouldNot($this$shouldNotBeExecutable, PathsKt.beExecutable());
    }

    @NotNull
    public static final Matcher<Path> beExecutable() {
        return (Matcher)new Matcher<Path>(){

            public MatcherResult test(Path value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(Files.isExecutable(value), () -> beExecutable.1.test$lambda$0(value), () -> beExecutable.1.test$lambda$1(value));
            }

            private static final String test$lambda$0(Path $value) {
                return "Path " + $value + " should be executable";
            }

            private static final String test$lambda$1(Path $value) {
                return "Path " + $value + " should not be executable";
            }
        };
    }

    public static final void shouldBeHidden(@NotNull Path $this$shouldBeHidden) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeHidden, (String)"<this>");
        ShouldKt.should($this$shouldBeHidden, PathsKt.beHidden());
    }

    public static final void shouldNotBeHidden(@NotNull Path $this$shouldNotBeHidden) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeHidden, (String)"<this>");
        ShouldKt.shouldNot($this$shouldNotBeHidden, PathsKt.beHidden());
    }

    @NotNull
    public static final Matcher<Path> beHidden() {
        return (Matcher)new Matcher<Path>(){

            public MatcherResult test(Path value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(Files.isHidden(value), () -> beHidden.1.test$lambda$0(value), () -> beHidden.1.test$lambda$1(value));
            }

            private static final String test$lambda$0(Path $value) {
                return "Path " + $value + " should be hidden";
            }

            private static final String test$lambda$1(Path $value) {
                return "Path " + $value + " should not be hidden";
            }
        };
    }

    public static final void shouldContainFileDeep(@NotNull Path $this$shouldContainFileDeep, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldContainFileDeep, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ShouldKt.should($this$shouldContainFileDeep, PathsKt.containFileDeep(name));
    }

    public static final void shouldNotContainFileDeep(@NotNull Path $this$shouldNotContainFileDeep, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotContainFileDeep, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ShouldKt.shouldNot($this$shouldNotContainFileDeep, PathsKt.containFileDeep(name));
    }

    @NotNull
    public static final Matcher<Path> containFileDeep(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (Matcher)new Matcher<Path>(name){
            final /* synthetic */ String $name;
            {
                this.$name = $name;
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private final boolean fileExists(Path dir) {
                Path it;
                void $this$mapTo$iv$iv;
                List contents = kotlin.io.path.PathsKt.listDirectoryEntries$default((Path)dir, null, (int)1, null);
                Iterable $this$partition$iv = contents;
                boolean $i$f$partition = false;
                ArrayList<T> first$iv = new ArrayList<T>();
                ArrayList<T> second$iv = new ArrayList<T>();
                for (T element$iv : $this$partition$iv) {
                    Path it2 = (Path)element$iv;
                    boolean bl = false;
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    boolean bl2 = Files.isDirectory(it2, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? first$iv.add(element$iv) : second$iv.add(element$iv);
                }
                Pair pair = new Pair(first$iv, second$iv);
                List dirs = (List)pair.component1();
                List files = (List)pair.component2();
                Iterable $this$map$iv = files;
                boolean $i$f$map = false;
                Iterator<T> iterator = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it3;
                    Path path = (Path)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(kotlin.io.path.PathsKt.getName((Path)it3));
                }
                if (((List)destination$iv$iv).contains(this.$name)) return true;
                Iterable $this$any$iv = dirs;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    return false;
                }
                iterator = $this$any$iv.iterator();
                do {
                    T element$iv;
                    if (!iterator.hasNext()) return false;
                    element$iv = iterator.next();
                    it = (Path)element$iv;
                    boolean bl = false;
                } while (!this.fileExists(it));
                return true;
            }

            public MatcherResult test(Path value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(this.fileExists(value), () -> containFileDeep.1.test$lambda$3(this.$name, value), () -> containFileDeep.1.test$lambda$4(this.$name, value));
            }

            private static final String test$lambda$3(String $name, Path $value) {
                return "Path " + $name + " should exist in " + $value;
            }

            private static final String test$lambda$4(String $name, Path $value) {
                return "Path " + $name + " should not exist in " + $value;
            }
        };
    }

    public static final void shouldHaveParent(@NotNull Path $this$shouldHaveParent, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldHaveParent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ShouldKt.should($this$shouldHaveParent, PathsKt.haveParent(name));
    }

    public static final void shouldNotHaveParent(@NotNull Path $this$shouldNotHaveParent, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotHaveParent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ShouldKt.shouldNot($this$shouldNotHaveParent, PathsKt.haveParent(name));
    }

    @NotNull
    public static final Matcher<Path> haveParent(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (Matcher)new Matcher<Path>(name){
            final /* synthetic */ String $name;
            {
                this.$name = $name;
            }

            private final boolean isParentEqualExpected(Path parent) {
                if (parent == null) {
                    return false;
                }
                Path path = parent.getFileName();
                return Intrinsics.areEqual((Object)(path != null ? ((Object)path).toString() : null), (Object)this.$name) || this.isParentEqualExpected(parent.getParent());
            }

            public MatcherResult test(Path value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(this.isParentEqualExpected(value.getParent()), () -> haveParent.1.test$lambda$0(value, this.$name), () -> haveParent.1.test$lambda$1(value, this.$name));
            }

            private static final String test$lambda$0(Path $value, String $name) {
                return "Path " + $value + " should have parent " + $name;
            }

            private static final String test$lambda$1(Path $value, String $name) {
                return "Path " + $value + " should not have parent " + $name;
            }
        };
    }
}

