/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.mpp;

import io.kotest.mpp.IsPlatformStableKt;
import io.kotest.mpp.Property;
import io.kotest.mpp.reflectionjvm;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0002\u001a\u0012\u0010\u0007\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0002\u001a\u000e\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t\"\u001c\u0010\u0000\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"allPlatformStableTypes", "", "Lkotlin/reflect/KClass;", "Ljava/io/Serializable;", "hasStableMembers", "", "kclass", "isStable", "type", "Lkotlin/reflect/KType;", "kotest-common"})
@SourceDebugExtension(value={"SMAP\nstable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 stable.kt\nio/kotest/mpp/StableKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,58:1\n1726#2,3:59\n*S KotlinDebug\n*F\n+ 1 stable.kt\nio/kotest/mpp/StableKt\n*L\n42#1:59,3\n*E\n"})
public final class StableKt {
    @NotNull
    private static final Set<KClass<? extends Serializable>> allPlatformStableTypes;

    public static final boolean isStable(@NotNull KType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        KClassifier classifier = type.getClassifier();
        return classifier instanceof KClass ? StableKt.isStable((KClass)classifier) : false;
    }

    public static final boolean isStable(@NotNull KClass<?> kclass) {
        boolean bl;
        Intrinsics.checkNotNullParameter(kclass, (String)"kclass");
        if (CollectionsKt.contains((Iterable)allPlatformStableTypes, kclass)) {
            bl = true;
        } else if (reflectionjvm.getReflection().isEnumClass(kclass)) {
            bl = true;
        } else if (reflectionjvm.getReflection().isDataClass(kclass) && StableKt.hasStableMembers(kclass)) {
            bl = true;
        } else if (IsPlatformStableKt.isPlatformStable(kclass)) {
            bl = true;
        } else {
            System.out.println((Object)("Warning, type " + kclass + " used in data testing does not have a stable toString()"));
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean hasStableMembers(KClass<?> kclass) {
        Property it;
        List<Property> members = reflectionjvm.getReflection().primaryConstructorMembers(kclass);
        boolean bl = false;
        if (((Collection)members).isEmpty()) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        Iterable $this$all$iv = members;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            it = (Property)element$iv;
            boolean bl3 = false;
        } while (StableKt.isStable(it.getType()));
        return false;
    }

    static {
        Object[] objectArray = new KClass[]{Reflection.getOrCreateKotlinClass(String.class), Reflection.getOrCreateKotlinClass(Integer.TYPE), Reflection.getOrCreateKotlinClass(Long.TYPE), Reflection.getOrCreateKotlinClass(Double.TYPE), Reflection.getOrCreateKotlinClass(Float.TYPE), Reflection.getOrCreateKotlinClass(Byte.TYPE), Reflection.getOrCreateKotlinClass(Short.TYPE), Reflection.getOrCreateKotlinClass(Boolean.TYPE), Reflection.getOrCreateKotlinClass(Pair.class), Reflection.getOrCreateKotlinClass(Triple.class), Reflection.getOrCreateKotlinClass(Character.TYPE)};
        allPlatformStableTypes = SetsKt.setOf((Object[])objectArray);
    }
}

