/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.common.reflection;

import io.kotest.common.reflection.Instantiations;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.KVisibility;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\u0004\u001a\u0002H\u0005\"\b\b\u0000\u0010\u0005*\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\bH\u0016\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lio/kotest/common/reflection/ReflectionInstantiations;", "Lio/kotest/common/reflection/Instantiations;", "<init>", "()V", "newInstanceNoArgConstructorOrObjectInstance", "T", "", "kclass", "Lkotlin/reflect/KClass;", "(Lkotlin/reflect/KClass;)Ljava/lang/Object;", "kotest-common"})
public final class ReflectionInstantiations
implements Instantiations {
    @NotNull
    public static final ReflectionInstantiations INSTANCE = new ReflectionInstantiations();

    private ReflectionInstantiations() {
    }

    @Override
    @NotNull
    public <T> T newInstanceNoArgConstructorOrObjectInstance(@NotNull KClass<T> kclass) {
        Intrinsics.checkNotNullParameter(kclass, (String)"kclass");
        if (kclass.getVisibility() == KVisibility.PRIVATE) {
            throw new IllegalStateException(("Cannot use private class " + kclass.getQualifiedName()).toString());
        }
        Object obj = kclass.getObjectInstance();
        Object object = obj;
        if (object == null) {
            Object t = JvmClassMappingKt.getJavaClass(kclass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            object = t;
            Intrinsics.checkNotNullExpressionValue(t, (String)"newInstance(...)");
        }
        return (T)object;
    }
}

