package io.kotest.property.arbitrary

import io.kotest.property.Arb

// this is a dump of some locales built into the java.util.Locale class on JDK11, executed on a linux ubuntu os
val locales = listOf(
   "af",
   "af_NA",
   "af_ZA",
   "agq",
   "agq_CM",
   "ak",
   "ak_GH",
   "am",
   "am_ET",
   "ar",
   "ar_001",
   "ar_AE",
   "ar_BH",
   "ar_DJ",
   "ar_DZ",
   "ar_EG",
   "ar_EH",
   "ar_ER",
   "ar_IL",
   "ar_IQ",
   "ar_JO",
   "ar_KM",
   "ar_KW",
   "ar_LB",
   "ar_LY",
   "ar_MA",
   "ar_MR",
   "ar_OM",
   "ar_PS",
   "ar_QA",
   "ar_SA",
   "ar_SD",
   "ar_SO",
   "ar_SS",
   "ar_SY",
   "ar_TD",
   "ar_TN",
   "ar_YE",
   "as",
   "as_IN",
   "asa",
   "asa_TZ",
   "ast",
   "ast_ES",
   "az",
   "bas",
   "bas_CM",
   "be",
   "be_BY",
   "bem",
   "bem_ZM",
   "bez",
   "bez_TZ",
   "bg",
   "bg_BG",
   "bm",
   "bm_ML",
   "bn",
   "bn_BD",
   "bn_IN",
   "bo",
   "bo_CN",
   "bo_IN",
   "br",
   "br_FR",
   "brx",
   "brx_IN",
   "bs",
   "ca",
   "ca_AD",
   "ca_ES",
   "ca_ES_VALENCIA",
   "ca_FR",
   "ca_IT",
   "ccp",
   "ccp_BD",
   "ccp_IN",
   "ce",
   "ce_RU",
   "cgg",
   "cgg_UG",
   "chr",
   "chr_US",
   "ckb",
   "ckb_IQ",
   "ckb_IR",
   "cs",
   "cs_CZ",
   "cu",
   "cu_RU",
   "cy",
   "cy_GB",
   "da",
   "da_DK",
   "da_GL",
   "dav",
   "dav_KE",
   "de",
   "de_AT",
   "de_BE",
   "de_CH",
   "de_DE",
   "de_IT",
   "de_LI",
   "de_LU",
   "dje",
   "dje_NE",
   "dsb",
   "dsb_DE",
   "dua",
   "dua_CM",
   "dyo",
   "dyo_SN",
   "dz",
   "dz_BT",
   "ebu",
   "ebu_KE",
   "ee",
   "ee_GH",
   "ee_TG",
   "el",
   "el_CY",
   "el_GR",
   "en",
   "en_001",
   "en_150",
   "en_AG",
   "en_AI",
   "en_AS",
   "en_AT",
   "en_AU",
   "en_BB",
   "en_BE",
   "en_BI",
   "en_BM",
   "en_BS",
   "en_BW",
   "en_BZ",
   "en_CA",
   "en_CC",
   "en_CH",
   "en_CK",
   "en_CM",
   "en_CX",
   "en_CY",
   "en_DE",
   "en_DG",
   "en_DK",
   "en_DM",
   "en_ER",
   "en_FI",
   "en_FJ",
   "en_FK",
   "en_FM",
   "en_GB",
   "en_GD",
   "en_GG",
   "en_GH",
   "en_GI",
   "en_GM",
   "en_GU",
   "en_GY",
   "en_HK",
   "en_IE",
   "en_IL",
   "en_IM",
   "en_IN",
   "en_IO",
   "en_JE",
   "en_JM",
   "en_KE",
   "en_KI",
   "en_KN",
   "en_KY",
   "en_LC",
   "en_LR",
   "en_LS",
   "en_MG",
   "en_MH",
   "en_MO",
   "en_MP",
   "en_MS",
   "en_MT",
   "en_MU",
   "en_MW",
   "en_MY",
   "en_NA",
   "en_NF",
   "en_NG",
   "en_NL",
   "en_NR",
   "en_NU",
   "en_NZ",
   "en_PG",
   "en_PH",
   "en_PK",
   "en_PN",
   "en_PR",
   "en_PW",
   "en_RW",
   "en_SB",
   "en_SC",
   "en_SD",
   "en_SE",
   "en_SG",
   "en_SH",
   "en_SI",
   "en_SL",
   "en_SS",
   "en_SX",
   "en_SZ",
   "en_TC",
   "en_TK",
   "en_TO",
   "en_TT",
   "en_TV",
   "en_TZ",
   "en_UG",
   "en_UM",
   "en_US",
   "en_US_POSIX",
   "en_VC",
   "en_VG",
   "en_VI",
   "en_VU",
   "en_WS",
   "en_ZA",
   "en_ZM",
   "en_ZW",
   "eo",
   "eo_001",
   "es",
   "es_419",
   "es_AR",
   "es_BO",
   "es_BR",
   "es_BZ",
   "es_CL",
   "es_CO",
   "es_CR",
   "es_CU",
   "es_DO",
   "es_EA",
   "es_EC",
   "es_ES",
   "es_GQ",
   "es_GT",
   "es_HN",
   "es_IC",
   "es_MX",
   "es_NI",
   "es_PA",
   "es_PE",
   "es_PH",
   "es_PR",
   "es_PY",
   "es_SV",
   "es_US",
   "es_UY",
   "es_VE",
   "et",
   "et_EE",
   "eu",
   "eu_ES",
   "ewo",
   "ewo_CM",
   "fa",
   "fa_AF",
   "fa_IR",
   "ff",
   "ff_CM",
   "ff_GN",
   "ff_MR",
   "ff_SN",
   "fi",
   "fi_FI",
   "fil",
   "fil_PH",
   "fo",
   "fo_DK",
   "fo_FO",
   "fr",
   "fr_BE",
   "fr_BF",
   "fr_BI",
   "fr_BJ",
   "fr_BL",
   "fr_CA",
   "fr_CD",
   "fr_CF",
   "fr_CG",
   "fr_CH",
   "fr_CI",
   "fr_CM",
   "fr_DJ",
   "fr_DZ",
   "fr_FR",
   "fr_GA",
   "fr_GF",
   "fr_GN",
   "fr_GP",
   "fr_GQ",
   "fr_HT",
   "fr_KM",
   "fr_LU",
   "fr_MA",
   "fr_MC",
   "fr_MF",
   "fr_MG",
   "fr_ML",
   "fr_MQ",
   "fr_MR",
   "fr_MU",
   "fr_NC",
   "fr_NE",
   "fr_PF",
   "fr_PM",
   "fr_RE",
   "fr_RW",
   "fr_SC",
   "fr_SN",
   "fr_SY",
   "fr_TD",
   "fr_TG",
   "fr_TN",
   "fr_VU",
   "fr_WF",
   "fr_YT",
   "fur",
   "fur_IT",
   "fy",
   "fy_NL",
   "ga",
   "ga_IE",
   "gd",
   "gd_GB",
   "gl",
   "gl_ES",
   "gsw",
   "gsw_CH",
   "gsw_FR",
   "gsw_LI",
   "gu",
   "gu_IN",
   "guz",
   "guz_KE",
   "gv",
   "gv_IM",
   "ha",
   "ha_GH",
   "ha_NE",
   "ha_NG",
   "haw",
   "haw_US",
   "hi",
   "hi_IN",
   "hr",
   "hr_BA",
   "hr_HR",
   "hsb",
   "hsb_DE",
   "hu",
   "hu_HU",
   "hy",
   "hy_AM",
   "ig",
   "ig_NG",
   "ii",
   "ii_CN",
   "in",
   "in_ID",
   "is",
   "is_IS",
   "it",
   "it_CH",
   "it_IT",
   "it_SM",
   "it_VA",
   "iw",
   "iw_IL",
   "ja",
   "ja_JP",
   "jgo",
   "jgo_CM",
   "ji",
   "ji_001",
   "jmc",
   "jmc_TZ",
   "ka",
   "ka_GE",
   "kab",
   "kab_DZ",
   "kam",
   "kam_KE",
   "kde",
   "kde_TZ",
   "kea",
   "kea_CV",
   "khq",
   "khq_ML",
   "ki",
   "ki_KE",
   "kk",
   "kk_KZ",
   "kkj",
   "kkj_CM",
   "kl",
   "kl_GL",
   "kln",
   "kln_KE",
   "km",
   "km_KH",
   "kn",
   "kn_IN",
   "ko",
   "ko_KP",
   "ko_KR",
   "kok",
   "kok_IN",
   "ks",
   "ks_IN",
   "ksb",
   "ksb_TZ",
   "ksf",
   "ksf_CM",
   "ksh",
   "ksh_DE",
   "kw",
   "kw_GB",
   "ky",
   "ky_KG",
   "lag",
   "lag_TZ",
   "lb",
   "lb_LU",
   "lg",
   "lg_UG",
   "lkt",
   "lkt_US",
   "ln",
   "ln_AO",
   "ln_CD",
   "ln_CF",
   "ln_CG",
   "lo",
   "lo_LA",
   "lrc",
   "lrc_IQ",
   "lrc_IR",
   "lt",
   "lt_LT",
   "lu",
   "lu_CD",
   "luo",
   "luo_KE",
   "luy",
   "luy_KE",
   "lv",
   "lv_LV",
   "mas",
   "mas_KE",
   "mas_TZ",
   "mer",
   "mer_KE",
   "mfe",
   "mfe_MU",
   "mg",
   "mg_MG",
   "mgh",
   "mgh_MZ",
   "mgo",
   "mgo_CM",
   "mk",
   "mk_MK",
   "ml",
   "ml_IN",
   "mn",
   "mn_MN",
   "mr",
   "mr_IN",
   "ms",
   "ms_BN",
   "ms_MY",
   "ms_SG",
   "mt",
   "mt_MT",
   "mua",
   "mua_CM",
   "my",
   "my_MM",
   "mzn",
   "mzn_IR",
   "naq",
   "naq_NA",
   "nb",
   "nb_NO",
   "nb_SJ",
   "nd",
   "nd_ZW",
   "nds",
   "nds_DE",
   "nds_NL",
   "ne",
   "ne_IN",
   "ne_NP",
   "nl",
   "nl_AW",
   "nl_BE",
   "nl_BQ",
   "nl_CW",
   "nl_NL",
   "nl_SR",
   "nl_SX",
   "nmg",
   "nmg_CM",
   "nn_NO",
   "nnh",
   "nnh_CM",
   "no",
   "no_NO",
   "no_NO_NY",
   "nus",
   "nus_SS",
   "nyn",
   "nyn_UG",
   "om",
   "om_ET",
   "om_KE",
   "or",
   "or_IN",
   "os",
   "os_GE",
   "os_RU",
   "pa",
   "pl",
   "pl_PL",
   "prg",
   "prg_001",
   "ps",
   "ps_AF",
   "pt",
   "pt_AO",
   "pt_BR",
   "pt_CH",
   "pt_CV",
   "pt_GQ",
   "pt_GW",
   "pt_LU",
   "pt_MO",
   "pt_MZ",
   "pt_PT",
   "pt_ST",
   "pt_TL",
   "qu",
   "qu_BO",
   "qu_EC",
   "qu_PE",
   "rm",
   "rm_CH",
   "rn",
   "rn_BI",
   "ro",
   "ro_MD",
   "ro_RO",
   "rof",
   "rof_TZ",
   "ru",
   "ru_BY",
   "ru_KG",
   "ru_KZ",
   "ru_MD",
   "ru_RU",
   "ru_UA",
   "rw",
   "rw_RW",
   "rwk",
   "rwk_TZ",
   "sah",
   "sah_RU",
   "saq",
   "saq_KE",
   "sbp",
   "sbp_TZ",
   "sd",
   "sd_PK",
   "se",
   "se_FI",
   "se_NO",
   "se_SE",
   "seh",
   "seh_MZ",
   "ses",
   "ses_ML",
   "sg",
   "sg_CF",
   "shi",
   "si",
   "si_LK",
   "sk",
   "sk_SK",
   "sl",
   "sl_SI",
   "smn",
   "smn_FI",
   "sn",
   "sn_ZW",
   "so",
   "so_DJ",
   "so_ET",
   "so_KE",
   "so_SO",
   "sq",
   "sq_AL",
   "sq_MK",
   "sq_XK",
   "sr",
   "sr_BA",
   "sr_CS",
   "sr_ME",
   "sr_RS",
   "sv",
   "sv_AX",
   "sv_FI",
   "sv_SE",
   "sw",
   "sw_CD",
   "sw_KE",
   "sw_TZ",
   "sw_UG",
   "ta",
   "ta_IN",
   "ta_LK",
   "ta_MY",
   "ta_SG",
   "te",
   "te_IN",
   "teo",
   "teo_KE",
   "teo_UG",
   "tg",
   "tg_TJ",
   "th",
   "th_TH",
   "ti",
   "ti_ER",
   "ti_ET",
   "tk",
   "tk_TM",
   "to",
   "to_TO",
   "tr",
   "tr_CY",
   "tr_TR",
   "tt",
   "tt_RU",
   "twq",
   "twq_NE",
   "tzm",
   "tzm_MA",
   "ug",
   "ug_CN",
   "uk",
   "uk_UA",
   "ur",
   "ur_IN",
   "ur_PK",
   "uz",
   "vai",
   "vi",
   "vi_VN",
   "vo",
   "vo_001",
   "vun",
   "vun_TZ",
   "wae",
   "wae_CH",
   "wo",
   "wo_SN",
   "xog",
   "xog_UG",
   "yav",
   "yav_CM",
   "yo",
   "yo_BJ",
   "yo_NG",
   "yue",
   "zgh",
   "zgh_MA",
   "zh",
   "zh_CN",
   "zh_HK",
   "zh_SG",
   "zh_TW",
   "zu",
   "zu_ZA",
)

private val jdk17SafeLocales =
   locales.filterNot { it.startsWith("in") || it.startsWith("ji") || it.startsWith("iw") || it.startsWith("no") }

/**
 * Returns an Arb that generates locales.
 *
 * Edgecases include a locale that only has a language (without country) and a locale
 * that has a variant.
 */
fun Arb.Companion.locale() = arbitrary(listOf("en", "ca_ES_VALENCIA")) { locales.random(it.random) }

/**
 * An Arb that produces locales filtering out locales that are not compatible with JDK 17.
 *
 * The excluded locales include those with language codes starting with:
 * - "in" (deprecated code for Indonesian, replaced by "id")
 * - "ji" (deprecated code for Yiddish, replaced by "yi")
 * - "iw" (deprecated code for Hebrew, replaced by "he")
 * - "no" (Norwegian, replaced by "nb" for Bokmål or "nn" for Nynorsk)
 *
 * This ensures the generated locales are safe for use in environments running JDK 17,
 * where these deprecated codes are no longer supported.
 *
 * Example edge cases include:
 * - A locale that only specifies the language (e.g., "en")
 * - A locale that includes a variant (e.g., "ca_ES_VALENCIA")
 *
 * @return an Arb instance that generates JDK 17-safe locales.
 */
fun Arb.Companion.localeJdk17() = arbitrary(listOf("en", "ca_ES_VALENCIA")) { jdk17SafeLocales.random(it.random) }

