/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.openapi.routing;

import io.ktor.openapi.routing.RouteNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSession;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\nJ\u0006\u0010\u001a\u001a\u00020\u0000J\n\u0010\u001b\u001a\u00020\u0016*\u00020\nJ\u0018\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\nH\u0002J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\nH\u0002J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0!2\u0006\u0010\u0019\u001a\u00020\nH\u0002J\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\n0!2\u0006\u0010\u0019\u001a\u00020\nJ\u001a\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0$0$2\u0006\u0010\u0019\u001a\u00020\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011\u00a8\u0006%"}, d2={"Lio/ktor/openapi/routing/RouteCallGraph;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "parentToChildren", "", "Lio/ktor/openapi/routing/RouteNode;", "", "childToParents", "routes", "", "Lio/ktor/openapi/routing/RouteNode$Route;", "getRoutes$ktor_compiler_plugin", "()Ljava/util/List;", "functions", "Lio/ktor/openapi/routing/RouteNode$Function;", "getFunctions$ktor_compiler_plugin", "isEmpty", "", "add", "", "node", "build", "isTopLevel", "addEdge", "parent", "child", "hasParents", "getParents", "", "getChildren", "findAllPathsToRoots", "", "ktor-compiler-plugin"})
@SourceDebugExtension(value={"SMAP\nRouteCallGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RouteCallGraph.kt\nio/ktor/openapi/routing/RouteCallGraph\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,99:1\n2746#2,3:100\n382#3,7:103\n382#3,7:110\n*S KotlinDebug\n*F\n+ 1 RouteCallGraph.kt\nio/ktor/openapi/routing/RouteCallGraph\n*L\n52#1:100,3\n58#1:103,7\n59#1:110,7\n*E\n"})
public final class RouteCallGraph {
    @NotNull
    private final FirSession session;
    @NotNull
    private final Map<RouteNode, Set<RouteNode>> parentToChildren;
    @NotNull
    private final Map<RouteNode, Set<RouteNode>> childToParents;
    @NotNull
    private final List<RouteNode.Route> routes;
    @NotNull
    private final List<RouteNode.Function> functions;

    public RouteCallGraph(@NotNull FirSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        this.parentToChildren = new LinkedHashMap();
        this.childToParents = new LinkedHashMap();
        this.routes = new ArrayList();
        this.functions = new ArrayList();
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    public final List<RouteNode.Route> getRoutes$ktor_compiler_plugin() {
        return this.routes;
    }

    @NotNull
    public final List<RouteNode.Function> getFunctions$ktor_compiler_plugin() {
        return this.functions;
    }

    public final boolean isEmpty() {
        return this.routes.isEmpty();
    }

    public final void add(@NotNull RouteNode node) {
        RouteNode routeNode;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        int n = ((Collection)this.routes).size() + -1;
        if (0 <= n) {
            RouteNode.Route parent;
            do {
                int i;
                if (!(parent = this.routes.get(i = n--)).contains(node)) continue;
                this.addEdge(parent, node);
                break;
            } while (Intrinsics.areEqual((Object)parent.getFilePath(), (Object)node.getFilePath()) && !this.isTopLevel(parent) && 0 <= n);
        }
        if ((routeNode = node) instanceof RouteNode.Function) {
            this.functions.add((RouteNode.Function)node);
        } else if (routeNode instanceof RouteNode.Route) {
            this.routes.add((RouteNode.Route)node);
        } else if (!(routeNode instanceof RouteNode.CallFeature)) {
            throw new NoWhenBranchMatchedException();
        }
    }

    @NotNull
    public final RouteCallGraph build() {
        for (RouteNode.Function function : this.functions) {
            for (RouteNode.Function other : this.functions) {
                if (!function.contains(other) || !this.isTopLevel(other)) continue;
                this.addEdge(other, function);
            }
            for (RouteNode.Route route : this.routes) {
                if (!function.contains(route) || !this.isTopLevel(route)) continue;
                this.addEdge(function, route);
            }
        }
        return this;
    }

    public final boolean isTopLevel(@NotNull RouteNode $this$isTopLevel) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)$this$isTopLevel, (String)"<this>");
            Set set = this.childToParents.get($this$isTopLevel);
            if (set == null) {
                set = SetsKt.emptySet();
            }
            Iterable $this$none$iv = set;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    RouteNode it = (RouteNode)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof RouteNode.Route)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final void addEdge(RouteNode parent, RouteNode child) {
        Object object;
        Object object2;
        Map<RouteNode, Set<RouteNode>> $this$getOrPut$iv;
        Map<RouteNode, Set<RouteNode>> map = this.parentToChildren;
        RouteNode key$iv = parent;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Set answer$iv = new LinkedHashSet();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object2 = answer$iv;
        } else {
            object2 = value$iv;
        }
        ((Set)object2).add(child);
        $this$getOrPut$iv = this.childToParents;
        key$iv = child;
        $i$f$getOrPut = false;
        value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Set answer$iv = new LinkedHashSet();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((Set)object).add(parent);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasParents(RouteNode node) {
        if (!this.childToParents.containsKey(node)) return false;
        Set<RouteNode> set = this.childToParents.get(node);
        if (set == null) return false;
        if (((Collection)set).isEmpty()) return false;
        return true;
    }

    private final Set<RouteNode> getParents(RouteNode node) {
        Set set = this.childToParents.get(node);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    @NotNull
    public final Set<RouteNode> getChildren(@NotNull RouteNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Set set = this.parentToChildren.get(node);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    @NotNull
    public final List<List<RouteNode>> findAllPathsToRoots(@NotNull RouteNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (!this.hasParents(node)) {
            return CollectionsKt.listOf((Object)CollectionsKt.listOf((Object)node));
        }
        List result = new ArrayList();
        Set<RouteNode> parents = this.getParents(node);
        for (RouteNode parent : parents) {
            List<List<RouteNode>> parentPaths = this.findAllPathsToRoots(parent);
            for (List<RouteNode> path : parentPaths) {
                result.add(CollectionsKt.plus((Collection)path, (Object)node));
            }
        }
        return result;
    }
}

