/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.openapi.routing.interpreters;

import io.ktor.compiler.utils.ExpressionUtilsKt;
import io.ktor.openapi.OpenApiKDocParserKt;
import io.ktor.openapi.routing.RouteField;
import io.ktor.openapi.routing.RouteFieldKt;
import io.ktor.openapi.routing.RouteNode;
import io.ktor.openapi.routing.RouteStack;
import io.ktor.openapi.routing.RoutingCallInterpreter;
import io.ktor.openapi.routing.RoutingReferenceResult;
import io.ktor.openapi.routing.SourceTextRange;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.providers.FirProviderKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u00020\u0006R\u00020\bj\u0006\u0010\u0007\u001a\u00020\u0006j\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\fJ\u001f\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u000fH\u0002R\u00020\u0006j\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0010J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a8\u0006\u0013"}, d2={"Lio/ktor/openapi/routing/interpreters/CustomFunctionInterpreter;", "Lio/ktor/openapi/routing/RoutingCallInterpreter;", "<init>", "()V", "check", "Lio/ktor/openapi/routing/RoutingReferenceResult;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;)Lio/ktor/openapi/routing/RoutingReferenceResult;", "getDeclarationLocation", "Lio/ktor/openapi/routing/SourceTextRange;", "Lorg/jetbrains/kotlin/fir/references/FirNamedReference;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/references/FirNamedReference;)Lio/ktor/openapi/routing/SourceTextRange;", "isCustomRouteFunction", "", "ktor-compiler-plugin"})
public final class CustomFunctionInterpreter
implements RoutingCallInterpreter {
    @Override
    @NotNull
    public RoutingReferenceResult check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirFunctionCall expression) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        String receiverFqName = this.isCustomRouteFunction(expression, context);
        if (!Intrinsics.areEqual((Object)receiverFqName, (Object)"io.ktor.server.routing.Route")) {
            return RoutingReferenceResult.None.INSTANCE;
        }
        SourceTextRange sourceTextRange = ExpressionUtilsKt.getLocation(context, (FirExpression)expression);
        if (sourceTextRange == null) {
            return RoutingReferenceResult.None.INSTANCE;
        }
        SourceTextRange invocation = sourceTextRange;
        SourceTextRange sourceTextRange2 = this.getDeclarationLocation(context, expression.getCalleeReference());
        if (sourceTextRange2 == null) {
            return RoutingReferenceResult.None.INSTANCE;
        }
        SourceTextRange body = sourceTextRange2;
        RouteNode.Function routeNode = new RouteNode.Function(context.getContainingFilePath(), expression, body, (Function1<? super RouteStack, ? extends List<? extends RouteField>>)((Function1)arg_0 -> CustomFunctionInterpreter.check$lambda$0(context, invocation, body, arg_0)));
        return new RoutingReferenceResult.Match(routeNode);
    }

    private final SourceTextRange getDeclarationLocation(CheckerContext context, FirNamedReference $this$getDeclarationLocation) {
        FirResolvedNamedReference firResolvedNamedReference = FirReferenceUtilsKt.getResolved((FirReference)((FirReference)$this$getDeclarationLocation));
        if (firResolvedNamedReference == null || (firResolvedNamedReference = FirReferenceUtilsKt.toResolvedFunctionSymbol$default((FirReference)((FirReference)firResolvedNamedReference), (boolean)false, (int)1, null)) == null) {
            return null;
        }
        FirResolvedNamedReference resolvedFunctionSymbol = firResolvedNamedReference;
        FirFile firFile = FirProviderKt.getFirProvider((FirSession)context.getSession()).getFirCallableContainerFile((FirCallableSymbol)resolvedFunctionSymbol);
        if (firFile == null) {
            return null;
        }
        FirFile containingFile = firFile;
        Object object = containingFile.getSourceFile();
        if (object == null || (object = object.getPath()) == null) {
            return null;
        }
        Object filePath = object;
        Object object2 = containingFile.getSource();
        if (object2 == null || (object2 = KtSourceElementKt.getText((KtSourceElement)object2)) == null) {
            return null;
        }
        Object fileText = object2;
        KtSourceElement ktSourceElement = resolvedFunctionSymbol.getSource();
        if (ktSourceElement == null || (ktSourceElement = ExpressionUtilsKt.getRange(ktSourceElement)) == null) {
            return null;
        }
        KtSourceElement range = ktSourceElement;
        return new SourceTextRange((String)filePath, (CharSequence)fileText, (IntRange)range);
    }

    private final String isCustomRouteFunction(FirFunctionCall expression, CheckerContext context) {
        ClassId classId;
        ConeKotlinType coneKotlinType;
        FirExpression firExpression = expression.getExtensionReceiver();
        return firExpression != null && (coneKotlinType = FirTypeUtilsKt.getResolvedType((FirExpression)firExpression)) != null && (classId = FirHelpersKt.fullyExpandedClassId((ConeKotlinType)coneKotlinType, (FirSession)context.getSession())) != null ? classId.asFqNameString() : null;
    }

    private static final List check$lambda$0(CheckerContext $context, SourceTextRange $invocation, SourceTextRange $body, RouteStack $this$Function) {
        Intrinsics.checkNotNullParameter((Object)$this$Function, (String)"$this$Function");
        return RouteFieldKt.resolveSchemaReferences($this$Function, $context, CollectionsKt.plus((Collection)OpenApiKDocParserKt.parseKDoc($invocation), (Iterable)OpenApiKDocParserKt.parseKDoc($body)));
    }
}

