/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.openapi.routing.interpreters;

import io.ktor.compiler.utils.ExpressionUtilsKt;
import io.ktor.openapi.routing.RouteField;
import io.ktor.openapi.routing.RouteNode;
import io.ktor.openapi.routing.RouteStack;
import io.ktor.openapi.routing.RoutingCallInterpreter;
import io.ktor.openapi.routing.RoutingReferenceResult;
import io.ktor.openapi.routing.interpreters.HeadersLookupKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u00020\u0006R\u00020\bj\u0006\u0010\u0007\u001a\u00020\u0006j\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0010"}, d2={"Lio/ktor/openapi/routing/interpreters/RequestHeaderInterpreter;", "Lio/ktor/openapi/routing/RoutingCallInterpreter;", "<init>", "()V", "check", "Lio/ktor/openapi/routing/RoutingReferenceResult;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;)Lio/ktor/openapi/routing/RoutingReferenceResult;", "isHeadersGet", "", "isHeaderCallFromRequest", "ktor-compiler-plugin"})
public final class RequestHeaderInterpreter
implements RoutingCallInterpreter {
    @Override
    @NotNull
    public RoutingReferenceResult check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirFunctionCall expression) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        if (!this.isHeadersGet(expression) && !this.isHeaderCallFromRequest(expression)) {
            return RoutingReferenceResult.None.INSTANCE;
        }
        FirExpression firExpression = ExpressionUtilsKt.getArgument$default(context, expression, "name", 0, null, 12, null);
        if (firExpression == null) {
            return RoutingReferenceResult.None.INSTANCE;
        }
        FirExpression key = firExpression;
        RouteNode.CallFeature routeNode = new RouteNode.CallFeature(context.getContainingFilePath(), expression, (Function1<? super RouteStack, ? extends List<? extends RouteField>>)((Function1)arg_0 -> RequestHeaderInterpreter.check$lambda$0(context, reporter, key, arg_0)));
        return new RoutingReferenceResult.Match(routeNode);
    }

    private final boolean isHeadersGet(FirFunctionCall expression) {
        FirExpression firExpression;
        return StringsKt.startsWith$default((String)ExpressionUtilsKt.getFunctionName(expression), (String)"get", (boolean)false, (int)2, null) && Intrinsics.areEqual((firExpression = expression.getExplicitReceiver()) != null && (firExpression = FirTypeUtilsKt.getResolvedType((FirExpression)firExpression)) != null && (firExpression = ConeTypeUtilsKt.getClassId((ConeKotlinType)firExpression)) != null && (firExpression = firExpression.getShortClassName()) != null ? firExpression.asString() : null, (Object)"Headers");
    }

    private final boolean isHeaderCallFromRequest(FirFunctionCall expression) {
        FirExpression firExpression;
        return Intrinsics.areEqual((Object)ExpressionUtilsKt.getFunctionName(expression), (Object)"header") && Intrinsics.areEqual((firExpression = expression.getExplicitReceiver()) != null && (firExpression = FirTypeUtilsKt.getResolvedType((FirExpression)firExpression)) != null && (firExpression = ConeTypeUtilsKt.getClassId((ConeKotlinType)firExpression)) != null && (firExpression = firExpression.getShortClassName()) != null ? firExpression.asString() : null, (Object)"RoutingRequest");
    }

    private static final List check$lambda$0(CheckerContext $context, DiagnosticReporter $reporter, FirExpression $key, RouteStack $this$CallFeature) {
        Intrinsics.checkNotNullParameter((Object)$this$CallFeature, (String)"$this$CallFeature");
        String string = HeadersLookupKt.evaluateHeader($this$CallFeature, $context, $reporter, $key);
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        return CollectionsKt.listOf((Object)new RouteField.Header(string, null, null, null, 14, null));
    }
}

