/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.netty;

import io.ktor.server.application.Application;
import io.ktor.server.application.ApplicationEnvironment;
import io.ktor.server.engine.EngineConnectorConfig;
import io.ktor.server.engine.EnginePipeline;
import io.ktor.server.engine.EngineSSLConnectorConfig;
import io.ktor.server.netty.KtorReadTimeoutHandler;
import io.ktor.server.netty.http1.NettyHttp1Handler;
import io.ktor.server.netty.http2.NettyHttp2Handler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerExpectContinueHandler;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.CleartextHttp2ServerUpgradeHandler;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2MultiplexCodec;
import io.netty.handler.codec.http2.Http2MultiplexCodecBuilder;
import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.codec.http2.Http2ServerUpgradeCodec;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import io.netty.handler.timeout.WriteTimeoutHandler;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.nio.channels.ClosedChannelException;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManagerFactory;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 <2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002=<B\u0094\u0001\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\u0006\u0010\u0012\u001a\u00020\u0011\u0012\u0006\u0010\u0013\u001a\u00020\u0011\u0012\u0006\u0010\u0014\u001a\u00020\u0011\u0012\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0003\u0012\u0017\u0010\u001b\u001a\u0013\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017\u00a2\u0006\u0002\b\u001a\u0012\u0006\u0010\u001d\u001a\u00020\u001c\u0012\u0006\u0010\u001e\u001a\u00020\u001c\u00a2\u0006\u0004\b\u001f\u0010 B\u008e\u0001\b\u0017\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\u0006\u0010\u0012\u001a\u00020\u0011\u0012\u0006\u0010\u0013\u001a\u00020\u0011\u0012\u0006\u0010\u0014\u001a\u00020\u0011\u0012\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0003\u0012\u0017\u0010\u001b\u001a\u0013\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017\u00a2\u0006\u0002\b\u001a\u0012\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b\u001f\u0010!J\u0017\u0010#\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b#\u0010$J\u001f\u0010(\u001a\u00020\u00192\u0006\u0010%\u001a\u00020\u00182\u0006\u0010'\u001a\u00020&H\u0002\u00a2\u0006\u0004\b(\u0010)J\u0013\u0010+\u001a\u00020\u001c*\u00020*H\u0002\u00a2\u0006\u0004\b+\u0010,J\u0015\u0010.\u001a\u0004\u0018\u00010-*\u00020*H\u0002\u00a2\u0006\u0004\b.\u0010/R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u00100R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u00101R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u00102R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u00103R\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u00104R\u0014\u0010\u000e\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u00104R\u0014\u0010\u0010\u001a\u00020\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u00105R\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u00106R\u0014\u0010\u0013\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u00106R\u0014\u0010\u0014\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u00106R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u00100R%\u0010\u001b\u001a\u0013\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017\u00a2\u0006\u0002\b\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u00107R\u0014\u0010\u001d\u001a\u00020\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u00108R\u0014\u0010\u001e\u001a\u00020\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u00108R\u0018\u0010:\u001a\u0004\u0018\u0001098\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b:\u0010;\u00a8\u0006>"}, d2={"Lio/ktor/server/netty/NettyChannelInitializer;", "Lio/netty/channel/ChannelInitializer;", "Lio/netty/channel/socket/SocketChannel;", "Lkotlin/Function0;", "Lio/ktor/server/application/Application;", "applicationProvider", "Lio/ktor/server/engine/EnginePipeline;", "enginePipeline", "Lio/ktor/server/application/ApplicationEnvironment;", "environment", "Lio/netty/util/concurrent/EventExecutorGroup;", "callEventGroup", "Lkotlin/coroutines/CoroutineContext;", "engineContext", "userContext", "Lio/ktor/server/engine/EngineConnectorConfig;", "connector", "", "runningLimit", "responseWriteTimeout", "requestReadTimeout", "Lio/netty/handler/codec/http/HttpServerCodec;", "httpServerCodec", "Lkotlin/Function1;", "Lio/netty/channel/ChannelPipeline;", "", "Lkotlin/ExtensionFunctionType;", "channelPipelineConfig", "", "enableHttp2", "enableH2c", "<init>", "(Lkotlin/jvm/functions/Function0;Lio/ktor/server/engine/EnginePipeline;Lio/ktor/server/application/ApplicationEnvironment;Lio/netty/util/concurrent/EventExecutorGroup;Lkotlin/coroutines/CoroutineContext;Lkotlin/coroutines/CoroutineContext;Lio/ktor/server/engine/EngineConnectorConfig;IIILkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;ZZ)V", "(Lkotlin/jvm/functions/Function0;Lio/ktor/server/engine/EnginePipeline;Lio/ktor/server/application/ApplicationEnvironment;Lio/netty/util/concurrent/EventExecutorGroup;Lkotlin/coroutines/CoroutineContext;Lkotlin/coroutines/CoroutineContext;Lio/ktor/server/engine/EngineConnectorConfig;IIILkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Z)V", "ch", "initChannel", "(Lio/netty/channel/socket/SocketChannel;)V", "pipeline", "", "protocol", "configurePipeline", "(Lio/netty/channel/ChannelPipeline;Ljava/lang/String;)V", "Lio/ktor/server/engine/EngineSSLConnectorConfig;", "hasTrustStore", "(Lio/ktor/server/engine/EngineSSLConnectorConfig;)Z", "Ljavax/net/ssl/TrustManagerFactory;", "trustManagerFactory", "(Lio/ktor/server/engine/EngineSSLConnectorConfig;)Ljavax/net/ssl/TrustManagerFactory;", "Lkotlin/jvm/functions/Function0;", "Lio/ktor/server/engine/EnginePipeline;", "Lio/ktor/server/application/ApplicationEnvironment;", "Lio/netty/util/concurrent/EventExecutorGroup;", "Lkotlin/coroutines/CoroutineContext;", "Lio/ktor/server/engine/EngineConnectorConfig;", "I", "Lkotlin/jvm/functions/Function1;", "Z", "Lio/netty/handler/ssl/SslContext;", "sslContext", "Lio/netty/handler/ssl/SslContext;", "Companion", "NegotiatedPipelineInitializer", "ktor-server-netty"})
@SourceDebugExtension(value={"SMAP\nNettyChannelInitializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NettyChannelInitializer.kt\nio/ktor/server/netty/NettyChannelInitializer\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,358:1\n37#2,2:359\n37#2,2:362\n1#3:361\n*S KotlinDebug\n*F\n+ 1 NettyChannelInitializer.kt\nio/ktor/server/netty/NettyChannelInitializer\n*L\n119#1:359,2\n163#1:362,2\n*E\n"})
public final class NettyChannelInitializer
extends ChannelInitializer<SocketChannel> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<Application> applicationProvider;
    @NotNull
    private final EnginePipeline enginePipeline;
    @NotNull
    private final ApplicationEnvironment environment;
    @NotNull
    private final EventExecutorGroup callEventGroup;
    @NotNull
    private final CoroutineContext engineContext;
    @NotNull
    private final CoroutineContext userContext;
    @NotNull
    private final EngineConnectorConfig connector;
    private final int runningLimit;
    private final int responseWriteTimeout;
    private final int requestReadTimeout;
    @NotNull
    private final Function0<HttpServerCodec> httpServerCodec;
    @NotNull
    private final Function1<ChannelPipeline, Unit> channelPipelineConfig;
    private final boolean enableHttp2;
    private final boolean enableH2c;
    @Nullable
    private SslContext sslContext;
    @NotNull
    private static final Lazy<SslProvider> alpnProvider$delegate = LazyKt.lazy(NettyChannelInitializer::alpnProvider_delegate$lambda$0);

    /*
     * WARNING - void declaration
     */
    public NettyChannelInitializer(@NotNull Function0<Application> applicationProvider, @NotNull EnginePipeline enginePipeline, @NotNull ApplicationEnvironment environment, @NotNull EventExecutorGroup callEventGroup, @NotNull CoroutineContext engineContext, @NotNull CoroutineContext userContext, @NotNull EngineConnectorConfig connector, int runningLimit, int responseWriteTimeout, int requestReadTimeout, @NotNull Function0<HttpServerCodec> httpServerCodec2, @NotNull Function1<? super ChannelPipeline, Unit> channelPipelineConfig, boolean enableHttp2, boolean enableH2c) {
        Intrinsics.checkNotNullParameter(applicationProvider, (String)"applicationProvider");
        Intrinsics.checkNotNullParameter((Object)enginePipeline, (String)"enginePipeline");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)callEventGroup, (String)"callEventGroup");
        Intrinsics.checkNotNullParameter((Object)engineContext, (String)"engineContext");
        Intrinsics.checkNotNullParameter((Object)userContext, (String)"userContext");
        Intrinsics.checkNotNullParameter((Object)connector, (String)"connector");
        Intrinsics.checkNotNullParameter(httpServerCodec2, (String)"httpServerCodec");
        Intrinsics.checkNotNullParameter(channelPipelineConfig, (String)"channelPipelineConfig");
        this.applicationProvider = applicationProvider;
        this.enginePipeline = enginePipeline;
        this.environment = environment;
        this.callEventGroup = callEventGroup;
        this.engineContext = engineContext;
        this.userContext = userContext;
        this.connector = connector;
        this.runningLimit = runningLimit;
        this.responseWriteTimeout = responseWriteTimeout;
        this.requestReadTimeout = requestReadTimeout;
        this.httpServerCodec = httpServerCodec2;
        this.channelPipelineConfig = channelPipelineConfig;
        this.enableHttp2 = enableHttp2;
        this.enableH2c = enableH2c;
        if (this.connector instanceof EngineSSLConnectorConfig) {
            void $this$_init__u24lambda_u240;
            SslContextBuilder sslContextBuilder;
            Certificate[] certificateArray = ((EngineSSLConnectorConfig)this.connector).getKeyStore().getCertificateChain(((EngineSSLConnectorConfig)this.connector).getKeyAlias());
            Intrinsics.checkNotNullExpressionValue((Object)certificateArray, (String)"getCertificateChain(...)");
            List list = ArraysKt.toList((Object[])certificateArray);
            Intrinsics.checkNotNull((Object)list, (String)"null cannot be cast to non-null type kotlin.collections.List<java.security.cert.X509Certificate>");
            List chain1 = list;
            Collection $this$toTypedArray$iv = CollectionsKt.toList((Iterable)chain1);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            X509Certificate[] certs = thisCollection$iv.toArray(new X509Certificate[0]);
            char[] password = (char[])((EngineSSLConnectorConfig)this.connector).getPrivateKeyPassword().invoke();
            Key key = ((EngineSSLConnectorConfig)this.connector).getKeyStore().getKey(((EngineSSLConnectorConfig)this.connector).getKeyAlias(), password);
            Intrinsics.checkNotNull((Object)key, (String)"null cannot be cast to non-null type java.security.PrivateKey");
            PrivateKey pk = (PrivateKey)key;
            ArraysKt.fill$default((char[])password, (char)'\u0000', (int)0, (int)0, (int)6, null);
            SslContextBuilder sslContextBuilder2 = sslContextBuilder = SslContextBuilder.forServer((PrivateKey)pk, (X509Certificate[])Arrays.copyOf(certs, certs.length));
            NettyChannelInitializer nettyChannelInitializer = this;
            boolean bl = false;
            if (this.enableHttp2 && Companion.getAlpnProvider$ktor_server_netty() != null) {
                $this$_init__u24lambda_u240.sslProvider(Companion.getAlpnProvider$ktor_server_netty());
                $this$_init__u24lambda_u240.ciphers((Iterable)Http2SecurityUtil.CIPHERS, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE);
                String[] stringArray = new String[]{"h2", "http/1.1"};
                $this$_init__u24lambda_u240.applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, stringArray));
            }
            TrustManagerFactory trustManagerFactory = this.trustManagerFactory((EngineSSLConnectorConfig)this.connector);
            if (trustManagerFactory != null) {
                TrustManagerFactory it = trustManagerFactory;
                boolean bl2 = false;
                $this$_init__u24lambda_u240.trustManager(it);
            }
            nettyChannelInitializer.sslContext = sslContextBuilder.build();
        }
    }

    @Deprecated(message="Use main constructor", replaceWith=@ReplaceWith(expression="NettyChannelInitializer(getRequestBodySizeEstimator, enginePipeline, environment, callEventGroup, userContext, engineContext, connector, maxInitialLineLength, maxHeaderSize, maxChunkSize, httpServerCodec, channelPipelineConfig, enableHttp2, enableH2c)", imports={}))
    public NettyChannelInitializer(@NotNull Function0<Application> applicationProvider, @NotNull EnginePipeline enginePipeline, @NotNull ApplicationEnvironment environment, @NotNull EventExecutorGroup callEventGroup, @NotNull CoroutineContext engineContext, @NotNull CoroutineContext userContext, @NotNull EngineConnectorConfig connector, int runningLimit, int responseWriteTimeout, int requestReadTimeout, @NotNull Function0<HttpServerCodec> httpServerCodec2, @NotNull Function1<? super ChannelPipeline, Unit> channelPipelineConfig, boolean enableHttp2) {
        Intrinsics.checkNotNullParameter(applicationProvider, (String)"applicationProvider");
        Intrinsics.checkNotNullParameter((Object)enginePipeline, (String)"enginePipeline");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)callEventGroup, (String)"callEventGroup");
        Intrinsics.checkNotNullParameter((Object)engineContext, (String)"engineContext");
        Intrinsics.checkNotNullParameter((Object)userContext, (String)"userContext");
        Intrinsics.checkNotNullParameter((Object)connector, (String)"connector");
        Intrinsics.checkNotNullParameter(httpServerCodec2, (String)"httpServerCodec");
        Intrinsics.checkNotNullParameter(channelPipelineConfig, (String)"channelPipelineConfig");
        this(applicationProvider, enginePipeline, environment, callEventGroup, engineContext, userContext, connector, runningLimit, responseWriteTimeout, requestReadTimeout, httpServerCodec2, channelPipelineConfig, enableHttp2, false);
    }

    protected void initChannel(@NotNull SocketChannel ch) {
        Intrinsics.checkNotNullParameter((Object)ch, (String)"ch");
        ChannelPipeline $this$initChannel_u24lambda_u240 = ch.pipeline();
        boolean bl = false;
        if (this.enableHttp2 && this.enableH2c && this.connector instanceof EngineSSLConnectorConfig) {
            throw new IllegalStateException("Invalid configuration: H2C (HTTP/2 cleartext) cannot be used with SSL".toString());
        }
        if (this.enableHttp2 && this.enableH2c) {
            Intrinsics.checkNotNull((Object)$this$initChannel_u24lambda_u240);
            this.configurePipeline($this$initChannel_u24lambda_u240, ((Object)Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME).toString());
        } else if (this.connector instanceof EngineSSLConnectorConfig) {
            ChannelHandler[] channelHandlerArray;
            SslContext sslContext = this.sslContext;
            Intrinsics.checkNotNull((Object)sslContext);
            ChannelHandler[] $this$initChannel_u24lambda_u240_u240 = channelHandlerArray = sslContext.newEngine(ch.alloc());
            boolean bl2 = false;
            if (this.hasTrustStore((EngineSSLConnectorConfig)this.connector)) {
                $this$initChannel_u24lambda_u240_u240.setUseClientMode(false);
                $this$initChannel_u24lambda_u240_u240.setNeedClientAuth(true);
            }
            List list = ((EngineSSLConnectorConfig)this.connector).getEnabledProtocols();
            if (list != null) {
                List it = list;
                boolean bl3 = false;
                Collection $this$toTypedArray$iv = it;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                $this$initChannel_u24lambda_u240_u240.setEnabledProtocols(thisCollection$iv.toArray(new String[0]));
            }
            ChannelHandler[] sslEngine = channelHandlerArray;
            $this$initChannel_u24lambda_u240.addLast("ssl", (ChannelHandler)new SslHandler((SSLEngine)sslEngine));
            if (this.enableHttp2 && Companion.getAlpnProvider$ktor_server_netty() != null) {
                channelHandlerArray = new ChannelHandler[]{new NegotiatedPipelineInitializer()};
                $this$initChannel_u24lambda_u240.addLast(channelHandlerArray);
            } else {
                Intrinsics.checkNotNull((Object)$this$initChannel_u24lambda_u240);
                this.configurePipeline($this$initChannel_u24lambda_u240, "http/1.1");
            }
        } else {
            Intrinsics.checkNotNull((Object)$this$initChannel_u24lambda_u240);
            this.configurePipeline($this$initChannel_u24lambda_u240, "http/1.1");
        }
    }

    private final void configurePipeline(ChannelPipeline pipeline, String protocol) {
        String string = protocol;
        if (Intrinsics.areEqual((Object)string, (Object)"h2")) {
            Application application = (Application)this.applicationProvider.invoke();
            NettyHttp2Handler handler = new NettyHttp2Handler(this.enginePipeline, application, this.callEventGroup, application.getCoroutineContext().plus(this.userContext), this.runningLimit);
            ChannelHandler[] channelHandlerArray = new ChannelHandler[]{Http2MultiplexCodecBuilder.forServer((ChannelHandler)((ChannelHandler)handler)).build()};
            pipeline.addLast(channelHandlerArray);
            pipeline.channel().closeFuture().addListener(arg_0 -> NettyChannelInitializer.configurePipeline$lambda$0(handler, arg_0));
            this.channelPipelineConfig.invoke((Object)pipeline);
        } else if (Intrinsics.areEqual((Object)string, (Object)((Object)Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME).toString())) {
            NettyHttp2Handler handler = new NettyHttp2Handler(this.enginePipeline, (Application)this.applicationProvider.invoke(), this.callEventGroup, this.userContext, this.runningLimit);
            Http2MultiplexCodec multiplexHandler = Http2MultiplexCodecBuilder.forServer((ChannelHandler)((ChannelHandler)handler)).build();
            HttpServerCodec codec = (HttpServerCodec)this.httpServerCodec.invoke();
            HttpServerUpgradeHandler upgradeHandler = new HttpServerUpgradeHandler((HttpServerUpgradeHandler.SourceCodec)codec, arg_0 -> NettyChannelInitializer.configurePipeline$lambda$1(multiplexHandler, arg_0));
            CleartextHttp2ServerUpgradeHandler cleartextHttp2ServerUpgradeHandler = new CleartextHttp2ServerUpgradeHandler(codec, upgradeHandler, (ChannelHandler)multiplexHandler);
            pipeline.addLast("cleartextUpgradeHandler", (ChannelHandler)cleartextHttp2ServerUpgradeHandler);
            ChannelHandler[] channelHandlerArray = new ChannelHandler[]{new SimpleChannelInboundHandler<HttpMessage>(this, upgradeHandler){
                final /* synthetic */ NettyChannelInitializer this$0;
                final /* synthetic */ HttpServerUpgradeHandler $upgradeHandler;
                {
                    this.this$0 = $receiver;
                    this.$upgradeHandler = $upgradeHandler;
                }

                protected void channelRead0(ChannelHandlerContext ctx, HttpMessage msg) throws Exception {
                    ChannelPipeline channelPipeline;
                    Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                    Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
                    ChannelPipeline pipe = ctx.pipeline();
                    NettyHttp1Handler http1handler = new NettyHttp1Handler((Function0<Application>)NettyChannelInitializer.access$getApplicationProvider$p(this.this$0), NettyChannelInitializer.access$getEnginePipeline$p(this.this$0), NettyChannelInitializer.access$getEnvironment$p(this.this$0), NettyChannelInitializer.access$getCallEventGroup$p(this.this$0), NettyChannelInitializer.access$getEngineContext$p(this.this$0), NettyChannelInitializer.access$getUserContext$p(this.this$0), NettyChannelInitializer.access$getRunningLimit$p(this.this$0));
                    if (NettyChannelInitializer.access$getRequestReadTimeout$p(this.this$0) > 0) {
                        pipe.addAfter(ctx.name(), "readTimeout", (ChannelHandler)new KtorReadTimeoutHandler(NettyChannelInitializer.access$getRequestReadTimeout$p(this.this$0)));
                        channelPipeline = pipe.addAfter("readTimeout", "continue", (ChannelHandler)new HttpServerExpectContinueHandler());
                    } else {
                        channelPipeline = pipe.addAfter(ctx.name(), "continue", (ChannelHandler)new HttpServerExpectContinueHandler());
                    }
                    pipe.addAfter("continue", "timeout", (ChannelHandler)new WriteTimeoutHandler(NettyChannelInitializer.access$getResponseWriteTimeout$p(this.this$0)));
                    pipe.addAfter("timeout", "http1", (ChannelHandler)http1handler);
                    pipe.remove((ChannelHandler)this.$upgradeHandler);
                    pipe.remove(ctx.name());
                    ctx.fireChannelActive();
                    ctx.fireChannelRead((Object)msg);
                }
            }};
            pipeline.addLast(channelHandlerArray);
            pipeline.channel().closeFuture().addListener(arg_0 -> NettyChannelInitializer.configurePipeline$lambda$2(handler, arg_0));
            this.channelPipelineConfig.invoke((Object)pipeline);
        } else if (Intrinsics.areEqual((Object)string, (Object)"http/1.1")) {
            NettyHttp1Handler handler = new NettyHttp1Handler(this.applicationProvider, this.enginePipeline, this.environment, this.callEventGroup, this.engineContext, this.userContext, this.runningLimit);
            ChannelPipeline $this$configurePipeline_u24lambda_u243 = pipeline;
            boolean bl = false;
            if (this.requestReadTimeout > 0) {
                $this$configurePipeline_u24lambda_u243.addLast("readTimeout", (ChannelHandler)new KtorReadTimeoutHandler(this.requestReadTimeout));
            }
            $this$configurePipeline_u24lambda_u243.addLast("codec", (ChannelHandler)this.httpServerCodec.invoke());
            $this$configurePipeline_u24lambda_u243.addLast("continue", (ChannelHandler)new HttpServerExpectContinueHandler());
            $this$configurePipeline_u24lambda_u243.addLast("timeout", (ChannelHandler)new WriteTimeoutHandler(this.responseWriteTimeout));
            $this$configurePipeline_u24lambda_u243.addLast("http1", (ChannelHandler)handler);
            this.channelPipelineConfig.invoke((Object)$this$configurePipeline_u24lambda_u243);
            pipeline.context("codec").fireChannelActive();
        } else {
            this.environment.getLog().error("Unsupported protocol " + protocol);
            pipeline.close();
        }
    }

    private final boolean hasTrustStore(EngineSSLConnectorConfig $this$hasTrustStore) {
        return $this$hasTrustStore.getTrustStore() != null || $this$hasTrustStore.getTrustStorePath() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final TrustManagerFactory trustManagerFactory(EngineSSLConnectorConfig $this$trustManagerFactory) {
        TrustManagerFactory trustManagerFactory;
        KeyStore trustStore;
        KeyStore keyStore = $this$trustManagerFactory.getTrustStore();
        if (keyStore == null) {
            File file = $this$trustManagerFactory.getTrustStorePath();
            if (file != null) {
                File file2 = file;
                boolean bl = false;
                Closeable closeable = new FileInputStream(file2);
                Throwable throwable = null;
                try {
                    KeyStore keyStore2;
                    FileInputStream fis = (FileInputStream)closeable;
                    boolean bl2 = false;
                    KeyStore it = keyStore2 = KeyStore.getInstance(KeyStore.getDefaultType());
                    boolean bl3 = false;
                    it.load(fis, null);
                    KeyStore keyStore3 = keyStore2;
                    keyStore = keyStore3;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            } else {
                keyStore = null;
            }
        }
        KeyStore keyStore4 = trustStore = keyStore;
        if (keyStore4 != null) {
            TrustManagerFactory trustManagerFactory2;
            KeyStore store = keyStore4;
            boolean bl = false;
            TrustManagerFactory it = trustManagerFactory2 = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            boolean bl4 = false;
            it.init(store);
            trustManagerFactory = trustManagerFactory2;
        } else {
            trustManagerFactory = null;
        }
        return trustManagerFactory;
    }

    private static final void configurePipeline$lambda$0(NettyHttp2Handler $handler, Future it) {
        CoroutineScopeKt.cancel$default((CoroutineScope)$handler, null, (int)1, null);
    }

    private static final HttpServerUpgradeHandler.UpgradeCodec configurePipeline$lambda$1(Http2MultiplexCodec $multiplexHandler, CharSequence it) {
        return (HttpServerUpgradeHandler.UpgradeCodec)new Http2ServerUpgradeCodec($multiplexHandler);
    }

    private static final void configurePipeline$lambda$2(NettyHttp2Handler $handler, Future it) {
        CoroutineScopeKt.cancel$default((CoroutineScope)$handler, null, (int)1, null);
    }

    private static final SslProvider alpnProvider_delegate$lambda$0() {
        return NettyChannelInitializer.Companion.findAlpnProvider();
    }

    public static final /* synthetic */ Function0 access$getApplicationProvider$p(NettyChannelInitializer $this) {
        return $this.applicationProvider;
    }

    public static final /* synthetic */ EnginePipeline access$getEnginePipeline$p(NettyChannelInitializer $this) {
        return $this.enginePipeline;
    }

    public static final /* synthetic */ ApplicationEnvironment access$getEnvironment$p(NettyChannelInitializer $this) {
        return $this.environment;
    }

    public static final /* synthetic */ EventExecutorGroup access$getCallEventGroup$p(NettyChannelInitializer $this) {
        return $this.callEventGroup;
    }

    public static final /* synthetic */ CoroutineContext access$getEngineContext$p(NettyChannelInitializer $this) {
        return $this.engineContext;
    }

    public static final /* synthetic */ CoroutineContext access$getUserContext$p(NettyChannelInitializer $this) {
        return $this.userContext;
    }

    public static final /* synthetic */ int access$getRunningLimit$p(NettyChannelInitializer $this) {
        return $this.runningLimit;
    }

    public static final /* synthetic */ int access$getRequestReadTimeout$p(NettyChannelInitializer $this) {
        return $this.requestReadTimeout;
    }

    public static final /* synthetic */ int access$getResponseWriteTimeout$p(NettyChannelInitializer $this) {
        return $this.responseWriteTimeout;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u001d\u0010\n\u001a\u0004\u0018\u00010\u00048@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lio/ktor/server/netty/NettyChannelInitializer$Companion;", "", "<init>", "()V", "Lio/netty/handler/ssl/SslProvider;", "findAlpnProvider", "()Lio/netty/handler/ssl/SslProvider;", "alpnProvider$delegate", "Lkotlin/Lazy;", "getAlpnProvider$ktor_server_netty", "alpnProvider", "ktor-server-netty"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final SslProvider getAlpnProvider$ktor_server_netty() {
            Lazy lazy = alpnProvider$delegate;
            return (SslProvider)lazy.getValue();
        }

        private final SslProvider findAlpnProvider() {
            try {
                if (SslProvider.isAlpnSupported((SslProvider)SslProvider.OPENSSL)) {
                    return SslProvider.OPENSSL;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (SslProvider.isAlpnSupported((SslProvider)SslProvider.JDK)) {
                    return SslProvider.JDK;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0014\u00a2\u0006\u0004\b\t\u0010\nJ!\u0010\r\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0014\u00a2\u0006\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lio/ktor/server/netty/NettyChannelInitializer$NegotiatedPipelineInitializer;", "Lio/netty/handler/ssl/ApplicationProtocolNegotiationHandler;", "<init>", "(Lio/ktor/server/netty/NettyChannelInitializer;)V", "Lio/netty/channel/ChannelHandlerContext;", "ctx", "", "protocol", "", "configurePipeline", "(Lio/netty/channel/ChannelHandlerContext;Ljava/lang/String;)V", "", "cause", "handshakeFailure", "(Lio/netty/channel/ChannelHandlerContext;Ljava/lang/Throwable;)V", "ktor-server-netty"})
    private final class NegotiatedPipelineInitializer
    extends ApplicationProtocolNegotiationHandler {
        public NegotiatedPipelineInitializer() {
            super("http/1.1");
        }

        protected void configurePipeline(@NotNull ChannelHandlerContext ctx, @NotNull String protocol) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
            ChannelPipeline channelPipeline = ctx.pipeline();
            Intrinsics.checkNotNullExpressionValue((Object)channelPipeline, (String)"pipeline(...)");
            NettyChannelInitializer.this.configurePipeline(channelPipeline, protocol);
        }

        protected void handshakeFailure(@NotNull ChannelHandlerContext ctx, @Nullable Throwable cause) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            if (cause instanceof ClosedChannelException) {
                ctx.close();
            } else {
                super.handshakeFailure(ctx, cause);
            }
        }
    }
}

