/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.testing.client;

import io.ktor.client.engine.HttpClientEngine;
import io.ktor.client.engine.HttpClientEngineBase;
import io.ktor.client.engine.HttpClientEngineCapability;
import io.ktor.client.engine.HttpClientEngineFactory;
import io.ktor.client.plugins.HttpTimeout;
import io.ktor.client.plugins.websocket.WebSocketCapability;
import io.ktor.client.request.HttpRequestData;
import io.ktor.client.request.HttpResponseData;
import io.ktor.http.URLUtilsKt;
import io.ktor.http.Url;
import io.ktor.http.UrlKt;
import io.ktor.server.engine.EngineConnectorConfig;
import io.ktor.server.testing.TestApplication;
import io.ktor.server.testing.TestApplicationEngine;
import io.ktor.server.testing.client.DelegatingTestHttpClientConfig;
import io.ktor.server.testing.client.InvalidTestRequestException;
import io.ktor.server.testing.client.TestHttpClientConfig;
import io.ktor.server.testing.client.TestHttpClientEngine;
import io.ktor.server.testing.internal.CoroutineUtilsJvmKt;
import io.ktor.util.InternalAPI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 32\u00020\u0001:\u00013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010,\u001a\u00020-H\u0016J\u0019\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0097@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00102R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R'\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u00188BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\n\u001a\u0004\b\u001b\u0010\u001cR\u001b\u0010\u001e\u001a\u00020\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\n\u001a\u0004\b\u001f\u0010 R!\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00190#8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010\n\u001a\u0004\b$\u0010%R\u001e\u0010'\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030)0(X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00064"}, d2={"Lio/ktor/server/testing/client/DelegatingTestClientEngine;", "Lio/ktor/client/engine/HttpClientEngineBase;", "config", "Lio/ktor/server/testing/client/DelegatingTestHttpClientConfig;", "(Lio/ktor/server/testing/client/DelegatingTestHttpClientConfig;)V", "appEngine", "Lio/ktor/server/testing/TestApplicationEngine;", "getAppEngine", "()Lio/ktor/server/testing/TestApplicationEngine;", "appEngine$delegate", "Lkotlin/Lazy;", "clientJob", "Lkotlinx/coroutines/CompletableJob;", "getConfig", "()Lio/ktor/server/testing/client/DelegatingTestHttpClientConfig;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "dispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "getDispatcher", "()Lkotlinx/coroutines/CoroutineDispatcher;", "externalEngines", "", "", "Lio/ktor/server/testing/client/TestHttpClientEngine;", "getExternalEngines", "()Ljava/util/Map;", "externalEngines$delegate", "mainEngine", "getMainEngine", "()Lio/ktor/server/testing/client/TestHttpClientEngine;", "mainEngine$delegate", "mainEngineHostWithPorts", "", "getMainEngineHostWithPorts", "()Ljava/util/List;", "mainEngineHostWithPorts$delegate", "supportedCapabilities", "", "Lio/ktor/client/engine/HttpClientEngineCapability;", "getSupportedCapabilities", "()Ljava/util/Set;", "close", "", "execute", "Lio/ktor/client/request/HttpResponseData;", "data", "Lio/ktor/client/request/HttpRequestData;", "(Lio/ktor/client/request/HttpRequestData;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "ktor-server-test-host"})
@SourceDebugExtension(value={"SMAP\nDelegatingTestClientEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DelegatingTestClientEngine.kt\nio/ktor/server/testing/client/DelegatingTestClientEngine\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n1855#2,2:97\n*S KotlinDebug\n*F\n+ 1 DelegatingTestClientEngine.kt\nio/ktor/server/testing/client/DelegatingTestClientEngine\n*L\n67#1:97,2\n*E\n"})
public final class DelegatingTestClientEngine
extends HttpClientEngineBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DelegatingTestHttpClientConfig config;
    @NotNull
    private final CoroutineDispatcher dispatcher;
    @NotNull
    private final Set<HttpClientEngineCapability<?>> supportedCapabilities;
    @NotNull
    private final Lazy appEngine$delegate;
    @NotNull
    private final Lazy externalEngines$delegate;
    @NotNull
    private final Lazy mainEngine$delegate;
    @NotNull
    private final Lazy mainEngineHostWithPorts$delegate;
    @NotNull
    private final CompletableJob clientJob;
    @NotNull
    private final CoroutineContext coroutineContext;

    public DelegatingTestClientEngine(@NotNull DelegatingTestHttpClientConfig config) {
        Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
        super("delegating-test-engine");
        this.config = config;
        this.dispatcher = CoroutineUtilsJvmKt.getIOBridge(Dispatchers.INSTANCE);
        Object[] objectArray = new HttpClientEngineCapability[]{WebSocketCapability.INSTANCE, HttpTimeout.Plugin};
        this.supportedCapabilities = SetsKt.setOf((Object[])objectArray);
        this.appEngine$delegate = LazyKt.lazy(this.getConfig().getAppEngineProvider());
        this.externalEngines$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<String, ? extends TestHttpClientEngine>>(this){
            final /* synthetic */ DelegatingTestClientEngine this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Map<String, TestHttpClientEngine> invoke() {
                Map engines = new LinkedHashMap<K, V>();
                Map $this$forEach$iv = (Map)this.this$0.getConfig().getExternalApplicationsProvider().invoke();
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<K, V>> iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Object object;
                    Map.Entry<K, V> element$iv;
                    Map.Entry<K, V> entry = element$iv = iterator.next();
                    boolean bl = false;
                    String authority = (String)entry.getKey();
                    TestApplication testApplication2 = (TestApplication)entry.getValue();
                    Map map = engines;
                    TestHttpClientConfig $this$invoke_u24lambda_u241_u24lambda_u240 = object = new TestHttpClientConfig();
                    boolean bl2 = false;
                    $this$invoke_u24lambda_u241_u24lambda_u240.setApp(testApplication2.getEngine$ktor_server_test_host());
                    TestHttpClientConfig testHttpClientConfig = object;
                    object = new TestHttpClientEngine(testHttpClientConfig);
                    map.put(authority, object);
                }
                return MapsKt.toMap((Map)engines);
            }
        }));
        this.mainEngine$delegate = LazyKt.lazy((Function0)((Function0)new Function0<TestHttpClientEngine>(this){
            final /* synthetic */ DelegatingTestClientEngine this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final TestHttpClientEngine invoke() {
                TestHttpClientConfig testHttpClientConfig = new TestHttpClientConfig();
                DelegatingTestClientEngine delegatingTestClientEngine = this.this$0;
                TestHttpClientConfig $this$invoke_u24lambda_u240 = testHttpClientConfig;
                boolean bl = false;
                $this$invoke_u24lambda_u240.setApp(DelegatingTestClientEngine.access$getAppEngine(delegatingTestClientEngine));
                TestHttpClientConfig testHttpClientConfig2 = testHttpClientConfig;
                return new TestHttpClientEngine(testHttpClientConfig2);
            }
        }));
        this.mainEngineHostWithPorts$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends String>>(this){
            final /* synthetic */ DelegatingTestClientEngine this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<String> invoke() {
                return (List)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends String>>, Object>(this.this$0, null){
                    int label;
                    final /* synthetic */ DelegatingTestClientEngine this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var12_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                this.label = 1;
                                v0 = DelegatingTestClientEngine.access$getAppEngine(this.this$0).resolvedConnectors((Continuation<? super List<? extends EngineConnectorConfig>>)((Continuation)this));
                                if (v0 == var12_2) {
                                    return var12_2;
                                }
                                ** GOTO lbl13
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl13:
                                // 2 sources

                                $this$map$iv = (Iterable)v0;
                                $i$f$map = false;
                                var4_5 = $this$map$iv;
                                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    var9_10 = (EngineConnectorConfig)item$iv$iv;
                                    var11_12 = destination$iv$iv;
                                    $i$a$-map-DelegatingTestClientEngine$mainEngineHostWithPorts$2$1$1 = false;
                                    var11_12.add(it.getHost() + ':' + it.getPort());
                                }
                                return (List)destination$iv$iv;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super List<String>> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)1, null);
            }
        }));
        this.clientJob = JobKt.Job((Job)this.getConfig().getParentJob());
        this.coroutineContext = this.getDispatcher().plus((CoroutineContext)this.clientJob);
    }

    @NotNull
    public DelegatingTestHttpClientConfig getConfig() {
        return this.config;
    }

    @NotNull
    public CoroutineDispatcher getDispatcher() {
        return this.dispatcher;
    }

    @NotNull
    public Set<HttpClientEngineCapability<?>> getSupportedCapabilities() {
        return this.supportedCapabilities;
    }

    private final TestApplicationEngine getAppEngine() {
        Lazy lazy = this.appEngine$delegate;
        return (TestApplicationEngine)((Object)lazy.getValue());
    }

    private final Map<String, TestHttpClientEngine> getExternalEngines() {
        Lazy lazy = this.externalEngines$delegate;
        return (Map)lazy.getValue();
    }

    private final TestHttpClientEngine getMainEngine() {
        Lazy lazy = this.mainEngine$delegate;
        return (TestHttpClientEngine)((Object)lazy.getValue());
    }

    private final List<String> getMainEngineHostWithPorts() {
        Lazy lazy = this.mainEngineHostWithPorts$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    @InternalAPI
    @Nullable
    public Object execute(@NotNull HttpRequestData data, @NotNull Continuation<? super HttpResponseData> $completion) {
        String authority = UrlKt.getProtocolWithAuthority((Url)data.getUrl());
        String hostWithPort = URLUtilsKt.getHostWithPort((Url)data.getUrl());
        if (this.getExternalEngines().containsKey(authority)) {
            TestHttpClientEngine testHttpClientEngine = this.getExternalEngines().get(authority);
            Intrinsics.checkNotNull((Object)((Object)testHttpClientEngine));
            return testHttpClientEngine.execute(data, $completion);
        }
        if (this.getMainEngineHostWithPorts().contains(hostWithPort)) {
            return this.getMainEngine().execute(data, $completion);
        }
        throw new InvalidTestRequestException(authority, this.getExternalEngines().keySet(), this.getMainEngineHostWithPorts());
    }

    public void close() {
        this.clientJob.complete();
        this.getMainEngine().close();
        Iterable $this$forEach$iv = this.getExternalEngines().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TestHttpClientEngine it = (TestHttpClientEngine)((Object)element$iv);
            boolean bl = false;
            it.close();
        }
    }

    public static final /* synthetic */ TestApplicationEngine access$getAppEngine(DelegatingTestClientEngine $this) {
        return $this.getAppEngine();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J!\u0010\u0004\u001a\u00020\u00052\u0017\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\b\tH\u0016\u00a8\u0006\n"}, d2={"Lio/ktor/server/testing/client/DelegatingTestClientEngine$Companion;", "Lio/ktor/client/engine/HttpClientEngineFactory;", "Lio/ktor/server/testing/client/DelegatingTestHttpClientConfig;", "()V", "create", "Lio/ktor/client/engine/HttpClientEngine;", "block", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "ktor-server-test-host"})
    public static final class Companion
    implements HttpClientEngineFactory<DelegatingTestHttpClientConfig> {
        private Companion() {
        }

        @NotNull
        public HttpClientEngine create(@NotNull Function1<? super DelegatingTestHttpClientConfig, Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            DelegatingTestHttpClientConfig delegatingTestHttpClientConfig = new DelegatingTestHttpClientConfig();
            block.invoke((Object)delegatingTestHttpClientConfig);
            DelegatingTestHttpClientConfig config = delegatingTestHttpClientConfig;
            return (HttpClientEngine)new DelegatingTestClientEngine(config);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

