/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.fluent;

import io.kubernetes.client.fluent.DelegatingVisitor;
import io.kubernetes.client.fluent.Visitors;
import java.lang.reflect.Method;
import java.util.List;
import java.util.function.Predicate;

@FunctionalInterface
public interface Visitor<T> {
    default public Class<T> getType() {
        List<Class> args = Visitors.getTypeArguments(Visitor.class, this.getClass());
        if (args == null || args.isEmpty()) {
            return null;
        }
        return args.get(0);
    }

    public void visit(T var1);

    default public int order() {
        return 0;
    }

    default public void visit(List<Object> path, T element) {
        this.visit(element);
    }

    default public <F> Boolean canVisit(List<Object> path, F target) {
        if (target == null) {
            return false;
        }
        if (this.getType() == null) {
            return this.hasVisitMethodMatching(target);
        }
        if (!this.getType().isAssignableFrom(target.getClass())) {
            return false;
        }
        try {
            return this.getRequirement().test(path);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    default public <F> Boolean hasVisitMethodMatching(F target) {
        for (Method method : this.getClass().getMethods()) {
            if (!method.getName().equals("visit") || method.getParameterTypes().length != 1) continue;
            Class<?> visitorType = method.getParameterTypes()[0];
            if (visitorType.isAssignableFrom(target.getClass())) {
                return true;
            }
            return false;
        }
        return false;
    }

    default public <T> Predicate<List<Object>> getRequirement() {
        return p -> true;
    }

    default public <I> Predicate<List<Object>> hasItem(Class<I> type, Predicate<I> predicate) {
        Predicate<List<Object>> result = l -> l.stream().filter(i -> type.isInstance(i)).map(i -> type.cast(i)).anyMatch(predicate);
        return result;
    }

    default public <P> Visitor<T> addRequirement(Class<P> type, Predicate<P> predicate) {
        return this.addRequirement(predicate);
    }

    default public Visitor<T> addRequirement(final Predicate predicate) {
        return new DelegatingVisitor(this.getType(), this){

            @Override
            public Predicate<List<Object>> getRequirement() {
                return Visitor.this.getRequirement().and(predicate);
            }
        };
    }
}

