/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.AuthenticationV1TokenRequest;
import io.kubernetes.client.openapi.models.AuthenticationV1TokenRequestFluent;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1ObjectMetaBuilder;
import io.kubernetes.client.openapi.models.V1ObjectMetaFluentImpl;
import io.kubernetes.client.openapi.models.V1TokenRequestSpec;
import io.kubernetes.client.openapi.models.V1TokenRequestSpecBuilder;
import io.kubernetes.client.openapi.models.V1TokenRequestSpecFluentImpl;
import io.kubernetes.client.openapi.models.V1TokenRequestStatus;
import io.kubernetes.client.openapi.models.V1TokenRequestStatusBuilder;
import io.kubernetes.client.openapi.models.V1TokenRequestStatusFluentImpl;
import java.util.Objects;

public class AuthenticationV1TokenRequestFluentImpl<A extends AuthenticationV1TokenRequestFluent<A>>
extends BaseFluent<A>
implements AuthenticationV1TokenRequestFluent<A> {
    private String apiVersion;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private V1TokenRequestSpecBuilder spec;
    private V1TokenRequestStatusBuilder status;

    public AuthenticationV1TokenRequestFluentImpl() {
    }

    public AuthenticationV1TokenRequestFluentImpl(AuthenticationV1TokenRequest instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public V1ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public V1ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(V1ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new V1ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public AuthenticationV1TokenRequestFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public AuthenticationV1TokenRequestFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public AuthenticationV1TokenRequestFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public AuthenticationV1TokenRequestFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new V1ObjectMetaBuilder().build());
    }

    @Override
    public AuthenticationV1TokenRequestFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public V1TokenRequestSpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public V1TokenRequestSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(V1TokenRequestSpec spec) {
        this._visitables.get("spec").remove(this.spec);
        if (spec != null) {
            this.spec = new V1TokenRequestSpecBuilder(spec);
            this._visitables.get("spec").add(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public AuthenticationV1TokenRequestFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public AuthenticationV1TokenRequestFluent.SpecNested<A> withNewSpecLike(V1TokenRequestSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public AuthenticationV1TokenRequestFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public AuthenticationV1TokenRequestFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new V1TokenRequestSpecBuilder().build());
    }

    @Override
    public AuthenticationV1TokenRequestFluent.SpecNested<A> editOrNewSpecLike(V1TokenRequestSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    @Deprecated
    public V1TokenRequestStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public V1TokenRequestStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(V1TokenRequestStatus status) {
        this._visitables.get("status").remove(this.status);
        if (status != null) {
            this.status = new V1TokenRequestStatusBuilder(status);
            this._visitables.get("status").add(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public AuthenticationV1TokenRequestFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public AuthenticationV1TokenRequestFluent.StatusNested<A> withNewStatusLike(V1TokenRequestStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public AuthenticationV1TokenRequestFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public AuthenticationV1TokenRequestFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new V1TokenRequestStatusBuilder().build());
    }

    @Override
    public AuthenticationV1TokenRequestFluent.StatusNested<A> editOrNewStatusLike(V1TokenRequestStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationV1TokenRequestFluentImpl that = (AuthenticationV1TokenRequestFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec, this.status, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.spec != null) {
            sb.append("spec:");
            sb.append(this.spec + ",");
        }
        if (this.status != null) {
            sb.append("status:");
            sb.append(this.status);
        }
        sb.append("}");
        return sb.toString();
    }

    class StatusNestedImpl<N>
    extends V1TokenRequestStatusFluentImpl<AuthenticationV1TokenRequestFluent.StatusNested<N>>
    implements AuthenticationV1TokenRequestFluent.StatusNested<N>,
    Nested<N> {
        V1TokenRequestStatusBuilder builder;

        StatusNestedImpl(V1TokenRequestStatus item) {
            this.builder = new V1TokenRequestStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new V1TokenRequestStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)AuthenticationV1TokenRequestFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    class SpecNestedImpl<N>
    extends V1TokenRequestSpecFluentImpl<AuthenticationV1TokenRequestFluent.SpecNested<N>>
    implements AuthenticationV1TokenRequestFluent.SpecNested<N>,
    Nested<N> {
        V1TokenRequestSpecBuilder builder;

        SpecNestedImpl(V1TokenRequestSpec item) {
            this.builder = new V1TokenRequestSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new V1TokenRequestSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)AuthenticationV1TokenRequestFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    class MetadataNestedImpl<N>
    extends V1ObjectMetaFluentImpl<AuthenticationV1TokenRequestFluent.MetadataNested<N>>
    implements AuthenticationV1TokenRequestFluent.MetadataNested<N>,
    Nested<N> {
        V1ObjectMetaBuilder builder;

        MetadataNestedImpl(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new V1ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)AuthenticationV1TokenRequestFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

