/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.StorageV1TokenRequest;
import io.kubernetes.client.openapi.models.StorageV1TokenRequestBuilder;
import io.kubernetes.client.openapi.models.StorageV1TokenRequestFluentImpl;
import io.kubernetes.client.openapi.models.V1CSIDriverSpec;
import io.kubernetes.client.openapi.models.V1CSIDriverSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1CSIDriverSpecFluentImpl<A extends V1CSIDriverSpecFluent<A>>
extends BaseFluent<A>
implements V1CSIDriverSpecFluent<A> {
    private Boolean attachRequired;
    private String fsGroupPolicy;
    private Boolean podInfoOnMount;
    private Boolean requiresRepublish;
    private Boolean storageCapacity;
    private ArrayList<StorageV1TokenRequestBuilder> tokenRequests;
    private List<String> volumeLifecycleModes;

    public V1CSIDriverSpecFluentImpl() {
    }

    public V1CSIDriverSpecFluentImpl(V1CSIDriverSpec instance) {
        this.withAttachRequired(instance.getAttachRequired());
        this.withFsGroupPolicy(instance.getFsGroupPolicy());
        this.withPodInfoOnMount(instance.getPodInfoOnMount());
        this.withRequiresRepublish(instance.getRequiresRepublish());
        this.withStorageCapacity(instance.getStorageCapacity());
        this.withTokenRequests(instance.getTokenRequests());
        this.withVolumeLifecycleModes(instance.getVolumeLifecycleModes());
    }

    @Override
    public Boolean getAttachRequired() {
        return this.attachRequired;
    }

    @Override
    public A withAttachRequired(Boolean attachRequired) {
        this.attachRequired = attachRequired;
        return (A)this;
    }

    @Override
    public Boolean hasAttachRequired() {
        return this.attachRequired != null;
    }

    @Override
    public String getFsGroupPolicy() {
        return this.fsGroupPolicy;
    }

    @Override
    public A withFsGroupPolicy(String fsGroupPolicy) {
        this.fsGroupPolicy = fsGroupPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasFsGroupPolicy() {
        return this.fsGroupPolicy != null;
    }

    @Override
    public Boolean getPodInfoOnMount() {
        return this.podInfoOnMount;
    }

    @Override
    public A withPodInfoOnMount(Boolean podInfoOnMount) {
        this.podInfoOnMount = podInfoOnMount;
        return (A)this;
    }

    @Override
    public Boolean hasPodInfoOnMount() {
        return this.podInfoOnMount != null;
    }

    @Override
    public Boolean getRequiresRepublish() {
        return this.requiresRepublish;
    }

    @Override
    public A withRequiresRepublish(Boolean requiresRepublish) {
        this.requiresRepublish = requiresRepublish;
        return (A)this;
    }

    @Override
    public Boolean hasRequiresRepublish() {
        return this.requiresRepublish != null;
    }

    @Override
    public Boolean getStorageCapacity() {
        return this.storageCapacity;
    }

    @Override
    public A withStorageCapacity(Boolean storageCapacity) {
        this.storageCapacity = storageCapacity;
        return (A)this;
    }

    @Override
    public Boolean hasStorageCapacity() {
        return this.storageCapacity != null;
    }

    @Override
    public A addToTokenRequests(Integer index, StorageV1TokenRequest item) {
        if (this.tokenRequests == null) {
            this.tokenRequests = new ArrayList();
        }
        StorageV1TokenRequestBuilder builder = new StorageV1TokenRequestBuilder(item);
        this._visitables.get("tokenRequests").add(index >= 0 ? index.intValue() : this._visitables.get("tokenRequests").size(), builder);
        this.tokenRequests.add(index >= 0 ? index.intValue() : this.tokenRequests.size(), builder);
        return (A)this;
    }

    @Override
    public A setToTokenRequests(Integer index, StorageV1TokenRequest item) {
        if (this.tokenRequests == null) {
            this.tokenRequests = new ArrayList();
        }
        StorageV1TokenRequestBuilder builder = new StorageV1TokenRequestBuilder(item);
        if (index < 0 || index >= this._visitables.get("tokenRequests").size()) {
            this._visitables.get("tokenRequests").add(builder);
        } else {
            this._visitables.get("tokenRequests").set(index, builder);
        }
        if (index < 0 || index >= this.tokenRequests.size()) {
            this.tokenRequests.add(builder);
        } else {
            this.tokenRequests.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToTokenRequests(StorageV1TokenRequest ... items) {
        if (this.tokenRequests == null) {
            this.tokenRequests = new ArrayList();
        }
        for (StorageV1TokenRequest item : items) {
            StorageV1TokenRequestBuilder builder = new StorageV1TokenRequestBuilder(item);
            this._visitables.get("tokenRequests").add(builder);
            this.tokenRequests.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToTokenRequests(Collection<StorageV1TokenRequest> items) {
        if (this.tokenRequests == null) {
            this.tokenRequests = new ArrayList();
        }
        for (StorageV1TokenRequest item : items) {
            StorageV1TokenRequestBuilder builder = new StorageV1TokenRequestBuilder(item);
            this._visitables.get("tokenRequests").add(builder);
            this.tokenRequests.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromTokenRequests(StorageV1TokenRequest ... items) {
        for (StorageV1TokenRequest item : items) {
            StorageV1TokenRequestBuilder builder = new StorageV1TokenRequestBuilder(item);
            this._visitables.get("tokenRequests").remove(builder);
            if (this.tokenRequests == null) continue;
            this.tokenRequests.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTokenRequests(Collection<StorageV1TokenRequest> items) {
        for (StorageV1TokenRequest item : items) {
            StorageV1TokenRequestBuilder builder = new StorageV1TokenRequestBuilder(item);
            this._visitables.get("tokenRequests").remove(builder);
            if (this.tokenRequests == null) continue;
            this.tokenRequests.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromTokenRequests(Predicate<StorageV1TokenRequestBuilder> predicate) {
        if (this.tokenRequests == null) {
            return (A)this;
        }
        Iterator<StorageV1TokenRequestBuilder> each = this.tokenRequests.iterator();
        Object visitables = this._visitables.get("tokenRequests");
        while (each.hasNext()) {
            StorageV1TokenRequestBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<StorageV1TokenRequest> getTokenRequests() {
        return this.tokenRequests != null ? V1CSIDriverSpecFluentImpl.build(this.tokenRequests) : null;
    }

    @Override
    public List<StorageV1TokenRequest> buildTokenRequests() {
        return this.tokenRequests != null ? V1CSIDriverSpecFluentImpl.build(this.tokenRequests) : null;
    }

    @Override
    public StorageV1TokenRequest buildTokenRequest(Integer index) {
        return this.tokenRequests.get(index).build();
    }

    @Override
    public StorageV1TokenRequest buildFirstTokenRequest() {
        return this.tokenRequests.get(0).build();
    }

    @Override
    public StorageV1TokenRequest buildLastTokenRequest() {
        return this.tokenRequests.get(this.tokenRequests.size() - 1).build();
    }

    @Override
    public StorageV1TokenRequest buildMatchingTokenRequest(Predicate<StorageV1TokenRequestBuilder> predicate) {
        for (StorageV1TokenRequestBuilder item : this.tokenRequests) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTokenRequest(Predicate<StorageV1TokenRequestBuilder> predicate) {
        for (StorageV1TokenRequestBuilder item : this.tokenRequests) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTokenRequests(List<StorageV1TokenRequest> tokenRequests) {
        if (this.tokenRequests != null) {
            this._visitables.get("tokenRequests").removeAll(this.tokenRequests);
        }
        if (tokenRequests != null) {
            this.tokenRequests = new ArrayList();
            for (StorageV1TokenRequest item : tokenRequests) {
                this.addToTokenRequests(item);
            }
        } else {
            this.tokenRequests = null;
        }
        return (A)this;
    }

    @Override
    public A withTokenRequests(StorageV1TokenRequest ... tokenRequests) {
        if (this.tokenRequests != null) {
            this.tokenRequests.clear();
        }
        if (tokenRequests != null) {
            for (StorageV1TokenRequest item : tokenRequests) {
                this.addToTokenRequests(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTokenRequests() {
        return this.tokenRequests != null && !this.tokenRequests.isEmpty();
    }

    @Override
    public V1CSIDriverSpecFluent.TokenRequestsNested<A> addNewTokenRequest() {
        return new TokenRequestsNestedImpl();
    }

    @Override
    public V1CSIDriverSpecFluent.TokenRequestsNested<A> addNewTokenRequestLike(StorageV1TokenRequest item) {
        return new TokenRequestsNestedImpl(-1, item);
    }

    @Override
    public V1CSIDriverSpecFluent.TokenRequestsNested<A> setNewTokenRequestLike(Integer index, StorageV1TokenRequest item) {
        return new TokenRequestsNestedImpl(index, item);
    }

    @Override
    public V1CSIDriverSpecFluent.TokenRequestsNested<A> editTokenRequest(Integer index) {
        if (this.tokenRequests.size() <= index) {
            throw new RuntimeException("Can't edit tokenRequests. Index exceeds size.");
        }
        return this.setNewTokenRequestLike(index, this.buildTokenRequest(index));
    }

    @Override
    public V1CSIDriverSpecFluent.TokenRequestsNested<A> editFirstTokenRequest() {
        if (this.tokenRequests.size() == 0) {
            throw new RuntimeException("Can't edit first tokenRequests. The list is empty.");
        }
        return this.setNewTokenRequestLike(0, this.buildTokenRequest(0));
    }

    @Override
    public V1CSIDriverSpecFluent.TokenRequestsNested<A> editLastTokenRequest() {
        int index = this.tokenRequests.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last tokenRequests. The list is empty.");
        }
        return this.setNewTokenRequestLike(index, this.buildTokenRequest(index));
    }

    @Override
    public V1CSIDriverSpecFluent.TokenRequestsNested<A> editMatchingTokenRequest(Predicate<StorageV1TokenRequestBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.tokenRequests.size(); ++i) {
            if (!predicate.test(this.tokenRequests.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching tokenRequests. No match found.");
        }
        return this.setNewTokenRequestLike(index, this.buildTokenRequest(index));
    }

    @Override
    public A addToVolumeLifecycleModes(Integer index, String item) {
        if (this.volumeLifecycleModes == null) {
            this.volumeLifecycleModes = new ArrayList<String>();
        }
        this.volumeLifecycleModes.add(index, item);
        return (A)this;
    }

    @Override
    public A setToVolumeLifecycleModes(Integer index, String item) {
        if (this.volumeLifecycleModes == null) {
            this.volumeLifecycleModes = new ArrayList<String>();
        }
        this.volumeLifecycleModes.set(index, item);
        return (A)this;
    }

    @Override
    public A addToVolumeLifecycleModes(String ... items) {
        if (this.volumeLifecycleModes == null) {
            this.volumeLifecycleModes = new ArrayList<String>();
        }
        for (String item : items) {
            this.volumeLifecycleModes.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToVolumeLifecycleModes(Collection<String> items) {
        if (this.volumeLifecycleModes == null) {
            this.volumeLifecycleModes = new ArrayList<String>();
        }
        for (String item : items) {
            this.volumeLifecycleModes.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumeLifecycleModes(String ... items) {
        for (String item : items) {
            if (this.volumeLifecycleModes == null) continue;
            this.volumeLifecycleModes.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVolumeLifecycleModes(Collection<String> items) {
        for (String item : items) {
            if (this.volumeLifecycleModes == null) continue;
            this.volumeLifecycleModes.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getVolumeLifecycleModes() {
        return this.volumeLifecycleModes;
    }

    @Override
    public String getVolumeLifecycleMode(Integer index) {
        return this.volumeLifecycleModes.get(index);
    }

    @Override
    public String getFirstVolumeLifecycleMode() {
        return this.volumeLifecycleModes.get(0);
    }

    @Override
    public String getLastVolumeLifecycleMode() {
        return this.volumeLifecycleModes.get(this.volumeLifecycleModes.size() - 1);
    }

    @Override
    public String getMatchingVolumeLifecycleMode(Predicate<String> predicate) {
        for (String item : this.volumeLifecycleModes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVolumeLifecycleMode(Predicate<String> predicate) {
        for (String item : this.volumeLifecycleModes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVolumeLifecycleModes(List<String> volumeLifecycleModes) {
        if (volumeLifecycleModes != null) {
            this.volumeLifecycleModes = new ArrayList<String>();
            for (String item : volumeLifecycleModes) {
                this.addToVolumeLifecycleModes(item);
            }
        } else {
            this.volumeLifecycleModes = null;
        }
        return (A)this;
    }

    @Override
    public A withVolumeLifecycleModes(String ... volumeLifecycleModes) {
        if (this.volumeLifecycleModes != null) {
            this.volumeLifecycleModes.clear();
        }
        if (volumeLifecycleModes != null) {
            for (String item : volumeLifecycleModes) {
                this.addToVolumeLifecycleModes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumeLifecycleModes() {
        return this.volumeLifecycleModes != null && !this.volumeLifecycleModes.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1CSIDriverSpecFluentImpl that = (V1CSIDriverSpecFluentImpl)o;
        if (this.attachRequired != null ? !this.attachRequired.equals(that.attachRequired) : that.attachRequired != null) {
            return false;
        }
        if (this.fsGroupPolicy != null ? !this.fsGroupPolicy.equals(that.fsGroupPolicy) : that.fsGroupPolicy != null) {
            return false;
        }
        if (this.podInfoOnMount != null ? !this.podInfoOnMount.equals(that.podInfoOnMount) : that.podInfoOnMount != null) {
            return false;
        }
        if (this.requiresRepublish != null ? !this.requiresRepublish.equals(that.requiresRepublish) : that.requiresRepublish != null) {
            return false;
        }
        if (this.storageCapacity != null ? !this.storageCapacity.equals(that.storageCapacity) : that.storageCapacity != null) {
            return false;
        }
        if (this.tokenRequests != null ? !this.tokenRequests.equals(that.tokenRequests) : that.tokenRequests != null) {
            return false;
        }
        return !(this.volumeLifecycleModes != null ? !this.volumeLifecycleModes.equals(that.volumeLifecycleModes) : that.volumeLifecycleModes != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.attachRequired, this.fsGroupPolicy, this.podInfoOnMount, this.requiresRepublish, this.storageCapacity, this.tokenRequests, this.volumeLifecycleModes, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.attachRequired != null) {
            sb.append("attachRequired:");
            sb.append(this.attachRequired + ",");
        }
        if (this.fsGroupPolicy != null) {
            sb.append("fsGroupPolicy:");
            sb.append(this.fsGroupPolicy + ",");
        }
        if (this.podInfoOnMount != null) {
            sb.append("podInfoOnMount:");
            sb.append(this.podInfoOnMount + ",");
        }
        if (this.requiresRepublish != null) {
            sb.append("requiresRepublish:");
            sb.append(this.requiresRepublish + ",");
        }
        if (this.storageCapacity != null) {
            sb.append("storageCapacity:");
            sb.append(this.storageCapacity + ",");
        }
        if (this.tokenRequests != null && !this.tokenRequests.isEmpty()) {
            sb.append("tokenRequests:");
            sb.append(this.tokenRequests + ",");
        }
        if (this.volumeLifecycleModes != null && !this.volumeLifecycleModes.isEmpty()) {
            sb.append("volumeLifecycleModes:");
            sb.append(this.volumeLifecycleModes);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withAttachRequired() {
        return this.withAttachRequired(true);
    }

    @Override
    public A withPodInfoOnMount() {
        return this.withPodInfoOnMount(true);
    }

    @Override
    public A withRequiresRepublish() {
        return this.withRequiresRepublish(true);
    }

    @Override
    public A withStorageCapacity() {
        return this.withStorageCapacity(true);
    }

    class TokenRequestsNestedImpl<N>
    extends StorageV1TokenRequestFluentImpl<V1CSIDriverSpecFluent.TokenRequestsNested<N>>
    implements V1CSIDriverSpecFluent.TokenRequestsNested<N>,
    Nested<N> {
        StorageV1TokenRequestBuilder builder;
        Integer index;

        TokenRequestsNestedImpl(Integer index, StorageV1TokenRequest item) {
            this.index = index;
            this.builder = new StorageV1TokenRequestBuilder(this, item);
        }

        TokenRequestsNestedImpl() {
            this.index = -1;
            this.builder = new StorageV1TokenRequestBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1CSIDriverSpecFluentImpl.this.setToTokenRequests(this.index, this.builder.build());
        }

        @Override
        public N endTokenRequest() {
            return this.and();
        }
    }
}

