/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1Container;
import io.kubernetes.client.openapi.models.V1ContainerFluent;
import io.kubernetes.client.openapi.models.V1ContainerPort;
import io.kubernetes.client.openapi.models.V1ContainerPortBuilder;
import io.kubernetes.client.openapi.models.V1ContainerPortFluentImpl;
import io.kubernetes.client.openapi.models.V1EnvFromSource;
import io.kubernetes.client.openapi.models.V1EnvFromSourceBuilder;
import io.kubernetes.client.openapi.models.V1EnvFromSourceFluentImpl;
import io.kubernetes.client.openapi.models.V1EnvVar;
import io.kubernetes.client.openapi.models.V1EnvVarBuilder;
import io.kubernetes.client.openapi.models.V1EnvVarFluentImpl;
import io.kubernetes.client.openapi.models.V1Lifecycle;
import io.kubernetes.client.openapi.models.V1LifecycleBuilder;
import io.kubernetes.client.openapi.models.V1LifecycleFluentImpl;
import io.kubernetes.client.openapi.models.V1Probe;
import io.kubernetes.client.openapi.models.V1ProbeBuilder;
import io.kubernetes.client.openapi.models.V1ProbeFluentImpl;
import io.kubernetes.client.openapi.models.V1ResourceRequirements;
import io.kubernetes.client.openapi.models.V1ResourceRequirementsBuilder;
import io.kubernetes.client.openapi.models.V1ResourceRequirementsFluentImpl;
import io.kubernetes.client.openapi.models.V1SecurityContext;
import io.kubernetes.client.openapi.models.V1SecurityContextBuilder;
import io.kubernetes.client.openapi.models.V1SecurityContextFluentImpl;
import io.kubernetes.client.openapi.models.V1VolumeDevice;
import io.kubernetes.client.openapi.models.V1VolumeDeviceBuilder;
import io.kubernetes.client.openapi.models.V1VolumeDeviceFluentImpl;
import io.kubernetes.client.openapi.models.V1VolumeMount;
import io.kubernetes.client.openapi.models.V1VolumeMountBuilder;
import io.kubernetes.client.openapi.models.V1VolumeMountFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1ContainerFluentImpl<A extends V1ContainerFluent<A>>
extends BaseFluent<A>
implements V1ContainerFluent<A> {
    private List<String> args;
    private List<String> command;
    private ArrayList<V1EnvVarBuilder> env;
    private ArrayList<V1EnvFromSourceBuilder> envFrom;
    private String image;
    private String imagePullPolicy;
    private V1LifecycleBuilder lifecycle;
    private V1ProbeBuilder livenessProbe;
    private String name;
    private ArrayList<V1ContainerPortBuilder> ports;
    private V1ProbeBuilder readinessProbe;
    private V1ResourceRequirementsBuilder resources;
    private V1SecurityContextBuilder securityContext;
    private V1ProbeBuilder startupProbe;
    private Boolean stdin;
    private Boolean stdinOnce;
    private String terminationMessagePath;
    private String terminationMessagePolicy;
    private Boolean tty;
    private ArrayList<V1VolumeDeviceBuilder> volumeDevices;
    private ArrayList<V1VolumeMountBuilder> volumeMounts;
    private String workingDir;

    public V1ContainerFluentImpl() {
    }

    public V1ContainerFluentImpl(V1Container instance) {
        this.withArgs(instance.getArgs());
        this.withCommand(instance.getCommand());
        this.withEnv(instance.getEnv());
        this.withEnvFrom(instance.getEnvFrom());
        this.withImage(instance.getImage());
        this.withImagePullPolicy(instance.getImagePullPolicy());
        this.withLifecycle(instance.getLifecycle());
        this.withLivenessProbe(instance.getLivenessProbe());
        this.withName(instance.getName());
        this.withPorts(instance.getPorts());
        this.withReadinessProbe(instance.getReadinessProbe());
        this.withResources(instance.getResources());
        this.withSecurityContext(instance.getSecurityContext());
        this.withStartupProbe(instance.getStartupProbe());
        this.withStdin(instance.getStdin());
        this.withStdinOnce(instance.getStdinOnce());
        this.withTerminationMessagePath(instance.getTerminationMessagePath());
        this.withTerminationMessagePolicy(instance.getTerminationMessagePolicy());
        this.withTty(instance.getTty());
        this.withVolumeDevices(instance.getVolumeDevices());
        this.withVolumeMounts(instance.getVolumeMounts());
        this.withWorkingDir(instance.getWorkingDir());
    }

    @Override
    public A addToArgs(Integer index, String item) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        this.args.add(index, item);
        return (A)this;
    }

    @Override
    public A setToArgs(Integer index, String item) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        this.args.set(index, item);
        return (A)this;
    }

    @Override
    public A addToArgs(String ... items) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        for (String item : items) {
            this.args.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToArgs(Collection<String> items) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        for (String item : items) {
            this.args.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromArgs(String ... items) {
        for (String item : items) {
            if (this.args == null) continue;
            this.args.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromArgs(Collection<String> items) {
        for (String item : items) {
            if (this.args == null) continue;
            this.args.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getArgs() {
        return this.args;
    }

    @Override
    public String getArg(Integer index) {
        return this.args.get(index);
    }

    @Override
    public String getFirstArg() {
        return this.args.get(0);
    }

    @Override
    public String getLastArg() {
        return this.args.get(this.args.size() - 1);
    }

    @Override
    public String getMatchingArg(Predicate<String> predicate) {
        for (String item : this.args) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingArg(Predicate<String> predicate) {
        for (String item : this.args) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withArgs(List<String> args) {
        if (args != null) {
            this.args = new ArrayList<String>();
            for (String item : args) {
                this.addToArgs(item);
            }
        } else {
            this.args = null;
        }
        return (A)this;
    }

    @Override
    public A withArgs(String ... args) {
        if (this.args != null) {
            this.args.clear();
        }
        if (args != null) {
            for (String item : args) {
                this.addToArgs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasArgs() {
        return this.args != null && !this.args.isEmpty();
    }

    @Override
    public A addToCommand(Integer index, String item) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        this.command.add(index, item);
        return (A)this;
    }

    @Override
    public A setToCommand(Integer index, String item) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        this.command.set(index, item);
        return (A)this;
    }

    @Override
    public A addToCommand(String ... items) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        for (String item : items) {
            this.command.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToCommand(Collection<String> items) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        for (String item : items) {
            this.command.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromCommand(String ... items) {
        for (String item : items) {
            if (this.command == null) continue;
            this.command.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCommand(Collection<String> items) {
        for (String item : items) {
            if (this.command == null) continue;
            this.command.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getCommand() {
        return this.command;
    }

    @Override
    public String getCommand(Integer index) {
        return this.command.get(index);
    }

    @Override
    public String getFirstCommand() {
        return this.command.get(0);
    }

    @Override
    public String getLastCommand() {
        return this.command.get(this.command.size() - 1);
    }

    @Override
    public String getMatchingCommand(Predicate<String> predicate) {
        for (String item : this.command) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCommand(Predicate<String> predicate) {
        for (String item : this.command) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withCommand(List<String> command) {
        if (command != null) {
            this.command = new ArrayList<String>();
            for (String item : command) {
                this.addToCommand(item);
            }
        } else {
            this.command = null;
        }
        return (A)this;
    }

    @Override
    public A withCommand(String ... command) {
        if (this.command != null) {
            this.command.clear();
        }
        if (command != null) {
            for (String item : command) {
                this.addToCommand(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasCommand() {
        return this.command != null && !this.command.isEmpty();
    }

    @Override
    public A addToEnv(Integer index, V1EnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        V1EnvVarBuilder builder = new V1EnvVarBuilder(item);
        this._visitables.get("env").add(index >= 0 ? index.intValue() : this._visitables.get("env").size(), builder);
        this.env.add(index >= 0 ? index.intValue() : this.env.size(), builder);
        return (A)this;
    }

    @Override
    public A setToEnv(Integer index, V1EnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        V1EnvVarBuilder builder = new V1EnvVarBuilder(item);
        if (index < 0 || index >= this._visitables.get("env").size()) {
            this._visitables.get("env").add(builder);
        } else {
            this._visitables.get("env").set(index, builder);
        }
        if (index < 0 || index >= this.env.size()) {
            this.env.add(builder);
        } else {
            this.env.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToEnv(V1EnvVar ... items) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        for (V1EnvVar item : items) {
            V1EnvVarBuilder builder = new V1EnvVarBuilder(item);
            this._visitables.get("env").add(builder);
            this.env.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToEnv(Collection<V1EnvVar> items) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        for (V1EnvVar item : items) {
            V1EnvVarBuilder builder = new V1EnvVarBuilder(item);
            this._visitables.get("env").add(builder);
            this.env.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromEnv(V1EnvVar ... items) {
        for (V1EnvVar item : items) {
            V1EnvVarBuilder builder = new V1EnvVarBuilder(item);
            this._visitables.get("env").remove(builder);
            if (this.env == null) continue;
            this.env.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEnv(Collection<V1EnvVar> items) {
        for (V1EnvVar item : items) {
            V1EnvVarBuilder builder = new V1EnvVarBuilder(item);
            this._visitables.get("env").remove(builder);
            if (this.env == null) continue;
            this.env.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromEnv(Predicate<V1EnvVarBuilder> predicate) {
        if (this.env == null) {
            return (A)this;
        }
        Iterator<V1EnvVarBuilder> each = this.env.iterator();
        Object visitables = this._visitables.get("env");
        while (each.hasNext()) {
            V1EnvVarBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1EnvVar> getEnv() {
        return this.env != null ? V1ContainerFluentImpl.build(this.env) : null;
    }

    @Override
    public List<V1EnvVar> buildEnv() {
        return this.env != null ? V1ContainerFluentImpl.build(this.env) : null;
    }

    @Override
    public V1EnvVar buildEnv(Integer index) {
        return this.env.get(index).build();
    }

    @Override
    public V1EnvVar buildFirstEnv() {
        return this.env.get(0).build();
    }

    @Override
    public V1EnvVar buildLastEnv() {
        return this.env.get(this.env.size() - 1).build();
    }

    @Override
    public V1EnvVar buildMatchingEnv(Predicate<V1EnvVarBuilder> predicate) {
        for (V1EnvVarBuilder item : this.env) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEnv(Predicate<V1EnvVarBuilder> predicate) {
        for (V1EnvVarBuilder item : this.env) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withEnv(List<V1EnvVar> env) {
        if (this.env != null) {
            this._visitables.get("env").removeAll(this.env);
        }
        if (env != null) {
            this.env = new ArrayList();
            for (V1EnvVar item : env) {
                this.addToEnv(item);
            }
        } else {
            this.env = null;
        }
        return (A)this;
    }

    @Override
    public A withEnv(V1EnvVar ... env) {
        if (this.env != null) {
            this.env.clear();
        }
        if (env != null) {
            for (V1EnvVar item : env) {
                this.addToEnv(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasEnv() {
        return this.env != null && !this.env.isEmpty();
    }

    @Override
    public V1ContainerFluent.EnvNested<A> addNewEnv() {
        return new EnvNestedImpl();
    }

    @Override
    public V1ContainerFluent.EnvNested<A> addNewEnvLike(V1EnvVar item) {
        return new EnvNestedImpl(-1, item);
    }

    @Override
    public V1ContainerFluent.EnvNested<A> setNewEnvLike(Integer index, V1EnvVar item) {
        return new EnvNestedImpl(index, item);
    }

    @Override
    public V1ContainerFluent.EnvNested<A> editEnv(Integer index) {
        if (this.env.size() <= index) {
            throw new RuntimeException("Can't edit env. Index exceeds size.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    @Override
    public V1ContainerFluent.EnvNested<A> editFirstEnv() {
        if (this.env.size() == 0) {
            throw new RuntimeException("Can't edit first env. The list is empty.");
        }
        return this.setNewEnvLike(0, this.buildEnv(0));
    }

    @Override
    public V1ContainerFluent.EnvNested<A> editLastEnv() {
        int index = this.env.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last env. The list is empty.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    @Override
    public V1ContainerFluent.EnvNested<A> editMatchingEnv(Predicate<V1EnvVarBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.env.size(); ++i) {
            if (!predicate.test(this.env.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching env. No match found.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    @Override
    public A addToEnvFrom(Integer index, V1EnvFromSource item) {
        if (this.envFrom == null) {
            this.envFrom = new ArrayList();
        }
        V1EnvFromSourceBuilder builder = new V1EnvFromSourceBuilder(item);
        this._visitables.get("envFrom").add(index >= 0 ? index.intValue() : this._visitables.get("envFrom").size(), builder);
        this.envFrom.add(index >= 0 ? index.intValue() : this.envFrom.size(), builder);
        return (A)this;
    }

    @Override
    public A setToEnvFrom(Integer index, V1EnvFromSource item) {
        if (this.envFrom == null) {
            this.envFrom = new ArrayList();
        }
        V1EnvFromSourceBuilder builder = new V1EnvFromSourceBuilder(item);
        if (index < 0 || index >= this._visitables.get("envFrom").size()) {
            this._visitables.get("envFrom").add(builder);
        } else {
            this._visitables.get("envFrom").set(index, builder);
        }
        if (index < 0 || index >= this.envFrom.size()) {
            this.envFrom.add(builder);
        } else {
            this.envFrom.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToEnvFrom(V1EnvFromSource ... items) {
        if (this.envFrom == null) {
            this.envFrom = new ArrayList();
        }
        for (V1EnvFromSource item : items) {
            V1EnvFromSourceBuilder builder = new V1EnvFromSourceBuilder(item);
            this._visitables.get("envFrom").add(builder);
            this.envFrom.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToEnvFrom(Collection<V1EnvFromSource> items) {
        if (this.envFrom == null) {
            this.envFrom = new ArrayList();
        }
        for (V1EnvFromSource item : items) {
            V1EnvFromSourceBuilder builder = new V1EnvFromSourceBuilder(item);
            this._visitables.get("envFrom").add(builder);
            this.envFrom.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromEnvFrom(V1EnvFromSource ... items) {
        for (V1EnvFromSource item : items) {
            V1EnvFromSourceBuilder builder = new V1EnvFromSourceBuilder(item);
            this._visitables.get("envFrom").remove(builder);
            if (this.envFrom == null) continue;
            this.envFrom.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEnvFrom(Collection<V1EnvFromSource> items) {
        for (V1EnvFromSource item : items) {
            V1EnvFromSourceBuilder builder = new V1EnvFromSourceBuilder(item);
            this._visitables.get("envFrom").remove(builder);
            if (this.envFrom == null) continue;
            this.envFrom.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromEnvFrom(Predicate<V1EnvFromSourceBuilder> predicate) {
        if (this.envFrom == null) {
            return (A)this;
        }
        Iterator<V1EnvFromSourceBuilder> each = this.envFrom.iterator();
        Object visitables = this._visitables.get("envFrom");
        while (each.hasNext()) {
            V1EnvFromSourceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1EnvFromSource> getEnvFrom() {
        return this.envFrom != null ? V1ContainerFluentImpl.build(this.envFrom) : null;
    }

    @Override
    public List<V1EnvFromSource> buildEnvFrom() {
        return this.envFrom != null ? V1ContainerFluentImpl.build(this.envFrom) : null;
    }

    @Override
    public V1EnvFromSource buildEnvFrom(Integer index) {
        return this.envFrom.get(index).build();
    }

    @Override
    public V1EnvFromSource buildFirstEnvFrom() {
        return this.envFrom.get(0).build();
    }

    @Override
    public V1EnvFromSource buildLastEnvFrom() {
        return this.envFrom.get(this.envFrom.size() - 1).build();
    }

    @Override
    public V1EnvFromSource buildMatchingEnvFrom(Predicate<V1EnvFromSourceBuilder> predicate) {
        for (V1EnvFromSourceBuilder item : this.envFrom) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEnvFrom(Predicate<V1EnvFromSourceBuilder> predicate) {
        for (V1EnvFromSourceBuilder item : this.envFrom) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withEnvFrom(List<V1EnvFromSource> envFrom) {
        if (this.envFrom != null) {
            this._visitables.get("envFrom").removeAll(this.envFrom);
        }
        if (envFrom != null) {
            this.envFrom = new ArrayList();
            for (V1EnvFromSource item : envFrom) {
                this.addToEnvFrom(item);
            }
        } else {
            this.envFrom = null;
        }
        return (A)this;
    }

    @Override
    public A withEnvFrom(V1EnvFromSource ... envFrom) {
        if (this.envFrom != null) {
            this.envFrom.clear();
        }
        if (envFrom != null) {
            for (V1EnvFromSource item : envFrom) {
                this.addToEnvFrom(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasEnvFrom() {
        return this.envFrom != null && !this.envFrom.isEmpty();
    }

    @Override
    public V1ContainerFluent.EnvFromNested<A> addNewEnvFrom() {
        return new EnvFromNestedImpl();
    }

    @Override
    public V1ContainerFluent.EnvFromNested<A> addNewEnvFromLike(V1EnvFromSource item) {
        return new EnvFromNestedImpl(-1, item);
    }

    @Override
    public V1ContainerFluent.EnvFromNested<A> setNewEnvFromLike(Integer index, V1EnvFromSource item) {
        return new EnvFromNestedImpl(index, item);
    }

    @Override
    public V1ContainerFluent.EnvFromNested<A> editEnvFrom(Integer index) {
        if (this.envFrom.size() <= index) {
            throw new RuntimeException("Can't edit envFrom. Index exceeds size.");
        }
        return this.setNewEnvFromLike(index, this.buildEnvFrom(index));
    }

    @Override
    public V1ContainerFluent.EnvFromNested<A> editFirstEnvFrom() {
        if (this.envFrom.size() == 0) {
            throw new RuntimeException("Can't edit first envFrom. The list is empty.");
        }
        return this.setNewEnvFromLike(0, this.buildEnvFrom(0));
    }

    @Override
    public V1ContainerFluent.EnvFromNested<A> editLastEnvFrom() {
        int index = this.envFrom.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last envFrom. The list is empty.");
        }
        return this.setNewEnvFromLike(index, this.buildEnvFrom(index));
    }

    @Override
    public V1ContainerFluent.EnvFromNested<A> editMatchingEnvFrom(Predicate<V1EnvFromSourceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.envFrom.size(); ++i) {
            if (!predicate.test(this.envFrom.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching envFrom. No match found.");
        }
        return this.setNewEnvFromLike(index, this.buildEnvFrom(index));
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public A withImage(String image) {
        this.image = image;
        return (A)this;
    }

    @Override
    public Boolean hasImage() {
        return this.image != null;
    }

    @Override
    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    @Override
    public A withImagePullPolicy(String imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasImagePullPolicy() {
        return this.imagePullPolicy != null;
    }

    @Override
    @Deprecated
    public V1Lifecycle getLifecycle() {
        return this.lifecycle != null ? this.lifecycle.build() : null;
    }

    @Override
    public V1Lifecycle buildLifecycle() {
        return this.lifecycle != null ? this.lifecycle.build() : null;
    }

    @Override
    public A withLifecycle(V1Lifecycle lifecycle) {
        this._visitables.get("lifecycle").remove(this.lifecycle);
        if (lifecycle != null) {
            this.lifecycle = new V1LifecycleBuilder(lifecycle);
            this._visitables.get("lifecycle").add(this.lifecycle);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLifecycle() {
        return this.lifecycle != null;
    }

    @Override
    public V1ContainerFluent.LifecycleNested<A> withNewLifecycle() {
        return new LifecycleNestedImpl();
    }

    @Override
    public V1ContainerFluent.LifecycleNested<A> withNewLifecycleLike(V1Lifecycle item) {
        return new LifecycleNestedImpl(item);
    }

    @Override
    public V1ContainerFluent.LifecycleNested<A> editLifecycle() {
        return this.withNewLifecycleLike(this.getLifecycle());
    }

    @Override
    public V1ContainerFluent.LifecycleNested<A> editOrNewLifecycle() {
        return this.withNewLifecycleLike(this.getLifecycle() != null ? this.getLifecycle() : new V1LifecycleBuilder().build());
    }

    @Override
    public V1ContainerFluent.LifecycleNested<A> editOrNewLifecycleLike(V1Lifecycle item) {
        return this.withNewLifecycleLike(this.getLifecycle() != null ? this.getLifecycle() : item);
    }

    @Override
    @Deprecated
    public V1Probe getLivenessProbe() {
        return this.livenessProbe != null ? this.livenessProbe.build() : null;
    }

    @Override
    public V1Probe buildLivenessProbe() {
        return this.livenessProbe != null ? this.livenessProbe.build() : null;
    }

    @Override
    public A withLivenessProbe(V1Probe livenessProbe) {
        this._visitables.get("livenessProbe").remove(this.livenessProbe);
        if (livenessProbe != null) {
            this.livenessProbe = new V1ProbeBuilder(livenessProbe);
            this._visitables.get("livenessProbe").add(this.livenessProbe);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLivenessProbe() {
        return this.livenessProbe != null;
    }

    @Override
    public V1ContainerFluent.LivenessProbeNested<A> withNewLivenessProbe() {
        return new LivenessProbeNestedImpl();
    }

    @Override
    public V1ContainerFluent.LivenessProbeNested<A> withNewLivenessProbeLike(V1Probe item) {
        return new LivenessProbeNestedImpl(item);
    }

    @Override
    public V1ContainerFluent.LivenessProbeNested<A> editLivenessProbe() {
        return this.withNewLivenessProbeLike(this.getLivenessProbe());
    }

    @Override
    public V1ContainerFluent.LivenessProbeNested<A> editOrNewLivenessProbe() {
        return this.withNewLivenessProbeLike(this.getLivenessProbe() != null ? this.getLivenessProbe() : new V1ProbeBuilder().build());
    }

    @Override
    public V1ContainerFluent.LivenessProbeNested<A> editOrNewLivenessProbeLike(V1Probe item) {
        return this.withNewLivenessProbeLike(this.getLivenessProbe() != null ? this.getLivenessProbe() : item);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public A addToPorts(Integer index, V1ContainerPort item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        V1ContainerPortBuilder builder = new V1ContainerPortBuilder(item);
        this._visitables.get("ports").add(index >= 0 ? index.intValue() : this._visitables.get("ports").size(), builder);
        this.ports.add(index >= 0 ? index.intValue() : this.ports.size(), builder);
        return (A)this;
    }

    @Override
    public A setToPorts(Integer index, V1ContainerPort item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        V1ContainerPortBuilder builder = new V1ContainerPortBuilder(item);
        if (index < 0 || index >= this._visitables.get("ports").size()) {
            this._visitables.get("ports").add(builder);
        } else {
            this._visitables.get("ports").set(index, builder);
        }
        if (index < 0 || index >= this.ports.size()) {
            this.ports.add(builder);
        } else {
            this.ports.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToPorts(V1ContainerPort ... items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (V1ContainerPort item : items) {
            V1ContainerPortBuilder builder = new V1ContainerPortBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToPorts(Collection<V1ContainerPort> items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (V1ContainerPort item : items) {
            V1ContainerPortBuilder builder = new V1ContainerPortBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPorts(V1ContainerPort ... items) {
        for (V1ContainerPort item : items) {
            V1ContainerPortBuilder builder = new V1ContainerPortBuilder(item);
            this._visitables.get("ports").remove(builder);
            if (this.ports == null) continue;
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPorts(Collection<V1ContainerPort> items) {
        for (V1ContainerPort item : items) {
            V1ContainerPortBuilder builder = new V1ContainerPortBuilder(item);
            this._visitables.get("ports").remove(builder);
            if (this.ports == null) continue;
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromPorts(Predicate<V1ContainerPortBuilder> predicate) {
        if (this.ports == null) {
            return (A)this;
        }
        Iterator<V1ContainerPortBuilder> each = this.ports.iterator();
        Object visitables = this._visitables.get("ports");
        while (each.hasNext()) {
            V1ContainerPortBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1ContainerPort> getPorts() {
        return this.ports != null ? V1ContainerFluentImpl.build(this.ports) : null;
    }

    @Override
    public List<V1ContainerPort> buildPorts() {
        return this.ports != null ? V1ContainerFluentImpl.build(this.ports) : null;
    }

    @Override
    public V1ContainerPort buildPort(Integer index) {
        return this.ports.get(index).build();
    }

    @Override
    public V1ContainerPort buildFirstPort() {
        return this.ports.get(0).build();
    }

    @Override
    public V1ContainerPort buildLastPort() {
        return this.ports.get(this.ports.size() - 1).build();
    }

    @Override
    public V1ContainerPort buildMatchingPort(Predicate<V1ContainerPortBuilder> predicate) {
        for (V1ContainerPortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPort(Predicate<V1ContainerPortBuilder> predicate) {
        for (V1ContainerPortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPorts(List<V1ContainerPort> ports) {
        if (this.ports != null) {
            this._visitables.get("ports").removeAll(this.ports);
        }
        if (ports != null) {
            this.ports = new ArrayList();
            for (V1ContainerPort item : ports) {
                this.addToPorts(item);
            }
        } else {
            this.ports = null;
        }
        return (A)this;
    }

    @Override
    public A withPorts(V1ContainerPort ... ports) {
        if (this.ports != null) {
            this.ports.clear();
        }
        if (ports != null) {
            for (V1ContainerPort item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPorts() {
        return this.ports != null && !this.ports.isEmpty();
    }

    @Override
    public V1ContainerFluent.PortsNested<A> addNewPort() {
        return new PortsNestedImpl();
    }

    @Override
    public V1ContainerFluent.PortsNested<A> addNewPortLike(V1ContainerPort item) {
        return new PortsNestedImpl(-1, item);
    }

    @Override
    public V1ContainerFluent.PortsNested<A> setNewPortLike(Integer index, V1ContainerPort item) {
        return new PortsNestedImpl(index, item);
    }

    @Override
    public V1ContainerFluent.PortsNested<A> editPort(Integer index) {
        if (this.ports.size() <= index) {
            throw new RuntimeException("Can't edit ports. Index exceeds size.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public V1ContainerFluent.PortsNested<A> editFirstPort() {
        if (this.ports.size() == 0) {
            throw new RuntimeException("Can't edit first ports. The list is empty.");
        }
        return this.setNewPortLike(0, this.buildPort(0));
    }

    @Override
    public V1ContainerFluent.PortsNested<A> editLastPort() {
        int index = this.ports.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ports. The list is empty.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public V1ContainerFluent.PortsNested<A> editMatchingPort(Predicate<V1ContainerPortBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ports.size(); ++i) {
            if (!predicate.test(this.ports.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ports. No match found.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    @Deprecated
    public V1Probe getReadinessProbe() {
        return this.readinessProbe != null ? this.readinessProbe.build() : null;
    }

    @Override
    public V1Probe buildReadinessProbe() {
        return this.readinessProbe != null ? this.readinessProbe.build() : null;
    }

    @Override
    public A withReadinessProbe(V1Probe readinessProbe) {
        this._visitables.get("readinessProbe").remove(this.readinessProbe);
        if (readinessProbe != null) {
            this.readinessProbe = new V1ProbeBuilder(readinessProbe);
            this._visitables.get("readinessProbe").add(this.readinessProbe);
        }
        return (A)this;
    }

    @Override
    public Boolean hasReadinessProbe() {
        return this.readinessProbe != null;
    }

    @Override
    public V1ContainerFluent.ReadinessProbeNested<A> withNewReadinessProbe() {
        return new ReadinessProbeNestedImpl();
    }

    @Override
    public V1ContainerFluent.ReadinessProbeNested<A> withNewReadinessProbeLike(V1Probe item) {
        return new ReadinessProbeNestedImpl(item);
    }

    @Override
    public V1ContainerFluent.ReadinessProbeNested<A> editReadinessProbe() {
        return this.withNewReadinessProbeLike(this.getReadinessProbe());
    }

    @Override
    public V1ContainerFluent.ReadinessProbeNested<A> editOrNewReadinessProbe() {
        return this.withNewReadinessProbeLike(this.getReadinessProbe() != null ? this.getReadinessProbe() : new V1ProbeBuilder().build());
    }

    @Override
    public V1ContainerFluent.ReadinessProbeNested<A> editOrNewReadinessProbeLike(V1Probe item) {
        return this.withNewReadinessProbeLike(this.getReadinessProbe() != null ? this.getReadinessProbe() : item);
    }

    @Override
    @Deprecated
    public V1ResourceRequirements getResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    @Override
    public V1ResourceRequirements buildResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    @Override
    public A withResources(V1ResourceRequirements resources) {
        this._visitables.get("resources").remove(this.resources);
        if (resources != null) {
            this.resources = new V1ResourceRequirementsBuilder(resources);
            this._visitables.get("resources").add(this.resources);
        }
        return (A)this;
    }

    @Override
    public Boolean hasResources() {
        return this.resources != null;
    }

    @Override
    public V1ContainerFluent.ResourcesNested<A> withNewResources() {
        return new ResourcesNestedImpl();
    }

    @Override
    public V1ContainerFluent.ResourcesNested<A> withNewResourcesLike(V1ResourceRequirements item) {
        return new ResourcesNestedImpl(item);
    }

    @Override
    public V1ContainerFluent.ResourcesNested<A> editResources() {
        return this.withNewResourcesLike(this.getResources());
    }

    @Override
    public V1ContainerFluent.ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(this.getResources() != null ? this.getResources() : new V1ResourceRequirementsBuilder().build());
    }

    @Override
    public V1ContainerFluent.ResourcesNested<A> editOrNewResourcesLike(V1ResourceRequirements item) {
        return this.withNewResourcesLike(this.getResources() != null ? this.getResources() : item);
    }

    @Override
    @Deprecated
    public V1SecurityContext getSecurityContext() {
        return this.securityContext != null ? this.securityContext.build() : null;
    }

    @Override
    public V1SecurityContext buildSecurityContext() {
        return this.securityContext != null ? this.securityContext.build() : null;
    }

    @Override
    public A withSecurityContext(V1SecurityContext securityContext) {
        this._visitables.get("securityContext").remove(this.securityContext);
        if (securityContext != null) {
            this.securityContext = new V1SecurityContextBuilder(securityContext);
            this._visitables.get("securityContext").add(this.securityContext);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecurityContext() {
        return this.securityContext != null;
    }

    @Override
    public V1ContainerFluent.SecurityContextNested<A> withNewSecurityContext() {
        return new SecurityContextNestedImpl();
    }

    @Override
    public V1ContainerFluent.SecurityContextNested<A> withNewSecurityContextLike(V1SecurityContext item) {
        return new SecurityContextNestedImpl(item);
    }

    @Override
    public V1ContainerFluent.SecurityContextNested<A> editSecurityContext() {
        return this.withNewSecurityContextLike(this.getSecurityContext());
    }

    @Override
    public V1ContainerFluent.SecurityContextNested<A> editOrNewSecurityContext() {
        return this.withNewSecurityContextLike(this.getSecurityContext() != null ? this.getSecurityContext() : new V1SecurityContextBuilder().build());
    }

    @Override
    public V1ContainerFluent.SecurityContextNested<A> editOrNewSecurityContextLike(V1SecurityContext item) {
        return this.withNewSecurityContextLike(this.getSecurityContext() != null ? this.getSecurityContext() : item);
    }

    @Override
    @Deprecated
    public V1Probe getStartupProbe() {
        return this.startupProbe != null ? this.startupProbe.build() : null;
    }

    @Override
    public V1Probe buildStartupProbe() {
        return this.startupProbe != null ? this.startupProbe.build() : null;
    }

    @Override
    public A withStartupProbe(V1Probe startupProbe) {
        this._visitables.get("startupProbe").remove(this.startupProbe);
        if (startupProbe != null) {
            this.startupProbe = new V1ProbeBuilder(startupProbe);
            this._visitables.get("startupProbe").add(this.startupProbe);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStartupProbe() {
        return this.startupProbe != null;
    }

    @Override
    public V1ContainerFluent.StartupProbeNested<A> withNewStartupProbe() {
        return new StartupProbeNestedImpl();
    }

    @Override
    public V1ContainerFluent.StartupProbeNested<A> withNewStartupProbeLike(V1Probe item) {
        return new StartupProbeNestedImpl(item);
    }

    @Override
    public V1ContainerFluent.StartupProbeNested<A> editStartupProbe() {
        return this.withNewStartupProbeLike(this.getStartupProbe());
    }

    @Override
    public V1ContainerFluent.StartupProbeNested<A> editOrNewStartupProbe() {
        return this.withNewStartupProbeLike(this.getStartupProbe() != null ? this.getStartupProbe() : new V1ProbeBuilder().build());
    }

    @Override
    public V1ContainerFluent.StartupProbeNested<A> editOrNewStartupProbeLike(V1Probe item) {
        return this.withNewStartupProbeLike(this.getStartupProbe() != null ? this.getStartupProbe() : item);
    }

    @Override
    public Boolean getStdin() {
        return this.stdin;
    }

    @Override
    public A withStdin(Boolean stdin) {
        this.stdin = stdin;
        return (A)this;
    }

    @Override
    public Boolean hasStdin() {
        return this.stdin != null;
    }

    @Override
    public Boolean getStdinOnce() {
        return this.stdinOnce;
    }

    @Override
    public A withStdinOnce(Boolean stdinOnce) {
        this.stdinOnce = stdinOnce;
        return (A)this;
    }

    @Override
    public Boolean hasStdinOnce() {
        return this.stdinOnce != null;
    }

    @Override
    public String getTerminationMessagePath() {
        return this.terminationMessagePath;
    }

    @Override
    public A withTerminationMessagePath(String terminationMessagePath) {
        this.terminationMessagePath = terminationMessagePath;
        return (A)this;
    }

    @Override
    public Boolean hasTerminationMessagePath() {
        return this.terminationMessagePath != null;
    }

    @Override
    public String getTerminationMessagePolicy() {
        return this.terminationMessagePolicy;
    }

    @Override
    public A withTerminationMessagePolicy(String terminationMessagePolicy) {
        this.terminationMessagePolicy = terminationMessagePolicy;
        return (A)this;
    }

    @Override
    public Boolean hasTerminationMessagePolicy() {
        return this.terminationMessagePolicy != null;
    }

    @Override
    public Boolean getTty() {
        return this.tty;
    }

    @Override
    public A withTty(Boolean tty) {
        this.tty = tty;
        return (A)this;
    }

    @Override
    public Boolean hasTty() {
        return this.tty != null;
    }

    @Override
    public A addToVolumeDevices(Integer index, V1VolumeDevice item) {
        if (this.volumeDevices == null) {
            this.volumeDevices = new ArrayList();
        }
        V1VolumeDeviceBuilder builder = new V1VolumeDeviceBuilder(item);
        this._visitables.get("volumeDevices").add(index >= 0 ? index.intValue() : this._visitables.get("volumeDevices").size(), builder);
        this.volumeDevices.add(index >= 0 ? index.intValue() : this.volumeDevices.size(), builder);
        return (A)this;
    }

    @Override
    public A setToVolumeDevices(Integer index, V1VolumeDevice item) {
        if (this.volumeDevices == null) {
            this.volumeDevices = new ArrayList();
        }
        V1VolumeDeviceBuilder builder = new V1VolumeDeviceBuilder(item);
        if (index < 0 || index >= this._visitables.get("volumeDevices").size()) {
            this._visitables.get("volumeDevices").add(builder);
        } else {
            this._visitables.get("volumeDevices").set(index, builder);
        }
        if (index < 0 || index >= this.volumeDevices.size()) {
            this.volumeDevices.add(builder);
        } else {
            this.volumeDevices.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToVolumeDevices(V1VolumeDevice ... items) {
        if (this.volumeDevices == null) {
            this.volumeDevices = new ArrayList();
        }
        for (V1VolumeDevice item : items) {
            V1VolumeDeviceBuilder builder = new V1VolumeDeviceBuilder(item);
            this._visitables.get("volumeDevices").add(builder);
            this.volumeDevices.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToVolumeDevices(Collection<V1VolumeDevice> items) {
        if (this.volumeDevices == null) {
            this.volumeDevices = new ArrayList();
        }
        for (V1VolumeDevice item : items) {
            V1VolumeDeviceBuilder builder = new V1VolumeDeviceBuilder(item);
            this._visitables.get("volumeDevices").add(builder);
            this.volumeDevices.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumeDevices(V1VolumeDevice ... items) {
        for (V1VolumeDevice item : items) {
            V1VolumeDeviceBuilder builder = new V1VolumeDeviceBuilder(item);
            this._visitables.get("volumeDevices").remove(builder);
            if (this.volumeDevices == null) continue;
            this.volumeDevices.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVolumeDevices(Collection<V1VolumeDevice> items) {
        for (V1VolumeDevice item : items) {
            V1VolumeDeviceBuilder builder = new V1VolumeDeviceBuilder(item);
            this._visitables.get("volumeDevices").remove(builder);
            if (this.volumeDevices == null) continue;
            this.volumeDevices.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromVolumeDevices(Predicate<V1VolumeDeviceBuilder> predicate) {
        if (this.volumeDevices == null) {
            return (A)this;
        }
        Iterator<V1VolumeDeviceBuilder> each = this.volumeDevices.iterator();
        Object visitables = this._visitables.get("volumeDevices");
        while (each.hasNext()) {
            V1VolumeDeviceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1VolumeDevice> getVolumeDevices() {
        return this.volumeDevices != null ? V1ContainerFluentImpl.build(this.volumeDevices) : null;
    }

    @Override
    public List<V1VolumeDevice> buildVolumeDevices() {
        return this.volumeDevices != null ? V1ContainerFluentImpl.build(this.volumeDevices) : null;
    }

    @Override
    public V1VolumeDevice buildVolumeDevice(Integer index) {
        return this.volumeDevices.get(index).build();
    }

    @Override
    public V1VolumeDevice buildFirstVolumeDevice() {
        return this.volumeDevices.get(0).build();
    }

    @Override
    public V1VolumeDevice buildLastVolumeDevice() {
        return this.volumeDevices.get(this.volumeDevices.size() - 1).build();
    }

    @Override
    public V1VolumeDevice buildMatchingVolumeDevice(Predicate<V1VolumeDeviceBuilder> predicate) {
        for (V1VolumeDeviceBuilder item : this.volumeDevices) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVolumeDevice(Predicate<V1VolumeDeviceBuilder> predicate) {
        for (V1VolumeDeviceBuilder item : this.volumeDevices) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVolumeDevices(List<V1VolumeDevice> volumeDevices) {
        if (this.volumeDevices != null) {
            this._visitables.get("volumeDevices").removeAll(this.volumeDevices);
        }
        if (volumeDevices != null) {
            this.volumeDevices = new ArrayList();
            for (V1VolumeDevice item : volumeDevices) {
                this.addToVolumeDevices(item);
            }
        } else {
            this.volumeDevices = null;
        }
        return (A)this;
    }

    @Override
    public A withVolumeDevices(V1VolumeDevice ... volumeDevices) {
        if (this.volumeDevices != null) {
            this.volumeDevices.clear();
        }
        if (volumeDevices != null) {
            for (V1VolumeDevice item : volumeDevices) {
                this.addToVolumeDevices(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumeDevices() {
        return this.volumeDevices != null && !this.volumeDevices.isEmpty();
    }

    @Override
    public V1ContainerFluent.VolumeDevicesNested<A> addNewVolumeDevice() {
        return new VolumeDevicesNestedImpl();
    }

    @Override
    public V1ContainerFluent.VolumeDevicesNested<A> addNewVolumeDeviceLike(V1VolumeDevice item) {
        return new VolumeDevicesNestedImpl(-1, item);
    }

    @Override
    public V1ContainerFluent.VolumeDevicesNested<A> setNewVolumeDeviceLike(Integer index, V1VolumeDevice item) {
        return new VolumeDevicesNestedImpl(index, item);
    }

    @Override
    public V1ContainerFluent.VolumeDevicesNested<A> editVolumeDevice(Integer index) {
        if (this.volumeDevices.size() <= index) {
            throw new RuntimeException("Can't edit volumeDevices. Index exceeds size.");
        }
        return this.setNewVolumeDeviceLike(index, this.buildVolumeDevice(index));
    }

    @Override
    public V1ContainerFluent.VolumeDevicesNested<A> editFirstVolumeDevice() {
        if (this.volumeDevices.size() == 0) {
            throw new RuntimeException("Can't edit first volumeDevices. The list is empty.");
        }
        return this.setNewVolumeDeviceLike(0, this.buildVolumeDevice(0));
    }

    @Override
    public V1ContainerFluent.VolumeDevicesNested<A> editLastVolumeDevice() {
        int index = this.volumeDevices.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last volumeDevices. The list is empty.");
        }
        return this.setNewVolumeDeviceLike(index, this.buildVolumeDevice(index));
    }

    @Override
    public V1ContainerFluent.VolumeDevicesNested<A> editMatchingVolumeDevice(Predicate<V1VolumeDeviceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumeDevices.size(); ++i) {
            if (!predicate.test(this.volumeDevices.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching volumeDevices. No match found.");
        }
        return this.setNewVolumeDeviceLike(index, this.buildVolumeDevice(index));
    }

    @Override
    public A addToVolumeMounts(Integer index, V1VolumeMount item) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList();
        }
        V1VolumeMountBuilder builder = new V1VolumeMountBuilder(item);
        this._visitables.get("volumeMounts").add(index >= 0 ? index.intValue() : this._visitables.get("volumeMounts").size(), builder);
        this.volumeMounts.add(index >= 0 ? index.intValue() : this.volumeMounts.size(), builder);
        return (A)this;
    }

    @Override
    public A setToVolumeMounts(Integer index, V1VolumeMount item) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList();
        }
        V1VolumeMountBuilder builder = new V1VolumeMountBuilder(item);
        if (index < 0 || index >= this._visitables.get("volumeMounts").size()) {
            this._visitables.get("volumeMounts").add(builder);
        } else {
            this._visitables.get("volumeMounts").set(index, builder);
        }
        if (index < 0 || index >= this.volumeMounts.size()) {
            this.volumeMounts.add(builder);
        } else {
            this.volumeMounts.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToVolumeMounts(V1VolumeMount ... items) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList();
        }
        for (V1VolumeMount item : items) {
            V1VolumeMountBuilder builder = new V1VolumeMountBuilder(item);
            this._visitables.get("volumeMounts").add(builder);
            this.volumeMounts.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToVolumeMounts(Collection<V1VolumeMount> items) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList();
        }
        for (V1VolumeMount item : items) {
            V1VolumeMountBuilder builder = new V1VolumeMountBuilder(item);
            this._visitables.get("volumeMounts").add(builder);
            this.volumeMounts.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumeMounts(V1VolumeMount ... items) {
        for (V1VolumeMount item : items) {
            V1VolumeMountBuilder builder = new V1VolumeMountBuilder(item);
            this._visitables.get("volumeMounts").remove(builder);
            if (this.volumeMounts == null) continue;
            this.volumeMounts.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVolumeMounts(Collection<V1VolumeMount> items) {
        for (V1VolumeMount item : items) {
            V1VolumeMountBuilder builder = new V1VolumeMountBuilder(item);
            this._visitables.get("volumeMounts").remove(builder);
            if (this.volumeMounts == null) continue;
            this.volumeMounts.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromVolumeMounts(Predicate<V1VolumeMountBuilder> predicate) {
        if (this.volumeMounts == null) {
            return (A)this;
        }
        Iterator<V1VolumeMountBuilder> each = this.volumeMounts.iterator();
        Object visitables = this._visitables.get("volumeMounts");
        while (each.hasNext()) {
            V1VolumeMountBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1VolumeMount> getVolumeMounts() {
        return this.volumeMounts != null ? V1ContainerFluentImpl.build(this.volumeMounts) : null;
    }

    @Override
    public List<V1VolumeMount> buildVolumeMounts() {
        return this.volumeMounts != null ? V1ContainerFluentImpl.build(this.volumeMounts) : null;
    }

    @Override
    public V1VolumeMount buildVolumeMount(Integer index) {
        return this.volumeMounts.get(index).build();
    }

    @Override
    public V1VolumeMount buildFirstVolumeMount() {
        return this.volumeMounts.get(0).build();
    }

    @Override
    public V1VolumeMount buildLastVolumeMount() {
        return this.volumeMounts.get(this.volumeMounts.size() - 1).build();
    }

    @Override
    public V1VolumeMount buildMatchingVolumeMount(Predicate<V1VolumeMountBuilder> predicate) {
        for (V1VolumeMountBuilder item : this.volumeMounts) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVolumeMount(Predicate<V1VolumeMountBuilder> predicate) {
        for (V1VolumeMountBuilder item : this.volumeMounts) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVolumeMounts(List<V1VolumeMount> volumeMounts) {
        if (this.volumeMounts != null) {
            this._visitables.get("volumeMounts").removeAll(this.volumeMounts);
        }
        if (volumeMounts != null) {
            this.volumeMounts = new ArrayList();
            for (V1VolumeMount item : volumeMounts) {
                this.addToVolumeMounts(item);
            }
        } else {
            this.volumeMounts = null;
        }
        return (A)this;
    }

    @Override
    public A withVolumeMounts(V1VolumeMount ... volumeMounts) {
        if (this.volumeMounts != null) {
            this.volumeMounts.clear();
        }
        if (volumeMounts != null) {
            for (V1VolumeMount item : volumeMounts) {
                this.addToVolumeMounts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumeMounts() {
        return this.volumeMounts != null && !this.volumeMounts.isEmpty();
    }

    @Override
    public V1ContainerFluent.VolumeMountsNested<A> addNewVolumeMount() {
        return new VolumeMountsNestedImpl();
    }

    @Override
    public V1ContainerFluent.VolumeMountsNested<A> addNewVolumeMountLike(V1VolumeMount item) {
        return new VolumeMountsNestedImpl(-1, item);
    }

    @Override
    public V1ContainerFluent.VolumeMountsNested<A> setNewVolumeMountLike(Integer index, V1VolumeMount item) {
        return new VolumeMountsNestedImpl(index, item);
    }

    @Override
    public V1ContainerFluent.VolumeMountsNested<A> editVolumeMount(Integer index) {
        if (this.volumeMounts.size() <= index) {
            throw new RuntimeException("Can't edit volumeMounts. Index exceeds size.");
        }
        return this.setNewVolumeMountLike(index, this.buildVolumeMount(index));
    }

    @Override
    public V1ContainerFluent.VolumeMountsNested<A> editFirstVolumeMount() {
        if (this.volumeMounts.size() == 0) {
            throw new RuntimeException("Can't edit first volumeMounts. The list is empty.");
        }
        return this.setNewVolumeMountLike(0, this.buildVolumeMount(0));
    }

    @Override
    public V1ContainerFluent.VolumeMountsNested<A> editLastVolumeMount() {
        int index = this.volumeMounts.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last volumeMounts. The list is empty.");
        }
        return this.setNewVolumeMountLike(index, this.buildVolumeMount(index));
    }

    @Override
    public V1ContainerFluent.VolumeMountsNested<A> editMatchingVolumeMount(Predicate<V1VolumeMountBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumeMounts.size(); ++i) {
            if (!predicate.test(this.volumeMounts.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching volumeMounts. No match found.");
        }
        return this.setNewVolumeMountLike(index, this.buildVolumeMount(index));
    }

    @Override
    public String getWorkingDir() {
        return this.workingDir;
    }

    @Override
    public A withWorkingDir(String workingDir) {
        this.workingDir = workingDir;
        return (A)this;
    }

    @Override
    public Boolean hasWorkingDir() {
        return this.workingDir != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ContainerFluentImpl that = (V1ContainerFluentImpl)o;
        if (this.args != null ? !this.args.equals(that.args) : that.args != null) {
            return false;
        }
        if (this.command != null ? !this.command.equals(that.command) : that.command != null) {
            return false;
        }
        if (this.env != null ? !this.env.equals(that.env) : that.env != null) {
            return false;
        }
        if (this.envFrom != null ? !this.envFrom.equals(that.envFrom) : that.envFrom != null) {
            return false;
        }
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.imagePullPolicy != null ? !this.imagePullPolicy.equals(that.imagePullPolicy) : that.imagePullPolicy != null) {
            return false;
        }
        if (this.lifecycle != null ? !this.lifecycle.equals(that.lifecycle) : that.lifecycle != null) {
            return false;
        }
        if (this.livenessProbe != null ? !this.livenessProbe.equals(that.livenessProbe) : that.livenessProbe != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.ports != null ? !this.ports.equals(that.ports) : that.ports != null) {
            return false;
        }
        if (this.readinessProbe != null ? !this.readinessProbe.equals(that.readinessProbe) : that.readinessProbe != null) {
            return false;
        }
        if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) {
            return false;
        }
        if (this.securityContext != null ? !this.securityContext.equals(that.securityContext) : that.securityContext != null) {
            return false;
        }
        if (this.startupProbe != null ? !this.startupProbe.equals(that.startupProbe) : that.startupProbe != null) {
            return false;
        }
        if (this.stdin != null ? !this.stdin.equals(that.stdin) : that.stdin != null) {
            return false;
        }
        if (this.stdinOnce != null ? !this.stdinOnce.equals(that.stdinOnce) : that.stdinOnce != null) {
            return false;
        }
        if (this.terminationMessagePath != null ? !this.terminationMessagePath.equals(that.terminationMessagePath) : that.terminationMessagePath != null) {
            return false;
        }
        if (this.terminationMessagePolicy != null ? !this.terminationMessagePolicy.equals(that.terminationMessagePolicy) : that.terminationMessagePolicy != null) {
            return false;
        }
        if (this.tty != null ? !this.tty.equals(that.tty) : that.tty != null) {
            return false;
        }
        if (this.volumeDevices != null ? !this.volumeDevices.equals(that.volumeDevices) : that.volumeDevices != null) {
            return false;
        }
        if (this.volumeMounts != null ? !this.volumeMounts.equals(that.volumeMounts) : that.volumeMounts != null) {
            return false;
        }
        return !(this.workingDir != null ? !this.workingDir.equals(that.workingDir) : that.workingDir != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.args, this.command, this.env, this.envFrom, this.image, this.imagePullPolicy, this.lifecycle, this.livenessProbe, this.name, this.ports, this.readinessProbe, this.resources, this.securityContext, this.startupProbe, this.stdin, this.stdinOnce, this.terminationMessagePath, this.terminationMessagePolicy, this.tty, this.volumeDevices, this.volumeMounts, this.workingDir, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.args != null && !this.args.isEmpty()) {
            sb.append("args:");
            sb.append(this.args + ",");
        }
        if (this.command != null && !this.command.isEmpty()) {
            sb.append("command:");
            sb.append(this.command + ",");
        }
        if (this.env != null && !this.env.isEmpty()) {
            sb.append("env:");
            sb.append(this.env + ",");
        }
        if (this.envFrom != null && !this.envFrom.isEmpty()) {
            sb.append("envFrom:");
            sb.append(this.envFrom + ",");
        }
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.imagePullPolicy != null) {
            sb.append("imagePullPolicy:");
            sb.append(this.imagePullPolicy + ",");
        }
        if (this.lifecycle != null) {
            sb.append("lifecycle:");
            sb.append(this.lifecycle + ",");
        }
        if (this.livenessProbe != null) {
            sb.append("livenessProbe:");
            sb.append(this.livenessProbe + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.ports != null && !this.ports.isEmpty()) {
            sb.append("ports:");
            sb.append(this.ports + ",");
        }
        if (this.readinessProbe != null) {
            sb.append("readinessProbe:");
            sb.append(this.readinessProbe + ",");
        }
        if (this.resources != null) {
            sb.append("resources:");
            sb.append(this.resources + ",");
        }
        if (this.securityContext != null) {
            sb.append("securityContext:");
            sb.append(this.securityContext + ",");
        }
        if (this.startupProbe != null) {
            sb.append("startupProbe:");
            sb.append(this.startupProbe + ",");
        }
        if (this.stdin != null) {
            sb.append("stdin:");
            sb.append(this.stdin + ",");
        }
        if (this.stdinOnce != null) {
            sb.append("stdinOnce:");
            sb.append(this.stdinOnce + ",");
        }
        if (this.terminationMessagePath != null) {
            sb.append("terminationMessagePath:");
            sb.append(this.terminationMessagePath + ",");
        }
        if (this.terminationMessagePolicy != null) {
            sb.append("terminationMessagePolicy:");
            sb.append(this.terminationMessagePolicy + ",");
        }
        if (this.tty != null) {
            sb.append("tty:");
            sb.append(this.tty + ",");
        }
        if (this.volumeDevices != null && !this.volumeDevices.isEmpty()) {
            sb.append("volumeDevices:");
            sb.append(this.volumeDevices + ",");
        }
        if (this.volumeMounts != null && !this.volumeMounts.isEmpty()) {
            sb.append("volumeMounts:");
            sb.append(this.volumeMounts + ",");
        }
        if (this.workingDir != null) {
            sb.append("workingDir:");
            sb.append(this.workingDir);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withStdin() {
        return this.withStdin(true);
    }

    @Override
    public A withStdinOnce() {
        return this.withStdinOnce(true);
    }

    @Override
    public A withTty() {
        return this.withTty(true);
    }

    class VolumeMountsNestedImpl<N>
    extends V1VolumeMountFluentImpl<V1ContainerFluent.VolumeMountsNested<N>>
    implements V1ContainerFluent.VolumeMountsNested<N>,
    Nested<N> {
        V1VolumeMountBuilder builder;
        Integer index;

        VolumeMountsNestedImpl(Integer index, V1VolumeMount item) {
            this.index = index;
            this.builder = new V1VolumeMountBuilder(this, item);
        }

        VolumeMountsNestedImpl() {
            this.index = -1;
            this.builder = new V1VolumeMountBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ContainerFluentImpl.this.setToVolumeMounts(this.index, this.builder.build());
        }

        @Override
        public N endVolumeMount() {
            return this.and();
        }
    }

    class VolumeDevicesNestedImpl<N>
    extends V1VolumeDeviceFluentImpl<V1ContainerFluent.VolumeDevicesNested<N>>
    implements V1ContainerFluent.VolumeDevicesNested<N>,
    Nested<N> {
        V1VolumeDeviceBuilder builder;
        Integer index;

        VolumeDevicesNestedImpl(Integer index, V1VolumeDevice item) {
            this.index = index;
            this.builder = new V1VolumeDeviceBuilder(this, item);
        }

        VolumeDevicesNestedImpl() {
            this.index = -1;
            this.builder = new V1VolumeDeviceBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ContainerFluentImpl.this.setToVolumeDevices(this.index, this.builder.build());
        }

        @Override
        public N endVolumeDevice() {
            return this.and();
        }
    }

    class StartupProbeNestedImpl<N>
    extends V1ProbeFluentImpl<V1ContainerFluent.StartupProbeNested<N>>
    implements V1ContainerFluent.StartupProbeNested<N>,
    Nested<N> {
        V1ProbeBuilder builder;

        StartupProbeNestedImpl(V1Probe item) {
            this.builder = new V1ProbeBuilder(this, item);
        }

        StartupProbeNestedImpl() {
            this.builder = new V1ProbeBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ContainerFluentImpl.this.withStartupProbe(this.builder.build());
        }

        @Override
        public N endStartupProbe() {
            return this.and();
        }
    }

    class SecurityContextNestedImpl<N>
    extends V1SecurityContextFluentImpl<V1ContainerFluent.SecurityContextNested<N>>
    implements V1ContainerFluent.SecurityContextNested<N>,
    Nested<N> {
        V1SecurityContextBuilder builder;

        SecurityContextNestedImpl(V1SecurityContext item) {
            this.builder = new V1SecurityContextBuilder(this, item);
        }

        SecurityContextNestedImpl() {
            this.builder = new V1SecurityContextBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ContainerFluentImpl.this.withSecurityContext(this.builder.build());
        }

        @Override
        public N endSecurityContext() {
            return this.and();
        }
    }

    class ResourcesNestedImpl<N>
    extends V1ResourceRequirementsFluentImpl<V1ContainerFluent.ResourcesNested<N>>
    implements V1ContainerFluent.ResourcesNested<N>,
    Nested<N> {
        V1ResourceRequirementsBuilder builder;

        ResourcesNestedImpl(V1ResourceRequirements item) {
            this.builder = new V1ResourceRequirementsBuilder(this, item);
        }

        ResourcesNestedImpl() {
            this.builder = new V1ResourceRequirementsBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ContainerFluentImpl.this.withResources(this.builder.build());
        }

        @Override
        public N endResources() {
            return this.and();
        }
    }

    class ReadinessProbeNestedImpl<N>
    extends V1ProbeFluentImpl<V1ContainerFluent.ReadinessProbeNested<N>>
    implements V1ContainerFluent.ReadinessProbeNested<N>,
    Nested<N> {
        V1ProbeBuilder builder;

        ReadinessProbeNestedImpl(V1Probe item) {
            this.builder = new V1ProbeBuilder(this, item);
        }

        ReadinessProbeNestedImpl() {
            this.builder = new V1ProbeBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ContainerFluentImpl.this.withReadinessProbe(this.builder.build());
        }

        @Override
        public N endReadinessProbe() {
            return this.and();
        }
    }

    class PortsNestedImpl<N>
    extends V1ContainerPortFluentImpl<V1ContainerFluent.PortsNested<N>>
    implements V1ContainerFluent.PortsNested<N>,
    Nested<N> {
        V1ContainerPortBuilder builder;
        Integer index;

        PortsNestedImpl(Integer index, V1ContainerPort item) {
            this.index = index;
            this.builder = new V1ContainerPortBuilder(this, item);
        }

        PortsNestedImpl() {
            this.index = -1;
            this.builder = new V1ContainerPortBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ContainerFluentImpl.this.setToPorts(this.index, this.builder.build());
        }

        @Override
        public N endPort() {
            return this.and();
        }
    }

    class LivenessProbeNestedImpl<N>
    extends V1ProbeFluentImpl<V1ContainerFluent.LivenessProbeNested<N>>
    implements V1ContainerFluent.LivenessProbeNested<N>,
    Nested<N> {
        V1ProbeBuilder builder;

        LivenessProbeNestedImpl(V1Probe item) {
            this.builder = new V1ProbeBuilder(this, item);
        }

        LivenessProbeNestedImpl() {
            this.builder = new V1ProbeBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ContainerFluentImpl.this.withLivenessProbe(this.builder.build());
        }

        @Override
        public N endLivenessProbe() {
            return this.and();
        }
    }

    class LifecycleNestedImpl<N>
    extends V1LifecycleFluentImpl<V1ContainerFluent.LifecycleNested<N>>
    implements V1ContainerFluent.LifecycleNested<N>,
    Nested<N> {
        V1LifecycleBuilder builder;

        LifecycleNestedImpl(V1Lifecycle item) {
            this.builder = new V1LifecycleBuilder(this, item);
        }

        LifecycleNestedImpl() {
            this.builder = new V1LifecycleBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ContainerFluentImpl.this.withLifecycle(this.builder.build());
        }

        @Override
        public N endLifecycle() {
            return this.and();
        }
    }

    class EnvFromNestedImpl<N>
    extends V1EnvFromSourceFluentImpl<V1ContainerFluent.EnvFromNested<N>>
    implements V1ContainerFluent.EnvFromNested<N>,
    Nested<N> {
        V1EnvFromSourceBuilder builder;
        Integer index;

        EnvFromNestedImpl(Integer index, V1EnvFromSource item) {
            this.index = index;
            this.builder = new V1EnvFromSourceBuilder(this, item);
        }

        EnvFromNestedImpl() {
            this.index = -1;
            this.builder = new V1EnvFromSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ContainerFluentImpl.this.setToEnvFrom(this.index, this.builder.build());
        }

        @Override
        public N endEnvFrom() {
            return this.and();
        }
    }

    class EnvNestedImpl<N>
    extends V1EnvVarFluentImpl<V1ContainerFluent.EnvNested<N>>
    implements V1ContainerFluent.EnvNested<N>,
    Nested<N> {
        V1EnvVarBuilder builder;
        Integer index;

        EnvNestedImpl(Integer index, V1EnvVar item) {
            this.index = index;
            this.builder = new V1EnvVarBuilder(this, item);
        }

        EnvNestedImpl() {
            this.index = -1;
            this.builder = new V1EnvVarBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ContainerFluentImpl.this.setToEnv(this.index, this.builder.build());
        }

        @Override
        public N endEnv() {
            return this.and();
        }
    }
}

