/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.CoreV1EndpointPort;
import io.kubernetes.client.openapi.models.CoreV1EndpointPortBuilder;
import io.kubernetes.client.openapi.models.CoreV1EndpointPortFluentImpl;
import io.kubernetes.client.openapi.models.V1EndpointAddress;
import io.kubernetes.client.openapi.models.V1EndpointAddressBuilder;
import io.kubernetes.client.openapi.models.V1EndpointAddressFluentImpl;
import io.kubernetes.client.openapi.models.V1EndpointSubset;
import io.kubernetes.client.openapi.models.V1EndpointSubsetFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1EndpointSubsetFluentImpl<A extends V1EndpointSubsetFluent<A>>
extends BaseFluent<A>
implements V1EndpointSubsetFluent<A> {
    private ArrayList<V1EndpointAddressBuilder> addresses;
    private ArrayList<V1EndpointAddressBuilder> notReadyAddresses;
    private ArrayList<CoreV1EndpointPortBuilder> ports;

    public V1EndpointSubsetFluentImpl() {
    }

    public V1EndpointSubsetFluentImpl(V1EndpointSubset instance) {
        this.withAddresses(instance.getAddresses());
        this.withNotReadyAddresses(instance.getNotReadyAddresses());
        this.withPorts(instance.getPorts());
    }

    @Override
    public A addToAddresses(Integer index, V1EndpointAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        V1EndpointAddressBuilder builder = new V1EndpointAddressBuilder(item);
        this._visitables.get("addresses").add(index >= 0 ? index.intValue() : this._visitables.get("addresses").size(), builder);
        this.addresses.add(index >= 0 ? index.intValue() : this.addresses.size(), builder);
        return (A)this;
    }

    @Override
    public A setToAddresses(Integer index, V1EndpointAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        V1EndpointAddressBuilder builder = new V1EndpointAddressBuilder(item);
        if (index < 0 || index >= this._visitables.get("addresses").size()) {
            this._visitables.get("addresses").add(builder);
        } else {
            this._visitables.get("addresses").set(index, builder);
        }
        if (index < 0 || index >= this.addresses.size()) {
            this.addresses.add(builder);
        } else {
            this.addresses.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToAddresses(V1EndpointAddress ... items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        for (V1EndpointAddress item : items) {
            V1EndpointAddressBuilder builder = new V1EndpointAddressBuilder(item);
            this._visitables.get("addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToAddresses(Collection<V1EndpointAddress> items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        for (V1EndpointAddress item : items) {
            V1EndpointAddressBuilder builder = new V1EndpointAddressBuilder(item);
            this._visitables.get("addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromAddresses(V1EndpointAddress ... items) {
        for (V1EndpointAddress item : items) {
            V1EndpointAddressBuilder builder = new V1EndpointAddressBuilder(item);
            this._visitables.get("addresses").remove(builder);
            if (this.addresses == null) continue;
            this.addresses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAddresses(Collection<V1EndpointAddress> items) {
        for (V1EndpointAddress item : items) {
            V1EndpointAddressBuilder builder = new V1EndpointAddressBuilder(item);
            this._visitables.get("addresses").remove(builder);
            if (this.addresses == null) continue;
            this.addresses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromAddresses(Predicate<V1EndpointAddressBuilder> predicate) {
        if (this.addresses == null) {
            return (A)this;
        }
        Iterator<V1EndpointAddressBuilder> each = this.addresses.iterator();
        Object visitables = this._visitables.get("addresses");
        while (each.hasNext()) {
            V1EndpointAddressBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1EndpointAddress> getAddresses() {
        return this.addresses != null ? V1EndpointSubsetFluentImpl.build(this.addresses) : null;
    }

    @Override
    public List<V1EndpointAddress> buildAddresses() {
        return this.addresses != null ? V1EndpointSubsetFluentImpl.build(this.addresses) : null;
    }

    @Override
    public V1EndpointAddress buildAddress(Integer index) {
        return this.addresses.get(index).build();
    }

    @Override
    public V1EndpointAddress buildFirstAddress() {
        return this.addresses.get(0).build();
    }

    @Override
    public V1EndpointAddress buildLastAddress() {
        return this.addresses.get(this.addresses.size() - 1).build();
    }

    @Override
    public V1EndpointAddress buildMatchingAddress(Predicate<V1EndpointAddressBuilder> predicate) {
        for (V1EndpointAddressBuilder item : this.addresses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAddress(Predicate<V1EndpointAddressBuilder> predicate) {
        for (V1EndpointAddressBuilder item : this.addresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAddresses(List<V1EndpointAddress> addresses) {
        if (this.addresses != null) {
            this._visitables.get("addresses").removeAll(this.addresses);
        }
        if (addresses != null) {
            this.addresses = new ArrayList();
            for (V1EndpointAddress item : addresses) {
                this.addToAddresses(item);
            }
        } else {
            this.addresses = null;
        }
        return (A)this;
    }

    @Override
    public A withAddresses(V1EndpointAddress ... addresses) {
        if (this.addresses != null) {
            this.addresses.clear();
        }
        if (addresses != null) {
            for (V1EndpointAddress item : addresses) {
                this.addToAddresses(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAddresses() {
        return this.addresses != null && !this.addresses.isEmpty();
    }

    @Override
    public V1EndpointSubsetFluent.AddressesNested<A> addNewAddress() {
        return new AddressesNestedImpl();
    }

    @Override
    public V1EndpointSubsetFluent.AddressesNested<A> addNewAddressLike(V1EndpointAddress item) {
        return new AddressesNestedImpl(-1, item);
    }

    @Override
    public V1EndpointSubsetFluent.AddressesNested<A> setNewAddressLike(Integer index, V1EndpointAddress item) {
        return new AddressesNestedImpl(index, item);
    }

    @Override
    public V1EndpointSubsetFluent.AddressesNested<A> editAddress(Integer index) {
        if (this.addresses.size() <= index) {
            throw new RuntimeException("Can't edit addresses. Index exceeds size.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    @Override
    public V1EndpointSubsetFluent.AddressesNested<A> editFirstAddress() {
        if (this.addresses.size() == 0) {
            throw new RuntimeException("Can't edit first addresses. The list is empty.");
        }
        return this.setNewAddressLike(0, this.buildAddress(0));
    }

    @Override
    public V1EndpointSubsetFluent.AddressesNested<A> editLastAddress() {
        int index = this.addresses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last addresses. The list is empty.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    @Override
    public V1EndpointSubsetFluent.AddressesNested<A> editMatchingAddress(Predicate<V1EndpointAddressBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.addresses.size(); ++i) {
            if (!predicate.test(this.addresses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching addresses. No match found.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    @Override
    public A addToNotReadyAddresses(Integer index, V1EndpointAddress item) {
        if (this.notReadyAddresses == null) {
            this.notReadyAddresses = new ArrayList();
        }
        V1EndpointAddressBuilder builder = new V1EndpointAddressBuilder(item);
        this._visitables.get("notReadyAddresses").add(index >= 0 ? index.intValue() : this._visitables.get("notReadyAddresses").size(), builder);
        this.notReadyAddresses.add(index >= 0 ? index.intValue() : this.notReadyAddresses.size(), builder);
        return (A)this;
    }

    @Override
    public A setToNotReadyAddresses(Integer index, V1EndpointAddress item) {
        if (this.notReadyAddresses == null) {
            this.notReadyAddresses = new ArrayList();
        }
        V1EndpointAddressBuilder builder = new V1EndpointAddressBuilder(item);
        if (index < 0 || index >= this._visitables.get("notReadyAddresses").size()) {
            this._visitables.get("notReadyAddresses").add(builder);
        } else {
            this._visitables.get("notReadyAddresses").set(index, builder);
        }
        if (index < 0 || index >= this.notReadyAddresses.size()) {
            this.notReadyAddresses.add(builder);
        } else {
            this.notReadyAddresses.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToNotReadyAddresses(V1EndpointAddress ... items) {
        if (this.notReadyAddresses == null) {
            this.notReadyAddresses = new ArrayList();
        }
        for (V1EndpointAddress item : items) {
            V1EndpointAddressBuilder builder = new V1EndpointAddressBuilder(item);
            this._visitables.get("notReadyAddresses").add(builder);
            this.notReadyAddresses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToNotReadyAddresses(Collection<V1EndpointAddress> items) {
        if (this.notReadyAddresses == null) {
            this.notReadyAddresses = new ArrayList();
        }
        for (V1EndpointAddress item : items) {
            V1EndpointAddressBuilder builder = new V1EndpointAddressBuilder(item);
            this._visitables.get("notReadyAddresses").add(builder);
            this.notReadyAddresses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromNotReadyAddresses(V1EndpointAddress ... items) {
        for (V1EndpointAddress item : items) {
            V1EndpointAddressBuilder builder = new V1EndpointAddressBuilder(item);
            this._visitables.get("notReadyAddresses").remove(builder);
            if (this.notReadyAddresses == null) continue;
            this.notReadyAddresses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromNotReadyAddresses(Collection<V1EndpointAddress> items) {
        for (V1EndpointAddress item : items) {
            V1EndpointAddressBuilder builder = new V1EndpointAddressBuilder(item);
            this._visitables.get("notReadyAddresses").remove(builder);
            if (this.notReadyAddresses == null) continue;
            this.notReadyAddresses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromNotReadyAddresses(Predicate<V1EndpointAddressBuilder> predicate) {
        if (this.notReadyAddresses == null) {
            return (A)this;
        }
        Iterator<V1EndpointAddressBuilder> each = this.notReadyAddresses.iterator();
        Object visitables = this._visitables.get("notReadyAddresses");
        while (each.hasNext()) {
            V1EndpointAddressBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1EndpointAddress> getNotReadyAddresses() {
        return this.notReadyAddresses != null ? V1EndpointSubsetFluentImpl.build(this.notReadyAddresses) : null;
    }

    @Override
    public List<V1EndpointAddress> buildNotReadyAddresses() {
        return this.notReadyAddresses != null ? V1EndpointSubsetFluentImpl.build(this.notReadyAddresses) : null;
    }

    @Override
    public V1EndpointAddress buildNotReadyAddress(Integer index) {
        return this.notReadyAddresses.get(index).build();
    }

    @Override
    public V1EndpointAddress buildFirstNotReadyAddress() {
        return this.notReadyAddresses.get(0).build();
    }

    @Override
    public V1EndpointAddress buildLastNotReadyAddress() {
        return this.notReadyAddresses.get(this.notReadyAddresses.size() - 1).build();
    }

    @Override
    public V1EndpointAddress buildMatchingNotReadyAddress(Predicate<V1EndpointAddressBuilder> predicate) {
        for (V1EndpointAddressBuilder item : this.notReadyAddresses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingNotReadyAddress(Predicate<V1EndpointAddressBuilder> predicate) {
        for (V1EndpointAddressBuilder item : this.notReadyAddresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withNotReadyAddresses(List<V1EndpointAddress> notReadyAddresses) {
        if (this.notReadyAddresses != null) {
            this._visitables.get("notReadyAddresses").removeAll(this.notReadyAddresses);
        }
        if (notReadyAddresses != null) {
            this.notReadyAddresses = new ArrayList();
            for (V1EndpointAddress item : notReadyAddresses) {
                this.addToNotReadyAddresses(item);
            }
        } else {
            this.notReadyAddresses = null;
        }
        return (A)this;
    }

    @Override
    public A withNotReadyAddresses(V1EndpointAddress ... notReadyAddresses) {
        if (this.notReadyAddresses != null) {
            this.notReadyAddresses.clear();
        }
        if (notReadyAddresses != null) {
            for (V1EndpointAddress item : notReadyAddresses) {
                this.addToNotReadyAddresses(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasNotReadyAddresses() {
        return this.notReadyAddresses != null && !this.notReadyAddresses.isEmpty();
    }

    @Override
    public V1EndpointSubsetFluent.NotReadyAddressesNested<A> addNewNotReadyAddress() {
        return new NotReadyAddressesNestedImpl();
    }

    @Override
    public V1EndpointSubsetFluent.NotReadyAddressesNested<A> addNewNotReadyAddressLike(V1EndpointAddress item) {
        return new NotReadyAddressesNestedImpl(-1, item);
    }

    @Override
    public V1EndpointSubsetFluent.NotReadyAddressesNested<A> setNewNotReadyAddressLike(Integer index, V1EndpointAddress item) {
        return new NotReadyAddressesNestedImpl(index, item);
    }

    @Override
    public V1EndpointSubsetFluent.NotReadyAddressesNested<A> editNotReadyAddress(Integer index) {
        if (this.notReadyAddresses.size() <= index) {
            throw new RuntimeException("Can't edit notReadyAddresses. Index exceeds size.");
        }
        return this.setNewNotReadyAddressLike(index, this.buildNotReadyAddress(index));
    }

    @Override
    public V1EndpointSubsetFluent.NotReadyAddressesNested<A> editFirstNotReadyAddress() {
        if (this.notReadyAddresses.size() == 0) {
            throw new RuntimeException("Can't edit first notReadyAddresses. The list is empty.");
        }
        return this.setNewNotReadyAddressLike(0, this.buildNotReadyAddress(0));
    }

    @Override
    public V1EndpointSubsetFluent.NotReadyAddressesNested<A> editLastNotReadyAddress() {
        int index = this.notReadyAddresses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last notReadyAddresses. The list is empty.");
        }
        return this.setNewNotReadyAddressLike(index, this.buildNotReadyAddress(index));
    }

    @Override
    public V1EndpointSubsetFluent.NotReadyAddressesNested<A> editMatchingNotReadyAddress(Predicate<V1EndpointAddressBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.notReadyAddresses.size(); ++i) {
            if (!predicate.test(this.notReadyAddresses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching notReadyAddresses. No match found.");
        }
        return this.setNewNotReadyAddressLike(index, this.buildNotReadyAddress(index));
    }

    @Override
    public A addToPorts(Integer index, CoreV1EndpointPort item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        CoreV1EndpointPortBuilder builder = new CoreV1EndpointPortBuilder(item);
        this._visitables.get("ports").add(index >= 0 ? index.intValue() : this._visitables.get("ports").size(), builder);
        this.ports.add(index >= 0 ? index.intValue() : this.ports.size(), builder);
        return (A)this;
    }

    @Override
    public A setToPorts(Integer index, CoreV1EndpointPort item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        CoreV1EndpointPortBuilder builder = new CoreV1EndpointPortBuilder(item);
        if (index < 0 || index >= this._visitables.get("ports").size()) {
            this._visitables.get("ports").add(builder);
        } else {
            this._visitables.get("ports").set(index, builder);
        }
        if (index < 0 || index >= this.ports.size()) {
            this.ports.add(builder);
        } else {
            this.ports.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToPorts(CoreV1EndpointPort ... items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (CoreV1EndpointPort item : items) {
            CoreV1EndpointPortBuilder builder = new CoreV1EndpointPortBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToPorts(Collection<CoreV1EndpointPort> items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (CoreV1EndpointPort item : items) {
            CoreV1EndpointPortBuilder builder = new CoreV1EndpointPortBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPorts(CoreV1EndpointPort ... items) {
        for (CoreV1EndpointPort item : items) {
            CoreV1EndpointPortBuilder builder = new CoreV1EndpointPortBuilder(item);
            this._visitables.get("ports").remove(builder);
            if (this.ports == null) continue;
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPorts(Collection<CoreV1EndpointPort> items) {
        for (CoreV1EndpointPort item : items) {
            CoreV1EndpointPortBuilder builder = new CoreV1EndpointPortBuilder(item);
            this._visitables.get("ports").remove(builder);
            if (this.ports == null) continue;
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromPorts(Predicate<CoreV1EndpointPortBuilder> predicate) {
        if (this.ports == null) {
            return (A)this;
        }
        Iterator<CoreV1EndpointPortBuilder> each = this.ports.iterator();
        Object visitables = this._visitables.get("ports");
        while (each.hasNext()) {
            CoreV1EndpointPortBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<CoreV1EndpointPort> getPorts() {
        return this.ports != null ? V1EndpointSubsetFluentImpl.build(this.ports) : null;
    }

    @Override
    public List<CoreV1EndpointPort> buildPorts() {
        return this.ports != null ? V1EndpointSubsetFluentImpl.build(this.ports) : null;
    }

    @Override
    public CoreV1EndpointPort buildPort(Integer index) {
        return this.ports.get(index).build();
    }

    @Override
    public CoreV1EndpointPort buildFirstPort() {
        return this.ports.get(0).build();
    }

    @Override
    public CoreV1EndpointPort buildLastPort() {
        return this.ports.get(this.ports.size() - 1).build();
    }

    @Override
    public CoreV1EndpointPort buildMatchingPort(Predicate<CoreV1EndpointPortBuilder> predicate) {
        for (CoreV1EndpointPortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPort(Predicate<CoreV1EndpointPortBuilder> predicate) {
        for (CoreV1EndpointPortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPorts(List<CoreV1EndpointPort> ports) {
        if (this.ports != null) {
            this._visitables.get("ports").removeAll(this.ports);
        }
        if (ports != null) {
            this.ports = new ArrayList();
            for (CoreV1EndpointPort item : ports) {
                this.addToPorts(item);
            }
        } else {
            this.ports = null;
        }
        return (A)this;
    }

    @Override
    public A withPorts(CoreV1EndpointPort ... ports) {
        if (this.ports != null) {
            this.ports.clear();
        }
        if (ports != null) {
            for (CoreV1EndpointPort item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPorts() {
        return this.ports != null && !this.ports.isEmpty();
    }

    @Override
    public V1EndpointSubsetFluent.PortsNested<A> addNewPort() {
        return new PortsNestedImpl();
    }

    @Override
    public V1EndpointSubsetFluent.PortsNested<A> addNewPortLike(CoreV1EndpointPort item) {
        return new PortsNestedImpl(-1, item);
    }

    @Override
    public V1EndpointSubsetFluent.PortsNested<A> setNewPortLike(Integer index, CoreV1EndpointPort item) {
        return new PortsNestedImpl(index, item);
    }

    @Override
    public V1EndpointSubsetFluent.PortsNested<A> editPort(Integer index) {
        if (this.ports.size() <= index) {
            throw new RuntimeException("Can't edit ports. Index exceeds size.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public V1EndpointSubsetFluent.PortsNested<A> editFirstPort() {
        if (this.ports.size() == 0) {
            throw new RuntimeException("Can't edit first ports. The list is empty.");
        }
        return this.setNewPortLike(0, this.buildPort(0));
    }

    @Override
    public V1EndpointSubsetFluent.PortsNested<A> editLastPort() {
        int index = this.ports.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ports. The list is empty.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public V1EndpointSubsetFluent.PortsNested<A> editMatchingPort(Predicate<CoreV1EndpointPortBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ports.size(); ++i) {
            if (!predicate.test(this.ports.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ports. No match found.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1EndpointSubsetFluentImpl that = (V1EndpointSubsetFluentImpl)o;
        if (this.addresses != null ? !this.addresses.equals(that.addresses) : that.addresses != null) {
            return false;
        }
        if (this.notReadyAddresses != null ? !this.notReadyAddresses.equals(that.notReadyAddresses) : that.notReadyAddresses != null) {
            return false;
        }
        return !(this.ports != null ? !this.ports.equals(that.ports) : that.ports != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.addresses, this.notReadyAddresses, this.ports, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.addresses != null && !this.addresses.isEmpty()) {
            sb.append("addresses:");
            sb.append(this.addresses + ",");
        }
        if (this.notReadyAddresses != null && !this.notReadyAddresses.isEmpty()) {
            sb.append("notReadyAddresses:");
            sb.append(this.notReadyAddresses + ",");
        }
        if (this.ports != null && !this.ports.isEmpty()) {
            sb.append("ports:");
            sb.append(this.ports);
        }
        sb.append("}");
        return sb.toString();
    }

    class PortsNestedImpl<N>
    extends CoreV1EndpointPortFluentImpl<V1EndpointSubsetFluent.PortsNested<N>>
    implements V1EndpointSubsetFluent.PortsNested<N>,
    Nested<N> {
        CoreV1EndpointPortBuilder builder;
        Integer index;

        PortsNestedImpl(Integer index, CoreV1EndpointPort item) {
            this.index = index;
            this.builder = new CoreV1EndpointPortBuilder(this, item);
        }

        PortsNestedImpl() {
            this.index = -1;
            this.builder = new CoreV1EndpointPortBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1EndpointSubsetFluentImpl.this.setToPorts(this.index, this.builder.build());
        }

        @Override
        public N endPort() {
            return this.and();
        }
    }

    class NotReadyAddressesNestedImpl<N>
    extends V1EndpointAddressFluentImpl<V1EndpointSubsetFluent.NotReadyAddressesNested<N>>
    implements V1EndpointSubsetFluent.NotReadyAddressesNested<N>,
    Nested<N> {
        V1EndpointAddressBuilder builder;
        Integer index;

        NotReadyAddressesNestedImpl(Integer index, V1EndpointAddress item) {
            this.index = index;
            this.builder = new V1EndpointAddressBuilder(this, item);
        }

        NotReadyAddressesNestedImpl() {
            this.index = -1;
            this.builder = new V1EndpointAddressBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1EndpointSubsetFluentImpl.this.setToNotReadyAddresses(this.index, this.builder.build());
        }

        @Override
        public N endNotReadyAddress() {
            return this.and();
        }
    }

    class AddressesNestedImpl<N>
    extends V1EndpointAddressFluentImpl<V1EndpointSubsetFluent.AddressesNested<N>>
    implements V1EndpointSubsetFluent.AddressesNested<N>,
    Nested<N> {
        V1EndpointAddressBuilder builder;
        Integer index;

        AddressesNestedImpl(Integer index, V1EndpointAddress item) {
            this.index = index;
            this.builder = new V1EndpointAddressBuilder(this, item);
        }

        AddressesNestedImpl() {
            this.index = -1;
            this.builder = new V1EndpointAddressBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1EndpointSubsetFluentImpl.this.setToAddresses(this.index, this.builder.build());
        }

        @Override
        public N endAddress() {
            return this.and();
        }
    }
}

