/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1LocalObjectReference;
import io.kubernetes.client.openapi.models.V1LocalObjectReferenceBuilder;
import io.kubernetes.client.openapi.models.V1LocalObjectReferenceFluentImpl;
import io.kubernetes.client.openapi.models.V1ScaleIOVolumeSource;
import io.kubernetes.client.openapi.models.V1ScaleIOVolumeSourceFluent;
import java.util.Objects;

public class V1ScaleIOVolumeSourceFluentImpl<A extends V1ScaleIOVolumeSourceFluent<A>>
extends BaseFluent<A>
implements V1ScaleIOVolumeSourceFluent<A> {
    private String fsType;
    private String gateway;
    private String protectionDomain;
    private Boolean readOnly;
    private V1LocalObjectReferenceBuilder secretRef;
    private Boolean sslEnabled;
    private String storageMode;
    private String storagePool;
    private String system;
    private String volumeName;

    public V1ScaleIOVolumeSourceFluentImpl() {
    }

    public V1ScaleIOVolumeSourceFluentImpl(V1ScaleIOVolumeSource instance) {
        this.withFsType(instance.getFsType());
        this.withGateway(instance.getGateway());
        this.withProtectionDomain(instance.getProtectionDomain());
        this.withReadOnly(instance.getReadOnly());
        this.withSecretRef(instance.getSecretRef());
        this.withSslEnabled(instance.getSslEnabled());
        this.withStorageMode(instance.getStorageMode());
        this.withStoragePool(instance.getStoragePool());
        this.withSystem(instance.getSystem());
        this.withVolumeName(instance.getVolumeName());
    }

    @Override
    public String getFsType() {
        return this.fsType;
    }

    @Override
    public A withFsType(String fsType) {
        this.fsType = fsType;
        return (A)this;
    }

    @Override
    public Boolean hasFsType() {
        return this.fsType != null;
    }

    @Override
    public String getGateway() {
        return this.gateway;
    }

    @Override
    public A withGateway(String gateway) {
        this.gateway = gateway;
        return (A)this;
    }

    @Override
    public Boolean hasGateway() {
        return this.gateway != null;
    }

    @Override
    public String getProtectionDomain() {
        return this.protectionDomain;
    }

    @Override
    public A withProtectionDomain(String protectionDomain) {
        this.protectionDomain = protectionDomain;
        return (A)this;
    }

    @Override
    public Boolean hasProtectionDomain() {
        return this.protectionDomain != null;
    }

    @Override
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    @Override
    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)this;
    }

    @Override
    public Boolean hasReadOnly() {
        return this.readOnly != null;
    }

    @Override
    @Deprecated
    public V1LocalObjectReference getSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public V1LocalObjectReference buildSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public A withSecretRef(V1LocalObjectReference secretRef) {
        this._visitables.get("secretRef").remove(this.secretRef);
        if (secretRef != null) {
            this.secretRef = new V1LocalObjectReferenceBuilder(secretRef);
            this._visitables.get("secretRef").add(this.secretRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecretRef() {
        return this.secretRef != null;
    }

    @Override
    public V1ScaleIOVolumeSourceFluent.SecretRefNested<A> withNewSecretRef() {
        return new SecretRefNestedImpl();
    }

    @Override
    public V1ScaleIOVolumeSourceFluent.SecretRefNested<A> withNewSecretRefLike(V1LocalObjectReference item) {
        return new SecretRefNestedImpl(item);
    }

    @Override
    public V1ScaleIOVolumeSourceFluent.SecretRefNested<A> editSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef());
    }

    @Override
    public V1ScaleIOVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : new V1LocalObjectReferenceBuilder().build());
    }

    @Override
    public V1ScaleIOVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRefLike(V1LocalObjectReference item) {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : item);
    }

    @Override
    public Boolean getSslEnabled() {
        return this.sslEnabled;
    }

    @Override
    public A withSslEnabled(Boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
        return (A)this;
    }

    @Override
    public Boolean hasSslEnabled() {
        return this.sslEnabled != null;
    }

    @Override
    public String getStorageMode() {
        return this.storageMode;
    }

    @Override
    public A withStorageMode(String storageMode) {
        this.storageMode = storageMode;
        return (A)this;
    }

    @Override
    public Boolean hasStorageMode() {
        return this.storageMode != null;
    }

    @Override
    public String getStoragePool() {
        return this.storagePool;
    }

    @Override
    public A withStoragePool(String storagePool) {
        this.storagePool = storagePool;
        return (A)this;
    }

    @Override
    public Boolean hasStoragePool() {
        return this.storagePool != null;
    }

    @Override
    public String getSystem() {
        return this.system;
    }

    @Override
    public A withSystem(String system) {
        this.system = system;
        return (A)this;
    }

    @Override
    public Boolean hasSystem() {
        return this.system != null;
    }

    @Override
    public String getVolumeName() {
        return this.volumeName;
    }

    @Override
    public A withVolumeName(String volumeName) {
        this.volumeName = volumeName;
        return (A)this;
    }

    @Override
    public Boolean hasVolumeName() {
        return this.volumeName != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ScaleIOVolumeSourceFluentImpl that = (V1ScaleIOVolumeSourceFluentImpl)o;
        if (this.fsType != null ? !this.fsType.equals(that.fsType) : that.fsType != null) {
            return false;
        }
        if (this.gateway != null ? !this.gateway.equals(that.gateway) : that.gateway != null) {
            return false;
        }
        if (this.protectionDomain != null ? !this.protectionDomain.equals(that.protectionDomain) : that.protectionDomain != null) {
            return false;
        }
        if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) {
            return false;
        }
        if (this.secretRef != null ? !this.secretRef.equals(that.secretRef) : that.secretRef != null) {
            return false;
        }
        if (this.sslEnabled != null ? !this.sslEnabled.equals(that.sslEnabled) : that.sslEnabled != null) {
            return false;
        }
        if (this.storageMode != null ? !this.storageMode.equals(that.storageMode) : that.storageMode != null) {
            return false;
        }
        if (this.storagePool != null ? !this.storagePool.equals(that.storagePool) : that.storagePool != null) {
            return false;
        }
        if (this.system != null ? !this.system.equals(that.system) : that.system != null) {
            return false;
        }
        return !(this.volumeName != null ? !this.volumeName.equals(that.volumeName) : that.volumeName != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fsType, this.gateway, this.protectionDomain, this.readOnly, this.secretRef, this.sslEnabled, this.storageMode, this.storagePool, this.system, this.volumeName, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.fsType != null) {
            sb.append("fsType:");
            sb.append(this.fsType + ",");
        }
        if (this.gateway != null) {
            sb.append("gateway:");
            sb.append(this.gateway + ",");
        }
        if (this.protectionDomain != null) {
            sb.append("protectionDomain:");
            sb.append(this.protectionDomain + ",");
        }
        if (this.readOnly != null) {
            sb.append("readOnly:");
            sb.append(this.readOnly + ",");
        }
        if (this.secretRef != null) {
            sb.append("secretRef:");
            sb.append(this.secretRef + ",");
        }
        if (this.sslEnabled != null) {
            sb.append("sslEnabled:");
            sb.append(this.sslEnabled + ",");
        }
        if (this.storageMode != null) {
            sb.append("storageMode:");
            sb.append(this.storageMode + ",");
        }
        if (this.storagePool != null) {
            sb.append("storagePool:");
            sb.append(this.storagePool + ",");
        }
        if (this.system != null) {
            sb.append("system:");
            sb.append(this.system + ",");
        }
        if (this.volumeName != null) {
            sb.append("volumeName:");
            sb.append(this.volumeName);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withReadOnly() {
        return this.withReadOnly(true);
    }

    @Override
    public A withSslEnabled() {
        return this.withSslEnabled(true);
    }

    class SecretRefNestedImpl<N>
    extends V1LocalObjectReferenceFluentImpl<V1ScaleIOVolumeSourceFluent.SecretRefNested<N>>
    implements V1ScaleIOVolumeSourceFluent.SecretRefNested<N>,
    Nested<N> {
        V1LocalObjectReferenceBuilder builder;

        SecretRefNestedImpl(V1LocalObjectReference item) {
            this.builder = new V1LocalObjectReferenceBuilder(this, item);
        }

        SecretRefNestedImpl() {
            this.builder = new V1LocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ScaleIOVolumeSourceFluentImpl.this.withSecretRef(this.builder.build());
        }

        @Override
        public N endSecretRef() {
            return this.and();
        }
    }
}

