/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.kubernetes.client.openapi.models.V1LabelSelectorBuilder;
import io.kubernetes.client.openapi.models.V1LabelSelectorFluentImpl;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1ObjectMetaBuilder;
import io.kubernetes.client.openapi.models.V1ObjectMetaFluentImpl;
import io.kubernetes.client.openapi.models.V1beta1CSIStorageCapacity;
import io.kubernetes.client.openapi.models.V1beta1CSIStorageCapacityFluent;
import java.util.Objects;

public class V1beta1CSIStorageCapacityFluentImpl<A extends V1beta1CSIStorageCapacityFluent<A>>
extends BaseFluent<A>
implements V1beta1CSIStorageCapacityFluent<A> {
    private String apiVersion;
    private Quantity capacity;
    private String kind;
    private Quantity maximumVolumeSize;
    private V1ObjectMetaBuilder metadata;
    private V1LabelSelectorBuilder nodeTopology;
    private String storageClassName;

    public V1beta1CSIStorageCapacityFluentImpl() {
    }

    public V1beta1CSIStorageCapacityFluentImpl(V1beta1CSIStorageCapacity instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withCapacity(instance.getCapacity());
        this.withKind(instance.getKind());
        this.withMaximumVolumeSize(instance.getMaximumVolumeSize());
        this.withMetadata(instance.getMetadata());
        this.withNodeTopology(instance.getNodeTopology());
        this.withStorageClassName(instance.getStorageClassName());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public Quantity getCapacity() {
        return this.capacity;
    }

    @Override
    public A withCapacity(Quantity capacity) {
        this.capacity = capacity;
        return (A)this;
    }

    @Override
    public Boolean hasCapacity() {
        return this.capacity != null;
    }

    @Override
    public A withNewCapacity(String value) {
        return this.withCapacity(new Quantity(value));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public Quantity getMaximumVolumeSize() {
        return this.maximumVolumeSize;
    }

    @Override
    public A withMaximumVolumeSize(Quantity maximumVolumeSize) {
        this.maximumVolumeSize = maximumVolumeSize;
        return (A)this;
    }

    @Override
    public Boolean hasMaximumVolumeSize() {
        return this.maximumVolumeSize != null;
    }

    @Override
    public A withNewMaximumVolumeSize(String value) {
        return this.withMaximumVolumeSize(new Quantity(value));
    }

    @Override
    @Deprecated
    public V1ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public V1ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(V1ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new V1ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public V1beta1CSIStorageCapacityFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public V1beta1CSIStorageCapacityFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public V1beta1CSIStorageCapacityFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public V1beta1CSIStorageCapacityFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new V1ObjectMetaBuilder().build());
    }

    @Override
    public V1beta1CSIStorageCapacityFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public V1LabelSelector getNodeTopology() {
        return this.nodeTopology != null ? this.nodeTopology.build() : null;
    }

    @Override
    public V1LabelSelector buildNodeTopology() {
        return this.nodeTopology != null ? this.nodeTopology.build() : null;
    }

    @Override
    public A withNodeTopology(V1LabelSelector nodeTopology) {
        this._visitables.get("nodeTopology").remove(this.nodeTopology);
        if (nodeTopology != null) {
            this.nodeTopology = new V1LabelSelectorBuilder(nodeTopology);
            this._visitables.get("nodeTopology").add(this.nodeTopology);
        }
        return (A)this;
    }

    @Override
    public Boolean hasNodeTopology() {
        return this.nodeTopology != null;
    }

    @Override
    public V1beta1CSIStorageCapacityFluent.NodeTopologyNested<A> withNewNodeTopology() {
        return new NodeTopologyNestedImpl();
    }

    @Override
    public V1beta1CSIStorageCapacityFluent.NodeTopologyNested<A> withNewNodeTopologyLike(V1LabelSelector item) {
        return new NodeTopologyNestedImpl(item);
    }

    @Override
    public V1beta1CSIStorageCapacityFluent.NodeTopologyNested<A> editNodeTopology() {
        return this.withNewNodeTopologyLike(this.getNodeTopology());
    }

    @Override
    public V1beta1CSIStorageCapacityFluent.NodeTopologyNested<A> editOrNewNodeTopology() {
        return this.withNewNodeTopologyLike(this.getNodeTopology() != null ? this.getNodeTopology() : new V1LabelSelectorBuilder().build());
    }

    @Override
    public V1beta1CSIStorageCapacityFluent.NodeTopologyNested<A> editOrNewNodeTopologyLike(V1LabelSelector item) {
        return this.withNewNodeTopologyLike(this.getNodeTopology() != null ? this.getNodeTopology() : item);
    }

    @Override
    public String getStorageClassName() {
        return this.storageClassName;
    }

    @Override
    public A withStorageClassName(String storageClassName) {
        this.storageClassName = storageClassName;
        return (A)this;
    }

    @Override
    public Boolean hasStorageClassName() {
        return this.storageClassName != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1CSIStorageCapacityFluentImpl that = (V1beta1CSIStorageCapacityFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.capacity != null ? !this.capacity.equals((Object)that.capacity) : that.capacity != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.maximumVolumeSize != null ? !this.maximumVolumeSize.equals((Object)that.maximumVolumeSize) : that.maximumVolumeSize != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.nodeTopology != null ? !this.nodeTopology.equals(that.nodeTopology) : that.nodeTopology != null) {
            return false;
        }
        return !(this.storageClassName != null ? !this.storageClassName.equals(that.storageClassName) : that.storageClassName != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.capacity, this.kind, this.maximumVolumeSize, this.metadata, this.nodeTopology, this.storageClassName, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.capacity != null) {
            sb.append("capacity:");
            sb.append(this.capacity + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.maximumVolumeSize != null) {
            sb.append("maximumVolumeSize:");
            sb.append(this.maximumVolumeSize + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.nodeTopology != null) {
            sb.append("nodeTopology:");
            sb.append(this.nodeTopology + ",");
        }
        if (this.storageClassName != null) {
            sb.append("storageClassName:");
            sb.append(this.storageClassName);
        }
        sb.append("}");
        return sb.toString();
    }

    class NodeTopologyNestedImpl<N>
    extends V1LabelSelectorFluentImpl<V1beta1CSIStorageCapacityFluent.NodeTopologyNested<N>>
    implements V1beta1CSIStorageCapacityFluent.NodeTopologyNested<N>,
    Nested<N> {
        V1LabelSelectorBuilder builder;

        NodeTopologyNestedImpl(V1LabelSelector item) {
            this.builder = new V1LabelSelectorBuilder(this, item);
        }

        NodeTopologyNestedImpl() {
            this.builder = new V1LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1beta1CSIStorageCapacityFluentImpl.this.withNodeTopology(this.builder.build());
        }

        @Override
        public N endNodeTopology() {
            return this.and();
        }
    }

    class MetadataNestedImpl<N>
    extends V1ObjectMetaFluentImpl<V1beta1CSIStorageCapacityFluent.MetadataNested<N>>
    implements V1beta1CSIStorageCapacityFluent.MetadataNested<N>,
    Nested<N> {
        V1ObjectMetaBuilder builder;

        MetadataNestedImpl(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new V1ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1beta1CSIStorageCapacityFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

