/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1ObjectMetaBuilder;
import io.kubernetes.client.openapi.models.V1ObjectMetaFluentImpl;
import io.kubernetes.client.openapi.models.V2HorizontalPodAutoscaler;
import io.kubernetes.client.openapi.models.V2HorizontalPodAutoscalerFluent;
import io.kubernetes.client.openapi.models.V2HorizontalPodAutoscalerSpec;
import io.kubernetes.client.openapi.models.V2HorizontalPodAutoscalerSpecBuilder;
import io.kubernetes.client.openapi.models.V2HorizontalPodAutoscalerSpecFluentImpl;
import io.kubernetes.client.openapi.models.V2HorizontalPodAutoscalerStatus;
import io.kubernetes.client.openapi.models.V2HorizontalPodAutoscalerStatusBuilder;
import io.kubernetes.client.openapi.models.V2HorizontalPodAutoscalerStatusFluentImpl;
import java.util.Objects;

public class V2HorizontalPodAutoscalerFluentImpl<A extends V2HorizontalPodAutoscalerFluent<A>>
extends BaseFluent<A>
implements V2HorizontalPodAutoscalerFluent<A> {
    private String apiVersion;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private V2HorizontalPodAutoscalerSpecBuilder spec;
    private V2HorizontalPodAutoscalerStatusBuilder status;

    public V2HorizontalPodAutoscalerFluentImpl() {
    }

    public V2HorizontalPodAutoscalerFluentImpl(V2HorizontalPodAutoscaler instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public V1ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public V1ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(V1ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new V1ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public V2HorizontalPodAutoscalerFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public V2HorizontalPodAutoscalerFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public V2HorizontalPodAutoscalerFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public V2HorizontalPodAutoscalerFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new V1ObjectMetaBuilder().build());
    }

    @Override
    public V2HorizontalPodAutoscalerFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public V2HorizontalPodAutoscalerSpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public V2HorizontalPodAutoscalerSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(V2HorizontalPodAutoscalerSpec spec) {
        this._visitables.get("spec").remove(this.spec);
        if (spec != null) {
            this.spec = new V2HorizontalPodAutoscalerSpecBuilder(spec);
            this._visitables.get("spec").add(this.spec);
        } else {
            this.spec = null;
            this._visitables.get("spec").remove(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public V2HorizontalPodAutoscalerFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public V2HorizontalPodAutoscalerFluent.SpecNested<A> withNewSpecLike(V2HorizontalPodAutoscalerSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public V2HorizontalPodAutoscalerFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public V2HorizontalPodAutoscalerFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new V2HorizontalPodAutoscalerSpecBuilder().build());
    }

    @Override
    public V2HorizontalPodAutoscalerFluent.SpecNested<A> editOrNewSpecLike(V2HorizontalPodAutoscalerSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    @Deprecated
    public V2HorizontalPodAutoscalerStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public V2HorizontalPodAutoscalerStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(V2HorizontalPodAutoscalerStatus status) {
        this._visitables.get("status").remove(this.status);
        if (status != null) {
            this.status = new V2HorizontalPodAutoscalerStatusBuilder(status);
            this._visitables.get("status").add(this.status);
        } else {
            this.status = null;
            this._visitables.get("status").remove(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public V2HorizontalPodAutoscalerFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public V2HorizontalPodAutoscalerFluent.StatusNested<A> withNewStatusLike(V2HorizontalPodAutoscalerStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public V2HorizontalPodAutoscalerFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public V2HorizontalPodAutoscalerFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new V2HorizontalPodAutoscalerStatusBuilder().build());
    }

    @Override
    public V2HorizontalPodAutoscalerFluent.StatusNested<A> editOrNewStatusLike(V2HorizontalPodAutoscalerStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2HorizontalPodAutoscalerFluentImpl that = (V2HorizontalPodAutoscalerFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec, this.status, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.spec != null) {
            sb.append("spec:");
            sb.append(this.spec + ",");
        }
        if (this.status != null) {
            sb.append("status:");
            sb.append(this.status);
        }
        sb.append("}");
        return sb.toString();
    }

    class MetadataNestedImpl<N>
    extends V1ObjectMetaFluentImpl<V2HorizontalPodAutoscalerFluent.MetadataNested<N>>
    implements V2HorizontalPodAutoscalerFluent.MetadataNested<N>,
    Nested<N> {
        V1ObjectMetaBuilder builder;

        MetadataNestedImpl(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new V1ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)V2HorizontalPodAutoscalerFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    class SpecNestedImpl<N>
    extends V2HorizontalPodAutoscalerSpecFluentImpl<V2HorizontalPodAutoscalerFluent.SpecNested<N>>
    implements V2HorizontalPodAutoscalerFluent.SpecNested<N>,
    Nested<N> {
        V2HorizontalPodAutoscalerSpecBuilder builder;

        SpecNestedImpl(V2HorizontalPodAutoscalerSpec item) {
            this.builder = new V2HorizontalPodAutoscalerSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new V2HorizontalPodAutoscalerSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)V2HorizontalPodAutoscalerFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    class StatusNestedImpl<N>
    extends V2HorizontalPodAutoscalerStatusFluentImpl<V2HorizontalPodAutoscalerFluent.StatusNested<N>>
    implements V2HorizontalPodAutoscalerFluent.StatusNested<N>,
    Nested<N> {
        V2HorizontalPodAutoscalerStatusBuilder builder;

        StatusNestedImpl(V2HorizontalPodAutoscalerStatus item) {
            this.builder = new V2HorizontalPodAutoscalerStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new V2HorizontalPodAutoscalerStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)V2HorizontalPodAutoscalerFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }
}

