/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.openapi.models.V1VolumeResourceRequirements;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class V1VolumeResourceRequirementsFluent<A extends V1VolumeResourceRequirementsFluent<A>>
extends BaseFluent<A> {
    private Map<String, Quantity> limits;
    private Map<String, Quantity> requests;

    public V1VolumeResourceRequirementsFluent() {
    }

    public V1VolumeResourceRequirementsFluent(V1VolumeResourceRequirements instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1VolumeResourceRequirements instance) {
        V1VolumeResourceRequirements v1VolumeResourceRequirements = instance = instance != null ? instance : new V1VolumeResourceRequirements();
        if (instance != null) {
            this.withLimits(instance.getLimits());
            this.withRequests(instance.getRequests());
        }
    }

    public A addToLimits(String key, Quantity value) {
        if (this.limits == null && key != null && value != null) {
            this.limits = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.limits.put(key, value);
        }
        return (A)this;
    }

    public A addToLimits(Map<String, Quantity> map) {
        if (this.limits == null && map != null) {
            this.limits = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.limits.putAll(map);
        }
        return (A)this;
    }

    public A removeFromLimits(String key) {
        if (this.limits == null) {
            return (A)this;
        }
        if (key != null && this.limits != null) {
            this.limits.remove(key);
        }
        return (A)this;
    }

    public A removeFromLimits(Map<String, Quantity> map) {
        if (this.limits == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.limits == null) continue;
                this.limits.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Quantity> getLimits() {
        return this.limits;
    }

    public <K, V> A withLimits(Map<String, Quantity> limits) {
        this.limits = limits == null ? null : new LinkedHashMap<String, Quantity>(limits);
        return (A)this;
    }

    public boolean hasLimits() {
        return this.limits != null;
    }

    public A addToRequests(String key, Quantity value) {
        if (this.requests == null && key != null && value != null) {
            this.requests = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.requests.put(key, value);
        }
        return (A)this;
    }

    public A addToRequests(Map<String, Quantity> map) {
        if (this.requests == null && map != null) {
            this.requests = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.requests.putAll(map);
        }
        return (A)this;
    }

    public A removeFromRequests(String key) {
        if (this.requests == null) {
            return (A)this;
        }
        if (key != null && this.requests != null) {
            this.requests.remove(key);
        }
        return (A)this;
    }

    public A removeFromRequests(Map<String, Quantity> map) {
        if (this.requests == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.requests == null) continue;
                this.requests.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Quantity> getRequests() {
        return this.requests;
    }

    public <K, V> A withRequests(Map<String, Quantity> requests) {
        this.requests = requests == null ? null : new LinkedHashMap<String, Quantity>(requests);
        return (A)this;
    }

    public boolean hasRequests() {
        return this.requests != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1VolumeResourceRequirementsFluent that = (V1VolumeResourceRequirementsFluent)o;
        if (!Objects.equals(this.limits, that.limits)) {
            return false;
        }
        return Objects.equals(this.requests, that.requests);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.limits, this.requests, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.limits != null && !this.limits.isEmpty()) {
            sb.append("limits:");
            sb.append(this.limits + ",");
        }
        if (this.requests != null && !this.requests.isEmpty()) {
            sb.append("requests:");
            sb.append(this.requests);
        }
        sb.append("}");
        return sb.toString();
    }
}

