/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1ObjectMetaBuilder;
import io.kubernetes.client.openapi.models.V1ObjectMetaFluent;
import io.kubernetes.client.openapi.models.V1alpha2NamedResourcesResources;
import io.kubernetes.client.openapi.models.V1alpha2NamedResourcesResourcesBuilder;
import io.kubernetes.client.openapi.models.V1alpha2NamedResourcesResourcesFluent;
import io.kubernetes.client.openapi.models.V1alpha2ResourceSlice;
import java.util.Objects;
import java.util.Optional;

public class V1alpha2ResourceSliceFluent<A extends V1alpha2ResourceSliceFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private String driverName;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private V1alpha2NamedResourcesResourcesBuilder namedResources;
    private String nodeName;

    public V1alpha2ResourceSliceFluent() {
    }

    public V1alpha2ResourceSliceFluent(V1alpha2ResourceSlice instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1alpha2ResourceSlice instance) {
        V1alpha2ResourceSlice v1alpha2ResourceSlice = instance = instance != null ? instance : new V1alpha2ResourceSlice();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withDriverName(instance.getDriverName());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withNamedResources(instance.getNamedResources());
            this.withNodeName(instance.getNodeName());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public A withDriverName(String driverName) {
        this.driverName = driverName;
        return (A)this;
    }

    public boolean hasDriverName() {
        return this.driverName != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public V1ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(V1ObjectMeta metadata) {
        this._visitables.remove("metadata");
        if (metadata != null) {
            this.metadata = new V1ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new V1ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public V1alpha2NamedResourcesResources buildNamedResources() {
        return this.namedResources != null ? this.namedResources.build() : null;
    }

    public A withNamedResources(V1alpha2NamedResourcesResources namedResources) {
        this._visitables.remove("namedResources");
        if (namedResources != null) {
            this.namedResources = new V1alpha2NamedResourcesResourcesBuilder(namedResources);
            this._visitables.get("namedResources").add(this.namedResources);
        } else {
            this.namedResources = null;
            this._visitables.get("namedResources").remove(this.namedResources);
        }
        return (A)this;
    }

    public boolean hasNamedResources() {
        return this.namedResources != null;
    }

    public NamedResourcesNested<A> withNewNamedResources() {
        return new NamedResourcesNested(null);
    }

    public NamedResourcesNested<A> withNewNamedResourcesLike(V1alpha2NamedResourcesResources item) {
        return new NamedResourcesNested(item);
    }

    public NamedResourcesNested<A> editNamedResources() {
        return this.withNewNamedResourcesLike(Optional.ofNullable(this.buildNamedResources()).orElse(null));
    }

    public NamedResourcesNested<A> editOrNewNamedResources() {
        return this.withNewNamedResourcesLike(Optional.ofNullable(this.buildNamedResources()).orElse(new V1alpha2NamedResourcesResourcesBuilder().build()));
    }

    public NamedResourcesNested<A> editOrNewNamedResourcesLike(V1alpha2NamedResourcesResources item) {
        return this.withNewNamedResourcesLike(Optional.ofNullable(this.buildNamedResources()).orElse(item));
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public A withNodeName(String nodeName) {
        this.nodeName = nodeName;
        return (A)this;
    }

    public boolean hasNodeName() {
        return this.nodeName != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1alpha2ResourceSliceFluent that = (V1alpha2ResourceSliceFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.driverName, that.driverName)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.namedResources, that.namedResources)) {
            return false;
        }
        return Objects.equals(this.nodeName, that.nodeName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.driverName, this.kind, this.metadata, this.namedResources, this.nodeName, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.driverName != null) {
            sb.append("driverName:");
            sb.append(this.driverName + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.namedResources != null) {
            sb.append("namedResources:");
            sb.append(this.namedResources + ",");
        }
        if (this.nodeName != null) {
            sb.append("nodeName:");
            sb.append(this.nodeName);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MetadataNested<N>
    extends V1ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        V1ObjectMetaBuilder builder;

        MetadataNested(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1alpha2ResourceSliceFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }

    public class NamedResourcesNested<N>
    extends V1alpha2NamedResourcesResourcesFluent<NamedResourcesNested<N>>
    implements Nested<N> {
        V1alpha2NamedResourcesResourcesBuilder builder;

        NamedResourcesNested(V1alpha2NamedResourcesResources item) {
            this.builder = new V1alpha2NamedResourcesResourcesBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1alpha2ResourceSliceFluent.this.withNamedResources(this.builder.build());
        }

        public N endNamedResources() {
            return this.and();
        }
    }
}

