/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.apis;

import com.google.gson.reflect.TypeToken;
import io.kubernetes.client.custom.V1Patch;
import io.kubernetes.client.openapi.ApiCallback;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.ApiResponse;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.Pair;
import io.kubernetes.client.openapi.models.V1APIResourceList;
import io.kubernetes.client.openapi.models.V1DeleteOptions;
import io.kubernetes.client.openapi.models.V1Status;
import io.kubernetes.client.openapi.models.V1alpha2PodSchedulingContext;
import io.kubernetes.client.openapi.models.V1alpha2PodSchedulingContextList;
import io.kubernetes.client.openapi.models.V1alpha2ResourceClaim;
import io.kubernetes.client.openapi.models.V1alpha2ResourceClaimList;
import io.kubernetes.client.openapi.models.V1alpha2ResourceClaimTemplate;
import io.kubernetes.client.openapi.models.V1alpha2ResourceClaimTemplateList;
import io.kubernetes.client.openapi.models.V1alpha2ResourceClass;
import io.kubernetes.client.openapi.models.V1alpha2ResourceClassList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class ResourceV1alpha2Api {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ResourceV1alpha2Api() {
        this(Configuration.getDefaultApiClient());
    }

    public ResourceV1alpha2Api(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call createNamespacedPodSchedulingContextCall(String namespace, V1alpha2PodSchedulingContext body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1alpha2PodSchedulingContext localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1alpha2/namespaces/{namespace}/podschedulingcontexts".replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createNamespacedPodSchedulingContextValidateBeforeCall(String namespace, V1alpha2PodSchedulingContext body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling createNamespacedPodSchedulingContext(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createNamespacedPodSchedulingContext(Async)");
        }
        return this.createNamespacedPodSchedulingContextCall(namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
    }

    private ApiResponse<V1alpha2PodSchedulingContext> createNamespacedPodSchedulingContextWithHttpInfo(String namespace, V1alpha2PodSchedulingContext body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        Call localVarCall = this.createNamespacedPodSchedulingContextValidateBeforeCall(namespace, body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1alpha2PodSchedulingContext>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call createNamespacedPodSchedulingContextAsync(String namespace, V1alpha2PodSchedulingContext body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback<V1alpha2PodSchedulingContext> _callback) throws ApiException {
        Call localVarCall = this.createNamespacedPodSchedulingContextValidateBeforeCall(namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1alpha2PodSchedulingContext>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIcreateNamespacedPodSchedulingContextRequest createNamespacedPodSchedulingContext(String namespace, V1alpha2PodSchedulingContext body) {
        return new APIcreateNamespacedPodSchedulingContextRequest(namespace, body);
    }

    private Call createNamespacedResourceClaimCall(String namespace, V1alpha2ResourceClaim body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1alpha2ResourceClaim localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1alpha2/namespaces/{namespace}/resourceclaims".replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createNamespacedResourceClaimValidateBeforeCall(String namespace, V1alpha2ResourceClaim body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling createNamespacedResourceClaim(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createNamespacedResourceClaim(Async)");
        }
        return this.createNamespacedResourceClaimCall(namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
    }

    private ApiResponse<V1alpha2ResourceClaim> createNamespacedResourceClaimWithHttpInfo(String namespace, V1alpha2ResourceClaim body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        Call localVarCall = this.createNamespacedResourceClaimValidateBeforeCall(namespace, body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1alpha2ResourceClaim>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call createNamespacedResourceClaimAsync(String namespace, V1alpha2ResourceClaim body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback<V1alpha2ResourceClaim> _callback) throws ApiException {
        Call localVarCall = this.createNamespacedResourceClaimValidateBeforeCall(namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1alpha2ResourceClaim>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIcreateNamespacedResourceClaimRequest createNamespacedResourceClaim(String namespace, V1alpha2ResourceClaim body) {
        return new APIcreateNamespacedResourceClaimRequest(namespace, body);
    }

    private Call createNamespacedResourceClaimTemplateCall(String namespace, V1alpha2ResourceClaimTemplate body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1alpha2ResourceClaimTemplate localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1alpha2/namespaces/{namespace}/resourceclaimtemplates".replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createNamespacedResourceClaimTemplateValidateBeforeCall(String namespace, V1alpha2ResourceClaimTemplate body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling createNamespacedResourceClaimTemplate(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createNamespacedResourceClaimTemplate(Async)");
        }
        return this.createNamespacedResourceClaimTemplateCall(namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
    }

    private ApiResponse<V1alpha2ResourceClaimTemplate> createNamespacedResourceClaimTemplateWithHttpInfo(String namespace, V1alpha2ResourceClaimTemplate body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        Call localVarCall = this.createNamespacedResourceClaimTemplateValidateBeforeCall(namespace, body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1alpha2ResourceClaimTemplate>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call createNamespacedResourceClaimTemplateAsync(String namespace, V1alpha2ResourceClaimTemplate body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback<V1alpha2ResourceClaimTemplate> _callback) throws ApiException {
        Call localVarCall = this.createNamespacedResourceClaimTemplateValidateBeforeCall(namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1alpha2ResourceClaimTemplate>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIcreateNamespacedResourceClaimTemplateRequest createNamespacedResourceClaimTemplate(String namespace, V1alpha2ResourceClaimTemplate body) {
        return new APIcreateNamespacedResourceClaimTemplateRequest(namespace, body);
    }

    private Call createResourceClassCall(V1alpha2ResourceClass body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1alpha2ResourceClass localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1alpha2/resourceclasses";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createResourceClassValidateBeforeCall(V1alpha2ResourceClass body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createResourceClass(Async)");
        }
        return this.createResourceClassCall(body, pretty, dryRun, fieldManager, fieldValidation, _callback);
    }

    private ApiResponse<V1alpha2ResourceClass> createResourceClassWithHttpInfo(V1alpha2ResourceClass body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        Call localVarCall = this.createResourceClassValidateBeforeCall(body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1alpha2ResourceClass>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call createResourceClassAsync(V1alpha2ResourceClass body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback<V1alpha2ResourceClass> _callback) throws ApiException {
        Call localVarCall = this.createResourceClassValidateBeforeCall(body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1alpha2ResourceClass>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIcreateResourceClassRequest createResourceClass(V1alpha2ResourceClass body) {
        return new APIcreateResourceClassRequest(body);
    }

    private Call deleteCollectionNamespacedPodSchedulingContextCall(String namespace, String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1alpha2/namespaces/{namespace}/podschedulingcontexts".replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteCollectionNamespacedPodSchedulingContextValidateBeforeCall(String namespace, String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling deleteCollectionNamespacedPodSchedulingContext(Async)");
        }
        return this.deleteCollectionNamespacedPodSchedulingContextCall(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, _callback);
    }

    private ApiResponse<V1Status> deleteCollectionNamespacedPodSchedulingContextWithHttpInfo(String namespace, String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteCollectionNamespacedPodSchedulingContextValidateBeforeCall(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, null);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteCollectionNamespacedPodSchedulingContextAsync(String namespace, String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body, ApiCallback<V1Status> _callback) throws ApiException {
        Call localVarCall = this.deleteCollectionNamespacedPodSchedulingContextValidateBeforeCall(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, _callback);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIdeleteCollectionNamespacedPodSchedulingContextRequest deleteCollectionNamespacedPodSchedulingContext(String namespace) {
        return new APIdeleteCollectionNamespacedPodSchedulingContextRequest(namespace);
    }

    private Call deleteCollectionNamespacedResourceClaimCall(String namespace, String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1alpha2/namespaces/{namespace}/resourceclaims".replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteCollectionNamespacedResourceClaimValidateBeforeCall(String namespace, String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling deleteCollectionNamespacedResourceClaim(Async)");
        }
        return this.deleteCollectionNamespacedResourceClaimCall(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, _callback);
    }

    private ApiResponse<V1Status> deleteCollectionNamespacedResourceClaimWithHttpInfo(String namespace, String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteCollectionNamespacedResourceClaimValidateBeforeCall(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, null);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteCollectionNamespacedResourceClaimAsync(String namespace, String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body, ApiCallback<V1Status> _callback) throws ApiException {
        Call localVarCall = this.deleteCollectionNamespacedResourceClaimValidateBeforeCall(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, _callback);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIdeleteCollectionNamespacedResourceClaimRequest deleteCollectionNamespacedResourceClaim(String namespace) {
        return new APIdeleteCollectionNamespacedResourceClaimRequest(namespace);
    }

    private Call deleteCollectionNamespacedResourceClaimTemplateCall(String namespace, String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1alpha2/namespaces/{namespace}/resourceclaimtemplates".replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteCollectionNamespacedResourceClaimTemplateValidateBeforeCall(String namespace, String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling deleteCollectionNamespacedResourceClaimTemplate(Async)");
        }
        return this.deleteCollectionNamespacedResourceClaimTemplateCall(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, _callback);
    }

    private ApiResponse<V1Status> deleteCollectionNamespacedResourceClaimTemplateWithHttpInfo(String namespace, String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteCollectionNamespacedResourceClaimTemplateValidateBeforeCall(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, null);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteCollectionNamespacedResourceClaimTemplateAsync(String namespace, String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body, ApiCallback<V1Status> _callback) throws ApiException {
        Call localVarCall = this.deleteCollectionNamespacedResourceClaimTemplateValidateBeforeCall(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, _callback);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIdeleteCollectionNamespacedResourceClaimTemplateRequest deleteCollectionNamespacedResourceClaimTemplate(String namespace) {
        return new APIdeleteCollectionNamespacedResourceClaimTemplateRequest(namespace);
    }

    private Call deleteCollectionResourceClassCall(String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1alpha2/resourceclasses";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteCollectionResourceClassValidateBeforeCall(String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        return this.deleteCollectionResourceClassCall(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, _callback);
    }

    private ApiResponse<V1Status> deleteCollectionResourceClassWithHttpInfo(String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteCollectionResourceClassValidateBeforeCall(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, null);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteCollectionResourceClassAsync(String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body, ApiCallback<V1Status> _callback) throws ApiException {
        Call localVarCall = this.deleteCollectionResourceClassValidateBeforeCall(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, _callback);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIdeleteCollectionResourceClassRequest deleteCollectionResourceClass() {
        return new APIdeleteCollectionResourceClassRequest();
    }

    private Call deleteNamespacedPodSchedulingContextCall(String name, String namespace, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1alpha2/namespaces/{namespace}/podschedulingcontexts/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteNamespacedPodSchedulingContextValidateBeforeCall(String name, String namespace, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteNamespacedPodSchedulingContext(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling deleteNamespacedPodSchedulingContext(Async)");
        }
        return this.deleteNamespacedPodSchedulingContextCall(name, namespace, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, _callback);
    }

    private ApiResponse<V1alpha2PodSchedulingContext> deleteNamespacedPodSchedulingContextWithHttpInfo(String name, String namespace, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteNamespacedPodSchedulingContextValidateBeforeCall(name, namespace, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, null);
        Type localVarReturnType = new TypeToken<V1alpha2PodSchedulingContext>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteNamespacedPodSchedulingContextAsync(String name, String namespace, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body, ApiCallback<V1alpha2PodSchedulingContext> _callback) throws ApiException {
        Call localVarCall = this.deleteNamespacedPodSchedulingContextValidateBeforeCall(name, namespace, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, _callback);
        Type localVarReturnType = new TypeToken<V1alpha2PodSchedulingContext>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIdeleteNamespacedPodSchedulingContextRequest deleteNamespacedPodSchedulingContext(String name, String namespace) {
        return new APIdeleteNamespacedPodSchedulingContextRequest(name, namespace);
    }

    private Call deleteNamespacedResourceClaimCall(String name, String namespace, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1alpha2/namespaces/{namespace}/resourceclaims/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteNamespacedResourceClaimValidateBeforeCall(String name, String namespace, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteNamespacedResourceClaim(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling deleteNamespacedResourceClaim(Async)");
        }
        return this.deleteNamespacedResourceClaimCall(name, namespace, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, _callback);
    }

    private ApiResponse<V1alpha2ResourceClaim> deleteNamespacedResourceClaimWithHttpInfo(String name, String namespace, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteNamespacedResourceClaimValidateBeforeCall(name, namespace, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, null);
        Type localVarReturnType = new TypeToken<V1alpha2ResourceClaim>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteNamespacedResourceClaimAsync(String name, String namespace, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body, ApiCallback<V1alpha2ResourceClaim> _callback) throws ApiException {
        Call localVarCall = this.deleteNamespacedResourceClaimValidateBeforeCall(name, namespace, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, _callback);
        Type localVarReturnType = new TypeToken<V1alpha2ResourceClaim>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIdeleteNamespacedResourceClaimRequest deleteNamespacedResourceClaim(String name, String namespace) {
        return new APIdeleteNamespacedResourceClaimRequest(name, namespace);
    }

    private Call deleteNamespacedResourceClaimTemplateCall(String name, String namespace, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1alpha2/namespaces/{namespace}/resourceclaimtemplates/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteNamespacedResourceClaimTemplateValidateBeforeCall(String name, String namespace, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteNamespacedResourceClaimTemplate(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling deleteNamespacedResourceClaimTemplate(Async)");
        }
        return this.deleteNamespacedResourceClaimTemplateCall(name, namespace, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, _callback);
    }

    private ApiResponse<V1alpha2ResourceClaimTemplate> deleteNamespacedResourceClaimTemplateWithHttpInfo(String name, String namespace, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteNamespacedResourceClaimTemplateValidateBeforeCall(name, namespace, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, null);
        Type localVarReturnType = new TypeToken<V1alpha2ResourceClaimTemplate>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteNamespacedResourceClaimTemplateAsync(String name, String namespace, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body, ApiCallback<V1alpha2ResourceClaimTemplate> _callback) throws ApiException {
        Call localVarCall = this.deleteNamespacedResourceClaimTemplateValidateBeforeCall(name, namespace, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, _callback);
        Type localVarReturnType = new TypeToken<V1alpha2ResourceClaimTemplate>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIdeleteNamespacedResourceClaimTemplateRequest deleteNamespacedResourceClaimTemplate(String name, String namespace) {
        return new APIdeleteNamespacedResourceClaimTemplateRequest(name, namespace);
    }

    private Call deleteResourceClassCall(String name, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1alpha2/resourceclasses/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteResourceClassValidateBeforeCall(String name, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteResourceClass(Async)");
        }
        return this.deleteResourceClassCall(name, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, _callback);
    }

    private ApiResponse<V1alpha2ResourceClass> deleteResourceClassWithHttpInfo(String name, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteResourceClassValidateBeforeCall(name, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, null);
        Type localVarReturnType = new TypeToken<V1alpha2ResourceClass>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteResourceClassAsync(String name, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body, ApiCallback<V1alpha2ResourceClass> _callback) throws ApiException {
        Call localVarCall = this.deleteResourceClassValidateBeforeCall(name, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, _callback);
        Type localVarReturnType = new TypeToken<V1alpha2ResourceClass>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIdeleteResourceClassRequest deleteResourceClass(String name) {
        return new APIdeleteResourceClassRequest(name);
    }

    private Call getAPIResourcesCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/resource.k8s.io/v1alpha2/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAPIResourcesValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.getAPIResourcesCall(_callback);
    }

    private ApiResponse<V1APIResourceList> getAPIResourcesWithHttpInfo() throws ApiException {
        Call localVarCall = this.getAPIResourcesValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<V1APIResourceList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getAPIResourcesAsync(ApiCallback<V1APIResourceList> _callback) throws ApiException {
        Call localVarCall = this.getAPIResourcesValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<V1APIResourceList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetAPIResourcesRequest getAPIResources() {
        return new APIgetAPIResourcesRequest();
    }

    private Call listNamespacedPodSchedulingContextCall(String namespace, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/resource.k8s.io/v1alpha2/namespaces/{namespace}/podschedulingcontexts".replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (allowWatchBookmarks != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("allowWatchBookmarks", allowWatchBookmarks));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("watch", watch));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listNamespacedPodSchedulingContextValidateBeforeCall(String namespace, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling listNamespacedPodSchedulingContext(Async)");
        }
        return this.listNamespacedPodSchedulingContextCall(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
    }

    private ApiResponse<V1alpha2PodSchedulingContextList> listNamespacedPodSchedulingContextWithHttpInfo(String namespace, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch) throws ApiException {
        Call localVarCall = this.listNamespacedPodSchedulingContextValidateBeforeCall(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, null);
        Type localVarReturnType = new TypeToken<V1alpha2PodSchedulingContextList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listNamespacedPodSchedulingContextAsync(String namespace, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch, ApiCallback<V1alpha2PodSchedulingContextList> _callback) throws ApiException {
        Call localVarCall = this.listNamespacedPodSchedulingContextValidateBeforeCall(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
        Type localVarReturnType = new TypeToken<V1alpha2PodSchedulingContextList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistNamespacedPodSchedulingContextRequest listNamespacedPodSchedulingContext(String namespace) {
        return new APIlistNamespacedPodSchedulingContextRequest(namespace);
    }

    private Call listNamespacedResourceClaimCall(String namespace, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/resource.k8s.io/v1alpha2/namespaces/{namespace}/resourceclaims".replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (allowWatchBookmarks != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("allowWatchBookmarks", allowWatchBookmarks));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("watch", watch));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listNamespacedResourceClaimValidateBeforeCall(String namespace, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling listNamespacedResourceClaim(Async)");
        }
        return this.listNamespacedResourceClaimCall(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
    }

    private ApiResponse<V1alpha2ResourceClaimList> listNamespacedResourceClaimWithHttpInfo(String namespace, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch) throws ApiException {
        Call localVarCall = this.listNamespacedResourceClaimValidateBeforeCall(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, null);
        Type localVarReturnType = new TypeToken<V1alpha2ResourceClaimList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listNamespacedResourceClaimAsync(String namespace, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch, ApiCallback<V1alpha2ResourceClaimList> _callback) throws ApiException {
        Call localVarCall = this.listNamespacedResourceClaimValidateBeforeCall(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
        Type localVarReturnType = new TypeToken<V1alpha2ResourceClaimList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistNamespacedResourceClaimRequest listNamespacedResourceClaim(String namespace) {
        return new APIlistNamespacedResourceClaimRequest(namespace);
    }

    private Call listNamespacedResourceClaimTemplateCall(String namespace, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/resource.k8s.io/v1alpha2/namespaces/{namespace}/resourceclaimtemplates".replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (allowWatchBookmarks != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("allowWatchBookmarks", allowWatchBookmarks));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("watch", watch));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listNamespacedResourceClaimTemplateValidateBeforeCall(String namespace, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling listNamespacedResourceClaimTemplate(Async)");
        }
        return this.listNamespacedResourceClaimTemplateCall(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
    }

    private ApiResponse<V1alpha2ResourceClaimTemplateList> listNamespacedResourceClaimTemplateWithHttpInfo(String namespace, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch) throws ApiException {
        Call localVarCall = this.listNamespacedResourceClaimTemplateValidateBeforeCall(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, null);
        Type localVarReturnType = new TypeToken<V1alpha2ResourceClaimTemplateList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listNamespacedResourceClaimTemplateAsync(String namespace, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch, ApiCallback<V1alpha2ResourceClaimTemplateList> _callback) throws ApiException {
        Call localVarCall = this.listNamespacedResourceClaimTemplateValidateBeforeCall(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
        Type localVarReturnType = new TypeToken<V1alpha2ResourceClaimTemplateList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistNamespacedResourceClaimTemplateRequest listNamespacedResourceClaimTemplate(String namespace) {
        return new APIlistNamespacedResourceClaimTemplateRequest(namespace);
    }

    private Call listPodSchedulingContextForAllNamespacesCall(Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String pretty, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/resource.k8s.io/v1alpha2/podschedulingcontexts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (allowWatchBookmarks != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("allowWatchBookmarks", allowWatchBookmarks));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("watch", watch));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listPodSchedulingContextForAllNamespacesValidateBeforeCall(Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String pretty, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch, ApiCallback _callback) throws ApiException {
        return this.listPodSchedulingContextForAllNamespacesCall(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
    }

    private ApiResponse<V1alpha2PodSchedulingContextList> listPodSchedulingContextForAllNamespacesWithHttpInfo(Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String pretty, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch) throws ApiException {
        Call localVarCall = this.listPodSchedulingContextForAllNamespacesValidateBeforeCall(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, null);
        Type localVarReturnType = new TypeToken<V1alpha2PodSchedulingContextList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listPodSchedulingContextForAllNamespacesAsync(Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String pretty, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch, ApiCallback<V1alpha2PodSchedulingContextList> _callback) throws ApiException {
        Call localVarCall = this.listPodSchedulingContextForAllNamespacesValidateBeforeCall(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
        Type localVarReturnType = new TypeToken<V1alpha2PodSchedulingContextList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistPodSchedulingContextForAllNamespacesRequest listPodSchedulingContextForAllNamespaces() {
        return new APIlistPodSchedulingContextForAllNamespacesRequest();
    }

    private Call listResourceClaimForAllNamespacesCall(Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String pretty, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/resource.k8s.io/v1alpha2/resourceclaims";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (allowWatchBookmarks != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("allowWatchBookmarks", allowWatchBookmarks));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("watch", watch));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listResourceClaimForAllNamespacesValidateBeforeCall(Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String pretty, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch, ApiCallback _callback) throws ApiException {
        return this.listResourceClaimForAllNamespacesCall(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
    }

    private ApiResponse<V1alpha2ResourceClaimList> listResourceClaimForAllNamespacesWithHttpInfo(Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String pretty, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch) throws ApiException {
        Call localVarCall = this.listResourceClaimForAllNamespacesValidateBeforeCall(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, null);
        Type localVarReturnType = new TypeToken<V1alpha2ResourceClaimList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listResourceClaimForAllNamespacesAsync(Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String pretty, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch, ApiCallback<V1alpha2ResourceClaimList> _callback) throws ApiException {
        Call localVarCall = this.listResourceClaimForAllNamespacesValidateBeforeCall(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
        Type localVarReturnType = new TypeToken<V1alpha2ResourceClaimList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistResourceClaimForAllNamespacesRequest listResourceClaimForAllNamespaces() {
        return new APIlistResourceClaimForAllNamespacesRequest();
    }

    private Call listResourceClaimTemplateForAllNamespacesCall(Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String pretty, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/resource.k8s.io/v1alpha2/resourceclaimtemplates";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (allowWatchBookmarks != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("allowWatchBookmarks", allowWatchBookmarks));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("watch", watch));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listResourceClaimTemplateForAllNamespacesValidateBeforeCall(Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String pretty, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch, ApiCallback _callback) throws ApiException {
        return this.listResourceClaimTemplateForAllNamespacesCall(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
    }

    private ApiResponse<V1alpha2ResourceClaimTemplateList> listResourceClaimTemplateForAllNamespacesWithHttpInfo(Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String pretty, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch) throws ApiException {
        Call localVarCall = this.listResourceClaimTemplateForAllNamespacesValidateBeforeCall(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, null);
        Type localVarReturnType = new TypeToken<V1alpha2ResourceClaimTemplateList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listResourceClaimTemplateForAllNamespacesAsync(Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String pretty, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch, ApiCallback<V1alpha2ResourceClaimTemplateList> _callback) throws ApiException {
        Call localVarCall = this.listResourceClaimTemplateForAllNamespacesValidateBeforeCall(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
        Type localVarReturnType = new TypeToken<V1alpha2ResourceClaimTemplateList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistResourceClaimTemplateForAllNamespacesRequest listResourceClaimTemplateForAllNamespaces() {
        return new APIlistResourceClaimTemplateForAllNamespacesRequest();
    }

    private Call listResourceClassCall(String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/resource.k8s.io/v1alpha2/resourceclasses";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (allowWatchBookmarks != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("allowWatchBookmarks", allowWatchBookmarks));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("watch", watch));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listResourceClassValidateBeforeCall(String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch, ApiCallback _callback) throws ApiException {
        return this.listResourceClassCall(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
    }

    private ApiResponse<V1alpha2ResourceClassList> listResourceClassWithHttpInfo(String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch) throws ApiException {
        Call localVarCall = this.listResourceClassValidateBeforeCall(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, null);
        Type localVarReturnType = new TypeToken<V1alpha2ResourceClassList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listResourceClassAsync(String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch, ApiCallback<V1alpha2ResourceClassList> _callback) throws ApiException {
        Call localVarCall = this.listResourceClassValidateBeforeCall(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
        Type localVarReturnType = new TypeToken<V1alpha2ResourceClassList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistResourceClassRequest listResourceClass() {
        return new APIlistResourceClassRequest();
    }

    private Call patchNamespacedPodSchedulingContextCall(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1Patch localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1alpha2/namespaces/{namespace}/podschedulingcontexts/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchNamespacedPodSchedulingContextValidateBeforeCall(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchNamespacedPodSchedulingContext(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling patchNamespacedPodSchedulingContext(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchNamespacedPodSchedulingContext(Async)");
        }
        return this.patchNamespacedPodSchedulingContextCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
    }

    private ApiResponse<V1alpha2PodSchedulingContext> patchNamespacedPodSchedulingContextWithHttpInfo(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) throws ApiException {
        Call localVarCall = this.patchNamespacedPodSchedulingContextValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, null);
        Type localVarReturnType = new TypeToken<V1alpha2PodSchedulingContext>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call patchNamespacedPodSchedulingContextAsync(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback<V1alpha2PodSchedulingContext> _callback) throws ApiException {
        Call localVarCall = this.patchNamespacedPodSchedulingContextValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
        Type localVarReturnType = new TypeToken<V1alpha2PodSchedulingContext>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIpatchNamespacedPodSchedulingContextRequest patchNamespacedPodSchedulingContext(String name, String namespace, V1Patch body) {
        return new APIpatchNamespacedPodSchedulingContextRequest(name, namespace, body);
    }

    private Call patchNamespacedPodSchedulingContextStatusCall(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1Patch localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1alpha2/namespaces/{namespace}/podschedulingcontexts/{name}/status".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchNamespacedPodSchedulingContextStatusValidateBeforeCall(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchNamespacedPodSchedulingContextStatus(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling patchNamespacedPodSchedulingContextStatus(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchNamespacedPodSchedulingContextStatus(Async)");
        }
        return this.patchNamespacedPodSchedulingContextStatusCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
    }

    private ApiResponse<V1alpha2PodSchedulingContext> patchNamespacedPodSchedulingContextStatusWithHttpInfo(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) throws ApiException {
        Call localVarCall = this.patchNamespacedPodSchedulingContextStatusValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, null);
        Type localVarReturnType = new TypeToken<V1alpha2PodSchedulingContext>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call patchNamespacedPodSchedulingContextStatusAsync(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback<V1alpha2PodSchedulingContext> _callback) throws ApiException {
        Call localVarCall = this.patchNamespacedPodSchedulingContextStatusValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
        Type localVarReturnType = new TypeToken<V1alpha2PodSchedulingContext>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIpatchNamespacedPodSchedulingContextStatusRequest patchNamespacedPodSchedulingContextStatus(String name, String namespace, V1Patch body) {
        return new APIpatchNamespacedPodSchedulingContextStatusRequest(name, namespace, body);
    }

    private Call patchNamespacedResourceClaimCall(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1Patch localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1alpha2/namespaces/{namespace}/resourceclaims/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchNamespacedResourceClaimValidateBeforeCall(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchNamespacedResourceClaim(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling patchNamespacedResourceClaim(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchNamespacedResourceClaim(Async)");
        }
        return this.patchNamespacedResourceClaimCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
    }

    private ApiResponse<V1alpha2ResourceClaim> patchNamespacedResourceClaimWithHttpInfo(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) throws ApiException {
        Call localVarCall = this.patchNamespacedResourceClaimValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, null);
        Type localVarReturnType = new TypeToken<V1alpha2ResourceClaim>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call patchNamespacedResourceClaimAsync(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback<V1alpha2ResourceClaim> _callback) throws ApiException {
        Call localVarCall = this.patchNamespacedResourceClaimValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
        Type localVarReturnType = new TypeToken<V1alpha2ResourceClaim>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIpatchNamespacedResourceClaimRequest patchNamespacedResourceClaim(String name, String namespace, V1Patch body) {
        return new APIpatchNamespacedResourceClaimRequest(name, namespace, body);
    }

    private Call patchNamespacedResourceClaimStatusCall(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1Patch localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1alpha2/namespaces/{namespace}/resourceclaims/{name}/status".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchNamespacedResourceClaimStatusValidateBeforeCall(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchNamespacedResourceClaimStatus(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling patchNamespacedResourceClaimStatus(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchNamespacedResourceClaimStatus(Async)");
        }
        return this.patchNamespacedResourceClaimStatusCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
    }

    private ApiResponse<V1alpha2ResourceClaim> patchNamespacedResourceClaimStatusWithHttpInfo(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) throws ApiException {
        Call localVarCall = this.patchNamespacedResourceClaimStatusValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, null);
        Type localVarReturnType = new TypeToken<V1alpha2ResourceClaim>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call patchNamespacedResourceClaimStatusAsync(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback<V1alpha2ResourceClaim> _callback) throws ApiException {
        Call localVarCall = this.patchNamespacedResourceClaimStatusValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
        Type localVarReturnType = new TypeToken<V1alpha2ResourceClaim>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIpatchNamespacedResourceClaimStatusRequest patchNamespacedResourceClaimStatus(String name, String namespace, V1Patch body) {
        return new APIpatchNamespacedResourceClaimStatusRequest(name, namespace, body);
    }

    private Call patchNamespacedResourceClaimTemplateCall(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1Patch localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1alpha2/namespaces/{namespace}/resourceclaimtemplates/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchNamespacedResourceClaimTemplateValidateBeforeCall(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchNamespacedResourceClaimTemplate(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling patchNamespacedResourceClaimTemplate(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchNamespacedResourceClaimTemplate(Async)");
        }
        return this.patchNamespacedResourceClaimTemplateCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
    }

    private ApiResponse<V1alpha2ResourceClaimTemplate> patchNamespacedResourceClaimTemplateWithHttpInfo(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) throws ApiException {
        Call localVarCall = this.patchNamespacedResourceClaimTemplateValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, null);
        Type localVarReturnType = new TypeToken<V1alpha2ResourceClaimTemplate>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call patchNamespacedResourceClaimTemplateAsync(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback<V1alpha2ResourceClaimTemplate> _callback) throws ApiException {
        Call localVarCall = this.patchNamespacedResourceClaimTemplateValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
        Type localVarReturnType = new TypeToken<V1alpha2ResourceClaimTemplate>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIpatchNamespacedResourceClaimTemplateRequest patchNamespacedResourceClaimTemplate(String name, String namespace, V1Patch body) {
        return new APIpatchNamespacedResourceClaimTemplateRequest(name, namespace, body);
    }

    private Call patchResourceClassCall(String name, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1Patch localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1alpha2/resourceclasses/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchResourceClassValidateBeforeCall(String name, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchResourceClass(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchResourceClass(Async)");
        }
        return this.patchResourceClassCall(name, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
    }

    private ApiResponse<V1alpha2ResourceClass> patchResourceClassWithHttpInfo(String name, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) throws ApiException {
        Call localVarCall = this.patchResourceClassValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, force, null);
        Type localVarReturnType = new TypeToken<V1alpha2ResourceClass>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call patchResourceClassAsync(String name, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback<V1alpha2ResourceClass> _callback) throws ApiException {
        Call localVarCall = this.patchResourceClassValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
        Type localVarReturnType = new TypeToken<V1alpha2ResourceClass>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIpatchResourceClassRequest patchResourceClass(String name, V1Patch body) {
        return new APIpatchResourceClassRequest(name, body);
    }

    private Call readNamespacedPodSchedulingContextCall(String name, String namespace, String pretty, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/resource.k8s.io/v1alpha2/namespaces/{namespace}/podschedulingcontexts/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readNamespacedPodSchedulingContextValidateBeforeCall(String name, String namespace, String pretty, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readNamespacedPodSchedulingContext(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling readNamespacedPodSchedulingContext(Async)");
        }
        return this.readNamespacedPodSchedulingContextCall(name, namespace, pretty, _callback);
    }

    private ApiResponse<V1alpha2PodSchedulingContext> readNamespacedPodSchedulingContextWithHttpInfo(String name, String namespace, String pretty) throws ApiException {
        Call localVarCall = this.readNamespacedPodSchedulingContextValidateBeforeCall(name, namespace, pretty, null);
        Type localVarReturnType = new TypeToken<V1alpha2PodSchedulingContext>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call readNamespacedPodSchedulingContextAsync(String name, String namespace, String pretty, ApiCallback<V1alpha2PodSchedulingContext> _callback) throws ApiException {
        Call localVarCall = this.readNamespacedPodSchedulingContextValidateBeforeCall(name, namespace, pretty, _callback);
        Type localVarReturnType = new TypeToken<V1alpha2PodSchedulingContext>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreadNamespacedPodSchedulingContextRequest readNamespacedPodSchedulingContext(String name, String namespace) {
        return new APIreadNamespacedPodSchedulingContextRequest(name, namespace);
    }

    private Call readNamespacedPodSchedulingContextStatusCall(String name, String namespace, String pretty, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/resource.k8s.io/v1alpha2/namespaces/{namespace}/podschedulingcontexts/{name}/status".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readNamespacedPodSchedulingContextStatusValidateBeforeCall(String name, String namespace, String pretty, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readNamespacedPodSchedulingContextStatus(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling readNamespacedPodSchedulingContextStatus(Async)");
        }
        return this.readNamespacedPodSchedulingContextStatusCall(name, namespace, pretty, _callback);
    }

    private ApiResponse<V1alpha2PodSchedulingContext> readNamespacedPodSchedulingContextStatusWithHttpInfo(String name, String namespace, String pretty) throws ApiException {
        Call localVarCall = this.readNamespacedPodSchedulingContextStatusValidateBeforeCall(name, namespace, pretty, null);
        Type localVarReturnType = new TypeToken<V1alpha2PodSchedulingContext>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call readNamespacedPodSchedulingContextStatusAsync(String name, String namespace, String pretty, ApiCallback<V1alpha2PodSchedulingContext> _callback) throws ApiException {
        Call localVarCall = this.readNamespacedPodSchedulingContextStatusValidateBeforeCall(name, namespace, pretty, _callback);
        Type localVarReturnType = new TypeToken<V1alpha2PodSchedulingContext>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreadNamespacedPodSchedulingContextStatusRequest readNamespacedPodSchedulingContextStatus(String name, String namespace) {
        return new APIreadNamespacedPodSchedulingContextStatusRequest(name, namespace);
    }

    private Call readNamespacedResourceClaimCall(String name, String namespace, String pretty, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/resource.k8s.io/v1alpha2/namespaces/{namespace}/resourceclaims/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readNamespacedResourceClaimValidateBeforeCall(String name, String namespace, String pretty, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readNamespacedResourceClaim(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling readNamespacedResourceClaim(Async)");
        }
        return this.readNamespacedResourceClaimCall(name, namespace, pretty, _callback);
    }

    private ApiResponse<V1alpha2ResourceClaim> readNamespacedResourceClaimWithHttpInfo(String name, String namespace, String pretty) throws ApiException {
        Call localVarCall = this.readNamespacedResourceClaimValidateBeforeCall(name, namespace, pretty, null);
        Type localVarReturnType = new TypeToken<V1alpha2ResourceClaim>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call readNamespacedResourceClaimAsync(String name, String namespace, String pretty, ApiCallback<V1alpha2ResourceClaim> _callback) throws ApiException {
        Call localVarCall = this.readNamespacedResourceClaimValidateBeforeCall(name, namespace, pretty, _callback);
        Type localVarReturnType = new TypeToken<V1alpha2ResourceClaim>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreadNamespacedResourceClaimRequest readNamespacedResourceClaim(String name, String namespace) {
        return new APIreadNamespacedResourceClaimRequest(name, namespace);
    }

    private Call readNamespacedResourceClaimStatusCall(String name, String namespace, String pretty, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/resource.k8s.io/v1alpha2/namespaces/{namespace}/resourceclaims/{name}/status".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readNamespacedResourceClaimStatusValidateBeforeCall(String name, String namespace, String pretty, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readNamespacedResourceClaimStatus(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling readNamespacedResourceClaimStatus(Async)");
        }
        return this.readNamespacedResourceClaimStatusCall(name, namespace, pretty, _callback);
    }

    private ApiResponse<V1alpha2ResourceClaim> readNamespacedResourceClaimStatusWithHttpInfo(String name, String namespace, String pretty) throws ApiException {
        Call localVarCall = this.readNamespacedResourceClaimStatusValidateBeforeCall(name, namespace, pretty, null);
        Type localVarReturnType = new TypeToken<V1alpha2ResourceClaim>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call readNamespacedResourceClaimStatusAsync(String name, String namespace, String pretty, ApiCallback<V1alpha2ResourceClaim> _callback) throws ApiException {
        Call localVarCall = this.readNamespacedResourceClaimStatusValidateBeforeCall(name, namespace, pretty, _callback);
        Type localVarReturnType = new TypeToken<V1alpha2ResourceClaim>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreadNamespacedResourceClaimStatusRequest readNamespacedResourceClaimStatus(String name, String namespace) {
        return new APIreadNamespacedResourceClaimStatusRequest(name, namespace);
    }

    private Call readNamespacedResourceClaimTemplateCall(String name, String namespace, String pretty, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/resource.k8s.io/v1alpha2/namespaces/{namespace}/resourceclaimtemplates/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readNamespacedResourceClaimTemplateValidateBeforeCall(String name, String namespace, String pretty, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readNamespacedResourceClaimTemplate(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling readNamespacedResourceClaimTemplate(Async)");
        }
        return this.readNamespacedResourceClaimTemplateCall(name, namespace, pretty, _callback);
    }

    private ApiResponse<V1alpha2ResourceClaimTemplate> readNamespacedResourceClaimTemplateWithHttpInfo(String name, String namespace, String pretty) throws ApiException {
        Call localVarCall = this.readNamespacedResourceClaimTemplateValidateBeforeCall(name, namespace, pretty, null);
        Type localVarReturnType = new TypeToken<V1alpha2ResourceClaimTemplate>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call readNamespacedResourceClaimTemplateAsync(String name, String namespace, String pretty, ApiCallback<V1alpha2ResourceClaimTemplate> _callback) throws ApiException {
        Call localVarCall = this.readNamespacedResourceClaimTemplateValidateBeforeCall(name, namespace, pretty, _callback);
        Type localVarReturnType = new TypeToken<V1alpha2ResourceClaimTemplate>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreadNamespacedResourceClaimTemplateRequest readNamespacedResourceClaimTemplate(String name, String namespace) {
        return new APIreadNamespacedResourceClaimTemplateRequest(name, namespace);
    }

    private Call readResourceClassCall(String name, String pretty, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/resource.k8s.io/v1alpha2/resourceclasses/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readResourceClassValidateBeforeCall(String name, String pretty, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readResourceClass(Async)");
        }
        return this.readResourceClassCall(name, pretty, _callback);
    }

    private ApiResponse<V1alpha2ResourceClass> readResourceClassWithHttpInfo(String name, String pretty) throws ApiException {
        Call localVarCall = this.readResourceClassValidateBeforeCall(name, pretty, null);
        Type localVarReturnType = new TypeToken<V1alpha2ResourceClass>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call readResourceClassAsync(String name, String pretty, ApiCallback<V1alpha2ResourceClass> _callback) throws ApiException {
        Call localVarCall = this.readResourceClassValidateBeforeCall(name, pretty, _callback);
        Type localVarReturnType = new TypeToken<V1alpha2ResourceClass>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreadResourceClassRequest readResourceClass(String name) {
        return new APIreadResourceClassRequest(name);
    }

    private Call replaceNamespacedPodSchedulingContextCall(String name, String namespace, V1alpha2PodSchedulingContext body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1alpha2PodSchedulingContext localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1alpha2/namespaces/{namespace}/podschedulingcontexts/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceNamespacedPodSchedulingContextValidateBeforeCall(String name, String namespace, V1alpha2PodSchedulingContext body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceNamespacedPodSchedulingContext(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling replaceNamespacedPodSchedulingContext(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceNamespacedPodSchedulingContext(Async)");
        }
        return this.replaceNamespacedPodSchedulingContextCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
    }

    private ApiResponse<V1alpha2PodSchedulingContext> replaceNamespacedPodSchedulingContextWithHttpInfo(String name, String namespace, V1alpha2PodSchedulingContext body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        Call localVarCall = this.replaceNamespacedPodSchedulingContextValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1alpha2PodSchedulingContext>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call replaceNamespacedPodSchedulingContextAsync(String name, String namespace, V1alpha2PodSchedulingContext body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback<V1alpha2PodSchedulingContext> _callback) throws ApiException {
        Call localVarCall = this.replaceNamespacedPodSchedulingContextValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1alpha2PodSchedulingContext>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreplaceNamespacedPodSchedulingContextRequest replaceNamespacedPodSchedulingContext(String name, String namespace, V1alpha2PodSchedulingContext body) {
        return new APIreplaceNamespacedPodSchedulingContextRequest(name, namespace, body);
    }

    private Call replaceNamespacedPodSchedulingContextStatusCall(String name, String namespace, V1alpha2PodSchedulingContext body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1alpha2PodSchedulingContext localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1alpha2/namespaces/{namespace}/podschedulingcontexts/{name}/status".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceNamespacedPodSchedulingContextStatusValidateBeforeCall(String name, String namespace, V1alpha2PodSchedulingContext body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceNamespacedPodSchedulingContextStatus(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling replaceNamespacedPodSchedulingContextStatus(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceNamespacedPodSchedulingContextStatus(Async)");
        }
        return this.replaceNamespacedPodSchedulingContextStatusCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
    }

    private ApiResponse<V1alpha2PodSchedulingContext> replaceNamespacedPodSchedulingContextStatusWithHttpInfo(String name, String namespace, V1alpha2PodSchedulingContext body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        Call localVarCall = this.replaceNamespacedPodSchedulingContextStatusValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1alpha2PodSchedulingContext>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call replaceNamespacedPodSchedulingContextStatusAsync(String name, String namespace, V1alpha2PodSchedulingContext body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback<V1alpha2PodSchedulingContext> _callback) throws ApiException {
        Call localVarCall = this.replaceNamespacedPodSchedulingContextStatusValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1alpha2PodSchedulingContext>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreplaceNamespacedPodSchedulingContextStatusRequest replaceNamespacedPodSchedulingContextStatus(String name, String namespace, V1alpha2PodSchedulingContext body) {
        return new APIreplaceNamespacedPodSchedulingContextStatusRequest(name, namespace, body);
    }

    private Call replaceNamespacedResourceClaimCall(String name, String namespace, V1alpha2ResourceClaim body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1alpha2ResourceClaim localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1alpha2/namespaces/{namespace}/resourceclaims/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceNamespacedResourceClaimValidateBeforeCall(String name, String namespace, V1alpha2ResourceClaim body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceNamespacedResourceClaim(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling replaceNamespacedResourceClaim(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceNamespacedResourceClaim(Async)");
        }
        return this.replaceNamespacedResourceClaimCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
    }

    private ApiResponse<V1alpha2ResourceClaim> replaceNamespacedResourceClaimWithHttpInfo(String name, String namespace, V1alpha2ResourceClaim body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        Call localVarCall = this.replaceNamespacedResourceClaimValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1alpha2ResourceClaim>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call replaceNamespacedResourceClaimAsync(String name, String namespace, V1alpha2ResourceClaim body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback<V1alpha2ResourceClaim> _callback) throws ApiException {
        Call localVarCall = this.replaceNamespacedResourceClaimValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1alpha2ResourceClaim>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreplaceNamespacedResourceClaimRequest replaceNamespacedResourceClaim(String name, String namespace, V1alpha2ResourceClaim body) {
        return new APIreplaceNamespacedResourceClaimRequest(name, namespace, body);
    }

    private Call replaceNamespacedResourceClaimStatusCall(String name, String namespace, V1alpha2ResourceClaim body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1alpha2ResourceClaim localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1alpha2/namespaces/{namespace}/resourceclaims/{name}/status".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceNamespacedResourceClaimStatusValidateBeforeCall(String name, String namespace, V1alpha2ResourceClaim body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceNamespacedResourceClaimStatus(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling replaceNamespacedResourceClaimStatus(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceNamespacedResourceClaimStatus(Async)");
        }
        return this.replaceNamespacedResourceClaimStatusCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
    }

    private ApiResponse<V1alpha2ResourceClaim> replaceNamespacedResourceClaimStatusWithHttpInfo(String name, String namespace, V1alpha2ResourceClaim body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        Call localVarCall = this.replaceNamespacedResourceClaimStatusValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1alpha2ResourceClaim>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call replaceNamespacedResourceClaimStatusAsync(String name, String namespace, V1alpha2ResourceClaim body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback<V1alpha2ResourceClaim> _callback) throws ApiException {
        Call localVarCall = this.replaceNamespacedResourceClaimStatusValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1alpha2ResourceClaim>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreplaceNamespacedResourceClaimStatusRequest replaceNamespacedResourceClaimStatus(String name, String namespace, V1alpha2ResourceClaim body) {
        return new APIreplaceNamespacedResourceClaimStatusRequest(name, namespace, body);
    }

    private Call replaceNamespacedResourceClaimTemplateCall(String name, String namespace, V1alpha2ResourceClaimTemplate body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1alpha2ResourceClaimTemplate localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1alpha2/namespaces/{namespace}/resourceclaimtemplates/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{namespace}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceNamespacedResourceClaimTemplateValidateBeforeCall(String name, String namespace, V1alpha2ResourceClaimTemplate body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceNamespacedResourceClaimTemplate(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling replaceNamespacedResourceClaimTemplate(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceNamespacedResourceClaimTemplate(Async)");
        }
        return this.replaceNamespacedResourceClaimTemplateCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
    }

    private ApiResponse<V1alpha2ResourceClaimTemplate> replaceNamespacedResourceClaimTemplateWithHttpInfo(String name, String namespace, V1alpha2ResourceClaimTemplate body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        Call localVarCall = this.replaceNamespacedResourceClaimTemplateValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1alpha2ResourceClaimTemplate>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call replaceNamespacedResourceClaimTemplateAsync(String name, String namespace, V1alpha2ResourceClaimTemplate body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback<V1alpha2ResourceClaimTemplate> _callback) throws ApiException {
        Call localVarCall = this.replaceNamespacedResourceClaimTemplateValidateBeforeCall(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1alpha2ResourceClaimTemplate>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreplaceNamespacedResourceClaimTemplateRequest replaceNamespacedResourceClaimTemplate(String name, String namespace, V1alpha2ResourceClaimTemplate body) {
        return new APIreplaceNamespacedResourceClaimTemplateRequest(name, namespace, body);
    }

    private Call replaceResourceClassCall(String name, V1alpha2ResourceClass body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1alpha2ResourceClass localVarPostBody = body;
        String localVarPath = "/apis/resource.k8s.io/v1alpha2/resourceclasses/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceResourceClassValidateBeforeCall(String name, V1alpha2ResourceClass body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceResourceClass(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceResourceClass(Async)");
        }
        return this.replaceResourceClassCall(name, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
    }

    private ApiResponse<V1alpha2ResourceClass> replaceResourceClassWithHttpInfo(String name, V1alpha2ResourceClass body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        Call localVarCall = this.replaceResourceClassValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1alpha2ResourceClass>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call replaceResourceClassAsync(String name, V1alpha2ResourceClass body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback<V1alpha2ResourceClass> _callback) throws ApiException {
        Call localVarCall = this.replaceResourceClassValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1alpha2ResourceClass>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreplaceResourceClassRequest replaceResourceClass(String name, V1alpha2ResourceClass body) {
        return new APIreplaceResourceClassRequest(name, body);
    }

    public class APIcreateNamespacedPodSchedulingContextRequest {
        private final String namespace;
        private final V1alpha2PodSchedulingContext body;
        private String pretty;
        private String dryRun;
        private String fieldManager;
        private String fieldValidation;

        private APIcreateNamespacedPodSchedulingContextRequest(String namespace, V1alpha2PodSchedulingContext body) {
            this.namespace = namespace;
            this.body = body;
        }

        public APIcreateNamespacedPodSchedulingContextRequest pretty(String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIcreateNamespacedPodSchedulingContextRequest dryRun(String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIcreateNamespacedPodSchedulingContextRequest fieldManager(String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIcreateNamespacedPodSchedulingContextRequest fieldValidation(String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1alpha2Api.this.createNamespacedPodSchedulingContextCall(this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }

        public V1alpha2PodSchedulingContext execute() throws ApiException {
            ApiResponse localVarResp = ResourceV1alpha2Api.this.createNamespacedPodSchedulingContextWithHttpInfo(this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
            return (V1alpha2PodSchedulingContext)localVarResp.getData();
        }

        public ApiResponse<V1alpha2PodSchedulingContext> executeWithHttpInfo() throws ApiException {
            return ResourceV1alpha2Api.this.createNamespacedPodSchedulingContextWithHttpInfo(this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
        }

        public Call executeAsync(ApiCallback<V1alpha2PodSchedulingContext> _callback) throws ApiException {
            return ResourceV1alpha2Api.this.createNamespacedPodSchedulingContextAsync(this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }
    }

    public class APIcreateNamespacedResourceClaimRequest {
        private final String namespace;
        private final V1alpha2ResourceClaim body;
        private String pretty;
        private String dryRun;
        private String fieldManager;
        private String fieldValidation;

        private APIcreateNamespacedResourceClaimRequest(String namespace, V1alpha2ResourceClaim body) {
            this.namespace = namespace;
            this.body = body;
        }

        public APIcreateNamespacedResourceClaimRequest pretty(String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIcreateNamespacedResourceClaimRequest dryRun(String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIcreateNamespacedResourceClaimRequest fieldManager(String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIcreateNamespacedResourceClaimRequest fieldValidation(String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1alpha2Api.this.createNamespacedResourceClaimCall(this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }

        public V1alpha2ResourceClaim execute() throws ApiException {
            ApiResponse localVarResp = ResourceV1alpha2Api.this.createNamespacedResourceClaimWithHttpInfo(this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
            return (V1alpha2ResourceClaim)localVarResp.getData();
        }

        public ApiResponse<V1alpha2ResourceClaim> executeWithHttpInfo() throws ApiException {
            return ResourceV1alpha2Api.this.createNamespacedResourceClaimWithHttpInfo(this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
        }

        public Call executeAsync(ApiCallback<V1alpha2ResourceClaim> _callback) throws ApiException {
            return ResourceV1alpha2Api.this.createNamespacedResourceClaimAsync(this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }
    }

    public class APIcreateNamespacedResourceClaimTemplateRequest {
        private final String namespace;
        private final V1alpha2ResourceClaimTemplate body;
        private String pretty;
        private String dryRun;
        private String fieldManager;
        private String fieldValidation;

        private APIcreateNamespacedResourceClaimTemplateRequest(String namespace, V1alpha2ResourceClaimTemplate body) {
            this.namespace = namespace;
            this.body = body;
        }

        public APIcreateNamespacedResourceClaimTemplateRequest pretty(String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIcreateNamespacedResourceClaimTemplateRequest dryRun(String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIcreateNamespacedResourceClaimTemplateRequest fieldManager(String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIcreateNamespacedResourceClaimTemplateRequest fieldValidation(String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1alpha2Api.this.createNamespacedResourceClaimTemplateCall(this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }

        public V1alpha2ResourceClaimTemplate execute() throws ApiException {
            ApiResponse localVarResp = ResourceV1alpha2Api.this.createNamespacedResourceClaimTemplateWithHttpInfo(this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
            return (V1alpha2ResourceClaimTemplate)localVarResp.getData();
        }

        public ApiResponse<V1alpha2ResourceClaimTemplate> executeWithHttpInfo() throws ApiException {
            return ResourceV1alpha2Api.this.createNamespacedResourceClaimTemplateWithHttpInfo(this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
        }

        public Call executeAsync(ApiCallback<V1alpha2ResourceClaimTemplate> _callback) throws ApiException {
            return ResourceV1alpha2Api.this.createNamespacedResourceClaimTemplateAsync(this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }
    }

    public class APIcreateResourceClassRequest {
        private final V1alpha2ResourceClass body;
        private String pretty;
        private String dryRun;
        private String fieldManager;
        private String fieldValidation;

        private APIcreateResourceClassRequest(V1alpha2ResourceClass body) {
            this.body = body;
        }

        public APIcreateResourceClassRequest pretty(String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIcreateResourceClassRequest dryRun(String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIcreateResourceClassRequest fieldManager(String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIcreateResourceClassRequest fieldValidation(String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1alpha2Api.this.createResourceClassCall(this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }

        public V1alpha2ResourceClass execute() throws ApiException {
            ApiResponse localVarResp = ResourceV1alpha2Api.this.createResourceClassWithHttpInfo(this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
            return (V1alpha2ResourceClass)localVarResp.getData();
        }

        public ApiResponse<V1alpha2ResourceClass> executeWithHttpInfo() throws ApiException {
            return ResourceV1alpha2Api.this.createResourceClassWithHttpInfo(this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
        }

        public Call executeAsync(ApiCallback<V1alpha2ResourceClass> _callback) throws ApiException {
            return ResourceV1alpha2Api.this.createResourceClassAsync(this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }
    }

    public class APIdeleteCollectionNamespacedPodSchedulingContextRequest {
        private final String namespace;
        private String pretty;
        private String _continue;
        private String dryRun;
        private String fieldSelector;
        private Integer gracePeriodSeconds;
        private String labelSelector;
        private Integer limit;
        private Boolean orphanDependents;
        private String propagationPolicy;
        private String resourceVersion;
        private String resourceVersionMatch;
        private Boolean sendInitialEvents;
        private Integer timeoutSeconds;
        private V1DeleteOptions body;

        private APIdeleteCollectionNamespacedPodSchedulingContextRequest(String namespace) {
            this.namespace = namespace;
        }

        public APIdeleteCollectionNamespacedPodSchedulingContextRequest pretty(String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIdeleteCollectionNamespacedPodSchedulingContextRequest _continue(String _continue) {
            this._continue = _continue;
            return this;
        }

        public APIdeleteCollectionNamespacedPodSchedulingContextRequest dryRun(String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIdeleteCollectionNamespacedPodSchedulingContextRequest fieldSelector(String fieldSelector) {
            this.fieldSelector = fieldSelector;
            return this;
        }

        public APIdeleteCollectionNamespacedPodSchedulingContextRequest gracePeriodSeconds(Integer gracePeriodSeconds) {
            this.gracePeriodSeconds = gracePeriodSeconds;
            return this;
        }

        public APIdeleteCollectionNamespacedPodSchedulingContextRequest labelSelector(String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public APIdeleteCollectionNamespacedPodSchedulingContextRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIdeleteCollectionNamespacedPodSchedulingContextRequest orphanDependents(Boolean orphanDependents) {
            this.orphanDependents = orphanDependents;
            return this;
        }

        public APIdeleteCollectionNamespacedPodSchedulingContextRequest propagationPolicy(String propagationPolicy) {
            this.propagationPolicy = propagationPolicy;
            return this;
        }

        public APIdeleteCollectionNamespacedPodSchedulingContextRequest resourceVersion(String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        public APIdeleteCollectionNamespacedPodSchedulingContextRequest resourceVersionMatch(String resourceVersionMatch) {
            this.resourceVersionMatch = resourceVersionMatch;
            return this;
        }

        public APIdeleteCollectionNamespacedPodSchedulingContextRequest sendInitialEvents(Boolean sendInitialEvents) {
            this.sendInitialEvents = sendInitialEvents;
            return this;
        }

        public APIdeleteCollectionNamespacedPodSchedulingContextRequest timeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public APIdeleteCollectionNamespacedPodSchedulingContextRequest body(V1DeleteOptions body) {
            this.body = body;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1alpha2Api.this.deleteCollectionNamespacedPodSchedulingContextCall(this.namespace, this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body, _callback);
        }

        public V1Status execute() throws ApiException {
            ApiResponse localVarResp = ResourceV1alpha2Api.this.deleteCollectionNamespacedPodSchedulingContextWithHttpInfo(this.namespace, this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body);
            return (V1Status)localVarResp.getData();
        }

        public ApiResponse<V1Status> executeWithHttpInfo() throws ApiException {
            return ResourceV1alpha2Api.this.deleteCollectionNamespacedPodSchedulingContextWithHttpInfo(this.namespace, this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body);
        }

        public Call executeAsync(ApiCallback<V1Status> _callback) throws ApiException {
            return ResourceV1alpha2Api.this.deleteCollectionNamespacedPodSchedulingContextAsync(this.namespace, this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body, _callback);
        }
    }

    public class APIdeleteCollectionNamespacedResourceClaimRequest {
        private final String namespace;
        private String pretty;
        private String _continue;
        private String dryRun;
        private String fieldSelector;
        private Integer gracePeriodSeconds;
        private String labelSelector;
        private Integer limit;
        private Boolean orphanDependents;
        private String propagationPolicy;
        private String resourceVersion;
        private String resourceVersionMatch;
        private Boolean sendInitialEvents;
        private Integer timeoutSeconds;
        private V1DeleteOptions body;

        private APIdeleteCollectionNamespacedResourceClaimRequest(String namespace) {
            this.namespace = namespace;
        }

        public APIdeleteCollectionNamespacedResourceClaimRequest pretty(String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimRequest _continue(String _continue) {
            this._continue = _continue;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimRequest dryRun(String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimRequest fieldSelector(String fieldSelector) {
            this.fieldSelector = fieldSelector;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimRequest gracePeriodSeconds(Integer gracePeriodSeconds) {
            this.gracePeriodSeconds = gracePeriodSeconds;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimRequest labelSelector(String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimRequest orphanDependents(Boolean orphanDependents) {
            this.orphanDependents = orphanDependents;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimRequest propagationPolicy(String propagationPolicy) {
            this.propagationPolicy = propagationPolicy;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimRequest resourceVersion(String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimRequest resourceVersionMatch(String resourceVersionMatch) {
            this.resourceVersionMatch = resourceVersionMatch;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimRequest sendInitialEvents(Boolean sendInitialEvents) {
            this.sendInitialEvents = sendInitialEvents;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimRequest timeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimRequest body(V1DeleteOptions body) {
            this.body = body;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1alpha2Api.this.deleteCollectionNamespacedResourceClaimCall(this.namespace, this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body, _callback);
        }

        public V1Status execute() throws ApiException {
            ApiResponse localVarResp = ResourceV1alpha2Api.this.deleteCollectionNamespacedResourceClaimWithHttpInfo(this.namespace, this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body);
            return (V1Status)localVarResp.getData();
        }

        public ApiResponse<V1Status> executeWithHttpInfo() throws ApiException {
            return ResourceV1alpha2Api.this.deleteCollectionNamespacedResourceClaimWithHttpInfo(this.namespace, this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body);
        }

        public Call executeAsync(ApiCallback<V1Status> _callback) throws ApiException {
            return ResourceV1alpha2Api.this.deleteCollectionNamespacedResourceClaimAsync(this.namespace, this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body, _callback);
        }
    }

    public class APIdeleteCollectionNamespacedResourceClaimTemplateRequest {
        private final String namespace;
        private String pretty;
        private String _continue;
        private String dryRun;
        private String fieldSelector;
        private Integer gracePeriodSeconds;
        private String labelSelector;
        private Integer limit;
        private Boolean orphanDependents;
        private String propagationPolicy;
        private String resourceVersion;
        private String resourceVersionMatch;
        private Boolean sendInitialEvents;
        private Integer timeoutSeconds;
        private V1DeleteOptions body;

        private APIdeleteCollectionNamespacedResourceClaimTemplateRequest(String namespace) {
            this.namespace = namespace;
        }

        public APIdeleteCollectionNamespacedResourceClaimTemplateRequest pretty(String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimTemplateRequest _continue(String _continue) {
            this._continue = _continue;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimTemplateRequest dryRun(String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimTemplateRequest fieldSelector(String fieldSelector) {
            this.fieldSelector = fieldSelector;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimTemplateRequest gracePeriodSeconds(Integer gracePeriodSeconds) {
            this.gracePeriodSeconds = gracePeriodSeconds;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimTemplateRequest labelSelector(String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimTemplateRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimTemplateRequest orphanDependents(Boolean orphanDependents) {
            this.orphanDependents = orphanDependents;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimTemplateRequest propagationPolicy(String propagationPolicy) {
            this.propagationPolicy = propagationPolicy;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimTemplateRequest resourceVersion(String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimTemplateRequest resourceVersionMatch(String resourceVersionMatch) {
            this.resourceVersionMatch = resourceVersionMatch;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimTemplateRequest sendInitialEvents(Boolean sendInitialEvents) {
            this.sendInitialEvents = sendInitialEvents;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimTemplateRequest timeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public APIdeleteCollectionNamespacedResourceClaimTemplateRequest body(V1DeleteOptions body) {
            this.body = body;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1alpha2Api.this.deleteCollectionNamespacedResourceClaimTemplateCall(this.namespace, this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body, _callback);
        }

        public V1Status execute() throws ApiException {
            ApiResponse localVarResp = ResourceV1alpha2Api.this.deleteCollectionNamespacedResourceClaimTemplateWithHttpInfo(this.namespace, this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body);
            return (V1Status)localVarResp.getData();
        }

        public ApiResponse<V1Status> executeWithHttpInfo() throws ApiException {
            return ResourceV1alpha2Api.this.deleteCollectionNamespacedResourceClaimTemplateWithHttpInfo(this.namespace, this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body);
        }

        public Call executeAsync(ApiCallback<V1Status> _callback) throws ApiException {
            return ResourceV1alpha2Api.this.deleteCollectionNamespacedResourceClaimTemplateAsync(this.namespace, this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body, _callback);
        }
    }

    public class APIdeleteCollectionResourceClassRequest {
        private String pretty;
        private String _continue;
        private String dryRun;
        private String fieldSelector;
        private Integer gracePeriodSeconds;
        private String labelSelector;
        private Integer limit;
        private Boolean orphanDependents;
        private String propagationPolicy;
        private String resourceVersion;
        private String resourceVersionMatch;
        private Boolean sendInitialEvents;
        private Integer timeoutSeconds;
        private V1DeleteOptions body;

        private APIdeleteCollectionResourceClassRequest() {
        }

        public APIdeleteCollectionResourceClassRequest pretty(String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIdeleteCollectionResourceClassRequest _continue(String _continue) {
            this._continue = _continue;
            return this;
        }

        public APIdeleteCollectionResourceClassRequest dryRun(String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIdeleteCollectionResourceClassRequest fieldSelector(String fieldSelector) {
            this.fieldSelector = fieldSelector;
            return this;
        }

        public APIdeleteCollectionResourceClassRequest gracePeriodSeconds(Integer gracePeriodSeconds) {
            this.gracePeriodSeconds = gracePeriodSeconds;
            return this;
        }

        public APIdeleteCollectionResourceClassRequest labelSelector(String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public APIdeleteCollectionResourceClassRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIdeleteCollectionResourceClassRequest orphanDependents(Boolean orphanDependents) {
            this.orphanDependents = orphanDependents;
            return this;
        }

        public APIdeleteCollectionResourceClassRequest propagationPolicy(String propagationPolicy) {
            this.propagationPolicy = propagationPolicy;
            return this;
        }

        public APIdeleteCollectionResourceClassRequest resourceVersion(String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        public APIdeleteCollectionResourceClassRequest resourceVersionMatch(String resourceVersionMatch) {
            this.resourceVersionMatch = resourceVersionMatch;
            return this;
        }

        public APIdeleteCollectionResourceClassRequest sendInitialEvents(Boolean sendInitialEvents) {
            this.sendInitialEvents = sendInitialEvents;
            return this;
        }

        public APIdeleteCollectionResourceClassRequest timeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public APIdeleteCollectionResourceClassRequest body(V1DeleteOptions body) {
            this.body = body;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1alpha2Api.this.deleteCollectionResourceClassCall(this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body, _callback);
        }

        public V1Status execute() throws ApiException {
            ApiResponse localVarResp = ResourceV1alpha2Api.this.deleteCollectionResourceClassWithHttpInfo(this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body);
            return (V1Status)localVarResp.getData();
        }

        public ApiResponse<V1Status> executeWithHttpInfo() throws ApiException {
            return ResourceV1alpha2Api.this.deleteCollectionResourceClassWithHttpInfo(this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body);
        }

        public Call executeAsync(ApiCallback<V1Status> _callback) throws ApiException {
            return ResourceV1alpha2Api.this.deleteCollectionResourceClassAsync(this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body, _callback);
        }
    }

    public class APIdeleteNamespacedPodSchedulingContextRequest {
        private final String name;
        private final String namespace;
        private String pretty;
        private String dryRun;
        private Integer gracePeriodSeconds;
        private Boolean orphanDependents;
        private String propagationPolicy;
        private V1DeleteOptions body;

        private APIdeleteNamespacedPodSchedulingContextRequest(String name, String namespace) {
            this.name = name;
            this.namespace = namespace;
        }

        public APIdeleteNamespacedPodSchedulingContextRequest pretty(String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIdeleteNamespacedPodSchedulingContextRequest dryRun(String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIdeleteNamespacedPodSchedulingContextRequest gracePeriodSeconds(Integer gracePeriodSeconds) {
            this.gracePeriodSeconds = gracePeriodSeconds;
            return this;
        }

        public APIdeleteNamespacedPodSchedulingContextRequest orphanDependents(Boolean orphanDependents) {
            this.orphanDependents = orphanDependents;
            return this;
        }

        public APIdeleteNamespacedPodSchedulingContextRequest propagationPolicy(String propagationPolicy) {
            this.propagationPolicy = propagationPolicy;
            return this;
        }

        public APIdeleteNamespacedPodSchedulingContextRequest body(V1DeleteOptions body) {
            this.body = body;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1alpha2Api.this.deleteNamespacedPodSchedulingContextCall(this.name, this.namespace, this.pretty, this.dryRun, this.gracePeriodSeconds, this.orphanDependents, this.propagationPolicy, this.body, _callback);
        }

        public V1alpha2PodSchedulingContext execute() throws ApiException {
            ApiResponse localVarResp = ResourceV1alpha2Api.this.deleteNamespacedPodSchedulingContextWithHttpInfo(this.name, this.namespace, this.pretty, this.dryRun, this.gracePeriodSeconds, this.orphanDependents, this.propagationPolicy, this.body);
            return (V1alpha2PodSchedulingContext)localVarResp.getData();
        }

        public ApiResponse<V1alpha2PodSchedulingContext> executeWithHttpInfo() throws ApiException {
            return ResourceV1alpha2Api.this.deleteNamespacedPodSchedulingContextWithHttpInfo(this.name, this.namespace, this.pretty, this.dryRun, this.gracePeriodSeconds, this.orphanDependents, this.propagationPolicy, this.body);
        }

        public Call executeAsync(ApiCallback<V1alpha2PodSchedulingContext> _callback) throws ApiException {
            return ResourceV1alpha2Api.this.deleteNamespacedPodSchedulingContextAsync(this.name, this.namespace, this.pretty, this.dryRun, this.gracePeriodSeconds, this.orphanDependents, this.propagationPolicy, this.body, _callback);
        }
    }

    public class APIdeleteNamespacedResourceClaimRequest {
        private final String name;
        private final String namespace;
        private String pretty;
        private String dryRun;
        private Integer gracePeriodSeconds;
        private Boolean orphanDependents;
        private String propagationPolicy;
        private V1DeleteOptions body;

        private APIdeleteNamespacedResourceClaimRequest(String name, String namespace) {
            this.name = name;
            this.namespace = namespace;
        }

        public APIdeleteNamespacedResourceClaimRequest pretty(String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIdeleteNamespacedResourceClaimRequest dryRun(String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIdeleteNamespacedResourceClaimRequest gracePeriodSeconds(Integer gracePeriodSeconds) {
            this.gracePeriodSeconds = gracePeriodSeconds;
            return this;
        }

        public APIdeleteNamespacedResourceClaimRequest orphanDependents(Boolean orphanDependents) {
            this.orphanDependents = orphanDependents;
            return this;
        }

        public APIdeleteNamespacedResourceClaimRequest propagationPolicy(String propagationPolicy) {
            this.propagationPolicy = propagationPolicy;
            return this;
        }

        public APIdeleteNamespacedResourceClaimRequest body(V1DeleteOptions body) {
            this.body = body;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1alpha2Api.this.deleteNamespacedResourceClaimCall(this.name, this.namespace, this.pretty, this.dryRun, this.gracePeriodSeconds, this.orphanDependents, this.propagationPolicy, this.body, _callback);
        }

        public V1alpha2ResourceClaim execute() throws ApiException {
            ApiResponse localVarResp = ResourceV1alpha2Api.this.deleteNamespacedResourceClaimWithHttpInfo(this.name, this.namespace, this.pretty, this.dryRun, this.gracePeriodSeconds, this.orphanDependents, this.propagationPolicy, this.body);
            return (V1alpha2ResourceClaim)localVarResp.getData();
        }

        public ApiResponse<V1alpha2ResourceClaim> executeWithHttpInfo() throws ApiException {
            return ResourceV1alpha2Api.this.deleteNamespacedResourceClaimWithHttpInfo(this.name, this.namespace, this.pretty, this.dryRun, this.gracePeriodSeconds, this.orphanDependents, this.propagationPolicy, this.body);
        }

        public Call executeAsync(ApiCallback<V1alpha2ResourceClaim> _callback) throws ApiException {
            return ResourceV1alpha2Api.this.deleteNamespacedResourceClaimAsync(this.name, this.namespace, this.pretty, this.dryRun, this.gracePeriodSeconds, this.orphanDependents, this.propagationPolicy, this.body, _callback);
        }
    }

    public class APIdeleteNamespacedResourceClaimTemplateRequest {
        private final String name;
        private final String namespace;
        private String pretty;
        private String dryRun;
        private Integer gracePeriodSeconds;
        private Boolean orphanDependents;
        private String propagationPolicy;
        private V1DeleteOptions body;

        private APIdeleteNamespacedResourceClaimTemplateRequest(String name, String namespace) {
            this.name = name;
            this.namespace = namespace;
        }

        public APIdeleteNamespacedResourceClaimTemplateRequest pretty(String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIdeleteNamespacedResourceClaimTemplateRequest dryRun(String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIdeleteNamespacedResourceClaimTemplateRequest gracePeriodSeconds(Integer gracePeriodSeconds) {
            this.gracePeriodSeconds = gracePeriodSeconds;
            return this;
        }

        public APIdeleteNamespacedResourceClaimTemplateRequest orphanDependents(Boolean orphanDependents) {
            this.orphanDependents = orphanDependents;
            return this;
        }

        public APIdeleteNamespacedResourceClaimTemplateRequest propagationPolicy(String propagationPolicy) {
            this.propagationPolicy = propagationPolicy;
            return this;
        }

        public APIdeleteNamespacedResourceClaimTemplateRequest body(V1DeleteOptions body) {
            this.body = body;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1alpha2Api.this.deleteNamespacedResourceClaimTemplateCall(this.name, this.namespace, this.pretty, this.dryRun, this.gracePeriodSeconds, this.orphanDependents, this.propagationPolicy, this.body, _callback);
        }

        public V1alpha2ResourceClaimTemplate execute() throws ApiException {
            ApiResponse localVarResp = ResourceV1alpha2Api.this.deleteNamespacedResourceClaimTemplateWithHttpInfo(this.name, this.namespace, this.pretty, this.dryRun, this.gracePeriodSeconds, this.orphanDependents, this.propagationPolicy, this.body);
            return (V1alpha2ResourceClaimTemplate)localVarResp.getData();
        }

        public ApiResponse<V1alpha2ResourceClaimTemplate> executeWithHttpInfo() throws ApiException {
            return ResourceV1alpha2Api.this.deleteNamespacedResourceClaimTemplateWithHttpInfo(this.name, this.namespace, this.pretty, this.dryRun, this.gracePeriodSeconds, this.orphanDependents, this.propagationPolicy, this.body);
        }

        public Call executeAsync(ApiCallback<V1alpha2ResourceClaimTemplate> _callback) throws ApiException {
            return ResourceV1alpha2Api.this.deleteNamespacedResourceClaimTemplateAsync(this.name, this.namespace, this.pretty, this.dryRun, this.gracePeriodSeconds, this.orphanDependents, this.propagationPolicy, this.body, _callback);
        }
    }

    public class APIdeleteResourceClassRequest {
        private final String name;
        private String pretty;
        private String dryRun;
        private Integer gracePeriodSeconds;
        private Boolean orphanDependents;
        private String propagationPolicy;
        private V1DeleteOptions body;

        private APIdeleteResourceClassRequest(String name) {
            this.name = name;
        }

        public APIdeleteResourceClassRequest pretty(String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIdeleteResourceClassRequest dryRun(String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIdeleteResourceClassRequest gracePeriodSeconds(Integer gracePeriodSeconds) {
            this.gracePeriodSeconds = gracePeriodSeconds;
            return this;
        }

        public APIdeleteResourceClassRequest orphanDependents(Boolean orphanDependents) {
            this.orphanDependents = orphanDependents;
            return this;
        }

        public APIdeleteResourceClassRequest propagationPolicy(String propagationPolicy) {
            this.propagationPolicy = propagationPolicy;
            return this;
        }

        public APIdeleteResourceClassRequest body(V1DeleteOptions body) {
            this.body = body;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1alpha2Api.this.deleteResourceClassCall(this.name, this.pretty, this.dryRun, this.gracePeriodSeconds, this.orphanDependents, this.propagationPolicy, this.body, _callback);
        }

        public V1alpha2ResourceClass execute() throws ApiException {
            ApiResponse localVarResp = ResourceV1alpha2Api.this.deleteResourceClassWithHttpInfo(this.name, this.pretty, this.dryRun, this.gracePeriodSeconds, this.orphanDependents, this.propagationPolicy, this.body);
            return (V1alpha2ResourceClass)localVarResp.getData();
        }

        public ApiResponse<V1alpha2ResourceClass> executeWithHttpInfo() throws ApiException {
            return ResourceV1alpha2Api.this.deleteResourceClassWithHttpInfo(this.name, this.pretty, this.dryRun, this.gracePeriodSeconds, this.orphanDependents, this.propagationPolicy, this.body);
        }

        public Call executeAsync(ApiCallback<V1alpha2ResourceClass> _callback) throws ApiException {
            return ResourceV1alpha2Api.this.deleteResourceClassAsync(this.name, this.pretty, this.dryRun, this.gracePeriodSeconds, this.orphanDependents, this.propagationPolicy, this.body, _callback);
        }
    }

    public class APIgetAPIResourcesRequest {
        private APIgetAPIResourcesRequest() {
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1alpha2Api.this.getAPIResourcesCall(_callback);
        }

        public V1APIResourceList execute() throws ApiException {
            ApiResponse localVarResp = ResourceV1alpha2Api.this.getAPIResourcesWithHttpInfo();
            return (V1APIResourceList)localVarResp.getData();
        }

        public ApiResponse<V1APIResourceList> executeWithHttpInfo() throws ApiException {
            return ResourceV1alpha2Api.this.getAPIResourcesWithHttpInfo();
        }

        public Call executeAsync(ApiCallback<V1APIResourceList> _callback) throws ApiException {
            return ResourceV1alpha2Api.this.getAPIResourcesAsync(_callback);
        }
    }

    public class APIlistNamespacedPodSchedulingContextRequest {
        private final String namespace;
        private String pretty;
        private Boolean allowWatchBookmarks;
        private String _continue;
        private String fieldSelector;
        private String labelSelector;
        private Integer limit;
        private String resourceVersion;
        private String resourceVersionMatch;
        private Boolean sendInitialEvents;
        private Integer timeoutSeconds;
        private Boolean watch;

        private APIlistNamespacedPodSchedulingContextRequest(String namespace) {
            this.namespace = namespace;
        }

        public APIlistNamespacedPodSchedulingContextRequest pretty(String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIlistNamespacedPodSchedulingContextRequest allowWatchBookmarks(Boolean allowWatchBookmarks) {
            this.allowWatchBookmarks = allowWatchBookmarks;
            return this;
        }

        public APIlistNamespacedPodSchedulingContextRequest _continue(String _continue) {
            this._continue = _continue;
            return this;
        }

        public APIlistNamespacedPodSchedulingContextRequest fieldSelector(String fieldSelector) {
            this.fieldSelector = fieldSelector;
            return this;
        }

        public APIlistNamespacedPodSchedulingContextRequest labelSelector(String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public APIlistNamespacedPodSchedulingContextRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistNamespacedPodSchedulingContextRequest resourceVersion(String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        public APIlistNamespacedPodSchedulingContextRequest resourceVersionMatch(String resourceVersionMatch) {
            this.resourceVersionMatch = resourceVersionMatch;
            return this;
        }

        public APIlistNamespacedPodSchedulingContextRequest sendInitialEvents(Boolean sendInitialEvents) {
            this.sendInitialEvents = sendInitialEvents;
            return this;
        }

        public APIlistNamespacedPodSchedulingContextRequest timeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public APIlistNamespacedPodSchedulingContextRequest watch(Boolean watch) {
            this.watch = watch;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1alpha2Api.this.listNamespacedPodSchedulingContextCall(this.namespace, this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }

        public V1alpha2PodSchedulingContextList execute() throws ApiException {
            ApiResponse localVarResp = ResourceV1alpha2Api.this.listNamespacedPodSchedulingContextWithHttpInfo(this.namespace, this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
            return (V1alpha2PodSchedulingContextList)localVarResp.getData();
        }

        public ApiResponse<V1alpha2PodSchedulingContextList> executeWithHttpInfo() throws ApiException {
            return ResourceV1alpha2Api.this.listNamespacedPodSchedulingContextWithHttpInfo(this.namespace, this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
        }

        public Call executeAsync(ApiCallback<V1alpha2PodSchedulingContextList> _callback) throws ApiException {
            return ResourceV1alpha2Api.this.listNamespacedPodSchedulingContextAsync(this.namespace, this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }
    }

    public class APIlistNamespacedResourceClaimRequest {
        private final String namespace;
        private String pretty;
        private Boolean allowWatchBookmarks;
        private String _continue;
        private String fieldSelector;
        private String labelSelector;
        private Integer limit;
        private String resourceVersion;
        private String resourceVersionMatch;
        private Boolean sendInitialEvents;
        private Integer timeoutSeconds;
        private Boolean watch;

        private APIlistNamespacedResourceClaimRequest(String namespace) {
            this.namespace = namespace;
        }

        public APIlistNamespacedResourceClaimRequest pretty(String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIlistNamespacedResourceClaimRequest allowWatchBookmarks(Boolean allowWatchBookmarks) {
            this.allowWatchBookmarks = allowWatchBookmarks;
            return this;
        }

        public APIlistNamespacedResourceClaimRequest _continue(String _continue) {
            this._continue = _continue;
            return this;
        }

        public APIlistNamespacedResourceClaimRequest fieldSelector(String fieldSelector) {
            this.fieldSelector = fieldSelector;
            return this;
        }

        public APIlistNamespacedResourceClaimRequest labelSelector(String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public APIlistNamespacedResourceClaimRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistNamespacedResourceClaimRequest resourceVersion(String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        public APIlistNamespacedResourceClaimRequest resourceVersionMatch(String resourceVersionMatch) {
            this.resourceVersionMatch = resourceVersionMatch;
            return this;
        }

        public APIlistNamespacedResourceClaimRequest sendInitialEvents(Boolean sendInitialEvents) {
            this.sendInitialEvents = sendInitialEvents;
            return this;
        }

        public APIlistNamespacedResourceClaimRequest timeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public APIlistNamespacedResourceClaimRequest watch(Boolean watch) {
            this.watch = watch;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1alpha2Api.this.listNamespacedResourceClaimCall(this.namespace, this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }

        public V1alpha2ResourceClaimList execute() throws ApiException {
            ApiResponse localVarResp = ResourceV1alpha2Api.this.listNamespacedResourceClaimWithHttpInfo(this.namespace, this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
            return (V1alpha2ResourceClaimList)localVarResp.getData();
        }

        public ApiResponse<V1alpha2ResourceClaimList> executeWithHttpInfo() throws ApiException {
            return ResourceV1alpha2Api.this.listNamespacedResourceClaimWithHttpInfo(this.namespace, this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
        }

        public Call executeAsync(ApiCallback<V1alpha2ResourceClaimList> _callback) throws ApiException {
            return ResourceV1alpha2Api.this.listNamespacedResourceClaimAsync(this.namespace, this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }
    }

    public class APIlistNamespacedResourceClaimTemplateRequest {
        private final String namespace;
        private String pretty;
        private Boolean allowWatchBookmarks;
        private String _continue;
        private String fieldSelector;
        private String labelSelector;
        private Integer limit;
        private String resourceVersion;
        private String resourceVersionMatch;
        private Boolean sendInitialEvents;
        private Integer timeoutSeconds;
        private Boolean watch;

        private APIlistNamespacedResourceClaimTemplateRequest(String namespace) {
            this.namespace = namespace;
        }

        public APIlistNamespacedResourceClaimTemplateRequest pretty(String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIlistNamespacedResourceClaimTemplateRequest allowWatchBookmarks(Boolean allowWatchBookmarks) {
            this.allowWatchBookmarks = allowWatchBookmarks;
            return this;
        }

        public APIlistNamespacedResourceClaimTemplateRequest _continue(String _continue) {
            this._continue = _continue;
            return this;
        }

        public APIlistNamespacedResourceClaimTemplateRequest fieldSelector(String fieldSelector) {
            this.fieldSelector = fieldSelector;
            return this;
        }

        public APIlistNamespacedResourceClaimTemplateRequest labelSelector(String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public APIlistNamespacedResourceClaimTemplateRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistNamespacedResourceClaimTemplateRequest resourceVersion(String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        public APIlistNamespacedResourceClaimTemplateRequest resourceVersionMatch(String resourceVersionMatch) {
            this.resourceVersionMatch = resourceVersionMatch;
            return this;
        }

        public APIlistNamespacedResourceClaimTemplateRequest sendInitialEvents(Boolean sendInitialEvents) {
            this.sendInitialEvents = sendInitialEvents;
            return this;
        }

        public APIlistNamespacedResourceClaimTemplateRequest timeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public APIlistNamespacedResourceClaimTemplateRequest watch(Boolean watch) {
            this.watch = watch;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1alpha2Api.this.listNamespacedResourceClaimTemplateCall(this.namespace, this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }

        public V1alpha2ResourceClaimTemplateList execute() throws ApiException {
            ApiResponse localVarResp = ResourceV1alpha2Api.this.listNamespacedResourceClaimTemplateWithHttpInfo(this.namespace, this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
            return (V1alpha2ResourceClaimTemplateList)localVarResp.getData();
        }

        public ApiResponse<V1alpha2ResourceClaimTemplateList> executeWithHttpInfo() throws ApiException {
            return ResourceV1alpha2Api.this.listNamespacedResourceClaimTemplateWithHttpInfo(this.namespace, this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
        }

        public Call executeAsync(ApiCallback<V1alpha2ResourceClaimTemplateList> _callback) throws ApiException {
            return ResourceV1alpha2Api.this.listNamespacedResourceClaimTemplateAsync(this.namespace, this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }
    }

    public class APIlistPodSchedulingContextForAllNamespacesRequest {
        private Boolean allowWatchBookmarks;
        private String _continue;
        private String fieldSelector;
        private String labelSelector;
        private Integer limit;
        private String pretty;
        private String resourceVersion;
        private String resourceVersionMatch;
        private Boolean sendInitialEvents;
        private Integer timeoutSeconds;
        private Boolean watch;

        private APIlistPodSchedulingContextForAllNamespacesRequest() {
        }

        public APIlistPodSchedulingContextForAllNamespacesRequest allowWatchBookmarks(Boolean allowWatchBookmarks) {
            this.allowWatchBookmarks = allowWatchBookmarks;
            return this;
        }

        public APIlistPodSchedulingContextForAllNamespacesRequest _continue(String _continue) {
            this._continue = _continue;
            return this;
        }

        public APIlistPodSchedulingContextForAllNamespacesRequest fieldSelector(String fieldSelector) {
            this.fieldSelector = fieldSelector;
            return this;
        }

        public APIlistPodSchedulingContextForAllNamespacesRequest labelSelector(String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public APIlistPodSchedulingContextForAllNamespacesRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistPodSchedulingContextForAllNamespacesRequest pretty(String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIlistPodSchedulingContextForAllNamespacesRequest resourceVersion(String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        public APIlistPodSchedulingContextForAllNamespacesRequest resourceVersionMatch(String resourceVersionMatch) {
            this.resourceVersionMatch = resourceVersionMatch;
            return this;
        }

        public APIlistPodSchedulingContextForAllNamespacesRequest sendInitialEvents(Boolean sendInitialEvents) {
            this.sendInitialEvents = sendInitialEvents;
            return this;
        }

        public APIlistPodSchedulingContextForAllNamespacesRequest timeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public APIlistPodSchedulingContextForAllNamespacesRequest watch(Boolean watch) {
            this.watch = watch;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1alpha2Api.this.listPodSchedulingContextForAllNamespacesCall(this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.pretty, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }

        public V1alpha2PodSchedulingContextList execute() throws ApiException {
            ApiResponse localVarResp = ResourceV1alpha2Api.this.listPodSchedulingContextForAllNamespacesWithHttpInfo(this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.pretty, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
            return (V1alpha2PodSchedulingContextList)localVarResp.getData();
        }

        public ApiResponse<V1alpha2PodSchedulingContextList> executeWithHttpInfo() throws ApiException {
            return ResourceV1alpha2Api.this.listPodSchedulingContextForAllNamespacesWithHttpInfo(this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.pretty, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
        }

        public Call executeAsync(ApiCallback<V1alpha2PodSchedulingContextList> _callback) throws ApiException {
            return ResourceV1alpha2Api.this.listPodSchedulingContextForAllNamespacesAsync(this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.pretty, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }
    }

    public class APIlistResourceClaimForAllNamespacesRequest {
        private Boolean allowWatchBookmarks;
        private String _continue;
        private String fieldSelector;
        private String labelSelector;
        private Integer limit;
        private String pretty;
        private String resourceVersion;
        private String resourceVersionMatch;
        private Boolean sendInitialEvents;
        private Integer timeoutSeconds;
        private Boolean watch;

        private APIlistResourceClaimForAllNamespacesRequest() {
        }

        public APIlistResourceClaimForAllNamespacesRequest allowWatchBookmarks(Boolean allowWatchBookmarks) {
            this.allowWatchBookmarks = allowWatchBookmarks;
            return this;
        }

        public APIlistResourceClaimForAllNamespacesRequest _continue(String _continue) {
            this._continue = _continue;
            return this;
        }

        public APIlistResourceClaimForAllNamespacesRequest fieldSelector(String fieldSelector) {
            this.fieldSelector = fieldSelector;
            return this;
        }

        public APIlistResourceClaimForAllNamespacesRequest labelSelector(String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public APIlistResourceClaimForAllNamespacesRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistResourceClaimForAllNamespacesRequest pretty(String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIlistResourceClaimForAllNamespacesRequest resourceVersion(String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        public APIlistResourceClaimForAllNamespacesRequest resourceVersionMatch(String resourceVersionMatch) {
            this.resourceVersionMatch = resourceVersionMatch;
            return this;
        }

        public APIlistResourceClaimForAllNamespacesRequest sendInitialEvents(Boolean sendInitialEvents) {
            this.sendInitialEvents = sendInitialEvents;
            return this;
        }

        public APIlistResourceClaimForAllNamespacesRequest timeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public APIlistResourceClaimForAllNamespacesRequest watch(Boolean watch) {
            this.watch = watch;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1alpha2Api.this.listResourceClaimForAllNamespacesCall(this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.pretty, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }

        public V1alpha2ResourceClaimList execute() throws ApiException {
            ApiResponse localVarResp = ResourceV1alpha2Api.this.listResourceClaimForAllNamespacesWithHttpInfo(this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.pretty, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
            return (V1alpha2ResourceClaimList)localVarResp.getData();
        }

        public ApiResponse<V1alpha2ResourceClaimList> executeWithHttpInfo() throws ApiException {
            return ResourceV1alpha2Api.this.listResourceClaimForAllNamespacesWithHttpInfo(this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.pretty, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
        }

        public Call executeAsync(ApiCallback<V1alpha2ResourceClaimList> _callback) throws ApiException {
            return ResourceV1alpha2Api.this.listResourceClaimForAllNamespacesAsync(this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.pretty, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }
    }

    public class APIlistResourceClaimTemplateForAllNamespacesRequest {
        private Boolean allowWatchBookmarks;
        private String _continue;
        private String fieldSelector;
        private String labelSelector;
        private Integer limit;
        private String pretty;
        private String resourceVersion;
        private String resourceVersionMatch;
        private Boolean sendInitialEvents;
        private Integer timeoutSeconds;
        private Boolean watch;

        private APIlistResourceClaimTemplateForAllNamespacesRequest() {
        }

        public APIlistResourceClaimTemplateForAllNamespacesRequest allowWatchBookmarks(Boolean allowWatchBookmarks) {
            this.allowWatchBookmarks = allowWatchBookmarks;
            return this;
        }

        public APIlistResourceClaimTemplateForAllNamespacesRequest _continue(String _continue) {
            this._continue = _continue;
            return this;
        }

        public APIlistResourceClaimTemplateForAllNamespacesRequest fieldSelector(String fieldSelector) {
            this.fieldSelector = fieldSelector;
            return this;
        }

        public APIlistResourceClaimTemplateForAllNamespacesRequest labelSelector(String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public APIlistResourceClaimTemplateForAllNamespacesRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistResourceClaimTemplateForAllNamespacesRequest pretty(String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIlistResourceClaimTemplateForAllNamespacesRequest resourceVersion(String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        public APIlistResourceClaimTemplateForAllNamespacesRequest resourceVersionMatch(String resourceVersionMatch) {
            this.resourceVersionMatch = resourceVersionMatch;
            return this;
        }

        public APIlistResourceClaimTemplateForAllNamespacesRequest sendInitialEvents(Boolean sendInitialEvents) {
            this.sendInitialEvents = sendInitialEvents;
            return this;
        }

        public APIlistResourceClaimTemplateForAllNamespacesRequest timeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public APIlistResourceClaimTemplateForAllNamespacesRequest watch(Boolean watch) {
            this.watch = watch;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1alpha2Api.this.listResourceClaimTemplateForAllNamespacesCall(this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.pretty, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }

        public V1alpha2ResourceClaimTemplateList execute() throws ApiException {
            ApiResponse localVarResp = ResourceV1alpha2Api.this.listResourceClaimTemplateForAllNamespacesWithHttpInfo(this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.pretty, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
            return (V1alpha2ResourceClaimTemplateList)localVarResp.getData();
        }

        public ApiResponse<V1alpha2ResourceClaimTemplateList> executeWithHttpInfo() throws ApiException {
            return ResourceV1alpha2Api.this.listResourceClaimTemplateForAllNamespacesWithHttpInfo(this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.pretty, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
        }

        public Call executeAsync(ApiCallback<V1alpha2ResourceClaimTemplateList> _callback) throws ApiException {
            return ResourceV1alpha2Api.this.listResourceClaimTemplateForAllNamespacesAsync(this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.pretty, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }
    }

    public class APIlistResourceClassRequest {
        private String pretty;
        private Boolean allowWatchBookmarks;
        private String _continue;
        private String fieldSelector;
        private String labelSelector;
        private Integer limit;
        private String resourceVersion;
        private String resourceVersionMatch;
        private Boolean sendInitialEvents;
        private Integer timeoutSeconds;
        private Boolean watch;

        private APIlistResourceClassRequest() {
        }

        public APIlistResourceClassRequest pretty(String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIlistResourceClassRequest allowWatchBookmarks(Boolean allowWatchBookmarks) {
            this.allowWatchBookmarks = allowWatchBookmarks;
            return this;
        }

        public APIlistResourceClassRequest _continue(String _continue) {
            this._continue = _continue;
            return this;
        }

        public APIlistResourceClassRequest fieldSelector(String fieldSelector) {
            this.fieldSelector = fieldSelector;
            return this;
        }

        public APIlistResourceClassRequest labelSelector(String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public APIlistResourceClassRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistResourceClassRequest resourceVersion(String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        public APIlistResourceClassRequest resourceVersionMatch(String resourceVersionMatch) {
            this.resourceVersionMatch = resourceVersionMatch;
            return this;
        }

        public APIlistResourceClassRequest sendInitialEvents(Boolean sendInitialEvents) {
            this.sendInitialEvents = sendInitialEvents;
            return this;
        }

        public APIlistResourceClassRequest timeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public APIlistResourceClassRequest watch(Boolean watch) {
            this.watch = watch;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1alpha2Api.this.listResourceClassCall(this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }

        public V1alpha2ResourceClassList execute() throws ApiException {
            ApiResponse localVarResp = ResourceV1alpha2Api.this.listResourceClassWithHttpInfo(this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
            return (V1alpha2ResourceClassList)localVarResp.getData();
        }

        public ApiResponse<V1alpha2ResourceClassList> executeWithHttpInfo() throws ApiException {
            return ResourceV1alpha2Api.this.listResourceClassWithHttpInfo(this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
        }

        public Call executeAsync(ApiCallback<V1alpha2ResourceClassList> _callback) throws ApiException {
            return ResourceV1alpha2Api.this.listResourceClassAsync(this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }
    }

    public class APIpatchNamespacedPodSchedulingContextRequest {
        private final String name;
        private final String namespace;
        private final V1Patch body;
        private String pretty;
        private String dryRun;
        private String fieldManager;
        private String fieldValidation;
        private Boolean force;

        private APIpatchNamespacedPodSchedulingContextRequest(String name, String namespace, V1Patch body) {
            this.name = name;
            this.namespace = namespace;
            this.body = body;
        }

        public APIpatchNamespacedPodSchedulingContextRequest pretty(String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIpatchNamespacedPodSchedulingContextRequest dryRun(String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIpatchNamespacedPodSchedulingContextRequest fieldManager(String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIpatchNamespacedPodSchedulingContextRequest fieldValidation(String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public APIpatchNamespacedPodSchedulingContextRequest force(Boolean force) {
            this.force = force;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1alpha2Api.this.patchNamespacedPodSchedulingContextCall(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }

        public V1alpha2PodSchedulingContext execute() throws ApiException {
            ApiResponse localVarResp = ResourceV1alpha2Api.this.patchNamespacedPodSchedulingContextWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
            return (V1alpha2PodSchedulingContext)localVarResp.getData();
        }

        public ApiResponse<V1alpha2PodSchedulingContext> executeWithHttpInfo() throws ApiException {
            return ResourceV1alpha2Api.this.patchNamespacedPodSchedulingContextWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
        }

        public Call executeAsync(ApiCallback<V1alpha2PodSchedulingContext> _callback) throws ApiException {
            return ResourceV1alpha2Api.this.patchNamespacedPodSchedulingContextAsync(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }
    }

    public class APIpatchNamespacedPodSchedulingContextStatusRequest {
        private final String name;
        private final String namespace;
        private final V1Patch body;
        private String pretty;
        private String dryRun;
        private String fieldManager;
        private String fieldValidation;
        private Boolean force;

        private APIpatchNamespacedPodSchedulingContextStatusRequest(String name, String namespace, V1Patch body) {
            this.name = name;
            this.namespace = namespace;
            this.body = body;
        }

        public APIpatchNamespacedPodSchedulingContextStatusRequest pretty(String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIpatchNamespacedPodSchedulingContextStatusRequest dryRun(String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIpatchNamespacedPodSchedulingContextStatusRequest fieldManager(String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIpatchNamespacedPodSchedulingContextStatusRequest fieldValidation(String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public APIpatchNamespacedPodSchedulingContextStatusRequest force(Boolean force) {
            this.force = force;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1alpha2Api.this.patchNamespacedPodSchedulingContextStatusCall(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }

        public V1alpha2PodSchedulingContext execute() throws ApiException {
            ApiResponse localVarResp = ResourceV1alpha2Api.this.patchNamespacedPodSchedulingContextStatusWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
            return (V1alpha2PodSchedulingContext)localVarResp.getData();
        }

        public ApiResponse<V1alpha2PodSchedulingContext> executeWithHttpInfo() throws ApiException {
            return ResourceV1alpha2Api.this.patchNamespacedPodSchedulingContextStatusWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
        }

        public Call executeAsync(ApiCallback<V1alpha2PodSchedulingContext> _callback) throws ApiException {
            return ResourceV1alpha2Api.this.patchNamespacedPodSchedulingContextStatusAsync(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }
    }

    public class APIpatchNamespacedResourceClaimRequest {
        private final String name;
        private final String namespace;
        private final V1Patch body;
        private String pretty;
        private String dryRun;
        private String fieldManager;
        private String fieldValidation;
        private Boolean force;

        private APIpatchNamespacedResourceClaimRequest(String name, String namespace, V1Patch body) {
            this.name = name;
            this.namespace = namespace;
            this.body = body;
        }

        public APIpatchNamespacedResourceClaimRequest pretty(String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIpatchNamespacedResourceClaimRequest dryRun(String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIpatchNamespacedResourceClaimRequest fieldManager(String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIpatchNamespacedResourceClaimRequest fieldValidation(String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public APIpatchNamespacedResourceClaimRequest force(Boolean force) {
            this.force = force;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1alpha2Api.this.patchNamespacedResourceClaimCall(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }

        public V1alpha2ResourceClaim execute() throws ApiException {
            ApiResponse localVarResp = ResourceV1alpha2Api.this.patchNamespacedResourceClaimWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
            return (V1alpha2ResourceClaim)localVarResp.getData();
        }

        public ApiResponse<V1alpha2ResourceClaim> executeWithHttpInfo() throws ApiException {
            return ResourceV1alpha2Api.this.patchNamespacedResourceClaimWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
        }

        public Call executeAsync(ApiCallback<V1alpha2ResourceClaim> _callback) throws ApiException {
            return ResourceV1alpha2Api.this.patchNamespacedResourceClaimAsync(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }
    }

    public class APIpatchNamespacedResourceClaimStatusRequest {
        private final String name;
        private final String namespace;
        private final V1Patch body;
        private String pretty;
        private String dryRun;
        private String fieldManager;
        private String fieldValidation;
        private Boolean force;

        private APIpatchNamespacedResourceClaimStatusRequest(String name, String namespace, V1Patch body) {
            this.name = name;
            this.namespace = namespace;
            this.body = body;
        }

        public APIpatchNamespacedResourceClaimStatusRequest pretty(String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIpatchNamespacedResourceClaimStatusRequest dryRun(String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIpatchNamespacedResourceClaimStatusRequest fieldManager(String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIpatchNamespacedResourceClaimStatusRequest fieldValidation(String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public APIpatchNamespacedResourceClaimStatusRequest force(Boolean force) {
            this.force = force;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1alpha2Api.this.patchNamespacedResourceClaimStatusCall(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }

        public V1alpha2ResourceClaim execute() throws ApiException {
            ApiResponse localVarResp = ResourceV1alpha2Api.this.patchNamespacedResourceClaimStatusWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
            return (V1alpha2ResourceClaim)localVarResp.getData();
        }

        public ApiResponse<V1alpha2ResourceClaim> executeWithHttpInfo() throws ApiException {
            return ResourceV1alpha2Api.this.patchNamespacedResourceClaimStatusWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
        }

        public Call executeAsync(ApiCallback<V1alpha2ResourceClaim> _callback) throws ApiException {
            return ResourceV1alpha2Api.this.patchNamespacedResourceClaimStatusAsync(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }
    }

    public class APIpatchNamespacedResourceClaimTemplateRequest {
        private final String name;
        private final String namespace;
        private final V1Patch body;
        private String pretty;
        private String dryRun;
        private String fieldManager;
        private String fieldValidation;
        private Boolean force;

        private APIpatchNamespacedResourceClaimTemplateRequest(String name, String namespace, V1Patch body) {
            this.name = name;
            this.namespace = namespace;
            this.body = body;
        }

        public APIpatchNamespacedResourceClaimTemplateRequest pretty(String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIpatchNamespacedResourceClaimTemplateRequest dryRun(String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIpatchNamespacedResourceClaimTemplateRequest fieldManager(String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIpatchNamespacedResourceClaimTemplateRequest fieldValidation(String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public APIpatchNamespacedResourceClaimTemplateRequest force(Boolean force) {
            this.force = force;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1alpha2Api.this.patchNamespacedResourceClaimTemplateCall(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }

        public V1alpha2ResourceClaimTemplate execute() throws ApiException {
            ApiResponse localVarResp = ResourceV1alpha2Api.this.patchNamespacedResourceClaimTemplateWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
            return (V1alpha2ResourceClaimTemplate)localVarResp.getData();
        }

        public ApiResponse<V1alpha2ResourceClaimTemplate> executeWithHttpInfo() throws ApiException {
            return ResourceV1alpha2Api.this.patchNamespacedResourceClaimTemplateWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
        }

        public Call executeAsync(ApiCallback<V1alpha2ResourceClaimTemplate> _callback) throws ApiException {
            return ResourceV1alpha2Api.this.patchNamespacedResourceClaimTemplateAsync(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }
    }

    public class APIpatchResourceClassRequest {
        private final String name;
        private final V1Patch body;
        private String pretty;
        private String dryRun;
        private String fieldManager;
        private String fieldValidation;
        private Boolean force;

        private APIpatchResourceClassRequest(String name, V1Patch body) {
            this.name = name;
            this.body = body;
        }

        public APIpatchResourceClassRequest pretty(String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIpatchResourceClassRequest dryRun(String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIpatchResourceClassRequest fieldManager(String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIpatchResourceClassRequest fieldValidation(String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public APIpatchResourceClassRequest force(Boolean force) {
            this.force = force;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1alpha2Api.this.patchResourceClassCall(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }

        public V1alpha2ResourceClass execute() throws ApiException {
            ApiResponse localVarResp = ResourceV1alpha2Api.this.patchResourceClassWithHttpInfo(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
            return (V1alpha2ResourceClass)localVarResp.getData();
        }

        public ApiResponse<V1alpha2ResourceClass> executeWithHttpInfo() throws ApiException {
            return ResourceV1alpha2Api.this.patchResourceClassWithHttpInfo(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
        }

        public Call executeAsync(ApiCallback<V1alpha2ResourceClass> _callback) throws ApiException {
            return ResourceV1alpha2Api.this.patchResourceClassAsync(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }
    }

    public class APIreadNamespacedPodSchedulingContextRequest {
        private final String name;
        private final String namespace;
        private String pretty;

        private APIreadNamespacedPodSchedulingContextRequest(String name, String namespace) {
            this.name = name;
            this.namespace = namespace;
        }

        public APIreadNamespacedPodSchedulingContextRequest pretty(String pretty) {
            this.pretty = pretty;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1alpha2Api.this.readNamespacedPodSchedulingContextCall(this.name, this.namespace, this.pretty, _callback);
        }

        public V1alpha2PodSchedulingContext execute() throws ApiException {
            ApiResponse localVarResp = ResourceV1alpha2Api.this.readNamespacedPodSchedulingContextWithHttpInfo(this.name, this.namespace, this.pretty);
            return (V1alpha2PodSchedulingContext)localVarResp.getData();
        }

        public ApiResponse<V1alpha2PodSchedulingContext> executeWithHttpInfo() throws ApiException {
            return ResourceV1alpha2Api.this.readNamespacedPodSchedulingContextWithHttpInfo(this.name, this.namespace, this.pretty);
        }

        public Call executeAsync(ApiCallback<V1alpha2PodSchedulingContext> _callback) throws ApiException {
            return ResourceV1alpha2Api.this.readNamespacedPodSchedulingContextAsync(this.name, this.namespace, this.pretty, _callback);
        }
    }

    public class APIreadNamespacedPodSchedulingContextStatusRequest {
        private final String name;
        private final String namespace;
        private String pretty;

        private APIreadNamespacedPodSchedulingContextStatusRequest(String name, String namespace) {
            this.name = name;
            this.namespace = namespace;
        }

        public APIreadNamespacedPodSchedulingContextStatusRequest pretty(String pretty) {
            this.pretty = pretty;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1alpha2Api.this.readNamespacedPodSchedulingContextStatusCall(this.name, this.namespace, this.pretty, _callback);
        }

        public V1alpha2PodSchedulingContext execute() throws ApiException {
            ApiResponse localVarResp = ResourceV1alpha2Api.this.readNamespacedPodSchedulingContextStatusWithHttpInfo(this.name, this.namespace, this.pretty);
            return (V1alpha2PodSchedulingContext)localVarResp.getData();
        }

        public ApiResponse<V1alpha2PodSchedulingContext> executeWithHttpInfo() throws ApiException {
            return ResourceV1alpha2Api.this.readNamespacedPodSchedulingContextStatusWithHttpInfo(this.name, this.namespace, this.pretty);
        }

        public Call executeAsync(ApiCallback<V1alpha2PodSchedulingContext> _callback) throws ApiException {
            return ResourceV1alpha2Api.this.readNamespacedPodSchedulingContextStatusAsync(this.name, this.namespace, this.pretty, _callback);
        }
    }

    public class APIreadNamespacedResourceClaimRequest {
        private final String name;
        private final String namespace;
        private String pretty;

        private APIreadNamespacedResourceClaimRequest(String name, String namespace) {
            this.name = name;
            this.namespace = namespace;
        }

        public APIreadNamespacedResourceClaimRequest pretty(String pretty) {
            this.pretty = pretty;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1alpha2Api.this.readNamespacedResourceClaimCall(this.name, this.namespace, this.pretty, _callback);
        }

        public V1alpha2ResourceClaim execute() throws ApiException {
            ApiResponse localVarResp = ResourceV1alpha2Api.this.readNamespacedResourceClaimWithHttpInfo(this.name, this.namespace, this.pretty);
            return (V1alpha2ResourceClaim)localVarResp.getData();
        }

        public ApiResponse<V1alpha2ResourceClaim> executeWithHttpInfo() throws ApiException {
            return ResourceV1alpha2Api.this.readNamespacedResourceClaimWithHttpInfo(this.name, this.namespace, this.pretty);
        }

        public Call executeAsync(ApiCallback<V1alpha2ResourceClaim> _callback) throws ApiException {
            return ResourceV1alpha2Api.this.readNamespacedResourceClaimAsync(this.name, this.namespace, this.pretty, _callback);
        }
    }

    public class APIreadNamespacedResourceClaimStatusRequest {
        private final String name;
        private final String namespace;
        private String pretty;

        private APIreadNamespacedResourceClaimStatusRequest(String name, String namespace) {
            this.name = name;
            this.namespace = namespace;
        }

        public APIreadNamespacedResourceClaimStatusRequest pretty(String pretty) {
            this.pretty = pretty;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1alpha2Api.this.readNamespacedResourceClaimStatusCall(this.name, this.namespace, this.pretty, _callback);
        }

        public V1alpha2ResourceClaim execute() throws ApiException {
            ApiResponse localVarResp = ResourceV1alpha2Api.this.readNamespacedResourceClaimStatusWithHttpInfo(this.name, this.namespace, this.pretty);
            return (V1alpha2ResourceClaim)localVarResp.getData();
        }

        public ApiResponse<V1alpha2ResourceClaim> executeWithHttpInfo() throws ApiException {
            return ResourceV1alpha2Api.this.readNamespacedResourceClaimStatusWithHttpInfo(this.name, this.namespace, this.pretty);
        }

        public Call executeAsync(ApiCallback<V1alpha2ResourceClaim> _callback) throws ApiException {
            return ResourceV1alpha2Api.this.readNamespacedResourceClaimStatusAsync(this.name, this.namespace, this.pretty, _callback);
        }
    }

    public class APIreadNamespacedResourceClaimTemplateRequest {
        private final String name;
        private final String namespace;
        private String pretty;

        private APIreadNamespacedResourceClaimTemplateRequest(String name, String namespace) {
            this.name = name;
            this.namespace = namespace;
        }

        public APIreadNamespacedResourceClaimTemplateRequest pretty(String pretty) {
            this.pretty = pretty;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1alpha2Api.this.readNamespacedResourceClaimTemplateCall(this.name, this.namespace, this.pretty, _callback);
        }

        public V1alpha2ResourceClaimTemplate execute() throws ApiException {
            ApiResponse localVarResp = ResourceV1alpha2Api.this.readNamespacedResourceClaimTemplateWithHttpInfo(this.name, this.namespace, this.pretty);
            return (V1alpha2ResourceClaimTemplate)localVarResp.getData();
        }

        public ApiResponse<V1alpha2ResourceClaimTemplate> executeWithHttpInfo() throws ApiException {
            return ResourceV1alpha2Api.this.readNamespacedResourceClaimTemplateWithHttpInfo(this.name, this.namespace, this.pretty);
        }

        public Call executeAsync(ApiCallback<V1alpha2ResourceClaimTemplate> _callback) throws ApiException {
            return ResourceV1alpha2Api.this.readNamespacedResourceClaimTemplateAsync(this.name, this.namespace, this.pretty, _callback);
        }
    }

    public class APIreadResourceClassRequest {
        private final String name;
        private String pretty;

        private APIreadResourceClassRequest(String name) {
            this.name = name;
        }

        public APIreadResourceClassRequest pretty(String pretty) {
            this.pretty = pretty;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1alpha2Api.this.readResourceClassCall(this.name, this.pretty, _callback);
        }

        public V1alpha2ResourceClass execute() throws ApiException {
            ApiResponse localVarResp = ResourceV1alpha2Api.this.readResourceClassWithHttpInfo(this.name, this.pretty);
            return (V1alpha2ResourceClass)localVarResp.getData();
        }

        public ApiResponse<V1alpha2ResourceClass> executeWithHttpInfo() throws ApiException {
            return ResourceV1alpha2Api.this.readResourceClassWithHttpInfo(this.name, this.pretty);
        }

        public Call executeAsync(ApiCallback<V1alpha2ResourceClass> _callback) throws ApiException {
            return ResourceV1alpha2Api.this.readResourceClassAsync(this.name, this.pretty, _callback);
        }
    }

    public class APIreplaceNamespacedPodSchedulingContextRequest {
        private final String name;
        private final String namespace;
        private final V1alpha2PodSchedulingContext body;
        private String pretty;
        private String dryRun;
        private String fieldManager;
        private String fieldValidation;

        private APIreplaceNamespacedPodSchedulingContextRequest(String name, String namespace, V1alpha2PodSchedulingContext body) {
            this.name = name;
            this.namespace = namespace;
            this.body = body;
        }

        public APIreplaceNamespacedPodSchedulingContextRequest pretty(String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIreplaceNamespacedPodSchedulingContextRequest dryRun(String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIreplaceNamespacedPodSchedulingContextRequest fieldManager(String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIreplaceNamespacedPodSchedulingContextRequest fieldValidation(String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1alpha2Api.this.replaceNamespacedPodSchedulingContextCall(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }

        public V1alpha2PodSchedulingContext execute() throws ApiException {
            ApiResponse localVarResp = ResourceV1alpha2Api.this.replaceNamespacedPodSchedulingContextWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
            return (V1alpha2PodSchedulingContext)localVarResp.getData();
        }

        public ApiResponse<V1alpha2PodSchedulingContext> executeWithHttpInfo() throws ApiException {
            return ResourceV1alpha2Api.this.replaceNamespacedPodSchedulingContextWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
        }

        public Call executeAsync(ApiCallback<V1alpha2PodSchedulingContext> _callback) throws ApiException {
            return ResourceV1alpha2Api.this.replaceNamespacedPodSchedulingContextAsync(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }
    }

    public class APIreplaceNamespacedPodSchedulingContextStatusRequest {
        private final String name;
        private final String namespace;
        private final V1alpha2PodSchedulingContext body;
        private String pretty;
        private String dryRun;
        private String fieldManager;
        private String fieldValidation;

        private APIreplaceNamespacedPodSchedulingContextStatusRequest(String name, String namespace, V1alpha2PodSchedulingContext body) {
            this.name = name;
            this.namespace = namespace;
            this.body = body;
        }

        public APIreplaceNamespacedPodSchedulingContextStatusRequest pretty(String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIreplaceNamespacedPodSchedulingContextStatusRequest dryRun(String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIreplaceNamespacedPodSchedulingContextStatusRequest fieldManager(String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIreplaceNamespacedPodSchedulingContextStatusRequest fieldValidation(String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1alpha2Api.this.replaceNamespacedPodSchedulingContextStatusCall(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }

        public V1alpha2PodSchedulingContext execute() throws ApiException {
            ApiResponse localVarResp = ResourceV1alpha2Api.this.replaceNamespacedPodSchedulingContextStatusWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
            return (V1alpha2PodSchedulingContext)localVarResp.getData();
        }

        public ApiResponse<V1alpha2PodSchedulingContext> executeWithHttpInfo() throws ApiException {
            return ResourceV1alpha2Api.this.replaceNamespacedPodSchedulingContextStatusWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
        }

        public Call executeAsync(ApiCallback<V1alpha2PodSchedulingContext> _callback) throws ApiException {
            return ResourceV1alpha2Api.this.replaceNamespacedPodSchedulingContextStatusAsync(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }
    }

    public class APIreplaceNamespacedResourceClaimRequest {
        private final String name;
        private final String namespace;
        private final V1alpha2ResourceClaim body;
        private String pretty;
        private String dryRun;
        private String fieldManager;
        private String fieldValidation;

        private APIreplaceNamespacedResourceClaimRequest(String name, String namespace, V1alpha2ResourceClaim body) {
            this.name = name;
            this.namespace = namespace;
            this.body = body;
        }

        public APIreplaceNamespacedResourceClaimRequest pretty(String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIreplaceNamespacedResourceClaimRequest dryRun(String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIreplaceNamespacedResourceClaimRequest fieldManager(String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIreplaceNamespacedResourceClaimRequest fieldValidation(String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1alpha2Api.this.replaceNamespacedResourceClaimCall(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }

        public V1alpha2ResourceClaim execute() throws ApiException {
            ApiResponse localVarResp = ResourceV1alpha2Api.this.replaceNamespacedResourceClaimWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
            return (V1alpha2ResourceClaim)localVarResp.getData();
        }

        public ApiResponse<V1alpha2ResourceClaim> executeWithHttpInfo() throws ApiException {
            return ResourceV1alpha2Api.this.replaceNamespacedResourceClaimWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
        }

        public Call executeAsync(ApiCallback<V1alpha2ResourceClaim> _callback) throws ApiException {
            return ResourceV1alpha2Api.this.replaceNamespacedResourceClaimAsync(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }
    }

    public class APIreplaceNamespacedResourceClaimStatusRequest {
        private final String name;
        private final String namespace;
        private final V1alpha2ResourceClaim body;
        private String pretty;
        private String dryRun;
        private String fieldManager;
        private String fieldValidation;

        private APIreplaceNamespacedResourceClaimStatusRequest(String name, String namespace, V1alpha2ResourceClaim body) {
            this.name = name;
            this.namespace = namespace;
            this.body = body;
        }

        public APIreplaceNamespacedResourceClaimStatusRequest pretty(String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIreplaceNamespacedResourceClaimStatusRequest dryRun(String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIreplaceNamespacedResourceClaimStatusRequest fieldManager(String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIreplaceNamespacedResourceClaimStatusRequest fieldValidation(String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1alpha2Api.this.replaceNamespacedResourceClaimStatusCall(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }

        public V1alpha2ResourceClaim execute() throws ApiException {
            ApiResponse localVarResp = ResourceV1alpha2Api.this.replaceNamespacedResourceClaimStatusWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
            return (V1alpha2ResourceClaim)localVarResp.getData();
        }

        public ApiResponse<V1alpha2ResourceClaim> executeWithHttpInfo() throws ApiException {
            return ResourceV1alpha2Api.this.replaceNamespacedResourceClaimStatusWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
        }

        public Call executeAsync(ApiCallback<V1alpha2ResourceClaim> _callback) throws ApiException {
            return ResourceV1alpha2Api.this.replaceNamespacedResourceClaimStatusAsync(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }
    }

    public class APIreplaceNamespacedResourceClaimTemplateRequest {
        private final String name;
        private final String namespace;
        private final V1alpha2ResourceClaimTemplate body;
        private String pretty;
        private String dryRun;
        private String fieldManager;
        private String fieldValidation;

        private APIreplaceNamespacedResourceClaimTemplateRequest(String name, String namespace, V1alpha2ResourceClaimTemplate body) {
            this.name = name;
            this.namespace = namespace;
            this.body = body;
        }

        public APIreplaceNamespacedResourceClaimTemplateRequest pretty(String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIreplaceNamespacedResourceClaimTemplateRequest dryRun(String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIreplaceNamespacedResourceClaimTemplateRequest fieldManager(String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIreplaceNamespacedResourceClaimTemplateRequest fieldValidation(String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1alpha2Api.this.replaceNamespacedResourceClaimTemplateCall(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }

        public V1alpha2ResourceClaimTemplate execute() throws ApiException {
            ApiResponse localVarResp = ResourceV1alpha2Api.this.replaceNamespacedResourceClaimTemplateWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
            return (V1alpha2ResourceClaimTemplate)localVarResp.getData();
        }

        public ApiResponse<V1alpha2ResourceClaimTemplate> executeWithHttpInfo() throws ApiException {
            return ResourceV1alpha2Api.this.replaceNamespacedResourceClaimTemplateWithHttpInfo(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
        }

        public Call executeAsync(ApiCallback<V1alpha2ResourceClaimTemplate> _callback) throws ApiException {
            return ResourceV1alpha2Api.this.replaceNamespacedResourceClaimTemplateAsync(this.name, this.namespace, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }
    }

    public class APIreplaceResourceClassRequest {
        private final String name;
        private final V1alpha2ResourceClass body;
        private String pretty;
        private String dryRun;
        private String fieldManager;
        private String fieldValidation;

        private APIreplaceResourceClassRequest(String name, V1alpha2ResourceClass body) {
            this.name = name;
            this.body = body;
        }

        public APIreplaceResourceClassRequest pretty(String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIreplaceResourceClassRequest dryRun(String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIreplaceResourceClassRequest fieldManager(String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIreplaceResourceClassRequest fieldValidation(String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ResourceV1alpha2Api.this.replaceResourceClassCall(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }

        public V1alpha2ResourceClass execute() throws ApiException {
            ApiResponse localVarResp = ResourceV1alpha2Api.this.replaceResourceClassWithHttpInfo(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
            return (V1alpha2ResourceClass)localVarResp.getData();
        }

        public ApiResponse<V1alpha2ResourceClass> executeWithHttpInfo() throws ApiException {
            return ResourceV1alpha2Api.this.replaceResourceClassWithHttpInfo(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
        }

        public Call executeAsync(ApiCallback<V1alpha2ResourceClass> _callback) throws ApiException {
            return ResourceV1alpha2Api.this.replaceResourceClassAsync(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }
    }
}

