/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.kubernetes.client.openapi.models.V1PodFailurePolicy;
import io.kubernetes.client.openapi.models.V1PodTemplateSpec;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class V1JobSpec {
    public static final String SERIALIZED_NAME_ACTIVE_DEADLINE_SECONDS = "activeDeadlineSeconds";
    @SerializedName(value="activeDeadlineSeconds")
    private Long activeDeadlineSeconds;
    public static final String SERIALIZED_NAME_BACKOFF_LIMIT = "backoffLimit";
    @SerializedName(value="backoffLimit")
    private Integer backoffLimit;
    public static final String SERIALIZED_NAME_BACKOFF_LIMIT_PER_INDEX = "backoffLimitPerIndex";
    @SerializedName(value="backoffLimitPerIndex")
    private Integer backoffLimitPerIndex;
    public static final String SERIALIZED_NAME_COMPLETION_MODE = "completionMode";
    @SerializedName(value="completionMode")
    private String completionMode;
    public static final String SERIALIZED_NAME_COMPLETIONS = "completions";
    @SerializedName(value="completions")
    private Integer completions;
    public static final String SERIALIZED_NAME_MANUAL_SELECTOR = "manualSelector";
    @SerializedName(value="manualSelector")
    private Boolean manualSelector;
    public static final String SERIALIZED_NAME_MAX_FAILED_INDEXES = "maxFailedIndexes";
    @SerializedName(value="maxFailedIndexes")
    private Integer maxFailedIndexes;
    public static final String SERIALIZED_NAME_PARALLELISM = "parallelism";
    @SerializedName(value="parallelism")
    private Integer parallelism;
    public static final String SERIALIZED_NAME_POD_FAILURE_POLICY = "podFailurePolicy";
    @SerializedName(value="podFailurePolicy")
    private V1PodFailurePolicy podFailurePolicy;
    public static final String SERIALIZED_NAME_POD_REPLACEMENT_POLICY = "podReplacementPolicy";
    @SerializedName(value="podReplacementPolicy")
    private String podReplacementPolicy;
    public static final String SERIALIZED_NAME_SELECTOR = "selector";
    @SerializedName(value="selector")
    private V1LabelSelector selector;
    public static final String SERIALIZED_NAME_SUSPEND = "suspend";
    @SerializedName(value="suspend")
    private Boolean suspend;
    public static final String SERIALIZED_NAME_TEMPLATE = "template";
    @SerializedName(value="template")
    private V1PodTemplateSpec template;
    public static final String SERIALIZED_NAME_TTL_SECONDS_AFTER_FINISHED = "ttlSecondsAfterFinished";
    @SerializedName(value="ttlSecondsAfterFinished")
    private Integer ttlSecondsAfterFinished;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1JobSpec activeDeadlineSeconds(Long activeDeadlineSeconds) {
        this.activeDeadlineSeconds = activeDeadlineSeconds;
        return this;
    }

    @Nullable
    public Long getActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds;
    }

    public void setActiveDeadlineSeconds(Long activeDeadlineSeconds) {
        this.activeDeadlineSeconds = activeDeadlineSeconds;
    }

    public V1JobSpec backoffLimit(Integer backoffLimit) {
        this.backoffLimit = backoffLimit;
        return this;
    }

    @Nullable
    public Integer getBackoffLimit() {
        return this.backoffLimit;
    }

    public void setBackoffLimit(Integer backoffLimit) {
        this.backoffLimit = backoffLimit;
    }

    public V1JobSpec backoffLimitPerIndex(Integer backoffLimitPerIndex) {
        this.backoffLimitPerIndex = backoffLimitPerIndex;
        return this;
    }

    @Nullable
    public Integer getBackoffLimitPerIndex() {
        return this.backoffLimitPerIndex;
    }

    public void setBackoffLimitPerIndex(Integer backoffLimitPerIndex) {
        this.backoffLimitPerIndex = backoffLimitPerIndex;
    }

    public V1JobSpec completionMode(String completionMode) {
        this.completionMode = completionMode;
        return this;
    }

    @Nullable
    public String getCompletionMode() {
        return this.completionMode;
    }

    public void setCompletionMode(String completionMode) {
        this.completionMode = completionMode;
    }

    public V1JobSpec completions(Integer completions) {
        this.completions = completions;
        return this;
    }

    @Nullable
    public Integer getCompletions() {
        return this.completions;
    }

    public void setCompletions(Integer completions) {
        this.completions = completions;
    }

    public V1JobSpec manualSelector(Boolean manualSelector) {
        this.manualSelector = manualSelector;
        return this;
    }

    @Nullable
    public Boolean getManualSelector() {
        return this.manualSelector;
    }

    public void setManualSelector(Boolean manualSelector) {
        this.manualSelector = manualSelector;
    }

    public V1JobSpec maxFailedIndexes(Integer maxFailedIndexes) {
        this.maxFailedIndexes = maxFailedIndexes;
        return this;
    }

    @Nullable
    public Integer getMaxFailedIndexes() {
        return this.maxFailedIndexes;
    }

    public void setMaxFailedIndexes(Integer maxFailedIndexes) {
        this.maxFailedIndexes = maxFailedIndexes;
    }

    public V1JobSpec parallelism(Integer parallelism) {
        this.parallelism = parallelism;
        return this;
    }

    @Nullable
    public Integer getParallelism() {
        return this.parallelism;
    }

    public void setParallelism(Integer parallelism) {
        this.parallelism = parallelism;
    }

    public V1JobSpec podFailurePolicy(V1PodFailurePolicy podFailurePolicy) {
        this.podFailurePolicy = podFailurePolicy;
        return this;
    }

    @Nullable
    public V1PodFailurePolicy getPodFailurePolicy() {
        return this.podFailurePolicy;
    }

    public void setPodFailurePolicy(V1PodFailurePolicy podFailurePolicy) {
        this.podFailurePolicy = podFailurePolicy;
    }

    public V1JobSpec podReplacementPolicy(String podReplacementPolicy) {
        this.podReplacementPolicy = podReplacementPolicy;
        return this;
    }

    @Nullable
    public String getPodReplacementPolicy() {
        return this.podReplacementPolicy;
    }

    public void setPodReplacementPolicy(String podReplacementPolicy) {
        this.podReplacementPolicy = podReplacementPolicy;
    }

    public V1JobSpec selector(V1LabelSelector selector) {
        this.selector = selector;
        return this;
    }

    @Nullable
    public V1LabelSelector getSelector() {
        return this.selector;
    }

    public void setSelector(V1LabelSelector selector) {
        this.selector = selector;
    }

    public V1JobSpec suspend(Boolean suspend) {
        this.suspend = suspend;
        return this;
    }

    @Nullable
    public Boolean getSuspend() {
        return this.suspend;
    }

    public void setSuspend(Boolean suspend) {
        this.suspend = suspend;
    }

    public V1JobSpec template(V1PodTemplateSpec template) {
        this.template = template;
        return this;
    }

    @Nonnull
    public V1PodTemplateSpec getTemplate() {
        return this.template;
    }

    public void setTemplate(V1PodTemplateSpec template) {
        this.template = template;
    }

    public V1JobSpec ttlSecondsAfterFinished(Integer ttlSecondsAfterFinished) {
        this.ttlSecondsAfterFinished = ttlSecondsAfterFinished;
        return this;
    }

    @Nullable
    public Integer getTtlSecondsAfterFinished() {
        return this.ttlSecondsAfterFinished;
    }

    public void setTtlSecondsAfterFinished(Integer ttlSecondsAfterFinished) {
        this.ttlSecondsAfterFinished = ttlSecondsAfterFinished;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1JobSpec v1JobSpec = (V1JobSpec)o;
        return Objects.equals(this.activeDeadlineSeconds, v1JobSpec.activeDeadlineSeconds) && Objects.equals(this.backoffLimit, v1JobSpec.backoffLimit) && Objects.equals(this.backoffLimitPerIndex, v1JobSpec.backoffLimitPerIndex) && Objects.equals(this.completionMode, v1JobSpec.completionMode) && Objects.equals(this.completions, v1JobSpec.completions) && Objects.equals(this.manualSelector, v1JobSpec.manualSelector) && Objects.equals(this.maxFailedIndexes, v1JobSpec.maxFailedIndexes) && Objects.equals(this.parallelism, v1JobSpec.parallelism) && Objects.equals(this.podFailurePolicy, v1JobSpec.podFailurePolicy) && Objects.equals(this.podReplacementPolicy, v1JobSpec.podReplacementPolicy) && Objects.equals(this.selector, v1JobSpec.selector) && Objects.equals(this.suspend, v1JobSpec.suspend) && Objects.equals(this.template, v1JobSpec.template) && Objects.equals(this.ttlSecondsAfterFinished, v1JobSpec.ttlSecondsAfterFinished);
    }

    public int hashCode() {
        return Objects.hash(this.activeDeadlineSeconds, this.backoffLimit, this.backoffLimitPerIndex, this.completionMode, this.completions, this.manualSelector, this.maxFailedIndexes, this.parallelism, this.podFailurePolicy, this.podReplacementPolicy, this.selector, this.suspend, this.template, this.ttlSecondsAfterFinished);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1JobSpec {\n");
        sb.append("    activeDeadlineSeconds: ").append(this.toIndentedString(this.activeDeadlineSeconds)).append("\n");
        sb.append("    backoffLimit: ").append(this.toIndentedString(this.backoffLimit)).append("\n");
        sb.append("    backoffLimitPerIndex: ").append(this.toIndentedString(this.backoffLimitPerIndex)).append("\n");
        sb.append("    completionMode: ").append(this.toIndentedString(this.completionMode)).append("\n");
        sb.append("    completions: ").append(this.toIndentedString(this.completions)).append("\n");
        sb.append("    manualSelector: ").append(this.toIndentedString(this.manualSelector)).append("\n");
        sb.append("    maxFailedIndexes: ").append(this.toIndentedString(this.maxFailedIndexes)).append("\n");
        sb.append("    parallelism: ").append(this.toIndentedString(this.parallelism)).append("\n");
        sb.append("    podFailurePolicy: ").append(this.toIndentedString(this.podFailurePolicy)).append("\n");
        sb.append("    podReplacementPolicy: ").append(this.toIndentedString(this.podReplacementPolicy)).append("\n");
        sb.append("    selector: ").append(this.toIndentedString(this.selector)).append("\n");
        sb.append("    suspend: ").append(this.toIndentedString(this.suspend)).append("\n");
        sb.append("    template: ").append(this.toIndentedString(this.template)).append("\n");
        sb.append("    ttlSecondsAfterFinished: ").append(this.toIndentedString(this.ttlSecondsAfterFinished)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1JobSpec is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1JobSpec` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COMPLETION_MODE) != null && !jsonObj.get(SERIALIZED_NAME_COMPLETION_MODE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_COMPLETION_MODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `completionMode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COMPLETION_MODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_POD_FAILURE_POLICY) != null && !jsonObj.get(SERIALIZED_NAME_POD_FAILURE_POLICY).isJsonNull()) {
            V1PodFailurePolicy.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_POD_FAILURE_POLICY));
        }
        if (jsonObj.get(SERIALIZED_NAME_POD_REPLACEMENT_POLICY) != null && !jsonObj.get(SERIALIZED_NAME_POD_REPLACEMENT_POLICY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_POD_REPLACEMENT_POLICY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `podReplacementPolicy` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_POD_REPLACEMENT_POLICY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SELECTOR) != null && !jsonObj.get(SERIALIZED_NAME_SELECTOR).isJsonNull()) {
            V1LabelSelector.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SELECTOR));
        }
        V1PodTemplateSpec.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_TEMPLATE));
    }

    public static V1JobSpec fromJson(String jsonString) throws IOException {
        return (V1JobSpec)JSON.getGson().fromJson(jsonString, V1JobSpec.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACTIVE_DEADLINE_SECONDS);
        openapiFields.add(SERIALIZED_NAME_BACKOFF_LIMIT);
        openapiFields.add(SERIALIZED_NAME_BACKOFF_LIMIT_PER_INDEX);
        openapiFields.add(SERIALIZED_NAME_COMPLETION_MODE);
        openapiFields.add(SERIALIZED_NAME_COMPLETIONS);
        openapiFields.add(SERIALIZED_NAME_MANUAL_SELECTOR);
        openapiFields.add(SERIALIZED_NAME_MAX_FAILED_INDEXES);
        openapiFields.add(SERIALIZED_NAME_PARALLELISM);
        openapiFields.add(SERIALIZED_NAME_POD_FAILURE_POLICY);
        openapiFields.add(SERIALIZED_NAME_POD_REPLACEMENT_POLICY);
        openapiFields.add(SERIALIZED_NAME_SELECTOR);
        openapiFields.add(SERIALIZED_NAME_SUSPEND);
        openapiFields.add(SERIALIZED_NAME_TEMPLATE);
        openapiFields.add(SERIALIZED_NAME_TTL_SECONDS_AFTER_FINISHED);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_TEMPLATE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1JobSpec.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1JobSpec.class));
            return new TypeAdapter<V1JobSpec>(){

                public void write(JsonWriter out, V1JobSpec value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1JobSpec read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    V1JobSpec.validateJsonObject(jsonObj);
                    return (V1JobSpec)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

