/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Describes the state of a migration at a certain point.")
public class V1alpha1MigrationCondition {
    public static final String SERIALIZED_NAME_LAST_UPDATE_TIME = "lastUpdateTime";
    @SerializedName(value="lastUpdateTime")
    private OffsetDateTime lastUpdateTime;
    public static final String SERIALIZED_NAME_MESSAGE = "message";
    @SerializedName(value="message")
    private String message;
    public static final String SERIALIZED_NAME_REASON = "reason";
    @SerializedName(value="reason")
    private String reason;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private String status;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;

    public V1alpha1MigrationCondition lastUpdateTime(OffsetDateTime lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The last time this condition was updated.")
    public OffsetDateTime getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(OffsetDateTime lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public V1alpha1MigrationCondition message(String message) {
        this.message = message;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A human readable message indicating details about the transition.")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public V1alpha1MigrationCondition reason(String reason) {
        this.reason = reason;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The reason for the condition's last transition.")
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public V1alpha1MigrationCondition status(String status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="Status of the condition, one of True, False, Unknown.")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public V1alpha1MigrationCondition type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="Type of the condition.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha1MigrationCondition v1alpha1MigrationCondition = (V1alpha1MigrationCondition)o;
        return Objects.equals(this.lastUpdateTime, v1alpha1MigrationCondition.lastUpdateTime) && Objects.equals(this.message, v1alpha1MigrationCondition.message) && Objects.equals(this.reason, v1alpha1MigrationCondition.reason) && Objects.equals(this.status, v1alpha1MigrationCondition.status) && Objects.equals(this.type, v1alpha1MigrationCondition.type);
    }

    public int hashCode() {
        return Objects.hash(this.lastUpdateTime, this.message, this.reason, this.status, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha1MigrationCondition {\n");
        sb.append("    lastUpdateTime: ").append(this.toIndentedString(this.lastUpdateTime)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

