/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.DiscoveryV1EndpointPort;
import io.kubernetes.client.openapi.models.V1Endpoint;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="EndpointSlice represents a subset of the endpoints that implement a service. For a given service there may be multiple EndpointSlice objects, selected by labels, which must be joined to produce the full set of endpoints.")
public class V1EndpointSlice
implements KubernetesObject {
    public static final String SERIALIZED_NAME_ADDRESS_TYPE = "addressType";
    @SerializedName(value="addressType")
    private String addressType;
    public static final String SERIALIZED_NAME_API_VERSION = "apiVersion";
    @SerializedName(value="apiVersion")
    private String apiVersion;
    public static final String SERIALIZED_NAME_ENDPOINTS = "endpoints";
    @SerializedName(value="endpoints")
    private List<V1Endpoint> endpoints = new ArrayList<V1Endpoint>();
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    private String kind;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private V1ObjectMeta metadata;
    public static final String SERIALIZED_NAME_PORTS = "ports";
    @SerializedName(value="ports")
    private List<DiscoveryV1EndpointPort> ports = new ArrayList<DiscoveryV1EndpointPort>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1EndpointSlice addressType(String addressType) {
        this.addressType = addressType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="addressType specifies the type of address carried by this EndpointSlice. All addresses in this slice must be the same type. This field is immutable after creation. The following address types are currently supported: * IPv4: Represents an IPv4 Address. * IPv6: Represents an IPv6 Address. * FQDN: Represents a Fully Qualified Domain Name.")
    public String getAddressType() {
        return this.addressType;
    }

    public void setAddressType(String addressType) {
        this.addressType = addressType;
    }

    public V1EndpointSlice apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Override
    @Nullable
    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1EndpointSlice endpoints(List<V1Endpoint> endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    public V1EndpointSlice addEndpointsItem(V1Endpoint endpointsItem) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<V1Endpoint>();
        }
        this.endpoints.add(endpointsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="endpoints is a list of unique endpoints in this slice. Each slice may include a maximum of 1000 endpoints.")
    public List<V1Endpoint> getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(List<V1Endpoint> endpoints) {
        this.endpoints = endpoints;
    }

    public V1EndpointSlice kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Override
    @Nullable
    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1EndpointSlice metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @Override
    @Nullable
    @ApiModelProperty(value="")
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V1EndpointSlice ports(List<DiscoveryV1EndpointPort> ports) {
        this.ports = ports;
        return this;
    }

    public V1EndpointSlice addPortsItem(DiscoveryV1EndpointPort portsItem) {
        if (this.ports == null) {
            this.ports = new ArrayList<DiscoveryV1EndpointPort>();
        }
        this.ports.add(portsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ports specifies the list of network ports exposed by each endpoint in this slice. Each port must have a unique name. When ports is empty, it indicates that there are no defined ports. When a port is defined with a nil port value, it indicates \"all ports\". Each slice may include a maximum of 100 ports.")
    public List<DiscoveryV1EndpointPort> getPorts() {
        return this.ports;
    }

    public void setPorts(List<DiscoveryV1EndpointPort> ports) {
        this.ports = ports;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1EndpointSlice v1EndpointSlice = (V1EndpointSlice)o;
        return Objects.equals(this.addressType, v1EndpointSlice.addressType) && Objects.equals(this.apiVersion, v1EndpointSlice.apiVersion) && Objects.equals(this.endpoints, v1EndpointSlice.endpoints) && Objects.equals(this.kind, v1EndpointSlice.kind) && Objects.equals(this.metadata, v1EndpointSlice.metadata) && Objects.equals(this.ports, v1EndpointSlice.ports);
    }

    public int hashCode() {
        return Objects.hash(this.addressType, this.apiVersion, this.endpoints, this.kind, this.metadata, this.ports);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1EndpointSlice {\n");
        sb.append("    addressType: ").append(this.toIndentedString(this.addressType)).append("\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    endpoints: ").append(this.toIndentedString(this.endpoints)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    ports: ").append(this.toIndentedString(this.ports)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayports;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1EndpointSlice is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1EndpointSlice` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_ADDRESS_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `addressType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ADDRESS_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_API_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_API_VERSION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_API_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `apiVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_API_VERSION).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_ENDPOINTS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `endpoints` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENDPOINTS).toString()));
        }
        JsonArray jsonArrayendpoints = jsonObj.getAsJsonArray(SERIALIZED_NAME_ENDPOINTS);
        for (int i = 0; i < jsonArrayendpoints.size(); ++i) {
            V1Endpoint.validateJsonElement(jsonArrayendpoints.get(i));
        }
        if (jsonObj.get(SERIALIZED_NAME_KIND) != null && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `kind` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KIND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_METADATA) != null && !jsonObj.get(SERIALIZED_NAME_METADATA).isJsonNull()) {
            V1ObjectMeta.validateJsonElement(jsonObj.get(SERIALIZED_NAME_METADATA));
        }
        if (jsonObj.get(SERIALIZED_NAME_PORTS) != null && !jsonObj.get(SERIALIZED_NAME_PORTS).isJsonNull() && (jsonArrayports = jsonObj.getAsJsonArray(SERIALIZED_NAME_PORTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_PORTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `ports` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PORTS).toString()));
            }
            for (int i = 0; i < jsonArrayports.size(); ++i) {
                DiscoveryV1EndpointPort.validateJsonElement(jsonArrayports.get(i));
            }
        }
    }

    public static V1EndpointSlice fromJson(String jsonString) throws IOException {
        return (V1EndpointSlice)JSON.getGson().fromJson(jsonString, V1EndpointSlice.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ADDRESS_TYPE);
        openapiFields.add(SERIALIZED_NAME_API_VERSION);
        openapiFields.add(SERIALIZED_NAME_ENDPOINTS);
        openapiFields.add(SERIALIZED_NAME_KIND);
        openapiFields.add(SERIALIZED_NAME_METADATA);
        openapiFields.add(SERIALIZED_NAME_PORTS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ADDRESS_TYPE);
        openapiRequiredFields.add(SERIALIZED_NAME_ENDPOINTS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1EndpointSlice.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1EndpointSlice.class));
            return new TypeAdapter<V1EndpointSlice>(){

                public void write(JsonWriter out, V1EndpointSlice value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1EndpointSlice read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1EndpointSlice.validateJsonElement(jsonElement);
                    return (V1EndpointSlice)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

