/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1ContainerStatus;
import io.kubernetes.client.openapi.models.V1HostIP;
import io.kubernetes.client.openapi.models.V1PodCondition;
import io.kubernetes.client.openapi.models.V1PodIP;
import io.kubernetes.client.openapi.models.V1PodResourceClaimStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="PodStatus represents information about the status of a pod. Status may trail the actual state of a system, especially if the node that hosts the pod cannot contact the control plane.")
public class V1PodStatus {
    public static final String SERIALIZED_NAME_CONDITIONS = "conditions";
    @SerializedName(value="conditions")
    private List<V1PodCondition> conditions = new ArrayList<V1PodCondition>();
    public static final String SERIALIZED_NAME_CONTAINER_STATUSES = "containerStatuses";
    @SerializedName(value="containerStatuses")
    private List<V1ContainerStatus> containerStatuses = new ArrayList<V1ContainerStatus>();
    public static final String SERIALIZED_NAME_EPHEMERAL_CONTAINER_STATUSES = "ephemeralContainerStatuses";
    @SerializedName(value="ephemeralContainerStatuses")
    private List<V1ContainerStatus> ephemeralContainerStatuses = new ArrayList<V1ContainerStatus>();
    public static final String SERIALIZED_NAME_HOST_I_P = "hostIP";
    @SerializedName(value="hostIP")
    private String hostIP;
    public static final String SERIALIZED_NAME_HOST_I_PS = "hostIPs";
    @SerializedName(value="hostIPs")
    private List<V1HostIP> hostIPs = new ArrayList<V1HostIP>();
    public static final String SERIALIZED_NAME_INIT_CONTAINER_STATUSES = "initContainerStatuses";
    @SerializedName(value="initContainerStatuses")
    private List<V1ContainerStatus> initContainerStatuses = new ArrayList<V1ContainerStatus>();
    public static final String SERIALIZED_NAME_MESSAGE = "message";
    @SerializedName(value="message")
    private String message;
    public static final String SERIALIZED_NAME_NOMINATED_NODE_NAME = "nominatedNodeName";
    @SerializedName(value="nominatedNodeName")
    private String nominatedNodeName;
    public static final String SERIALIZED_NAME_PHASE = "phase";
    @SerializedName(value="phase")
    private String phase;
    public static final String SERIALIZED_NAME_POD_I_P = "podIP";
    @SerializedName(value="podIP")
    private String podIP;
    public static final String SERIALIZED_NAME_POD_I_PS = "podIPs";
    @SerializedName(value="podIPs")
    private List<V1PodIP> podIPs = new ArrayList<V1PodIP>();
    public static final String SERIALIZED_NAME_QOS_CLASS = "qosClass";
    @SerializedName(value="qosClass")
    private String qosClass;
    public static final String SERIALIZED_NAME_REASON = "reason";
    @SerializedName(value="reason")
    private String reason;
    public static final String SERIALIZED_NAME_RESIZE = "resize";
    @SerializedName(value="resize")
    private String resize;
    public static final String SERIALIZED_NAME_RESOURCE_CLAIM_STATUSES = "resourceClaimStatuses";
    @SerializedName(value="resourceClaimStatuses")
    private List<V1PodResourceClaimStatus> resourceClaimStatuses = new ArrayList<V1PodResourceClaimStatus>();
    public static final String SERIALIZED_NAME_START_TIME = "startTime";
    @SerializedName(value="startTime")
    private OffsetDateTime startTime;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1PodStatus conditions(List<V1PodCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public V1PodStatus addConditionsItem(V1PodCondition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1PodCondition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Current service state of pod. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-conditions")
    public List<V1PodCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<V1PodCondition> conditions) {
        this.conditions = conditions;
    }

    public V1PodStatus containerStatuses(List<V1ContainerStatus> containerStatuses) {
        this.containerStatuses = containerStatuses;
        return this;
    }

    public V1PodStatus addContainerStatusesItem(V1ContainerStatus containerStatusesItem) {
        if (this.containerStatuses == null) {
            this.containerStatuses = new ArrayList<V1ContainerStatus>();
        }
        this.containerStatuses.add(containerStatusesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Statuses of containers in this pod. Each container in the pod should have at most one status in this list, and all statuses should be for containers in the pod. However this is not enforced. If a status for a non-existent container is present in the list, or the list has duplicate names, the behavior of various Kubernetes components is not defined and those statuses might be ignored. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-and-container-status")
    public List<V1ContainerStatus> getContainerStatuses() {
        return this.containerStatuses;
    }

    public void setContainerStatuses(List<V1ContainerStatus> containerStatuses) {
        this.containerStatuses = containerStatuses;
    }

    public V1PodStatus ephemeralContainerStatuses(List<V1ContainerStatus> ephemeralContainerStatuses) {
        this.ephemeralContainerStatuses = ephemeralContainerStatuses;
        return this;
    }

    public V1PodStatus addEphemeralContainerStatusesItem(V1ContainerStatus ephemeralContainerStatusesItem) {
        if (this.ephemeralContainerStatuses == null) {
            this.ephemeralContainerStatuses = new ArrayList<V1ContainerStatus>();
        }
        this.ephemeralContainerStatuses.add(ephemeralContainerStatusesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Statuses for any ephemeral containers that have run in this pod. Each ephemeral container in the pod should have at most one status in this list, and all statuses should be for containers in the pod. However this is not enforced. If a status for a non-existent container is present in the list, or the list has duplicate names, the behavior of various Kubernetes components is not defined and those statuses might be ignored. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-and-container-status")
    public List<V1ContainerStatus> getEphemeralContainerStatuses() {
        return this.ephemeralContainerStatuses;
    }

    public void setEphemeralContainerStatuses(List<V1ContainerStatus> ephemeralContainerStatuses) {
        this.ephemeralContainerStatuses = ephemeralContainerStatuses;
    }

    public V1PodStatus hostIP(String hostIP) {
        this.hostIP = hostIP;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="hostIP holds the IP address of the host to which the pod is assigned. Empty if the pod has not started yet. A pod can be assigned to a node that has a problem in kubelet which in turns mean that HostIP will not be updated even if there is a node is assigned to pod")
    public String getHostIP() {
        return this.hostIP;
    }

    public void setHostIP(String hostIP) {
        this.hostIP = hostIP;
    }

    public V1PodStatus hostIPs(List<V1HostIP> hostIPs) {
        this.hostIPs = hostIPs;
        return this;
    }

    public V1PodStatus addHostIPsItem(V1HostIP hostIPsItem) {
        if (this.hostIPs == null) {
            this.hostIPs = new ArrayList<V1HostIP>();
        }
        this.hostIPs.add(hostIPsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="hostIPs holds the IP addresses allocated to the host. If this field is specified, the first entry must match the hostIP field. This list is empty if the pod has not started yet. A pod can be assigned to a node that has a problem in kubelet which in turns means that HostIPs will not be updated even if there is a node is assigned to this pod.")
    public List<V1HostIP> getHostIPs() {
        return this.hostIPs;
    }

    public void setHostIPs(List<V1HostIP> hostIPs) {
        this.hostIPs = hostIPs;
    }

    public V1PodStatus initContainerStatuses(List<V1ContainerStatus> initContainerStatuses) {
        this.initContainerStatuses = initContainerStatuses;
        return this;
    }

    public V1PodStatus addInitContainerStatusesItem(V1ContainerStatus initContainerStatusesItem) {
        if (this.initContainerStatuses == null) {
            this.initContainerStatuses = new ArrayList<V1ContainerStatus>();
        }
        this.initContainerStatuses.add(initContainerStatusesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Statuses of init containers in this pod. The most recent successful non-restartable init container will have ready = true, the most recently started container will have startTime set. Each init container in the pod should have at most one status in this list, and all statuses should be for containers in the pod. However this is not enforced. If a status for a non-existent container is present in the list, or the list has duplicate names, the behavior of various Kubernetes components is not defined and those statuses might be ignored. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#pod-and-container-status")
    public List<V1ContainerStatus> getInitContainerStatuses() {
        return this.initContainerStatuses;
    }

    public void setInitContainerStatuses(List<V1ContainerStatus> initContainerStatuses) {
        this.initContainerStatuses = initContainerStatuses;
    }

    public V1PodStatus message(String message) {
        this.message = message;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A human readable message indicating details about why the pod is in this condition.")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public V1PodStatus nominatedNodeName(String nominatedNodeName) {
        this.nominatedNodeName = nominatedNodeName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="nominatedNodeName is set only when this pod preempts other pods on the node, but it cannot be scheduled right away as preemption victims receive their graceful termination periods. This field does not guarantee that the pod will be scheduled on this node. Scheduler may decide to place the pod elsewhere if other nodes become available sooner. Scheduler may also decide to give the resources on this node to a higher priority pod that is created after preemption. As a result, this field may be different than PodSpec.nodeName when the pod is scheduled.")
    public String getNominatedNodeName() {
        return this.nominatedNodeName;
    }

    public void setNominatedNodeName(String nominatedNodeName) {
        this.nominatedNodeName = nominatedNodeName;
    }

    public V1PodStatus phase(String phase) {
        this.phase = phase;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The phase of a Pod is a simple, high-level summary of where the Pod is in its lifecycle. The conditions array, the reason and message fields, and the individual container status arrays contain more detail about the pod's status. There are five possible phase values:  Pending: The pod has been accepted by the Kubernetes system, but one or more of the container images has not been created. This includes time before being scheduled as well as time spent downloading images over the network, which could take a while. Running: The pod has been bound to a node, and all of the containers have been created. At least one container is still running, or is in the process of starting or restarting. Succeeded: All containers in the pod have terminated in success, and will not be restarted. Failed: All containers in the pod have terminated, and at least one container has terminated in failure. The container either exited with non-zero status or was terminated by the system. Unknown: For some reason the state of the pod could not be obtained, typically due to an error in communicating with the host of the pod.  More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-phase")
    public String getPhase() {
        return this.phase;
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }

    public V1PodStatus podIP(String podIP) {
        this.podIP = podIP;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="podIP address allocated to the pod. Routable at least within the cluster. Empty if not yet allocated.")
    public String getPodIP() {
        return this.podIP;
    }

    public void setPodIP(String podIP) {
        this.podIP = podIP;
    }

    public V1PodStatus podIPs(List<V1PodIP> podIPs) {
        this.podIPs = podIPs;
        return this;
    }

    public V1PodStatus addPodIPsItem(V1PodIP podIPsItem) {
        if (this.podIPs == null) {
            this.podIPs = new ArrayList<V1PodIP>();
        }
        this.podIPs.add(podIPsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="podIPs holds the IP addresses allocated to the pod. If this field is specified, the 0th entry must match the podIP field. Pods may be allocated at most 1 value for each of IPv4 and IPv6. This list is empty if no IPs have been allocated yet.")
    public List<V1PodIP> getPodIPs() {
        return this.podIPs;
    }

    public void setPodIPs(List<V1PodIP> podIPs) {
        this.podIPs = podIPs;
    }

    public V1PodStatus qosClass(String qosClass) {
        this.qosClass = qosClass;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Quality of Service (QOS) classification assigned to the pod based on resource requirements See PodQOSClass type for available QOS classes More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-qos/#quality-of-service-classes")
    public String getQosClass() {
        return this.qosClass;
    }

    public void setQosClass(String qosClass) {
        this.qosClass = qosClass;
    }

    public V1PodStatus reason(String reason) {
        this.reason = reason;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A brief CamelCase message indicating details about why the pod is in this state. e.g. 'Evicted'")
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public V1PodStatus resize(String resize) {
        this.resize = resize;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Status of resources resize desired for pod's containers. It is empty if no resources resize is pending. Any changes to container resources will automatically set this to \"Proposed\"")
    public String getResize() {
        return this.resize;
    }

    public void setResize(String resize) {
        this.resize = resize;
    }

    public V1PodStatus resourceClaimStatuses(List<V1PodResourceClaimStatus> resourceClaimStatuses) {
        this.resourceClaimStatuses = resourceClaimStatuses;
        return this;
    }

    public V1PodStatus addResourceClaimStatusesItem(V1PodResourceClaimStatus resourceClaimStatusesItem) {
        if (this.resourceClaimStatuses == null) {
            this.resourceClaimStatuses = new ArrayList<V1PodResourceClaimStatus>();
        }
        this.resourceClaimStatuses.add(resourceClaimStatusesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Status of resource claims.")
    public List<V1PodResourceClaimStatus> getResourceClaimStatuses() {
        return this.resourceClaimStatuses;
    }

    public void setResourceClaimStatuses(List<V1PodResourceClaimStatus> resourceClaimStatuses) {
        this.resourceClaimStatuses = resourceClaimStatuses;
    }

    public V1PodStatus startTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="RFC 3339 date and time at which the object was acknowledged by the Kubelet. This is before the Kubelet pulled the container image(s) for the pod.")
    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PodStatus v1PodStatus = (V1PodStatus)o;
        return Objects.equals(this.conditions, v1PodStatus.conditions) && Objects.equals(this.containerStatuses, v1PodStatus.containerStatuses) && Objects.equals(this.ephemeralContainerStatuses, v1PodStatus.ephemeralContainerStatuses) && Objects.equals(this.hostIP, v1PodStatus.hostIP) && Objects.equals(this.hostIPs, v1PodStatus.hostIPs) && Objects.equals(this.initContainerStatuses, v1PodStatus.initContainerStatuses) && Objects.equals(this.message, v1PodStatus.message) && Objects.equals(this.nominatedNodeName, v1PodStatus.nominatedNodeName) && Objects.equals(this.phase, v1PodStatus.phase) && Objects.equals(this.podIP, v1PodStatus.podIP) && Objects.equals(this.podIPs, v1PodStatus.podIPs) && Objects.equals(this.qosClass, v1PodStatus.qosClass) && Objects.equals(this.reason, v1PodStatus.reason) && Objects.equals(this.resize, v1PodStatus.resize) && Objects.equals(this.resourceClaimStatuses, v1PodStatus.resourceClaimStatuses) && Objects.equals(this.startTime, v1PodStatus.startTime);
    }

    public int hashCode() {
        return Objects.hash(this.conditions, this.containerStatuses, this.ephemeralContainerStatuses, this.hostIP, this.hostIPs, this.initContainerStatuses, this.message, this.nominatedNodeName, this.phase, this.podIP, this.podIPs, this.qosClass, this.reason, this.resize, this.resourceClaimStatuses, this.startTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1PodStatus {\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    containerStatuses: ").append(this.toIndentedString(this.containerStatuses)).append("\n");
        sb.append("    ephemeralContainerStatuses: ").append(this.toIndentedString(this.ephemeralContainerStatuses)).append("\n");
        sb.append("    hostIP: ").append(this.toIndentedString(this.hostIP)).append("\n");
        sb.append("    hostIPs: ").append(this.toIndentedString(this.hostIPs)).append("\n");
        sb.append("    initContainerStatuses: ").append(this.toIndentedString(this.initContainerStatuses)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    nominatedNodeName: ").append(this.toIndentedString(this.nominatedNodeName)).append("\n");
        sb.append("    phase: ").append(this.toIndentedString(this.phase)).append("\n");
        sb.append("    podIP: ").append(this.toIndentedString(this.podIP)).append("\n");
        sb.append("    podIPs: ").append(this.toIndentedString(this.podIPs)).append("\n");
        sb.append("    qosClass: ").append(this.toIndentedString(this.qosClass)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    resize: ").append(this.toIndentedString(this.resize)).append("\n");
        sb.append("    resourceClaimStatuses: ").append(this.toIndentedString(this.resourceClaimStatuses)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayresourceClaimStatuses;
        JsonArray jsonArraypodIPs;
        JsonArray jsonArrayinitContainerStatuses;
        JsonArray jsonArrayhostIPs;
        JsonArray jsonArrayephemeralContainerStatuses;
        JsonArray jsonArraycontainerStatuses;
        int i;
        JsonArray jsonArrayconditions;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1PodStatus is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1PodStatus` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_CONDITIONS) != null && !jsonObj.get(SERIALIZED_NAME_CONDITIONS).isJsonNull() && (jsonArrayconditions = jsonObj.getAsJsonArray(SERIALIZED_NAME_CONDITIONS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CONDITIONS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `conditions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONDITIONS).toString()));
            }
            for (i = 0; i < jsonArrayconditions.size(); ++i) {
                V1PodCondition.validateJsonElement(jsonArrayconditions.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_CONTAINER_STATUSES) != null && !jsonObj.get(SERIALIZED_NAME_CONTAINER_STATUSES).isJsonNull() && (jsonArraycontainerStatuses = jsonObj.getAsJsonArray(SERIALIZED_NAME_CONTAINER_STATUSES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CONTAINER_STATUSES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `containerStatuses` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONTAINER_STATUSES).toString()));
            }
            for (i = 0; i < jsonArraycontainerStatuses.size(); ++i) {
                V1ContainerStatus.validateJsonElement(jsonArraycontainerStatuses.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_EPHEMERAL_CONTAINER_STATUSES) != null && !jsonObj.get(SERIALIZED_NAME_EPHEMERAL_CONTAINER_STATUSES).isJsonNull() && (jsonArrayephemeralContainerStatuses = jsonObj.getAsJsonArray(SERIALIZED_NAME_EPHEMERAL_CONTAINER_STATUSES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_EPHEMERAL_CONTAINER_STATUSES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `ephemeralContainerStatuses` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EPHEMERAL_CONTAINER_STATUSES).toString()));
            }
            for (i = 0; i < jsonArrayephemeralContainerStatuses.size(); ++i) {
                V1ContainerStatus.validateJsonElement(jsonArrayephemeralContainerStatuses.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_HOST_I_P) != null && !jsonObj.get(SERIALIZED_NAME_HOST_I_P).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_HOST_I_P).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `hostIP` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HOST_I_P).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_HOST_I_PS) != null && !jsonObj.get(SERIALIZED_NAME_HOST_I_PS).isJsonNull() && (jsonArrayhostIPs = jsonObj.getAsJsonArray(SERIALIZED_NAME_HOST_I_PS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_HOST_I_PS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `hostIPs` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HOST_I_PS).toString()));
            }
            for (i = 0; i < jsonArrayhostIPs.size(); ++i) {
                V1HostIP.validateJsonElement(jsonArrayhostIPs.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_INIT_CONTAINER_STATUSES) != null && !jsonObj.get(SERIALIZED_NAME_INIT_CONTAINER_STATUSES).isJsonNull() && (jsonArrayinitContainerStatuses = jsonObj.getAsJsonArray(SERIALIZED_NAME_INIT_CONTAINER_STATUSES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_INIT_CONTAINER_STATUSES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `initContainerStatuses` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INIT_CONTAINER_STATUSES).toString()));
            }
            for (i = 0; i < jsonArrayinitContainerStatuses.size(); ++i) {
                V1ContainerStatus.validateJsonElement(jsonArrayinitContainerStatuses.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_MESSAGE) != null && !jsonObj.get(SERIALIZED_NAME_MESSAGE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_MESSAGE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `message` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MESSAGE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NOMINATED_NODE_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NOMINATED_NODE_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NOMINATED_NODE_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `nominatedNodeName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NOMINATED_NODE_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PHASE) != null && !jsonObj.get(SERIALIZED_NAME_PHASE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PHASE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `phase` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PHASE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_POD_I_P) != null && !jsonObj.get(SERIALIZED_NAME_POD_I_P).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_POD_I_P).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `podIP` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_POD_I_P).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_POD_I_PS) != null && !jsonObj.get(SERIALIZED_NAME_POD_I_PS).isJsonNull() && (jsonArraypodIPs = jsonObj.getAsJsonArray(SERIALIZED_NAME_POD_I_PS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_POD_I_PS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `podIPs` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_POD_I_PS).toString()));
            }
            for (i = 0; i < jsonArraypodIPs.size(); ++i) {
                V1PodIP.validateJsonElement(jsonArraypodIPs.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_QOS_CLASS) != null && !jsonObj.get(SERIALIZED_NAME_QOS_CLASS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_QOS_CLASS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `qosClass` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_QOS_CLASS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REASON) != null && !jsonObj.get(SERIALIZED_NAME_REASON).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_REASON).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `reason` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REASON).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESIZE) != null && !jsonObj.get(SERIALIZED_NAME_RESIZE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_RESIZE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `resize` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESIZE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESOURCE_CLAIM_STATUSES) != null && !jsonObj.get(SERIALIZED_NAME_RESOURCE_CLAIM_STATUSES).isJsonNull() && (jsonArrayresourceClaimStatuses = jsonObj.getAsJsonArray(SERIALIZED_NAME_RESOURCE_CLAIM_STATUSES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_RESOURCE_CLAIM_STATUSES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `resourceClaimStatuses` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESOURCE_CLAIM_STATUSES).toString()));
            }
            for (i = 0; i < jsonArrayresourceClaimStatuses.size(); ++i) {
                V1PodResourceClaimStatus.validateJsonElement(jsonArrayresourceClaimStatuses.get(i));
            }
        }
    }

    public static V1PodStatus fromJson(String jsonString) throws IOException {
        return (V1PodStatus)JSON.getGson().fromJson(jsonString, V1PodStatus.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CONDITIONS);
        openapiFields.add(SERIALIZED_NAME_CONTAINER_STATUSES);
        openapiFields.add(SERIALIZED_NAME_EPHEMERAL_CONTAINER_STATUSES);
        openapiFields.add(SERIALIZED_NAME_HOST_I_P);
        openapiFields.add(SERIALIZED_NAME_HOST_I_PS);
        openapiFields.add(SERIALIZED_NAME_INIT_CONTAINER_STATUSES);
        openapiFields.add(SERIALIZED_NAME_MESSAGE);
        openapiFields.add(SERIALIZED_NAME_NOMINATED_NODE_NAME);
        openapiFields.add(SERIALIZED_NAME_PHASE);
        openapiFields.add(SERIALIZED_NAME_POD_I_P);
        openapiFields.add(SERIALIZED_NAME_POD_I_PS);
        openapiFields.add(SERIALIZED_NAME_QOS_CLASS);
        openapiFields.add(SERIALIZED_NAME_REASON);
        openapiFields.add(SERIALIZED_NAME_RESIZE);
        openapiFields.add(SERIALIZED_NAME_RESOURCE_CLAIM_STATUSES);
        openapiFields.add(SERIALIZED_NAME_START_TIME);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1PodStatus.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1PodStatus.class));
            return new TypeAdapter<V1PodStatus>(){

                public void write(JsonWriter out, V1PodStatus value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1PodStatus read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1PodStatus.validateJsonElement(jsonElement);
                    return (V1PodStatus)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

