/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V2ContainerResourceMetricSource;
import io.kubernetes.client.openapi.models.V2ExternalMetricSource;
import io.kubernetes.client.openapi.models.V2ObjectMetricSource;
import io.kubernetes.client.openapi.models.V2PodsMetricSource;
import io.kubernetes.client.openapi.models.V2ResourceMetricSource;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="MetricSpec specifies how to scale based on a single metric (only `type` and one other matching field should be set at once).")
public class V2MetricSpec {
    public static final String SERIALIZED_NAME_CONTAINER_RESOURCE = "containerResource";
    @SerializedName(value="containerResource")
    private V2ContainerResourceMetricSource containerResource;
    public static final String SERIALIZED_NAME_EXTERNAL = "external";
    @SerializedName(value="external")
    private V2ExternalMetricSource external;
    public static final String SERIALIZED_NAME_OBJECT = "object";
    @SerializedName(value="object")
    private V2ObjectMetricSource _object;
    public static final String SERIALIZED_NAME_PODS = "pods";
    @SerializedName(value="pods")
    private V2PodsMetricSource pods;
    public static final String SERIALIZED_NAME_RESOURCE = "resource";
    @SerializedName(value="resource")
    private V2ResourceMetricSource resource;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V2MetricSpec containerResource(V2ContainerResourceMetricSource containerResource) {
        this.containerResource = containerResource;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V2ContainerResourceMetricSource getContainerResource() {
        return this.containerResource;
    }

    public void setContainerResource(V2ContainerResourceMetricSource containerResource) {
        this.containerResource = containerResource;
    }

    public V2MetricSpec external(V2ExternalMetricSource external) {
        this.external = external;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V2ExternalMetricSource getExternal() {
        return this.external;
    }

    public void setExternal(V2ExternalMetricSource external) {
        this.external = external;
    }

    public V2MetricSpec _object(V2ObjectMetricSource _object) {
        this._object = _object;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V2ObjectMetricSource getObject() {
        return this._object;
    }

    public void setObject(V2ObjectMetricSource _object) {
        this._object = _object;
    }

    public V2MetricSpec pods(V2PodsMetricSource pods) {
        this.pods = pods;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V2PodsMetricSource getPods() {
        return this.pods;
    }

    public void setPods(V2PodsMetricSource pods) {
        this.pods = pods;
    }

    public V2MetricSpec resource(V2ResourceMetricSource resource) {
        this.resource = resource;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V2ResourceMetricSource getResource() {
        return this.resource;
    }

    public void setResource(V2ResourceMetricSource resource) {
        this.resource = resource;
    }

    public V2MetricSpec type(String type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="type is the type of metric source.  It should be one of \"ContainerResource\", \"External\", \"Object\", \"Pods\" or \"Resource\", each mapping to a matching field in the object.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2MetricSpec v2MetricSpec = (V2MetricSpec)o;
        return Objects.equals(this.containerResource, v2MetricSpec.containerResource) && Objects.equals(this.external, v2MetricSpec.external) && Objects.equals(this._object, v2MetricSpec._object) && Objects.equals(this.pods, v2MetricSpec.pods) && Objects.equals(this.resource, v2MetricSpec.resource) && Objects.equals(this.type, v2MetricSpec.type);
    }

    public int hashCode() {
        return Objects.hash(this.containerResource, this.external, this._object, this.pods, this.resource, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V2MetricSpec {\n");
        sb.append("    containerResource: ").append(this.toIndentedString(this.containerResource)).append("\n");
        sb.append("    external: ").append(this.toIndentedString(this.external)).append("\n");
        sb.append("    _object: ").append(this.toIndentedString(this._object)).append("\n");
        sb.append("    pods: ").append(this.toIndentedString(this.pods)).append("\n");
        sb.append("    resource: ").append(this.toIndentedString(this.resource)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V2MetricSpec is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V2MetricSpec` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_CONTAINER_RESOURCE) != null && !jsonObj.get(SERIALIZED_NAME_CONTAINER_RESOURCE).isJsonNull()) {
            V2ContainerResourceMetricSource.validateJsonElement(jsonObj.get(SERIALIZED_NAME_CONTAINER_RESOURCE));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXTERNAL) != null && !jsonObj.get(SERIALIZED_NAME_EXTERNAL).isJsonNull()) {
            V2ExternalMetricSource.validateJsonElement(jsonObj.get(SERIALIZED_NAME_EXTERNAL));
        }
        if (jsonObj.get(SERIALIZED_NAME_OBJECT) != null && !jsonObj.get(SERIALIZED_NAME_OBJECT).isJsonNull()) {
            V2ObjectMetricSource.validateJsonElement(jsonObj.get(SERIALIZED_NAME_OBJECT));
        }
        if (jsonObj.get(SERIALIZED_NAME_PODS) != null && !jsonObj.get(SERIALIZED_NAME_PODS).isJsonNull()) {
            V2PodsMetricSource.validateJsonElement(jsonObj.get(SERIALIZED_NAME_PODS));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESOURCE) != null && !jsonObj.get(SERIALIZED_NAME_RESOURCE).isJsonNull()) {
            V2ResourceMetricSource.validateJsonElement(jsonObj.get(SERIALIZED_NAME_RESOURCE));
        }
        if (!jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
        }
    }

    public static V2MetricSpec fromJson(String jsonString) throws IOException {
        return (V2MetricSpec)JSON.getGson().fromJson(jsonString, V2MetricSpec.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CONTAINER_RESOURCE);
        openapiFields.add(SERIALIZED_NAME_EXTERNAL);
        openapiFields.add(SERIALIZED_NAME_OBJECT);
        openapiFields.add(SERIALIZED_NAME_PODS);
        openapiFields.add(SERIALIZED_NAME_RESOURCE);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_TYPE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V2MetricSpec.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V2MetricSpec.class));
            return new TypeAdapter<V2MetricSpec>(){

                public void write(JsonWriter out, V2MetricSpec value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V2MetricSpec read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V2MetricSpec.validateJsonElement(jsonElement);
                    return (V2MetricSpec)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

