package io.kubernetes.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public class AppsV1beta1DeploymentRollbackFluentImpl<A extends AppsV1beta1DeploymentRollbackFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements AppsV1beta1DeploymentRollbackFluent<A>{

    private String apiVersion;
    private String kind;
    private String name;
    private AppsV1beta1RollbackConfigBuilder rollbackTo;
    private Map<String,String> updatedAnnotations;

    public AppsV1beta1DeploymentRollbackFluentImpl(){
    }
    public AppsV1beta1DeploymentRollbackFluentImpl(AppsV1beta1DeploymentRollback instance){
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withName(instance.getName());

            this.withRollbackTo(instance.getRollbackTo());

            this.withUpdatedAnnotations(instance.getUpdatedAnnotations());

    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNewKind(String arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1){
            return (A)withKind(new String(arg1));
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A withNewName(String arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1){
            return (A)withName(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildRollbackTo instead.
 * @return The buildable object.
 */
@Deprecated public AppsV1beta1RollbackConfig getRollbackTo(){
            return this.rollbackTo!=null?this.rollbackTo.build():null;
    }

    public AppsV1beta1RollbackConfig buildRollbackTo(){
            return this.rollbackTo!=null?this.rollbackTo.build():null;
    }

    public A withRollbackTo(AppsV1beta1RollbackConfig rollbackTo){
            _visitables.get("rollbackTo").remove(this.rollbackTo);
            if (rollbackTo!=null){ this.rollbackTo= new AppsV1beta1RollbackConfigBuilder(rollbackTo); _visitables.get("rollbackTo").add(this.rollbackTo);} return (A) this;
    }

    public Boolean hasRollbackTo(){
            return this.rollbackTo != null;
    }

    public AppsV1beta1DeploymentRollbackFluent.RollbackToNested<A> withNewRollbackTo(){
            return new RollbackToNestedImpl();
    }

    public AppsV1beta1DeploymentRollbackFluent.RollbackToNested<A> withNewRollbackToLike(AppsV1beta1RollbackConfig item){
            return new RollbackToNestedImpl(item);
    }

    public AppsV1beta1DeploymentRollbackFluent.RollbackToNested<A> editRollbackTo(){
            return withNewRollbackToLike(getRollbackTo());
    }

    public AppsV1beta1DeploymentRollbackFluent.RollbackToNested<A> editOrNewRollbackTo(){
            return withNewRollbackToLike(getRollbackTo() != null ? getRollbackTo(): new AppsV1beta1RollbackConfigBuilder().build());
    }

    public AppsV1beta1DeploymentRollbackFluent.RollbackToNested<A> editOrNewRollbackToLike(AppsV1beta1RollbackConfig item){
            return withNewRollbackToLike(getRollbackTo() != null ? getRollbackTo(): item);
    }

    public A addToUpdatedAnnotations(String key,String value){
            if(this.updatedAnnotations == null && key != null && value != null) { this.updatedAnnotations = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.updatedAnnotations.put(key, value);} return (A)this;
    }

    public A addToUpdatedAnnotations(Map<String,String> map){
            if(this.updatedAnnotations == null && map != null) { this.updatedAnnotations = new LinkedHashMap<String,String>(); }
            if(map != null) { this.updatedAnnotations.putAll(map);} return (A)this;
    }

    public A removeFromUpdatedAnnotations(String key){
            if(this.updatedAnnotations == null) { return (A) this; }
            if(key != null && this.updatedAnnotations != null) {this.updatedAnnotations.remove(key);} return (A)this;
    }

    public A removeFromUpdatedAnnotations(Map<String,String> map){
            if(this.updatedAnnotations == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.updatedAnnotations != null){this.updatedAnnotations.remove(key);}}} return (A)this;
    }

    public Map<String,String> getUpdatedAnnotations(){
            return this.updatedAnnotations;
    }

    public A withUpdatedAnnotations(Map<String,String> updatedAnnotations){
            if (updatedAnnotations == null) { this.updatedAnnotations =  null;} else {this.updatedAnnotations = new LinkedHashMap<String,String>(updatedAnnotations);} return (A) this;
    }

    public Boolean hasUpdatedAnnotations(){
            return this.updatedAnnotations != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            AppsV1beta1DeploymentRollbackFluentImpl that = (AppsV1beta1DeploymentRollbackFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (rollbackTo != null ? !rollbackTo.equals(that.rollbackTo) :that.rollbackTo != null) return false;
            if (updatedAnnotations != null ? !updatedAnnotations.equals(that.updatedAnnotations) :that.updatedAnnotations != null) return false;
            return true;
    }


    public class RollbackToNestedImpl<N> extends AppsV1beta1RollbackConfigFluentImpl<AppsV1beta1DeploymentRollbackFluent.RollbackToNested<N>> implements AppsV1beta1DeploymentRollbackFluent.RollbackToNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final AppsV1beta1RollbackConfigBuilder builder;
    
            RollbackToNestedImpl(AppsV1beta1RollbackConfig item){
                    this.builder = new AppsV1beta1RollbackConfigBuilder(this, item);
            }
            RollbackToNestedImpl(){
                    this.builder = new AppsV1beta1RollbackConfigBuilder(this);
            }
    
    public N and(){
            return (N) AppsV1beta1DeploymentRollbackFluentImpl.this.withRollbackTo(builder.build());
    }
    public N endRollbackTo(){
            return and();
    }

}


}
