package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AppsV1beta1DeploymentStrategyBuilder extends AppsV1beta1DeploymentStrategyFluentImpl<AppsV1beta1DeploymentStrategyBuilder> implements VisitableBuilder<AppsV1beta1DeploymentStrategy,AppsV1beta1DeploymentStrategyBuilder>{

    AppsV1beta1DeploymentStrategyFluent<?> fluent;
    Boolean validationEnabled;

    public AppsV1beta1DeploymentStrategyBuilder(){
            this(true);
    }
    public AppsV1beta1DeploymentStrategyBuilder(Boolean validationEnabled){
            this(new AppsV1beta1DeploymentStrategy(), validationEnabled);
    }
    public AppsV1beta1DeploymentStrategyBuilder(AppsV1beta1DeploymentStrategyFluent<?> fluent){
            this(fluent, true);
    }
    public AppsV1beta1DeploymentStrategyBuilder(AppsV1beta1DeploymentStrategyFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new AppsV1beta1DeploymentStrategy(), validationEnabled);
    }
    public AppsV1beta1DeploymentStrategyBuilder(AppsV1beta1DeploymentStrategyFluent<?> fluent,AppsV1beta1DeploymentStrategy instance){
            this(fluent, instance, true);
    }
    public AppsV1beta1DeploymentStrategyBuilder(AppsV1beta1DeploymentStrategyFluent<?> fluent,AppsV1beta1DeploymentStrategy instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withRollingUpdate(instance.getRollingUpdate());

            fluent.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }
    public AppsV1beta1DeploymentStrategyBuilder(AppsV1beta1DeploymentStrategy instance){
            this(instance,true);
    }
    public AppsV1beta1DeploymentStrategyBuilder(AppsV1beta1DeploymentStrategy instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withRollingUpdate(instance.getRollingUpdate());

            this.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }

    public AppsV1beta1DeploymentStrategy build(){
            AppsV1beta1DeploymentStrategy buildable = new AppsV1beta1DeploymentStrategy();
            buildable.setRollingUpdate(fluent.getRollingUpdate());
            buildable.setType(fluent.getType());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            AppsV1beta1DeploymentStrategyBuilder that = (AppsV1beta1DeploymentStrategyBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
