package io.kubernetes.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class ExtensionsV1beta1PodSecurityPolicyFluentImpl<A extends ExtensionsV1beta1PodSecurityPolicyFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements ExtensionsV1beta1PodSecurityPolicyFluent<A>{

    private String apiVersion;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private ExtensionsV1beta1PodSecurityPolicySpecBuilder spec;

    public ExtensionsV1beta1PodSecurityPolicyFluentImpl(){
    }
    public ExtensionsV1beta1PodSecurityPolicyFluentImpl(ExtensionsV1beta1PodSecurityPolicy instance){
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withSpec(instance.getSpec());

    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNewKind(String arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1){
            return (A)withKind(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public V1ObjectMeta buildMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(V1ObjectMeta metadata){
            _visitables.get("metadata").remove(this.metadata);
            if (metadata!=null){ this.metadata= new V1ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public ExtensionsV1beta1PodSecurityPolicyFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public ExtensionsV1beta1PodSecurityPolicyFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public ExtensionsV1beta1PodSecurityPolicyFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public ExtensionsV1beta1PodSecurityPolicyFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new V1ObjectMetaBuilder().build());
    }

    public ExtensionsV1beta1PodSecurityPolicyFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public ExtensionsV1beta1PodSecurityPolicySpec getSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public ExtensionsV1beta1PodSecurityPolicySpec buildSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(ExtensionsV1beta1PodSecurityPolicySpec spec){
            _visitables.get("spec").remove(this.spec);
            if (spec!=null){ this.spec= new ExtensionsV1beta1PodSecurityPolicySpecBuilder(spec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public Boolean hasSpec(){
            return this.spec != null;
    }

    public ExtensionsV1beta1PodSecurityPolicyFluent.SpecNested<A> withNewSpec(){
            return new SpecNestedImpl();
    }

    public ExtensionsV1beta1PodSecurityPolicyFluent.SpecNested<A> withNewSpecLike(ExtensionsV1beta1PodSecurityPolicySpec item){
            return new SpecNestedImpl(item);
    }

    public ExtensionsV1beta1PodSecurityPolicyFluent.SpecNested<A> editSpec(){
            return withNewSpecLike(getSpec());
    }

    public ExtensionsV1beta1PodSecurityPolicyFluent.SpecNested<A> editOrNewSpec(){
            return withNewSpecLike(getSpec() != null ? getSpec(): new ExtensionsV1beta1PodSecurityPolicySpecBuilder().build());
    }

    public ExtensionsV1beta1PodSecurityPolicyFluent.SpecNested<A> editOrNewSpecLike(ExtensionsV1beta1PodSecurityPolicySpec item){
            return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ExtensionsV1beta1PodSecurityPolicyFluentImpl that = (ExtensionsV1beta1PodSecurityPolicyFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
            return true;
    }


    public class MetadataNestedImpl<N> extends V1ObjectMetaFluentImpl<ExtensionsV1beta1PodSecurityPolicyFluent.MetadataNested<N>> implements ExtensionsV1beta1PodSecurityPolicyFluent.MetadataNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1ObjectMetaBuilder builder;
    
            MetadataNestedImpl(V1ObjectMeta item){
                    this.builder = new V1ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new V1ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) ExtensionsV1beta1PodSecurityPolicyFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}
    public class SpecNestedImpl<N> extends ExtensionsV1beta1PodSecurityPolicySpecFluentImpl<ExtensionsV1beta1PodSecurityPolicyFluent.SpecNested<N>> implements ExtensionsV1beta1PodSecurityPolicyFluent.SpecNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final ExtensionsV1beta1PodSecurityPolicySpecBuilder builder;
    
            SpecNestedImpl(ExtensionsV1beta1PodSecurityPolicySpec item){
                    this.builder = new ExtensionsV1beta1PodSecurityPolicySpecBuilder(this, item);
            }
            SpecNestedImpl(){
                    this.builder = new ExtensionsV1beta1PodSecurityPolicySpecBuilder(this);
            }
    
    public N and(){
            return (N) ExtensionsV1beta1PodSecurityPolicyFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec(){
            return and();
    }

}


}
